/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.gss;

import com.hm.postgresql.core.PGStream;
import com.hm.postgresql.gss.GSSCallbackHandler;
import com.hm.postgresql.gss.GssAction;
import com.hm.postgresql.gss.GssEncAction;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.io.IOException;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.ietf.jgss.GSSCredential;

public class MakeGSS {
    private static final Logger LOGGER = Logger.getLogger(MakeGSS.class.getName());

    public static void authenticate(boolean bl, PGStream pGStream, String string, String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, boolean bl2, boolean bl3, boolean bl4) {
        Exception exception;
        LOGGER.log(Level.FINEST, " <=BE AuthenticationReqGSS");
        if (string4 == null) {
            string4 = "pgjdbc";
        }
        if (string5 == null) {
            string5 = "postgres";
        }
        try {
            Object object;
            boolean bl5 = bl3;
            GSSCredential gSSCredential = null;
            Subject subject = Subject.getSubject(AccessController.getContext());
            if (subject != null && (object = subject.getPrivateCredentials(GSSCredential.class)) != null && !object.isEmpty()) {
                gSSCredential = object.iterator().next();
                bl5 = false;
            }
            if (bl5) {
                object = new LoginContext(string4, new GSSCallbackHandler(string2, string3));
                ((LoginContext)object).login();
                subject = ((LoginContext)object).getSubject();
            }
            if (bl) {
                object = new GssEncAction(pGStream, gSSCredential, string, string2, string5, bl2, bl4);
                exception = (Exception)Subject.doAs(subject, object);
            } else {
                object = new GssAction(pGStream, gSSCredential, string, string2, string5, bl2, bl4);
                exception = (Exception)Subject.doAs(subject, object);
            }
        }
        catch (Exception exception2) {
            throw new PSQLException(GT.tr("GSS Authentication failed", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)exception2);
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (exception instanceof PSQLException) {
            throw (PSQLException)exception;
        }
        if (exception != null) {
            throw new PSQLException(GT.tr("GSS Authentication failed", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)exception);
        }
    }
}

