/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.hostchooser;

import com.hm.postgresql.PGProperty;
import com.hm.postgresql.hostchooser.CandidateHost;
import com.hm.postgresql.hostchooser.GlobalHostStatusTracker;
import com.hm.postgresql.hostchooser.HostChooser;
import com.hm.postgresql.hostchooser.HostRequirement;
import com.hm.postgresql.util.HostSpec;
import com.hm.postgresql.util.PSQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

class MultiHostChooser
implements HostChooser {
    private HostSpec[] hostSpecs;
    private final HostRequirement targetServerType;
    private int hostRecheckTime;
    private boolean loadBalance;

    MultiHostChooser(HostSpec[] hostSpecArray, HostRequirement hostRequirement, Properties properties) {
        this.hostSpecs = hostSpecArray;
        this.targetServerType = hostRequirement;
        try {
            this.hostRecheckTime = PGProperty.HOST_RECHECK_SECONDS.getInt(properties) * 1000;
            this.loadBalance = PGProperty.LOAD_BALANCE_HOSTS.getBoolean(properties);
        }
        catch (PSQLException pSQLException) {
            throw new RuntimeException(pSQLException);
        }
    }

    @Override
    public Iterator<CandidateHost> iterator() {
        Iterator<CandidateHost> iterator = this.candidateIterator();
        if (!iterator.hasNext()) {
            List<HostSpec> list = Arrays.asList(this.hostSpecs);
            if (this.loadBalance) {
                list = new ArrayList<HostSpec>(list);
                Collections.shuffle(list);
            }
            iterator = this.withReqStatus(this.targetServerType, list).iterator();
        }
        return iterator;
    }

    private Iterator<CandidateHost> candidateIterator() {
        if (this.targetServerType != HostRequirement.preferSecondary) {
            return this.getCandidateHosts(this.targetServerType).iterator();
        }
        List<CandidateHost> list = this.getCandidateHosts(HostRequirement.secondary);
        List<CandidateHost> list2 = this.getCandidateHosts(HostRequirement.any);
        if (list.isEmpty()) {
            return list2.iterator();
        }
        if (list2.isEmpty()) {
            return list.iterator();
        }
        if (list.get(list.size() - 1).equals(list2.get(0))) {
            list = this.rtrim(1, list);
        }
        return this.append(list, list2).iterator();
    }

    private List<CandidateHost> getCandidateHosts(HostRequirement hostRequirement) {
        List<HostSpec> list = GlobalHostStatusTracker.getCandidateHosts(this.hostSpecs, hostRequirement, this.hostRecheckTime);
        if (this.loadBalance) {
            Collections.shuffle(list);
        }
        return this.withReqStatus(hostRequirement, list);
    }

    private List<CandidateHost> withReqStatus(final HostRequirement hostRequirement, final List<HostSpec> list) {
        return new AbstractList<CandidateHost>(){

            @Override
            public CandidateHost get(int n) {
                return new CandidateHost((HostSpec)list.get(n), hostRequirement);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    private <T> List<T> append(final List<T> list, final List<T> list2) {
        return new AbstractList<T>(){

            @Override
            public T get(int n) {
                return n < list.size() ? list.get(n) : list2.get(n - list.size());
            }

            @Override
            public int size() {
                return list.size() + list2.size();
            }
        };
    }

    private <T> List<T> rtrim(final int n, final List<T> list) {
        return new AbstractList<T>(){

            @Override
            public T get(int n2) {
                return list.get(n2);
            }

            @Override
            public int size() {
                return Math.max(0, list.size() - n);
            }
        };
    }
}

