/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.core.ServerVersion;
import com.hm.postgresql.largeobject.LargeObject;
import com.hm.postgresql.largeobject.LargeObjectManager;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractBlobClob {
    protected BaseConnection conn;
    private @Nullable LargeObject currentLo;
    private boolean currentLoIsWriteable;
    private boolean support64bit;
    private @Nullable ArrayList<LargeObject> subLOs = new ArrayList();
    private final long oid;

    public AbstractBlobClob(BaseConnection baseConnection, long l) {
        this.conn = baseConnection;
        this.oid = l;
        this.currentLoIsWriteable = false;
        this.support64bit = baseConnection.haveMinimumServerVersion(90300);
    }

    public synchronized void free() {
        if (this.currentLo != null) {
            this.currentLo.close();
            this.currentLo = null;
            this.currentLoIsWriteable = false;
        }
        if (this.subLOs != null) {
            for (LargeObject largeObject : this.subLOs) {
                largeObject.close();
            }
        }
        this.subLOs = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void truncate(long l) {
        this.checkFreed();
        if (!this.conn.haveMinimumServerVersion(ServerVersion.v8_3)) {
            throw new PSQLException(GT.tr("Truncation of large objects is only implemented in 8.3 and later servers.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
        }
        if (l < 0L) {
            throw new PSQLException(GT.tr("Cannot truncate LOB to a negative length.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (l > Integer.MAX_VALUE) {
            if (!this.support64bit) throw new PSQLException(GT.tr("PostgreSQL LOBs can only index to: {0}", Integer.MAX_VALUE), PSQLState.INVALID_PARAMETER_VALUE);
            this.getLo(true).truncate64(l);
            return;
        } else {
            this.getLo(true).truncate((int)l);
        }
    }

    public synchronized long length() {
        this.checkFreed();
        if (this.support64bit) {
            return this.getLo(false).size64();
        }
        return this.getLo(false).size();
    }

    public synchronized byte[] getBytes(long l, int n) {
        this.assertPosition(l);
        this.getLo(false).seek((int)(l - 1L), 0);
        return this.getLo(false).read(n);
    }

    public synchronized InputStream getBinaryStream() {
        this.checkFreed();
        LargeObject largeObject = this.getLo(false).copy();
        this.addSubLO(largeObject);
        largeObject.seek(0, 0);
        return largeObject.getInputStream();
    }

    public synchronized OutputStream setBinaryStream(long l) {
        this.assertPosition(l);
        LargeObject largeObject = this.getLo(true).copy();
        this.addSubLO(largeObject);
        largeObject.seek((int)(l - 1L));
        return largeObject.getOutputStream();
    }

    public synchronized long position(byte[] byArray, long l) {
        this.assertPosition(l, byArray.length);
        int n = 1;
        int n2 = 0;
        long l2 = -1L;
        int n3 = 1;
        LOIterator lOIterator = new LOIterator(l - 1L);
        while (lOIterator.hasNext()) {
            byte by = lOIterator.next();
            if (by == byArray[n2]) {
                if (n2 == 0) {
                    n3 = n;
                }
                if (++n2 == byArray.length) {
                    l2 = n3;
                    break;
                }
            } else {
                n2 = 0;
            }
            ++n;
        }
        return l2;
    }

    public synchronized long position(Blob blob, long l) {
        return this.position(blob.getBytes(1L, (int)blob.length()), l);
    }

    protected void assertPosition(long l) {
        this.assertPosition(l, 0L);
    }

    protected void assertPosition(long l, long l2) {
        this.checkFreed();
        if (l < 1L) {
            throw new PSQLException(GT.tr("LOB positioning offsets start at 1.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (l + l2 - 1L > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("PostgreSQL LOBs can only index to: {0}", Integer.MAX_VALUE), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    protected void checkFreed() {
        if (this.subLOs == null) {
            throw new PSQLException(GT.tr("free() was called on this LOB previously", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    protected synchronized LargeObject getLo(boolean bl) {
        LargeObject largeObject = this.currentLo;
        if (largeObject != null) {
            if (bl && !this.currentLoIsWriteable) {
                int n = largeObject.tell();
                LargeObjectManager largeObjectManager = this.conn.getLargeObjectAPI();
                LargeObject largeObject2 = largeObjectManager.open(this.oid, 393216);
                Nullness.castNonNull(this.subLOs).add(largeObject);
                this.currentLo = largeObject = largeObject2;
                if (n != 0) {
                    largeObject.seek(n);
                }
            }
            return largeObject;
        }
        LargeObjectManager largeObjectManager = this.conn.getLargeObjectAPI();
        this.currentLo = largeObject = largeObjectManager.open(this.oid, bl ? 393216 : 262144);
        this.currentLoIsWriteable = bl;
        return largeObject;
    }

    protected void addSubLO(LargeObject largeObject) {
        Nullness.castNonNull(this.subLOs).add(largeObject);
    }

    private class LOIterator {
        private static final int BUFFER_SIZE = 8096;
        private final byte[] buffer = new byte[8096];
        private int idx = 8096;
        private int numBytes = 8096;

        LOIterator(long l) {
            AbstractBlobClob.this.getLo(false).seek((int)l);
        }

        public boolean hasNext() {
            boolean bl;
            if (this.idx < this.numBytes) {
                bl = true;
            } else {
                this.numBytes = AbstractBlobClob.this.getLo(false).read(this.buffer, 0, 8096);
                this.idx = 0;
                bl = this.numBytes > 0;
            }
            return bl;
        }

        private byte next() {
            return this.buffer[this.idx++];
        }
    }
}

