/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.Driver;
import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.core.Parser;
import com.hm.postgresql.jdbc.BooleanTypeUtil;
import com.hm.postgresql.jdbc.PgArray;
import com.hm.postgresql.jdbc.PgResultSet;
import com.hm.postgresql.jdbc2.ArrayAssistant;
import com.hm.postgresql.jdbc2.ArrayAssistantRegistry;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PGbytea;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ArrayDecoding {
    private static final ArrayDecoder<Long[]> LONG_OBJ_ARRAY = new AbstractObjectArrayDecoder<Long[]>(Long.class){

        @Override
        Object parseValue(int n, ByteBuffer byteBuffer, BaseConnection baseConnection) {
            return byteBuffer.getLong();
        }

        @Override
        Object parseValue(String string, BaseConnection baseConnection) {
            return PgResultSet.toLong(string);
        }
    };
    private static final ArrayDecoder<Long[]> INT4_UNSIGNED_OBJ_ARRAY = new AbstractObjectArrayDecoder<Long[]>(Long.class){

        @Override
        Object parseValue(int n, ByteBuffer byteBuffer, BaseConnection baseConnection) {
            long l = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            return l;
        }

        @Override
        Object parseValue(String string, BaseConnection baseConnection) {
            return PgResultSet.toLong(string);
        }
    };
    private static final ArrayDecoder<Integer[]> INTEGER_OBJ_ARRAY = new AbstractObjectArrayDecoder<Integer[]>(Integer.class){

        @Override
        Object parseValue(int n, ByteBuffer byteBuffer, BaseConnection baseConnection) {
            return byteBuffer.getInt();
        }

        @Override
        Object parseValue(String string, BaseConnection baseConnection) {
            return PgResultSet.toInt(string);
        }
    };
    private static final ArrayDecoder<Short[]> SHORT_OBJ_ARRAY = new AbstractObjectArrayDecoder<Short[]>(Short.class){

        @Override
        Object parseValue(int n, ByteBuffer byteBuffer, BaseConnection baseConnection) {
            return byteBuffer.getShort();
        }

        @Override
        Object parseValue(String string, BaseConnection baseConnection) {
            return PgResultSet.toShort(string);
        }
    };
    private static final ArrayDecoder<Double[]> DOUBLE_OBJ_ARRAY = new AbstractObjectArrayDecoder<Double[]>(Double.class){

        @Override
        Object parseValue(int n, ByteBuffer byteBuffer, BaseConnection baseConnection) {
            return byteBuffer.getDouble();
        }

        @Override
        Object parseValue(String string, BaseConnection baseConnection) {
            return PgResultSet.toDouble(string);
        }
    };
    private static final ArrayDecoder<Float[]> FLOAT_OBJ_ARRAY = new AbstractObjectArrayDecoder<Float[]>(Float.class){

        @Override
        Object parseValue(int n, ByteBuffer byteBuffer, BaseConnection baseConnection) {
            return Float.valueOf(byteBuffer.getFloat());
        }

        @Override
        Object parseValue(String string, BaseConnection baseConnection) {
            return Float.valueOf(PgResultSet.toFloat(string));
        }
    };
    private static final ArrayDecoder<Boolean[]> BOOLEAN_OBJ_ARRAY = new AbstractObjectArrayDecoder<Boolean[]>(Boolean.class){

        @Override
        Object parseValue(int n, ByteBuffer byteBuffer, BaseConnection baseConnection) {
            return byteBuffer.get() == 1;
        }

        @Override
        Object parseValue(String string, BaseConnection baseConnection) {
            return BooleanTypeUtil.fromString(string);
        }
    };
    private static final ArrayDecoder<String[]> STRING_ARRAY = new AbstractObjectArrayDecoder<String[]>(String.class){

        @Override
        Object parseValue(int n, ByteBuffer byteBuffer, BaseConnection baseConnection) {
            String string;
            assert (byteBuffer.hasArray());
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
            try {
                string = baseConnection.getEncoding().decode(byArray, n2, n);
            }
            catch (IOException iOException) {
                throw new PSQLException(GT.tr("Invalid character data was found.  This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)iOException);
            }
            byteBuffer.position(byteBuffer.position() + n);
            return string;
        }

        @Override
        Object parseValue(String string, BaseConnection baseConnection) {
            return string;
        }
    };
    private static final ArrayDecoder<byte[][]> BYTE_ARRAY_ARRAY = new AbstractObjectArrayDecoder<byte[][]>(byte[].class){

        @Override
        Object parseValue(int n, ByteBuffer byteBuffer, BaseConnection baseConnection) {
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            return byArray;
        }

        @Override
        Object parseValue(String string, BaseConnection baseConnection) {
            return PGbytea.toBytes(string.getBytes(StandardCharsets.US_ASCII));
        }
    };
    private static final ArrayDecoder<BigDecimal[]> BIG_DECIMAL_STRING_DECODER = new AbstractObjectStringArrayDecoder<BigDecimal[]>(BigDecimal.class){

        @Override
        Object parseValue(String string, BaseConnection baseConnection) {
            return PgResultSet.toBigDecimal(string);
        }
    };
    private static final ArrayDecoder<String[]> STRING_ONLY_DECODER = new AbstractObjectStringArrayDecoder<String[]>(String.class){

        @Override
        Object parseValue(String string, BaseConnection baseConnection) {
            return string;
        }
    };
    private static final ArrayDecoder<Date[]> DATE_DECODER = new AbstractObjectStringArrayDecoder<Date[]>(Date.class){

        @Override
        Object parseValue(String string, BaseConnection baseConnection) {
            return baseConnection.getTimestampUtils().toDate(null, string);
        }
    };
    private static final ArrayDecoder<Time[]> TIME_DECODER = new AbstractObjectStringArrayDecoder<Time[]>(Time.class){

        @Override
        Object parseValue(String string, BaseConnection baseConnection) {
            return baseConnection.getTimestampUtils().toTime(null, string);
        }
    };
    private static final ArrayDecoder<Timestamp[]> TIMESTAMP_DECODER = new AbstractObjectStringArrayDecoder<Timestamp[]>(Timestamp.class){

        @Override
        Object parseValue(String string, BaseConnection baseConnection) {
            return baseConnection.getTimestampUtils().toTimestamp(null, string);
        }
    };
    private static final Map<Integer, ArrayDecoder> OID_TO_DECODER = new HashMap<Integer, ArrayDecoder>(29);

    ArrayDecoding() {
    }

    private static <A> ArrayDecoder<A> getDecoder(int n, BaseConnection baseConnection) {
        Integer n2 = n;
        ArrayDecoder arrayDecoder = OID_TO_DECODER.get(n2);
        if (arrayDecoder != null) {
            return arrayDecoder;
        }
        ArrayAssistant arrayAssistant = ArrayAssistantRegistry.getAssistant(n);
        if (arrayAssistant != null) {
            return new ArrayAssistantObjectArrayDecoder(arrayAssistant);
        }
        String string = baseConnection.getTypeInfo().getPGType(n);
        if (string == null) {
            throw Driver.notImplemented(PgArray.class, "readArray(data,oid)");
        }
        int n3 = baseConnection.getTypeInfo().getSQLType(string);
        if (n3 == 1 || n3 == 12) {
            return STRING_ONLY_DECODER;
        }
        return new MappedTypeObjectArrayDecoder(string);
    }

    public static Object readBinaryArray(int n, int n2, byte[] byArray, BaseConnection baseConnection) {
        int n3;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        int n4 = byteBuffer.getInt();
        boolean bl = byteBuffer.getInt() != 0;
        int n5 = byteBuffer.getInt();
        ArrayDecoder arrayDecoder = ArrayDecoding.getDecoder(n5, baseConnection);
        if (!arrayDecoder.supportBinary()) {
            throw Driver.notImplemented(PgArray.class, "readBinaryArray(data,oid)");
        }
        if (n4 == 0) {
            return arrayDecoder.createArray(0);
        }
        int n6 = n3 = n > 0 ? n - 1 : 0;
        if (n4 == 1) {
            int n7 = byteBuffer.getInt();
            byteBuffer.position(byteBuffer.position() + 4);
            if (n2 > 0) {
                n7 = Math.min(n7, n2);
            }
            Object a = arrayDecoder.createArray(n7);
            arrayDecoder.populateFromBinary(a, n3, n7, byteBuffer, baseConnection);
            return a;
        }
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = byteBuffer.getInt();
            byteBuffer.position(byteBuffer.position() + 4);
        }
        if (n2 > 0) {
            nArray[0] = Math.min(n2, nArray[0]);
        }
        Object[] objectArray = arrayDecoder.createMultiDimensionalArray(nArray);
        ArrayDecoding.storeValues(objectArray, arrayDecoder, byteBuffer, n3, nArray, 0, baseConnection);
        return objectArray;
    }

    private static <A> void storeValues(A[] AArray, ArrayDecoder<A> arrayDecoder, ByteBuffer byteBuffer, int n, int[] nArray, int n2, BaseConnection baseConnection) {
        int n3;
        assert (n2 <= nArray.length - 2);
        for (n3 = 0; n3 < n; ++n3) {
            if (n2 == nArray.length - 2) {
                arrayDecoder.populateFromBinary(AArray[0], 0, nArray[n2 + 1], byteBuffer, baseConnection);
                continue;
            }
            ArrayDecoding.storeValues((Object[])AArray[0], arrayDecoder, byteBuffer, 0, nArray, n2 + 1, baseConnection);
        }
        for (n3 = 0; n3 < nArray[n2]; ++n3) {
            if (n2 == nArray.length - 2) {
                arrayDecoder.populateFromBinary(AArray[n3], 0, nArray[n2 + 1], byteBuffer, baseConnection);
                continue;
            }
            ArrayDecoding.storeValues((Object[])AArray[n3], arrayDecoder, byteBuffer, 0, nArray, n2 + 1, baseConnection);
        }
    }

    static PgArrayList buildArrayList(String string, char c) {
        PgArrayList pgArrayList = new PgArrayList();
        if (string == null) {
            return pgArrayList;
        }
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = null;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<PgArrayList> arrayList = new ArrayList<PgArrayList>();
        PgArrayList pgArrayList2 = pgArrayList;
        int n = 0;
        if (cArray[0] == '[') {
            while (cArray[n] != '=') {
                ++n;
            }
            ++n;
        }
        for (int i = n; i < cArray.length; ++i) {
            if (cArray[i] == '\\') {
                ++i;
            } else {
                if (!bl && cArray[i] == '{') {
                    if (arrayList.isEmpty()) {
                        arrayList.add(pgArrayList);
                    } else {
                        PgArrayList pgArrayList3 = new PgArrayList();
                        PgArrayList pgArrayList4 = (PgArrayList)arrayList.get(arrayList.size() - 1);
                        pgArrayList4.add(pgArrayList3);
                        arrayList.add(pgArrayList3);
                    }
                    pgArrayList2 = (PgArrayList)arrayList.get(arrayList.size() - 1);
                    for (int j = i + 1; j < cArray.length; ++j) {
                        if (Character.isWhitespace(cArray[j])) continue;
                        if (cArray[j] != '{') break;
                        ++pgArrayList2.dimensionsCount;
                    }
                    stringBuilder = new StringBuilder();
                    continue;
                }
                if (cArray[i] == '\"') {
                    bl = !bl;
                    bl2 = true;
                    continue;
                }
                if (!bl && Parser.isArrayWhiteSpace(cArray[i])) continue;
                if (!bl && (cArray[i] == c || cArray[i] == '}') || i == cArray.length - 1) {
                    String string2;
                    if (cArray[i] != '\"' && cArray[i] != '}' && cArray[i] != c && stringBuilder != null) {
                        stringBuilder.append(cArray[i]);
                    }
                    String string3 = string2 = stringBuilder == null ? null : stringBuilder.toString();
                    if (string2 != null && (!string2.isEmpty() || bl2)) {
                        pgArrayList2.add(!bl2 && string2.equals("NULL") ? null : string2);
                    }
                    bl2 = false;
                    stringBuilder = new StringBuilder();
                    if (cArray[i] != '}') continue;
                    arrayList.remove(arrayList.size() - 1);
                    if (!arrayList.isEmpty()) {
                        pgArrayList2 = (PgArrayList)arrayList.get(arrayList.size() - 1);
                    }
                    stringBuilder = null;
                    continue;
                }
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(cArray[i]);
        }
        return pgArrayList;
    }

    public static Object readStringArray(int n, int n2, int n3, PgArrayList pgArrayList, BaseConnection baseConnection) {
        PgArrayList pgArrayList2;
        ArrayDecoder arrayDecoder = ArrayDecoding.getDecoder(n3, baseConnection);
        int n4 = pgArrayList.dimensionsCount;
        if (n4 == 0) {
            return arrayDecoder.createArray(0);
        }
        boolean bl = false;
        int n5 = 0;
        if (n > 1) {
            bl = true;
            n5 = n - 1;
        }
        int n6 = pgArrayList.size();
        if (n2 > 0 && n2 != n6) {
            bl = true;
            n6 = Math.min(n6, n2);
        }
        List<Object> list = pgArrayList2 = bl ? pgArrayList.subList(n5, n5 + n6) : pgArrayList;
        if (n4 == 1) {
            int n7 = pgArrayList2.size();
            if (n2 > 0) {
                n7 = Math.min(n7, n2);
            }
            Object a = arrayDecoder.createArray(n7);
            arrayDecoder.populateFromString(a, pgArrayList2, baseConnection);
            return a;
        }
        int[] nArray = new int[n4];
        nArray[0] = n6;
        Object object = (Object[])pgArrayList2.get(0);
        for (int i = 1; i < n4; ++i) {
            nArray[i] = object.size();
            if (i == n4 - 1) continue;
            object = (List)object.get(0);
        }
        object = arrayDecoder.createMultiDimensionalArray(nArray);
        ArrayDecoding.storeStringValues(object, arrayDecoder, pgArrayList2, nArray, 0, baseConnection);
        return object;
    }

    private static <A> void storeStringValues(A[] AArray, ArrayDecoder<A> arrayDecoder, List list, int @NonNull [] nArray, int n, BaseConnection baseConnection) {
        assert (n <= nArray.length - 2);
        for (int i = 0; i < nArray[n]; ++i) {
            if (n == nArray.length - 2) {
                arrayDecoder.populateFromString(AArray[i], (List)list.get(i), baseConnection);
                continue;
            }
            ArrayDecoding.storeStringValues((Object[])AArray[i], arrayDecoder, (List)list.get(i), nArray, n + 1, baseConnection);
        }
    }

    static {
        OID_TO_DECODER.put(26, INT4_UNSIGNED_OBJ_ARRAY);
        OID_TO_DECODER.put(20, LONG_OBJ_ARRAY);
        OID_TO_DECODER.put(23, INTEGER_OBJ_ARRAY);
        OID_TO_DECODER.put(21, SHORT_OBJ_ARRAY);
        OID_TO_DECODER.put(790, DOUBLE_OBJ_ARRAY);
        OID_TO_DECODER.put(701, DOUBLE_OBJ_ARRAY);
        OID_TO_DECODER.put(700, FLOAT_OBJ_ARRAY);
        OID_TO_DECODER.put(25, STRING_ARRAY);
        OID_TO_DECODER.put(1043, STRING_ARRAY);
        OID_TO_DECODER.put(3802, STRING_ONLY_DECODER);
        OID_TO_DECODER.put(1560, BOOLEAN_OBJ_ARRAY);
        OID_TO_DECODER.put(16, BOOLEAN_OBJ_ARRAY);
        OID_TO_DECODER.put(17, BYTE_ARRAY_ARRAY);
        OID_TO_DECODER.put(1700, BIG_DECIMAL_STRING_DECODER);
        OID_TO_DECODER.put(1042, STRING_ONLY_DECODER);
        OID_TO_DECODER.put(18, STRING_ONLY_DECODER);
        OID_TO_DECODER.put(114, STRING_ONLY_DECODER);
        OID_TO_DECODER.put(1082, DATE_DECODER);
        OID_TO_DECODER.put(1083, TIME_DECODER);
        OID_TO_DECODER.put(1266, TIME_DECODER);
        OID_TO_DECODER.put(1114, TIMESTAMP_DECODER);
        OID_TO_DECODER.put(1184, TIMESTAMP_DECODER);
    }

    private static final class MappedTypeObjectArrayDecoder
    extends AbstractObjectArrayDecoder<Object[]> {
        private final String typeName;

        MappedTypeObjectArrayDecoder(String string) {
            super(Object.class);
            this.typeName = string;
        }

        @Override
        Object parseValue(int n, ByteBuffer byteBuffer, BaseConnection baseConnection) {
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            return baseConnection.getObject(this.typeName, null, byArray);
        }

        @Override
        Object parseValue(String string, BaseConnection baseConnection) {
            return baseConnection.getObject(this.typeName, string, null);
        }
    }

    private static final class ArrayAssistantObjectArrayDecoder
    extends AbstractObjectArrayDecoder {
        private final ArrayAssistant arrayAssistant;

        ArrayAssistantObjectArrayDecoder(ArrayAssistant arrayAssistant) {
            super(arrayAssistant.baseType());
            this.arrayAssistant = arrayAssistant;
        }

        @Override
        Object parseValue(int n, ByteBuffer byteBuffer, BaseConnection baseConnection) {
            assert (byteBuffer.hasArray());
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
            Object object = this.arrayAssistant.buildElement(byArray, n2, n);
            byteBuffer.position(byteBuffer.position() + n);
            return object;
        }

        @Override
        Object parseValue(String string, BaseConnection baseConnection) {
            return this.arrayAssistant.buildElement(string);
        }
    }

    private static abstract class AbstractObjectArrayDecoder<A>
    extends AbstractObjectStringArrayDecoder<A> {
        AbstractObjectArrayDecoder(Class<?> clazz) {
            super(clazz);
        }

        @Override
        public boolean supportBinary() {
            return true;
        }

        @Override
        public void populateFromBinary(A a, @NonNegative int n, @NonNegative int n2, ByteBuffer byteBuffer, BaseConnection baseConnection) {
            int n3;
            int n4;
            @Nullable Object[] objectArray = (Object[])a;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = byteBuffer.getInt();
                if (n3 <= 0) continue;
                byteBuffer.position(byteBuffer.position() + n3);
            }
            for (n4 = 0; n4 < n2; ++n4) {
                n3 = byteBuffer.getInt();
                objectArray[n4] = n3 != -1 ? this.parseValue(n3, byteBuffer, baseConnection) : null;
            }
        }

        abstract Object parseValue(int var1, ByteBuffer var2, BaseConnection var3);
    }

    private static abstract class AbstractObjectStringArrayDecoder<A>
    implements ArrayDecoder<A> {
        final Class<?> baseClazz;

        AbstractObjectStringArrayDecoder(Class<?> clazz) {
            this.baseClazz = clazz;
        }

        @Override
        public boolean supportBinary() {
            return false;
        }

        @Override
        public A createArray(int n) {
            return (A)Array.newInstance(this.baseClazz, n);
        }

        @Override
        public Object[] createMultiDimensionalArray(int[] nArray) {
            return (Object[])Array.newInstance(this.baseClazz, nArray);
        }

        @Override
        public void populateFromBinary(A a, int n, int n2, ByteBuffer byteBuffer, BaseConnection baseConnection) {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public void populateFromString(A a, List<@Nullable String> list, BaseConnection baseConnection) {
            @Nullable Object[] objectArray = (Object[])a;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                String string = list.get(i);
                objectArray[i] = string != null ? this.parseValue(string, baseConnection) : null;
            }
        }

        abstract Object parseValue(String var1, BaseConnection var2);
    }

    private static interface ArrayDecoder<A> {
        public A createArray(@NonNegative int var1);

        public Object[] createMultiDimensionalArray(@NonNegative int[] var1);

        public boolean supportBinary();

        public void populateFromBinary(A var1, @NonNegative int var2, @NonNegative int var3, ByteBuffer var4, BaseConnection var5) throws SQLException;

        public void populateFromString(A var1, List<@Nullable String> var2, BaseConnection var3) throws SQLException;
    }

    static final class PgArrayList
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;
        int dimensionsCount = 1;

        PgArrayList() {
        }
    }
}

