/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.core.Encoding;
import com.hm.postgresql.jdbc.PgArray;
import com.hm.postgresql.util.ByteConverter;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.index.qual.Positive;

final class ArrayEncoding {
    private static final AbstractArrayEncoder<long[]> LONG_ARRAY = new FixedSizePrimitiveArrayEncoder<long[]>(8, 20, 1016){

        @Override
        public void appendArray(StringBuilder stringBuilder, char c, long[] lArray) {
            stringBuilder.append('{');
            for (int i = 0; i < lArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(c);
                }
                stringBuilder.append(lArray[i]);
            }
            stringBuilder.append('}');
        }

        @Override
        protected void write(long[] lArray, byte[] byArray, int n) {
            int n2 = n;
            for (int i = 0; i < lArray.length; ++i) {
                byArray[n2 + 3] = 8;
                ByteConverter.int8(byArray, n2 + 4, lArray[i]);
                n2 += 12;
            }
        }
    };
    private static final AbstractArrayEncoder<Long[]> LONG_OBJ_ARRAY = new NumberArrayEncoder<Long>(8, 20, 1016){

        @Override
        protected void write(Long l, byte[] byArray, int n) {
            ByteConverter.int8(byArray, n, l);
        }
    };
    private static final AbstractArrayEncoder<int[]> INT_ARRAY = new FixedSizePrimitiveArrayEncoder<int[]>(4, 23, 1007){

        @Override
        public void appendArray(StringBuilder stringBuilder, char c, int[] nArray) {
            stringBuilder.append('{');
            for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(c);
                }
                stringBuilder.append(nArray[i]);
            }
            stringBuilder.append('}');
        }

        @Override
        protected void write(int[] nArray, byte[] byArray, int n) {
            int n2 = n;
            for (int i = 0; i < nArray.length; ++i) {
                byArray[n2 + 3] = 4;
                ByteConverter.int4(byArray, n2 + 4, nArray[i]);
                n2 += 8;
            }
        }
    };
    private static final AbstractArrayEncoder<Integer[]> INT_OBJ_ARRAY = new NumberArrayEncoder<Integer>(4, 23, 1007){

        @Override
        protected void write(Integer n, byte[] byArray, int n2) {
            ByteConverter.int4(byArray, n2, n);
        }
    };
    private static final AbstractArrayEncoder<short[]> SHORT_ARRAY = new FixedSizePrimitiveArrayEncoder<short[]>(2, 21, 1005){

        @Override
        public void appendArray(StringBuilder stringBuilder, char c, short[] sArray) {
            stringBuilder.append('{');
            for (int i = 0; i < sArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(c);
                }
                stringBuilder.append(sArray[i]);
            }
            stringBuilder.append('}');
        }

        @Override
        protected void write(short[] sArray, byte[] byArray, int n) {
            int n2 = n;
            for (int i = 0; i < sArray.length; ++i) {
                byArray[n2 + 3] = 2;
                ByteConverter.int2(byArray, n2 + 4, sArray[i]);
                n2 += 6;
            }
        }
    };
    private static final AbstractArrayEncoder<Short[]> SHORT_OBJ_ARRAY = new NumberArrayEncoder<Short>(2, 21, 1005){

        @Override
        protected void write(Short s, byte[] byArray, int n) {
            ByteConverter.int2(byArray, n, s.shortValue());
        }
    };
    private static final AbstractArrayEncoder<double[]> DOUBLE_ARRAY = new FixedSizePrimitiveArrayEncoder<double[]>(8, 701, 1022){

        @Override
        public void appendArray(StringBuilder stringBuilder, char c, double[] dArray) {
            stringBuilder.append('{');
            for (int i = 0; i < dArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(c);
                }
                stringBuilder.append('\"');
                stringBuilder.append(dArray[i]);
                stringBuilder.append('\"');
            }
            stringBuilder.append('}');
        }

        @Override
        protected void write(double[] dArray, byte[] byArray, int n) {
            int n2 = n;
            for (int i = 0; i < dArray.length; ++i) {
                byArray[n2 + 3] = 8;
                ByteConverter.float8(byArray, n2 + 4, dArray[i]);
                n2 += 12;
            }
        }
    };
    private static final AbstractArrayEncoder<Double[]> DOUBLE_OBJ_ARRAY = new NumberArrayEncoder<Double>(8, 701, 1022){

        @Override
        protected void write(Double d, byte[] byArray, int n) {
            ByteConverter.float8(byArray, n, d);
        }
    };
    private static final AbstractArrayEncoder<float[]> FLOAT_ARRAY = new FixedSizePrimitiveArrayEncoder<float[]>(4, 700, 1021){

        @Override
        public void appendArray(StringBuilder stringBuilder, char c, float[] fArray) {
            stringBuilder.append('{');
            for (int i = 0; i < fArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(c);
                }
                stringBuilder.append('\"');
                stringBuilder.append(fArray[i]);
                stringBuilder.append('\"');
            }
            stringBuilder.append('}');
        }

        @Override
        protected void write(float[] fArray, byte[] byArray, int n) {
            int n2 = n;
            for (int i = 0; i < fArray.length; ++i) {
                byArray[n2 + 3] = 4;
                ByteConverter.float4(byArray, n2 + 4, fArray[i]);
                n2 += 8;
            }
        }
    };
    private static final AbstractArrayEncoder<Float[]> FLOAT_OBJ_ARRAY = new NumberArrayEncoder<Float>(4, 700, 1021){

        @Override
        protected void write(Float f, byte[] byArray, int n) {
            ByteConverter.float4(byArray, n, f.floatValue());
        }
    };
    private static final AbstractArrayEncoder<boolean[]> BOOLEAN_ARRAY = new FixedSizePrimitiveArrayEncoder<boolean[]>(1, 16, 1000){

        @Override
        public void appendArray(StringBuilder stringBuilder, char c, boolean[] blArray) {
            stringBuilder.append('{');
            for (int i = 0; i < blArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(c);
                }
                stringBuilder.append(blArray[i] ? (char)'1' : '0');
            }
            stringBuilder.append('}');
        }

        @Override
        protected void write(boolean[] blArray, byte[] byArray, int n) {
            int n2 = n;
            for (int i = 0; i < blArray.length; ++i) {
                byArray[n2 + 3] = 1;
                ByteConverter.bool(byArray, n2 + 4, blArray[i]);
                n2 += 5;
            }
        }
    };
    private static final AbstractArrayEncoder<Boolean[]> BOOLEAN_OBJ_ARRAY = new AbstractArrayEncoder<Boolean[]>(16, 1000){

        @Override
        public byte[] toBinaryRepresentation(BaseConnection baseConnection, Boolean[] booleanArray, int n) {
            assert (n == this.arrayOid);
            int n2 = this.countNulls(booleanArray);
            byte[] byArray = this.writeBytes(booleanArray, n2, 20);
            ByteConverter.int4(byArray, 0, 1);
            ByteConverter.int4(byArray, 4, n2 == 0 ? 0 : 1);
            ByteConverter.int4(byArray, 8, this.getTypeOID(n));
            ByteConverter.int4(byArray, 12, booleanArray.length);
            ByteConverter.int4(byArray, 16, 1);
            return byArray;
        }

        private byte[] writeBytes(Boolean[] booleanArray, int n, int n2) {
            int n3 = n2 + 4 * booleanArray.length + (booleanArray.length - n);
            byte[] byArray = new byte[n3];
            int n4 = n2;
            for (int i = 0; i < booleanArray.length; ++i) {
                if (booleanArray[i] == null) {
                    ByteConverter.int4(byArray, n4, -1);
                    n4 += 4;
                    continue;
                }
                ByteConverter.int4(byArray, n4, 1);
                this.write(booleanArray[i], byArray, n4 += 4);
                ++n4;
            }
            return byArray;
        }

        private void write(Boolean bl, byte[] byArray, int n) {
            ByteConverter.bool(byArray, n, bl);
        }

        @Override
        byte[] toSingleDimensionBinaryRepresentation(BaseConnection baseConnection, Boolean[] booleanArray) {
            int n = this.countNulls(booleanArray);
            return this.writeBytes(booleanArray, n, 0);
        }

        @Override
        public void appendArray(StringBuilder stringBuilder, char c, Boolean[] booleanArray) {
            stringBuilder.append('{');
            for (int i = 0; i < booleanArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(c);
                }
                if (booleanArray[i] == null) {
                    stringBuilder.append('N').append('U').append('L').append('L');
                    continue;
                }
                stringBuilder.append(booleanArray[i] != false ? (char)'1' : '0');
            }
            stringBuilder.append('}');
        }
    };
    private static final AbstractArrayEncoder<String[]> STRING_ARRAY = new AbstractArrayEncoder<String[]>(1043, 1015){

        @Override
        int countNulls(String[] stringArray) {
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] != null) continue;
                ++n;
            }
            return n;
        }

        @Override
        public boolean supportBinaryRepresentation(int n) {
            return n == 1015 || n == 1009;
        }

        @Override
        int getTypeOID(int n) {
            if (n == 1015) {
                return 1043;
            }
            if (n == 1009) {
                return 25;
            }
            throw new IllegalStateException("Invalid array oid: " + n);
        }

        @Override
        public void appendArray(StringBuilder stringBuilder, char c, String[] stringArray) {
            stringBuilder.append('{');
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(c);
                }
                if (stringArray[i] == null) {
                    stringBuilder.append('N').append('U').append('L').append('L');
                    continue;
                }
                PgArray.escapeArrayElement(stringBuilder, stringArray[i]);
            }
            stringBuilder.append('}');
        }

        @Override
        public byte[] toBinaryRepresentation(BaseConnection baseConnection, String[] stringArray, int n) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(Math.min(1024, stringArray.length * 32 + 20));
            assert (this.supportBinaryRepresentation(n));
            byte[] byArray = new byte[4];
            try {
                ByteConverter.int4(byArray, 0, 1);
                byteArrayOutputStream.write(byArray);
                ByteConverter.int4(byArray, 0, this.countNulls(stringArray) > 0 ? 1 : 0);
                byteArrayOutputStream.write(byArray);
                ByteConverter.int4(byArray, 0, this.getTypeOID(n));
                byteArrayOutputStream.write(byArray);
                ByteConverter.int4(byArray, 0, stringArray.length);
                byteArrayOutputStream.write(byArray);
                ByteConverter.int4(byArray, 0, 1);
                byteArrayOutputStream.write(byArray);
                Encoding encoding = baseConnection.getEncoding();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    if (string != null) {
                        byte[] byArray2;
                        try {
                            byArray2 = encoding.encode(string);
                        }
                        catch (IOException iOException) {
                            throw new PSQLException(GT.tr("Unable to translate data into the desired encoding.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)iOException);
                        }
                        ByteConverter.int4(byArray, 0, byArray2.length);
                        byteArrayOutputStream.write(byArray);
                        byteArrayOutputStream.write(byArray2);
                        continue;
                    }
                    ByteConverter.int4(byArray, 0, -1);
                    byteArrayOutputStream.write(byArray);
                }
                return byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        byte[] toSingleDimensionBinaryRepresentation(BaseConnection baseConnection, String[] stringArray) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(Math.min(1024, stringArray.length * 32 + 20));
                byte[] byArray = new byte[4];
                Encoding encoding = baseConnection.getEncoding();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    if (string != null) {
                        byte[] byArray2;
                        try {
                            byArray2 = encoding.encode(string);
                        }
                        catch (IOException iOException) {
                            throw new PSQLException(GT.tr("Unable to translate data into the desired encoding.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)iOException);
                        }
                        ByteConverter.int4(byArray, 0, byArray2.length);
                        byteArrayOutputStream.write(byArray);
                        byteArrayOutputStream.write(byArray2);
                        continue;
                    }
                    ByteConverter.int4(byArray, 0, -1);
                    byteArrayOutputStream.write(byArray);
                }
                return byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
    };
    private static final AbstractArrayEncoder<byte[][]> BYTEA_ARRAY = new AbstractArrayEncoder<byte[][]>(17, 1001){
        private final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

        @Override
        public byte[] toBinaryRepresentation(BaseConnection baseConnection, byte[][] byArray, int n) {
            assert (n == this.arrayOid);
            int n2 = 20;
            for (int i = 0; i < byArray.length; ++i) {
                n2 += 4;
                if (byArray[i] == null) continue;
                n2 += byArray[i].length;
            }
            byte[] byArray2 = new byte[n2];
            ByteConverter.int4(byArray2, 0, 1);
            ByteConverter.int4(byArray2, 4, 0);
            ByteConverter.int4(byArray2, 8, this.getTypeOID(n));
            ByteConverter.int4(byArray2, 12, byArray.length);
            ByteConverter.int4(byArray2, 16, 1);
            this.write(byArray, byArray2, 20);
            return byArray2;
        }

        @Override
        byte[] toSingleDimensionBinaryRepresentation(BaseConnection baseConnection, byte[][] byArray) {
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                n += 4;
                if (byArray[i] == null) continue;
                n += byArray[i].length;
            }
            byte[] byArray2 = new byte[n];
            this.write(byArray, byArray2, 0);
            return byArray2;
        }

        @Override
        int countNulls(byte[][] byArray) {
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != null) continue;
                ++n;
            }
            return n;
        }

        private void write(byte[][] byArray, byte[] byArray2, int n) {
            int n2 = n;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != null) {
                    ByteConverter.int4(byArray2, n2, byArray[i].length);
                    System.arraycopy(byArray[i], 0, byArray2, n2 += 4, byArray[i].length);
                    n2 += byArray[i].length;
                    continue;
                }
                ByteConverter.int4(byArray2, n2, -1);
                n2 += 4;
            }
        }

        @Override
        public void appendArray(StringBuilder stringBuilder, char c, byte[][] byArray) {
            stringBuilder.append('{');
            for (int i = 0; i < byArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(c);
                }
                if (byArray[i] != null) {
                    stringBuilder.append("\"\\\\x");
                    for (int j = 0; j < byArray[i].length; ++j) {
                        byte by = byArray[i][j];
                        stringBuilder.append(this.hexDigits[(by & 0xF0) >>> 4]);
                        stringBuilder.append(this.hexDigits[by & 0xF]);
                    }
                    stringBuilder.append('\"');
                    continue;
                }
                stringBuilder.append("NULL");
            }
            stringBuilder.append('}');
        }
    };
    private static final AbstractArrayEncoder<Object[]> OBJECT_ARRAY = new AbstractArrayEncoder<Object[]>(0, 0){

        @Override
        public int getDefaultArrayTypeOid() {
            return 0;
        }

        @Override
        public boolean supportBinaryRepresentation(int n) {
            return false;
        }

        @Override
        public byte[] toBinaryRepresentation(BaseConnection baseConnection, Object[] objectArray, int n) {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        byte[] toSingleDimensionBinaryRepresentation(BaseConnection baseConnection, Object[] objectArray) {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public void appendArray(StringBuilder stringBuilder, char c, Object[] objectArray) {
            stringBuilder.append('{');
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(c);
                }
                if (objectArray[i] == null) {
                    stringBuilder.append('N').append('U').append('L').append('L');
                    continue;
                }
                if (objectArray[i].getClass().isArray()) {
                    if (objectArray[i] instanceof byte[]) {
                        throw new UnsupportedOperationException("byte[] nested inside Object[]");
                    }
                    try {
                        ArrayEncoding.getArrayEncoder(objectArray[i]).appendArray(stringBuilder, c, objectArray[i]);
                        continue;
                    }
                    catch (PSQLException pSQLException) {
                        throw new IllegalStateException(pSQLException);
                    }
                }
                PgArray.escapeArrayElement(stringBuilder, objectArray[i].toString());
            }
            stringBuilder.append('}');
        }
    };
    private static final Map<Class, AbstractArrayEncoder> ARRAY_CLASS_TO_ENCODER = new HashMap<Class, AbstractArrayEncoder>(19);

    ArrayEncoding() {
    }

    public static <A> ArrayEncoder<A> getArrayEncoder(A a) {
        Class<?> clazz = a.getClass();
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 == null) {
            throw new PSQLException(GT.tr("Invalid elements {0}", a), PSQLState.INVALID_PARAMETER_TYPE);
        }
        AbstractArrayEncoder abstractArrayEncoder = ARRAY_CLASS_TO_ENCODER.get(clazz2);
        if (abstractArrayEncoder != null) {
            return abstractArrayEncoder;
        }
        Class<?> clazz3 = clazz2.getComponentType();
        if (clazz3 == null) {
            if (Object.class.isAssignableFrom(clazz2)) {
                return OBJECT_ARRAY;
            }
            throw new PSQLException(GT.tr("Invalid elements {0}", a), PSQLState.INVALID_PARAMETER_TYPE);
        }
        clazz2 = clazz3;
        int n = 2;
        while (clazz2 != null) {
            abstractArrayEncoder = ARRAY_CLASS_TO_ENCODER.get(clazz2);
            if (abstractArrayEncoder != null) {
                if (n == 2) {
                    return new TwoDimensionPrimitiveArrayEncoder(abstractArrayEncoder);
                }
                return new RecursiveArrayEncoder(abstractArrayEncoder, n);
            }
            clazz3 = clazz2.getComponentType();
            if (clazz3 == null && Object.class.isAssignableFrom(clazz2)) {
                if (n == 2) {
                    return new TwoDimensionPrimitiveArrayEncoder<Object[]>(OBJECT_ARRAY);
                }
                return new RecursiveArrayEncoder(OBJECT_ARRAY, n);
            }
            ++n;
            clazz2 = clazz3;
        }
        throw new PSQLException(GT.tr("Invalid elements {0}", a), PSQLState.INVALID_PARAMETER_TYPE);
    }

    static {
        ARRAY_CLASS_TO_ENCODER.put(Long.TYPE, LONG_ARRAY);
        ARRAY_CLASS_TO_ENCODER.put(Long.class, LONG_OBJ_ARRAY);
        ARRAY_CLASS_TO_ENCODER.put(Integer.TYPE, INT_ARRAY);
        ARRAY_CLASS_TO_ENCODER.put(Integer.class, INT_OBJ_ARRAY);
        ARRAY_CLASS_TO_ENCODER.put(Short.TYPE, SHORT_ARRAY);
        ARRAY_CLASS_TO_ENCODER.put(Short.class, SHORT_OBJ_ARRAY);
        ARRAY_CLASS_TO_ENCODER.put(Double.TYPE, DOUBLE_ARRAY);
        ARRAY_CLASS_TO_ENCODER.put(Double.class, DOUBLE_OBJ_ARRAY);
        ARRAY_CLASS_TO_ENCODER.put(Float.TYPE, FLOAT_ARRAY);
        ARRAY_CLASS_TO_ENCODER.put(Float.class, FLOAT_OBJ_ARRAY);
        ARRAY_CLASS_TO_ENCODER.put(Boolean.TYPE, BOOLEAN_ARRAY);
        ARRAY_CLASS_TO_ENCODER.put(Boolean.class, BOOLEAN_OBJ_ARRAY);
        ARRAY_CLASS_TO_ENCODER.put(byte[].class, BYTEA_ARRAY);
        ARRAY_CLASS_TO_ENCODER.put(String.class, STRING_ARRAY);
    }

    private static final class RecursiveArrayEncoder
    implements ArrayEncoder {
        private final AbstractArrayEncoder support;
        private final @Positive int dimensions;

        RecursiveArrayEncoder(AbstractArrayEncoder abstractArrayEncoder, @Positive int n) {
            this.support = abstractArrayEncoder;
            this.dimensions = n;
            assert (n >= 2);
        }

        @Override
        public int getDefaultArrayTypeOid() {
            return this.support.getDefaultArrayTypeOid();
        }

        public String toArrayString(char c, Object object) {
            StringBuilder stringBuilder = new StringBuilder(2048);
            this.arrayString(stringBuilder, object, c, this.dimensions);
            return stringBuilder.toString();
        }

        public void appendArray(StringBuilder stringBuilder, char c, Object object) {
            this.arrayString(stringBuilder, object, c, this.dimensions);
        }

        private void arrayString(StringBuilder stringBuilder, Object object, char c, int n) {
            if (n > 1) {
                stringBuilder.append('{');
                int n2 = Array.getLength(object);
                for (int i = 0; i < n2; ++i) {
                    if (i > 0) {
                        stringBuilder.append(c);
                    }
                    this.arrayString(stringBuilder, Array.get(object, i), c, n - 1);
                }
                stringBuilder.append('}');
            } else {
                this.support.appendArray(stringBuilder, c, object);
            }
        }

        @Override
        public boolean supportBinaryRepresentation(int n) {
            return this.support.supportBinaryRepresentation(n);
        }

        private boolean hasNulls(Object object, int n) {
            if (n > 1) {
                int n2 = Array.getLength(object);
                for (int i = 0; i < n2; ++i) {
                    if (!this.hasNulls(Array.get(object, i), n - 1)) continue;
                    return true;
                }
                return false;
            }
            return this.support.countNulls(object) > 0;
        }

        public byte[] toBinaryRepresentation(BaseConnection baseConnection, Object object, int n) {
            boolean bl = this.hasNulls(object, this.dimensions);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024 * this.dimensions);
            byte[] byArray = new byte[4];
            try {
                ByteConverter.int4(byArray, 0, this.dimensions);
                byteArrayOutputStream.write(byArray);
                ByteConverter.int4(byArray, 0, bl ? 1 : 0);
                byteArrayOutputStream.write(byArray);
                ByteConverter.int4(byArray, 0, this.support.getTypeOID(n));
                byteArrayOutputStream.write(byArray);
                ByteConverter.int4(byArray, 0, Array.getLength(object));
                byteArrayOutputStream.write(byArray);
                ByteConverter.int4(byArray, 0, 1);
                byteArrayOutputStream.write(byArray);
                this.writeArray(baseConnection, byArray, byteArrayOutputStream, object, this.dimensions, true);
                return byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        private void writeArray(BaseConnection baseConnection, byte[] byArray, ByteArrayOutputStream byteArrayOutputStream, Object object, int n, boolean bl) {
            int n2 = Array.getLength(object);
            if (bl) {
                ByteConverter.int4(byArray, 0, n2 > 0 ? Array.getLength(Array.get(object, 0)) : 0);
                byteArrayOutputStream.write(byArray);
                ByteConverter.int4(byArray, 0, 1);
                byteArrayOutputStream.write(byArray);
            }
            for (int i = 0; i < n2; ++i) {
                Object object2 = Array.get(object, i);
                if (n > 2) {
                    this.writeArray(baseConnection, byArray, byteArrayOutputStream, object2, n - 1, i == 0);
                    continue;
                }
                byteArrayOutputStream.write(this.support.toSingleDimensionBinaryRepresentation(baseConnection, object2));
            }
        }
    }

    private static final class TwoDimensionPrimitiveArrayEncoder<A>
    implements ArrayEncoder<A[]> {
        private final AbstractArrayEncoder<A> support;

        TwoDimensionPrimitiveArrayEncoder(AbstractArrayEncoder<A> abstractArrayEncoder) {
            this.support = abstractArrayEncoder;
        }

        @Override
        public int getDefaultArrayTypeOid() {
            return this.support.getDefaultArrayTypeOid();
        }

        @Override
        public String toArrayString(char c, A[] AArray) {
            StringBuilder stringBuilder = new StringBuilder(1024);
            this.appendArray(stringBuilder, c, AArray);
            return stringBuilder.toString();
        }

        @Override
        public void appendArray(StringBuilder stringBuilder, char c, A[] AArray) {
            stringBuilder.append('{');
            for (int i = 0; i < AArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(c);
                }
                this.support.appendArray(stringBuilder, c, AArray[i]);
            }
            stringBuilder.append('}');
        }

        @Override
        public boolean supportBinaryRepresentation(int n) {
            return this.support.supportBinaryRepresentation(n);
        }

        @Override
        public byte[] toBinaryRepresentation(BaseConnection baseConnection, A[] AArray, int n) {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(Math.min(1024, AArray.length * 32 + 20));
            byte[] byArray = new byte[4];
            boolean bl = false;
            for (n2 = 0; !bl && n2 < AArray.length; ++n2) {
                if (this.support.countNulls(AArray[n2]) <= 0) continue;
                bl = true;
            }
            try {
                ByteConverter.int4(byArray, 0, 2);
                byteArrayOutputStream.write(byArray);
                ByteConverter.int4(byArray, 0, bl ? 1 : 0);
                byteArrayOutputStream.write(byArray);
                ByteConverter.int4(byArray, 0, this.support.getTypeOID(n));
                byteArrayOutputStream.write(byArray);
                ByteConverter.int4(byArray, 0, AArray.length);
                byteArrayOutputStream.write(byArray);
                ByteConverter.int4(byArray, 0, 1);
                byteArrayOutputStream.write(byArray);
                ByteConverter.int4(byArray, 0, AArray.length > 0 ? Array.getLength(AArray[0]) : 0);
                byteArrayOutputStream.write(byArray);
                ByteConverter.int4(byArray, 0, 1);
                byteArrayOutputStream.write(byArray);
                for (n2 = 0; n2 < AArray.length; ++n2) {
                    byteArrayOutputStream.write(this.support.toSingleDimensionBinaryRepresentation(baseConnection, AArray[n2]));
                }
                return byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
    }

    private static abstract class FixedSizePrimitiveArrayEncoder<A>
    extends AbstractArrayEncoder<A> {
        private final int fieldSize;

        FixedSizePrimitiveArrayEncoder(int n, int n2, int n3) {
            super(n2, n3);
            this.fieldSize = n;
        }

        @Override
        final int countNulls(A a) {
            return 0;
        }

        @Override
        public final byte[] toBinaryRepresentation(BaseConnection baseConnection, A a, int n) {
            assert (n == this.arrayOid);
            int n2 = Array.getLength(a);
            int n3 = 20 + (this.fieldSize + 4) * n2;
            byte[] byArray = new byte[n3];
            ByteConverter.int4(byArray, 0, 1);
            ByteConverter.int4(byArray, 4, 0);
            ByteConverter.int4(byArray, 8, this.getTypeOID(n));
            ByteConverter.int4(byArray, 12, n2);
            ByteConverter.int4(byArray, 16, 1);
            this.write(a, byArray, 20);
            return byArray;
        }

        @Override
        final byte[] toSingleDimensionBinaryRepresentation(BaseConnection baseConnection, A a) {
            int n = (this.fieldSize + 4) * Array.getLength(a);
            byte[] byArray = new byte[n];
            this.write(a, byArray, 0);
            return byArray;
        }

        protected abstract void write(A var1, byte[] var2, int var3);
    }

    private static abstract class NumberArrayEncoder<N extends Number>
    extends AbstractArrayEncoder<N[]> {
        private final int fieldSize;

        NumberArrayEncoder(int n, int n2, int n3) {
            super(n2, n3);
            this.fieldSize = n;
        }

        @Override
        final int countNulls(N[] NArray) {
            int n = 0;
            for (int i = 0; i < NArray.length; ++i) {
                if (NArray[i] != null) continue;
                ++n;
            }
            return n;
        }

        @Override
        public final byte[] toBinaryRepresentation(BaseConnection baseConnection, N[] NArray, int n) {
            assert (n == this.arrayOid);
            int n2 = ((AbstractArrayEncoder)this).countNulls(NArray);
            byte[] byArray = this.writeBytes((Number[])NArray, n2, 20);
            ByteConverter.int4(byArray, 0, 1);
            ByteConverter.int4(byArray, 4, n2 == 0 ? 0 : 1);
            ByteConverter.int4(byArray, 8, this.getTypeOID(n));
            ByteConverter.int4(byArray, 12, NArray.length);
            ByteConverter.int4(byArray, 16, 1);
            return byArray;
        }

        @Override
        final byte[] toSingleDimensionBinaryRepresentation(BaseConnection baseConnection, N[] NArray) {
            int n = ((AbstractArrayEncoder)this).countNulls(NArray);
            return this.writeBytes((Number[])NArray, n, 0);
        }

        private byte[] writeBytes(N[] NArray, int n, int n2) {
            int n3 = n2 + 4 * NArray.length + this.fieldSize * (NArray.length - n);
            byte[] byArray = new byte[n3];
            int n4 = n2;
            for (int i = 0; i < NArray.length; ++i) {
                if (NArray[i] == null) {
                    ByteConverter.int4(byArray, n4, -1);
                    n4 += 4;
                    continue;
                }
                ByteConverter.int4(byArray, n4, this.fieldSize);
                this.write(NArray[i], byArray, n4 += 4);
                n4 += this.fieldSize;
            }
            return byArray;
        }

        protected abstract void write(N var1, byte[] var2, int var3);

        @Override
        public final void appendArray(StringBuilder stringBuilder, char c, N[] NArray) {
            stringBuilder.append('{');
            for (int i = 0; i < NArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(c);
                }
                if (NArray[i] == null) {
                    stringBuilder.append('N').append('U').append('L').append('L');
                    continue;
                }
                stringBuilder.append('\"');
                stringBuilder.append(NArray[i].toString());
                stringBuilder.append('\"');
            }
            stringBuilder.append('}');
        }
    }

    private static abstract class AbstractArrayEncoder<A>
    implements ArrayEncoder<A> {
        private final int oid;
        final int arrayOid;

        AbstractArrayEncoder(int n, int n2) {
            this.oid = n;
            this.arrayOid = n2;
        }

        int getTypeOID(int n) {
            return this.oid;
        }

        @Override
        public int getDefaultArrayTypeOid() {
            return this.arrayOid;
        }

        int countNulls(A a) {
            int n = 0;
            int n2 = Array.getLength(a);
            for (int i = 0; i < n2; ++i) {
                if (Array.get(a, i) != null) continue;
                ++n;
            }
            return n;
        }

        abstract byte[] toSingleDimensionBinaryRepresentation(BaseConnection var1, A var2);

        @Override
        public String toArrayString(char c, A a) {
            StringBuilder stringBuilder = new StringBuilder(1024);
            this.appendArray(stringBuilder, c, a);
            return stringBuilder.toString();
        }

        @Override
        public boolean supportBinaryRepresentation(int n) {
            return n == this.arrayOid;
        }
    }

    static interface ArrayEncoder<A> {
        public int getDefaultArrayTypeOid();

        public String toArrayString(char var1, A var2);

        public boolean supportBinaryRepresentation(int var1);

        public byte[] toBinaryRepresentation(BaseConnection var1, A var2, int var3) throws SQLException, SQLFeatureNotSupportedException;

        public void appendArray(StringBuilder var1, char var2, A var3);
    }
}

