/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.util.CanEstimateSize;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FieldMetadata
implements CanEstimateSize {
    final String columnName;
    final String tableName;
    final String schemaName;
    final int nullable;
    final boolean autoIncrement;

    public FieldMetadata(String string) {
        this(string, "", "", 2, false);
    }

    FieldMetadata(String string, String string2, String string3, int n, boolean bl) {
        this.columnName = string;
        this.tableName = string2;
        this.schemaName = string3;
        this.nullable = n;
        this.autoIncrement = bl;
    }

    @Override
    public long getSize() {
        return (long)(this.columnName.length() * 2 + this.tableName.length() * 2 + this.schemaName.length() * 2) + 4L + 1L;
    }

    public String toString() {
        return "FieldMetadata{columnName='" + this.columnName + '\'' + ", tableName='" + this.tableName + '\'' + ", schemaName='" + this.schemaName + '\'' + ", nullable=" + this.nullable + ", autoIncrement=" + this.autoIncrement + '}';
    }

    public static class Key {
        final int tableOid;
        final int positionInTable;

        Key(int n, int n2) {
            this.positionInTable = n2;
            this.tableOid = n;
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Key key = (Key)object;
            if (this.tableOid != key.tableOid) {
                return false;
            }
            return this.positionInTable == key.positionInTable;
        }

        public int hashCode() {
            int n = this.tableOid;
            n = 31 * n + this.positionInTable;
            return n;
        }

        public String toString() {
            return "Key{tableOid=" + this.tableOid + ", positionInTable=" + this.positionInTable + '}';
        }
    }
}

