/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.PGProperty;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.util.Properties;

public enum GSSEncMode {
    DISABLE("disable"),
    ALLOW("allow"),
    PREFER("prefer"),
    REQUIRE("require");

    private static final GSSEncMode[] VALUES;
    public final String value;

    private GSSEncMode(String string2) {
        this.value = string2;
    }

    public boolean requireEncryption() {
        return this.compareTo(REQUIRE) >= 0;
    }

    public static GSSEncMode of(Properties properties) {
        String string = PGProperty.GSS_ENC_MODE.get(properties);
        if (string == null) {
            return ALLOW;
        }
        for (GSSEncMode gSSEncMode : VALUES) {
            if (!gSSEncMode.value.equalsIgnoreCase(string)) continue;
            return gSSEncMode;
        }
        throw new PSQLException(GT.tr("Invalid gssEncMode value: {0}", string), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    static {
        VALUES = GSSEncMode.values();
    }
}

