/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.Driver;
import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.core.BaseStatement;
import com.hm.postgresql.core.Field;
import com.hm.postgresql.core.Tuple;
import com.hm.postgresql.jdbc.ArrayDecoding;
import com.hm.postgresql.jdbc.ArrayEncoding;
import com.hm.postgresql.jdbc.UUIDArrayAssistant;
import com.hm.postgresql.jdbc2.ArrayAssistantRegistry;
import com.hm.postgresql.util.ByteConverter;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PgArray
implements Array {
    protected @Nullable BaseConnection connection;
    private final int oid;
    protected @Nullable String fieldString;
    protected @Nullable ArrayDecoding.PgArrayList arrayList;
    protected byte @Nullable [] fieldBytes;

    private PgArray(BaseConnection baseConnection, int n) {
        this.connection = baseConnection;
        this.oid = n;
    }

    public PgArray(BaseConnection baseConnection, int n, @Nullable String string) {
        this(baseConnection, n);
        this.fieldString = string;
    }

    public PgArray(BaseConnection baseConnection, int n, byte @Nullable [] byArray) {
        this(baseConnection, n);
        this.fieldBytes = byArray;
    }

    private BaseConnection getConnection() {
        return Nullness.castNonNull(this.connection);
    }

    @Override
    public Object getArray() {
        return this.getArrayImpl(1L, 0, null);
    }

    @Override
    public Object getArray(long l, int n) {
        return this.getArrayImpl(l, n, null);
    }

    public Object getArrayImpl(Map<String, Class<?>> map) {
        return this.getArrayImpl(1L, 0, map);
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) {
        return this.getArrayImpl(map);
    }

    @Override
    public Object getArray(long l, int n, @Nullable Map<String, Class<?>> map) {
        return this.getArrayImpl(l, n, map);
    }

    public @Nullable Object getArrayImpl(long l, int n, @Nullable Map<String, Class<?>> map) {
        if (map != null && !map.isEmpty()) {
            throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
        }
        if (l < 1L) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}", l), PSQLState.DATA_ERROR);
        }
        if (this.fieldBytes != null) {
            return this.readBinaryArray(this.fieldBytes, (int)l, n);
        }
        if (this.fieldString == null) {
            return null;
        }
        ArrayDecoding.PgArrayList pgArrayList = this.buildArrayList(this.fieldString);
        if (n == 0) {
            n = pgArrayList.size();
        }
        if (l - 1L + (long)n > (long)pgArrayList.size()) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}, number of elements: {1}.", l + (long)n, pgArrayList.size()), PSQLState.DATA_ERROR);
        }
        return this.buildArray(pgArrayList, (int)l, n);
    }

    private Object readBinaryArray(byte[] byArray, int n, int n2) {
        return ArrayDecoding.readBinaryArray(n, n2, byArray, this.getConnection());
    }

    private ResultSet readBinaryResultSet(byte[] byArray, int n, int n2) {
        int n3 = ByteConverter.int4(byArray, 0);
        int n4 = ByteConverter.int4(byArray, 8);
        int n5 = 12;
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = ByteConverter.int4(byArray, n5);
            n5 += 4;
            n5 += 4;
        }
        if (n2 > 0 && n3 > 0) {
            nArray[0] = Math.min(n2, nArray[0]);
        }
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        Field[] fieldArray = new Field[2];
        this.storeValues(byArray, arrayList, fieldArray, n4, nArray, n5, 0, n);
        BaseStatement baseStatement = (BaseStatement)this.getConnection().createStatement(1004, 1007);
        return baseStatement.createDriverResultSet(fieldArray, arrayList);
    }

    private int storeValues(byte[] byArray, List<Tuple> list, Field[] fieldArray, int n, int[] nArray, int n2, int n3, int n4) {
        if (nArray.length == 0) {
            fieldArray[0] = new Field("INDEX", 23);
            fieldArray[0].setFormat(1);
            fieldArray[1] = new Field("VALUE", n);
            fieldArray[1].setFormat(1);
            for (int i = 1; i < n4; ++i) {
                int n5 = ByteConverter.int4(byArray, n2);
                n2 += 4;
                if (n5 == -1) continue;
                n2 += n5;
            }
        } else if (n3 == nArray.length - 1) {
            int n6;
            fieldArray[0] = new Field("INDEX", 23);
            fieldArray[0].setFormat(1);
            fieldArray[1] = new Field("VALUE", n);
            fieldArray[1].setFormat(1);
            for (n6 = 1; n6 < n4; ++n6) {
                int n7 = ByteConverter.int4(byArray, n2);
                n2 += 4;
                if (n7 == -1) continue;
                n2 += n7;
            }
            for (n6 = 0; n6 < nArray[n3]; ++n6) {
                byte[][] byArrayArray = new byte[2][];
                byArrayArray[0] = new byte[4];
                ByteConverter.int4(byArrayArray[0], 0, n6 + n4);
                list.add(new Tuple(byArrayArray));
                int n8 = ByteConverter.int4(byArray, n2);
                n2 += 4;
                if (n8 == -1) continue;
                byArrayArray[1] = new byte[n8];
                System.arraycopy(byArray, n2, byArrayArray[1], 0, byArrayArray[1].length);
                n2 += n8;
            }
        } else {
            int n9;
            fieldArray[0] = new Field("INDEX", 23);
            fieldArray[0].setFormat(1);
            fieldArray[1] = new Field("VALUE", this.oid);
            fieldArray[1].setFormat(1);
            int n10 = n3 + 1;
            int n11 = nArray.length - n10;
            for (n9 = 1; n9 < n4; ++n9) {
                n2 = this.calcRemainingDataLength(byArray, nArray, n2, n, n10);
            }
            for (n9 = 0; n9 < nArray[n3]; ++n9) {
                byte[][] byArrayArray = new byte[2][];
                byArrayArray[0] = new byte[4];
                ByteConverter.int4(byArrayArray[0], 0, n9 + n4);
                list.add(new Tuple(byArrayArray));
                int n12 = this.calcRemainingDataLength(byArray, nArray, n2, n, n10);
                int n13 = n12 - n2;
                byArrayArray[1] = new byte[12 + 8 * n11 + n13];
                ByteConverter.int4(byArrayArray[1], 0, n11);
                System.arraycopy(byArray, 4, byArrayArray[1], 4, 8);
                System.arraycopy(byArray, 12 + n10 * 8, byArrayArray[1], 12, n11 * 8);
                System.arraycopy(byArray, n2, byArrayArray[1], 12 + n11 * 8, n13);
                n2 = n12;
            }
        }
        return n2;
    }

    private int calcRemainingDataLength(byte[] byArray, int[] nArray, int n, int n2, int n3) {
        if (n3 == nArray.length - 1) {
            for (int i = 0; i < nArray[n3]; ++i) {
                int n4 = ByteConverter.int4(byArray, n);
                n += 4;
                if (n4 == -1) continue;
                n += n4;
            }
        } else {
            n = this.calcRemainingDataLength(byArray, nArray, n2, n, n3 + 1);
        }
        return n;
    }

    private synchronized ArrayDecoding.PgArrayList buildArrayList(String string) {
        if (this.arrayList == null) {
            this.arrayList = ArrayDecoding.buildArrayList(string, this.getConnection().getTypeInfo().getArrayDelimiter(this.oid));
        }
        return this.arrayList;
    }

    private Object buildArray(ArrayDecoding.PgArrayList pgArrayList, int n, int n2) {
        BaseConnection baseConnection = this.getConnection();
        return ArrayDecoding.readStringArray(n, n2, baseConnection.getTypeInfo().getPGArrayElement(this.oid), pgArrayList, baseConnection);
    }

    @Override
    public int getBaseType() {
        return this.getConnection().getTypeInfo().getSQLType(this.getBaseTypeName());
    }

    @Override
    public String getBaseTypeName() {
        int n = this.getConnection().getTypeInfo().getPGArrayElement(this.oid);
        return Nullness.castNonNull(this.getConnection().getTypeInfo().getPGType(n));
    }

    @Override
    public ResultSet getResultSet() {
        return this.getResultSetImpl(1L, 0, null);
    }

    @Override
    public ResultSet getResultSet(long l, int n) {
        return this.getResultSetImpl(l, n, null);
    }

    @Override
    public ResultSet getResultSet(@Nullable Map<String, Class<?>> map) {
        return this.getResultSetImpl(map);
    }

    @Override
    public ResultSet getResultSet(long l, int n, @Nullable Map<String, Class<?>> map) {
        return this.getResultSetImpl(l, n, map);
    }

    public ResultSet getResultSetImpl(@Nullable Map<String, Class<?>> map) {
        return this.getResultSetImpl(1L, 0, map);
    }

    public ResultSet getResultSetImpl(long l, int n, @Nullable Map<String, Class<?>> map) {
        int n2;
        if (map != null && !map.isEmpty()) {
            throw Driver.notImplemented(this.getClass(), "getResultSetImpl(long,int,Map)");
        }
        if (l < 1L) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}", l), PSQLState.DATA_ERROR);
        }
        if (this.fieldBytes != null) {
            return this.readBinaryResultSet(this.fieldBytes, (int)l, n);
        }
        ArrayDecoding.PgArrayList pgArrayList = this.buildArrayList(Nullness.castNonNull(this.fieldString));
        if (n == 0) {
            n = pgArrayList.size();
        }
        if (--l + (long)n > (long)pgArrayList.size()) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}, number of elements: {1}.", l + (long)n, pgArrayList.size()), PSQLState.DATA_ERROR);
        }
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        Field[] fieldArray = new Field[2];
        if (pgArrayList.dimensionsCount <= 1) {
            n2 = this.getConnection().getTypeInfo().getPGArrayElement(this.oid);
            fieldArray[0] = new Field("INDEX", 23);
            fieldArray[1] = new Field("VALUE", n2);
            for (int i = 0; i < n; ++i) {
                int n3 = (int)l + i;
                byte[] @Nullable [] byArray = new byte[2][0];
                String string = (String)pgArrayList.get(n3);
                byArray[0] = this.getConnection().encodeString(Integer.toString(n3 + 1));
                byArray[1] = string == null ? null : this.getConnection().encodeString(string);
                arrayList.add(new Tuple(byArray));
            }
        } else {
            fieldArray[0] = new Field("INDEX", 23);
            fieldArray[1] = new Field("VALUE", this.oid);
            for (n2 = 0; n2 < n; ++n2) {
                int n4 = (int)l + n2;
                byte[] @Nullable [] byArray = new byte[2][0];
                Object e = pgArrayList.get(n4);
                byArray[0] = this.getConnection().encodeString(Integer.toString(n4 + 1));
                byArray[1] = e == null ? null : this.getConnection().encodeString(this.toString((ArrayDecoding.PgArrayList)e));
                arrayList.add(new Tuple(byArray));
            }
        }
        BaseStatement baseStatement = (BaseStatement)this.getConnection().createStatement(1004, 1007);
        return baseStatement.createDriverResultSet(fieldArray, arrayList);
    }

    public @Nullable String toString() {
        if (this.fieldString == null && this.fieldBytes != null) {
            try {
                Object object = this.readBinaryArray(this.fieldBytes, 1, 0);
                ArrayEncoding.ArrayEncoder<Object> arrayEncoder = ArrayEncoding.getArrayEncoder(object);
                assert (arrayEncoder != null);
                this.fieldString = arrayEncoder.toArrayString(this.connection.getTypeInfo().getArrayDelimiter(this.oid), object);
            }
            catch (SQLException sQLException) {
                this.fieldString = "NULL";
            }
        }
        return this.fieldString;
    }

    private String toString(ArrayDecoding.PgArrayList pgArrayList) {
        if (pgArrayList == null) {
            return "NULL";
        }
        StringBuilder stringBuilder = new StringBuilder().append('{');
        char c = this.getConnection().getTypeInfo().getArrayDelimiter(this.oid);
        for (int i = 0; i < pgArrayList.size(); ++i) {
            Object e = pgArrayList.get(i);
            if (i > 0) {
                stringBuilder.append(c);
            }
            if (e == null) {
                stringBuilder.append("NULL");
                continue;
            }
            if (e instanceof ArrayDecoding.PgArrayList) {
                stringBuilder.append(this.toString((ArrayDecoding.PgArrayList)e));
                continue;
            }
            PgArray.escapeArrayElement(stringBuilder, (String)e);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static void escapeArrayElement(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"' || c == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\"');
    }

    public boolean isBinary() {
        return this.fieldBytes != null;
    }

    public byte @Nullable [] toBytes() {
        return this.fieldBytes;
    }

    @Override
    public void free() {
        this.connection = null;
        this.fieldString = null;
        this.fieldBytes = null;
        this.arrayList = null;
    }

    static {
        ArrayAssistantRegistry.register(2950, new UUIDArrayAssistant());
        ArrayAssistantRegistry.register(2951, new UUIDArrayAssistant());
    }
}

