/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.Driver;
import com.hm.postgresql.core.ParameterList;
import com.hm.postgresql.core.Query;
import com.hm.postgresql.jdbc.BatchResultHandler;
import com.hm.postgresql.jdbc.CallableBatchResultHandler;
import com.hm.postgresql.jdbc.PgConnection;
import com.hm.postgresql.jdbc.PgPreparedStatement;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.nullness.qual.Nullable;

class PgCallableStatement
extends PgPreparedStatement
implements CallableStatement {
    private final boolean isFunction;
    private int @Nullable [] functionReturnType;
    private int @Nullable [] testReturn;
    private boolean returnTypeSet;
    protected @Nullable Object @Nullable [] callResult;
    private int lastIndex = 0;

    PgCallableStatement(PgConnection pgConnection, String string, int n, int n2, int n3) {
        super(pgConnection, pgConnection.borrowCallableQuery(string), n, n2, n3);
        this.isFunction = this.preparedQuery.isFunction;
        if (this.isFunction) {
            int n4 = this.preparedParameters.getInParameterCount() + 1;
            this.testReturn = new int[n4];
            this.functionReturnType = new int[n4];
        }
    }

    @Override
    public int executeUpdate() {
        if (this.isFunction) {
            this.executeWithFlags(0);
            return 0;
        }
        return super.executeUpdate();
    }

    @Override
    public @Nullable Object getObject(@Positive int n, @Nullable Map<String, Class<?>> map) {
        return this.getObjectImpl(n, map);
    }

    @Override
    public @Nullable Object getObject(String string, @Nullable Map<String, Class<?>> map) {
        return this.getObjectImpl(string, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeWithFlags(int n) {
        int n2;
        boolean bl = super.executeWithFlags(n);
        int[] nArray = this.functionReturnType;
        if (!this.isFunction || !this.returnTypeSet || nArray == null) {
            return bl;
        }
        if (!bl) {
            throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet resultSet = Nullness.castNonNull(this.getResultSet());
        if (!resultSet.next()) {
            throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned.", new Object[0]), PSQLState.NO_DATA);
        }
        int n3 = resultSet.getMetaData().getColumnCount();
        if (n3 != (n2 = this.preparedParameters.getOutParameterCount())) {
            throw new PSQLException(GT.tr("A CallableStatement was executed with an invalid number of parameters", new Object[0]), PSQLState.SYNTAX_ERROR);
        }
        this.lastIndex = 0;
        @Nullable Object[] objectArray = new Object[this.preparedParameters.getParameterCount() + 1];
        this.callResult = objectArray;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            while (n5 < nArray.length && nArray[n5] == 0) {
                ++n5;
            }
            objectArray[n5] = resultSet.getObject(n4 + 1);
            int n6 = resultSet.getMetaData().getColumnType(n4 + 1);
            if (n6 != nArray[n5]) {
                if (n6 == 8 && nArray[n5] == 7) {
                    Object object = objectArray[n5];
                    if (object != null) {
                        objectArray[n5] = Float.valueOf(((Double)object).floatValue());
                    }
                } else if (n6 != 2012 || nArray[n5] != 1111) {
                    throw new PSQLException(GT.tr("A CallableStatement function was executed and the out parameter {0} was of type {1} however type {2} was registered.", n4 + 1, "java.sql.Types=" + n6, "java.sql.Types=" + nArray[n5]), PSQLState.DATA_TYPE_MISMATCH);
                }
            }
            ++n4;
            ++n5;
        }
        resultSet.close();
        PgCallableStatement pgCallableStatement = this;
        synchronized (pgCallableStatement) {
            this.result = null;
        }
        return false;
    }

    @Override
    public void registerOutParameter(@Positive int n, int n2) {
        this.checkClosed();
        switch (n2) {
            case -6: {
                n2 = 5;
                break;
            }
            case -1: {
                n2 = 12;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 8;
                break;
            }
            case -4: 
            case -3: {
                n2 = -2;
                break;
            }
            case 16: {
                n2 = -7;
                break;
            }
        }
        int[] nArray = this.functionReturnType;
        int[] nArray2 = this.testReturn;
        if (!this.isFunction || nArray == null || nArray2 == null) {
            throw new PSQLException(GT.tr("This statement does not declare an OUT parameter.  Use '{' ?= call ... '}' to declare one.", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        this.preparedParameters.registerOutParameter(n, n2);
        nArray[n - 1] = n2;
        nArray2[n - 1] = n2;
        if (nArray[n - 1] == 1 || nArray[n - 1] == -1) {
            nArray2[n - 1] = 12;
        } else if (nArray[n - 1] == 6) {
            nArray2[n - 1] = 7;
        }
        this.returnTypeSet = true;
    }

    @Override
    public boolean wasNull() {
        if (this.lastIndex == 0 || this.callResult == null) {
            throw new PSQLException(GT.tr("wasNull cannot be call before fetching a result.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        return this.callResult[this.lastIndex - 1] == null;
    }

    @Override
    public @Nullable String getString(@Positive int n) {
        Object object = this.checkIndex(n, 12, "String");
        return (String)object;
    }

    @Override
    public boolean getBoolean(@Positive int n) {
        Object object = this.checkIndex(n, -7, "Boolean");
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    @Override
    public byte getByte(@Positive int n) {
        Object object = this.checkIndex(n, 5, "Byte");
        if (object == null) {
            return 0;
        }
        return ((Integer)object).byteValue();
    }

    @Override
    public short getShort(@Positive int n) {
        Object object = this.checkIndex(n, 5, "Short");
        if (object == null) {
            return 0;
        }
        return ((Integer)object).shortValue();
    }

    @Override
    public int getInt(@Positive int n) {
        Object object = this.checkIndex(n, 4, "Int");
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    @Override
    public long getLong(@Positive int n) {
        Object object = this.checkIndex(n, -5, "Long");
        if (object == null) {
            return 0L;
        }
        return (Long)object;
    }

    @Override
    public float getFloat(@Positive int n) {
        Object object = this.checkIndex(n, 7, "Float");
        if (object == null) {
            return 0.0f;
        }
        return ((Float)object).floatValue();
    }

    @Override
    public double getDouble(@Positive int n) {
        Object object = this.checkIndex(n, 8, "Double");
        if (object == null) {
            return 0.0;
        }
        return (Double)object;
    }

    @Override
    public @Nullable BigDecimal getBigDecimal(@Positive int n, int n2) {
        Object object = this.checkIndex(n, 2, "BigDecimal");
        return (BigDecimal)object;
    }

    @Override
    public byte @Nullable [] getBytes(@Positive int n) {
        Object object = this.checkIndex(n, -3, -2, "Bytes");
        return (byte[])object;
    }

    @Override
    public @Nullable Date getDate(@Positive int n) {
        Object object = this.checkIndex(n, 91, "Date");
        return (Date)object;
    }

    @Override
    public @Nullable Time getTime(@Positive int n) {
        Object object = this.checkIndex(n, 92, "Time");
        return (Time)object;
    }

    @Override
    public @Nullable Timestamp getTimestamp(@Positive int n) {
        Object object = this.checkIndex(n, 93, "Timestamp");
        return (Timestamp)object;
    }

    @Override
    public @Nullable Object getObject(@Positive int n) {
        return this.getCallResult(n);
    }

    protected @Nullable Object checkIndex(@Positive int n, int n2, int n3, String string) {
        int n4;
        Object object = this.getCallResult(n);
        int n5 = n4 = this.testReturn != null ? this.testReturn[n - 1] : -1;
        if (n2 != n4 && n3 != n4) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", "java.sql.Types=" + n4, string, "java.sql.Types=" + n2), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
        return object;
    }

    protected @Nullable Object checkIndex(@Positive int n, int n2, String string) {
        int n3;
        Object object = this.getCallResult(n);
        int n4 = n3 = this.testReturn != null ? this.testReturn[n - 1] : -1;
        if (n2 != n3) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", "java.sql.Types=" + n3, string, "java.sql.Types=" + n2), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
        return object;
    }

    private @Nullable Object getCallResult(@Positive int n) {
        this.checkClosed();
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("A CallableStatement was declared, but no call to registerOutParameter(1, <some type>) was made.", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (!this.returnTypeSet) {
            throw new PSQLException(GT.tr("No function outputs were registered.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        @Nullable Object @Nullable [] objectArray = this.callResult;
        if (objectArray == null) {
            throw new PSQLException(GT.tr("Results cannot be retrieved from a CallableStatement before it is executed.", new Object[0]), PSQLState.NO_DATA);
        }
        this.lastIndex = n;
        return objectArray[n - 1];
    }

    @Override
    protected BatchResultHandler createBatchHandler(Query[] queryArray, @Nullable ParameterList[] parameterListArray) {
        return new CallableBatchResultHandler(this, queryArray, parameterListArray);
    }

    @Override
    public @Nullable Array getArray(int n) {
        Object object = this.checkIndex(n, 2003, "Array");
        return (Array)object;
    }

    @Override
    public @Nullable BigDecimal getBigDecimal(@Positive int n) {
        Object object = this.checkIndex(n, 2, "BigDecimal");
        return (BigDecimal)object;
    }

    @Override
    public @Nullable Blob getBlob(int n) {
        throw Driver.notImplemented(this.getClass(), "getBlob(int)");
    }

    @Override
    public @Nullable Clob getClob(int n) {
        throw Driver.notImplemented(this.getClass(), "getClob(int)");
    }

    public @Nullable Object getObjectImpl(int n, @Nullable Map<String, Class<?>> map) {
        if (map == null || map.isEmpty()) {
            return this.getObject(n);
        }
        throw Driver.notImplemented(this.getClass(), "getObjectImpl(int,Map)");
    }

    @Override
    public @Nullable Ref getRef(int n) {
        throw Driver.notImplemented(this.getClass(), "getRef(int)");
    }

    @Override
    public @Nullable Date getDate(int n, @Nullable Calendar calendar) {
        Object object = this.checkIndex(n, 91, "Date");
        if (object == null) {
            return null;
        }
        String string = object.toString();
        return this.connection.getTimestampUtils().toDate(calendar, string);
    }

    @Override
    public @Nullable Time getTime(int n, @Nullable Calendar calendar) {
        Object object = this.checkIndex(n, 92, "Time");
        if (object == null) {
            return null;
        }
        String string = object.toString();
        return this.connection.getTimestampUtils().toTime(calendar, string);
    }

    @Override
    public @Nullable Timestamp getTimestamp(int n, @Nullable Calendar calendar) {
        Object object = this.checkIndex(n, 93, "Timestamp");
        if (object == null) {
            return null;
        }
        String string = object.toString();
        return this.connection.getTimestampUtils().toTimestamp(calendar, string);
    }

    @Override
    public void registerOutParameter(@Positive int n, int n2, String string) {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(int,int,String)");
    }

    @Override
    public void setObject(String string, @Nullable Object object, SQLType sQLType, int n) {
        throw Driver.notImplemented(this.getClass(), "setObject");
    }

    @Override
    public void setObject(String string, @Nullable Object object, SQLType sQLType) {
        throw Driver.notImplemented(this.getClass(), "setObject");
    }

    @Override
    public void registerOutParameter(@Positive int n, SQLType sQLType) {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(@Positive int n, SQLType sQLType, int n2) {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(@Positive int n, SQLType sQLType, String string) {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(String string, SQLType sQLType) {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(String string, SQLType sQLType, int n) {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(String string, SQLType sQLType, String string2) {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public @Nullable RowId getRowId(@Positive int n) {
        throw Driver.notImplemented(this.getClass(), "getRowId(int)");
    }

    @Override
    public @Nullable RowId getRowId(String string) {
        throw Driver.notImplemented(this.getClass(), "getRowId(String)");
    }

    @Override
    public void setRowId(String string, @Nullable RowId rowId) {
        throw Driver.notImplemented(this.getClass(), "setRowId(String, RowId)");
    }

    @Override
    public void setNString(String string, @Nullable String string2) {
        throw Driver.notImplemented(this.getClass(), "setNString(String, String)");
    }

    @Override
    public void setNCharacterStream(String string, @Nullable Reader reader, long l) {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(String, Reader, long)");
    }

    @Override
    public void setNCharacterStream(String string, @Nullable Reader reader) {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(String, Reader)");
    }

    @Override
    public void setCharacterStream(String string, @Nullable Reader reader, long l) {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(String, Reader, long)");
    }

    @Override
    public void setCharacterStream(String string, @Nullable Reader reader) {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(String, Reader)");
    }

    @Override
    public void setBinaryStream(String string, @Nullable InputStream inputStream, long l) {
        throw Driver.notImplemented(this.getClass(), "setBinaryStream(String, InputStream, long)");
    }

    @Override
    public void setBinaryStream(String string, @Nullable InputStream inputStream) {
        throw Driver.notImplemented(this.getClass(), "setBinaryStream(String, InputStream)");
    }

    @Override
    public void setAsciiStream(String string, @Nullable InputStream inputStream, long l) {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(String, InputStream, long)");
    }

    @Override
    public void setAsciiStream(String string, @Nullable InputStream inputStream) {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(String, InputStream)");
    }

    @Override
    public void setNClob(String string, @Nullable NClob nClob) {
        throw Driver.notImplemented(this.getClass(), "setNClob(String, NClob)");
    }

    @Override
    public void setClob(String string, @Nullable Reader reader, long l) {
        throw Driver.notImplemented(this.getClass(), "setClob(String, Reader, long)");
    }

    @Override
    public void setClob(String string, @Nullable Reader reader) {
        throw Driver.notImplemented(this.getClass(), "setClob(String, Reader)");
    }

    @Override
    public void setBlob(String string, @Nullable InputStream inputStream, long l) {
        throw Driver.notImplemented(this.getClass(), "setBlob(String, InputStream, long)");
    }

    @Override
    public void setBlob(String string, @Nullable InputStream inputStream) {
        throw Driver.notImplemented(this.getClass(), "setBlob(String, InputStream)");
    }

    @Override
    public void setBlob(String string, @Nullable Blob blob) {
        throw Driver.notImplemented(this.getClass(), "setBlob(String, Blob)");
    }

    @Override
    public void setClob(String string, @Nullable Clob clob) {
        throw Driver.notImplemented(this.getClass(), "setClob(String, Clob)");
    }

    @Override
    public void setNClob(String string, @Nullable Reader reader, long l) {
        throw Driver.notImplemented(this.getClass(), "setNClob(String, Reader, long)");
    }

    @Override
    public void setNClob(String string, @Nullable Reader reader) {
        throw Driver.notImplemented(this.getClass(), "setNClob(String, Reader)");
    }

    @Override
    public @Nullable NClob getNClob(@Positive int n) {
        throw Driver.notImplemented(this.getClass(), "getNClob(int)");
    }

    @Override
    public @Nullable NClob getNClob(String string) {
        throw Driver.notImplemented(this.getClass(), "getNClob(String)");
    }

    @Override
    public void setSQLXML(String string, @Nullable SQLXML sQLXML) {
        throw Driver.notImplemented(this.getClass(), "setSQLXML(String, SQLXML)");
    }

    @Override
    public @Nullable SQLXML getSQLXML(@Positive int n) {
        Object object = this.checkIndex(n, 2009, "SQLXML");
        return (SQLXML)object;
    }

    @Override
    public @Nullable SQLXML getSQLXML(String string) {
        throw Driver.notImplemented(this.getClass(), "getSQLXML(String)");
    }

    @Override
    public String getNString(@Positive int n) {
        throw Driver.notImplemented(this.getClass(), "getNString(int)");
    }

    @Override
    public @Nullable String getNString(String string) {
        throw Driver.notImplemented(this.getClass(), "getNString(String)");
    }

    @Override
    public @Nullable Reader getNCharacterStream(@Positive int n) {
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(int)");
    }

    @Override
    public @Nullable Reader getNCharacterStream(String string) {
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(String)");
    }

    @Override
    public @Nullable Reader getCharacterStream(@Positive int n) {
        throw Driver.notImplemented(this.getClass(), "getCharacterStream(int)");
    }

    @Override
    public @Nullable Reader getCharacterStream(String string) {
        throw Driver.notImplemented(this.getClass(), "getCharacterStream(String)");
    }

    @Override
    public <T> @Nullable T getObject(@Positive int n, Class<T> clazz) {
        if (clazz == ResultSet.class) {
            return clazz.cast(this.getObject(n));
        }
        throw new PSQLException(GT.tr("Unsupported type conversion to {1}.", clazz), PSQLState.INVALID_PARAMETER_VALUE);
    }

    @Override
    public <T> @Nullable T getObject(String string, Class<T> clazz) {
        throw Driver.notImplemented(this.getClass(), "getObject(String, Class<T>)");
    }

    @Override
    public void registerOutParameter(String string, int n) {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(String,int)");
    }

    @Override
    public void registerOutParameter(String string, int n, int n2) {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(String,int,int)");
    }

    @Override
    public void registerOutParameter(String string, int n, String string2) {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(String,int,String)");
    }

    @Override
    public @Nullable URL getURL(@Positive int n) {
        throw Driver.notImplemented(this.getClass(), "getURL(String)");
    }

    @Override
    public void setURL(String string, @Nullable URL uRL) {
        throw Driver.notImplemented(this.getClass(), "setURL(String,URL)");
    }

    @Override
    public void setNull(String string, int n) {
        throw Driver.notImplemented(this.getClass(), "setNull(String,int)");
    }

    @Override
    public void setBoolean(String string, boolean bl) {
        throw Driver.notImplemented(this.getClass(), "setBoolean(String,boolean)");
    }

    @Override
    public void setByte(String string, byte by) {
        throw Driver.notImplemented(this.getClass(), "setByte(String,byte)");
    }

    @Override
    public void setShort(String string, short s) {
        throw Driver.notImplemented(this.getClass(), "setShort(String,short)");
    }

    @Override
    public void setInt(String string, int n) {
        throw Driver.notImplemented(this.getClass(), "setInt(String,int)");
    }

    @Override
    public void setLong(String string, long l) {
        throw Driver.notImplemented(this.getClass(), "setLong(String,long)");
    }

    @Override
    public void setFloat(String string, float f) {
        throw Driver.notImplemented(this.getClass(), "setFloat(String,float)");
    }

    @Override
    public void setDouble(String string, double d) {
        throw Driver.notImplemented(this.getClass(), "setDouble(String,double)");
    }

    @Override
    public void setBigDecimal(String string, @Nullable BigDecimal bigDecimal) {
        throw Driver.notImplemented(this.getClass(), "setBigDecimal(String,BigDecimal)");
    }

    @Override
    public void setString(String string, @Nullable String string2) {
        throw Driver.notImplemented(this.getClass(), "setString(String,String)");
    }

    @Override
    public void setBytes(String string, byte @Nullable [] byArray) {
        throw Driver.notImplemented(this.getClass(), "setBytes(String,byte)");
    }

    @Override
    public void setDate(String string, @Nullable Date date) {
        throw Driver.notImplemented(this.getClass(), "setDate(String,Date)");
    }

    @Override
    public void setTime(String string, @Nullable Time time) {
        throw Driver.notImplemented(this.getClass(), "setTime(String,Time)");
    }

    @Override
    public void setTimestamp(String string, @Nullable Timestamp timestamp) {
        throw Driver.notImplemented(this.getClass(), "setTimestamp(String,Timestamp)");
    }

    @Override
    public void setAsciiStream(String string, @Nullable InputStream inputStream, int n) {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(String,InputStream,int)");
    }

    @Override
    public void setBinaryStream(String string, @Nullable InputStream inputStream, int n) {
        throw Driver.notImplemented(this.getClass(), "setBinaryStream(String,InputStream,int)");
    }

    @Override
    public void setObject(String string, @Nullable Object object, int n, int n2) {
        throw Driver.notImplemented(this.getClass(), "setObject(String,Object,int,int)");
    }

    @Override
    public void setObject(String string, @Nullable Object object, int n) {
        throw Driver.notImplemented(this.getClass(), "setObject(String,Object,int)");
    }

    @Override
    public void setObject(String string, @Nullable Object object) {
        throw Driver.notImplemented(this.getClass(), "setObject(String,Object)");
    }

    @Override
    public void setCharacterStream(String string, @Nullable Reader reader, int n) {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(String,Reader,int)");
    }

    @Override
    public void setDate(String string, @Nullable Date date, @Nullable Calendar calendar) {
        throw Driver.notImplemented(this.getClass(), "setDate(String,Date,Calendar)");
    }

    @Override
    public void setTime(String string, @Nullable Time time, @Nullable Calendar calendar) {
        throw Driver.notImplemented(this.getClass(), "setTime(String,Time,Calendar)");
    }

    @Override
    public void setTimestamp(String string, @Nullable Timestamp timestamp, @Nullable Calendar calendar) {
        throw Driver.notImplemented(this.getClass(), "setTimestamp(String,Timestamp,Calendar)");
    }

    @Override
    public void setNull(String string, int n, String string2) {
        throw Driver.notImplemented(this.getClass(), "setNull(String,int,String)");
    }

    @Override
    public @Nullable String getString(String string) {
        throw Driver.notImplemented(this.getClass(), "getString(String)");
    }

    @Override
    public boolean getBoolean(String string) {
        throw Driver.notImplemented(this.getClass(), "getBoolean(String)");
    }

    @Override
    public byte getByte(String string) {
        throw Driver.notImplemented(this.getClass(), "getByte(String)");
    }

    @Override
    public short getShort(String string) {
        throw Driver.notImplemented(this.getClass(), "getShort(String)");
    }

    @Override
    public int getInt(String string) {
        throw Driver.notImplemented(this.getClass(), "getInt(String)");
    }

    @Override
    public long getLong(String string) {
        throw Driver.notImplemented(this.getClass(), "getLong(String)");
    }

    @Override
    public float getFloat(String string) {
        throw Driver.notImplemented(this.getClass(), "getFloat(String)");
    }

    @Override
    public double getDouble(String string) {
        throw Driver.notImplemented(this.getClass(), "getDouble(String)");
    }

    @Override
    public byte @Nullable [] getBytes(String string) {
        throw Driver.notImplemented(this.getClass(), "getBytes(String)");
    }

    @Override
    public @Nullable Date getDate(String string) {
        throw Driver.notImplemented(this.getClass(), "getDate(String)");
    }

    @Override
    public Time getTime(String string) {
        throw Driver.notImplemented(this.getClass(), "getTime(String)");
    }

    @Override
    public @Nullable Timestamp getTimestamp(String string) {
        throw Driver.notImplemented(this.getClass(), "getTimestamp(String)");
    }

    @Override
    public @Nullable Object getObject(String string) {
        throw Driver.notImplemented(this.getClass(), "getObject(String)");
    }

    @Override
    public @Nullable BigDecimal getBigDecimal(String string) {
        throw Driver.notImplemented(this.getClass(), "getBigDecimal(String)");
    }

    public @Nullable Object getObjectImpl(String string, @Nullable Map<String, Class<?>> map) {
        throw Driver.notImplemented(this.getClass(), "getObject(String,Map)");
    }

    @Override
    public @Nullable Ref getRef(String string) {
        throw Driver.notImplemented(this.getClass(), "getRef(String)");
    }

    @Override
    public @Nullable Blob getBlob(String string) {
        throw Driver.notImplemented(this.getClass(), "getBlob(String)");
    }

    @Override
    public @Nullable Clob getClob(String string) {
        throw Driver.notImplemented(this.getClass(), "getClob(String)");
    }

    @Override
    public @Nullable Array getArray(String string) {
        throw Driver.notImplemented(this.getClass(), "getArray(String)");
    }

    @Override
    public @Nullable Date getDate(String string, @Nullable Calendar calendar) {
        throw Driver.notImplemented(this.getClass(), "getDate(String,Calendar)");
    }

    @Override
    public @Nullable Time getTime(String string, @Nullable Calendar calendar) {
        throw Driver.notImplemented(this.getClass(), "getTime(String,Calendar)");
    }

    @Override
    public @Nullable Timestamp getTimestamp(String string, @Nullable Calendar calendar) {
        throw Driver.notImplemented(this.getClass(), "getTimestamp(String,Calendar)");
    }

    @Override
    public @Nullable URL getURL(String string) {
        throw Driver.notImplemented(this.getClass(), "getURL(String)");
    }

    @Override
    public void registerOutParameter(@Positive int n, int n2, int n3) {
        this.registerOutParameter(n, n2);
    }
}

