/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.Driver;
import com.hm.postgresql.PGNotification;
import com.hm.postgresql.PGProperty;
import com.hm.postgresql.copy.CopyManager;
import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.core.BaseStatement;
import com.hm.postgresql.core.CachedQuery;
import com.hm.postgresql.core.ConnectionFactory;
import com.hm.postgresql.core.Encoding;
import com.hm.postgresql.core.Oid;
import com.hm.postgresql.core.Query;
import com.hm.postgresql.core.QueryExecutor;
import com.hm.postgresql.core.ReplicationProtocol;
import com.hm.postgresql.core.ResultHandlerBase;
import com.hm.postgresql.core.ServerVersion;
import com.hm.postgresql.core.SqlCommand;
import com.hm.postgresql.core.TransactionState;
import com.hm.postgresql.core.TypeInfo;
import com.hm.postgresql.core.Utils;
import com.hm.postgresql.core.Version;
import com.hm.postgresql.fastpath.Fastpath;
import com.hm.postgresql.geometric.PGbox;
import com.hm.postgresql.geometric.PGcircle;
import com.hm.postgresql.geometric.PGline;
import com.hm.postgresql.geometric.PGlseg;
import com.hm.postgresql.geometric.PGpath;
import com.hm.postgresql.geometric.PGpoint;
import com.hm.postgresql.geometric.PGpolygon;
import com.hm.postgresql.jdbc.ArrayEncoding;
import com.hm.postgresql.jdbc.AutoSave;
import com.hm.postgresql.jdbc.FieldMetadata;
import com.hm.postgresql.jdbc.PSQLSavepoint;
import com.hm.postgresql.jdbc.PgArray;
import com.hm.postgresql.jdbc.PgBlob;
import com.hm.postgresql.jdbc.PgCallableStatement;
import com.hm.postgresql.jdbc.PgClob;
import com.hm.postgresql.jdbc.PgDatabaseMetaData;
import com.hm.postgresql.jdbc.PgPreparedStatement;
import com.hm.postgresql.jdbc.PgSQLXML;
import com.hm.postgresql.jdbc.PgStatement;
import com.hm.postgresql.jdbc.PreferQueryMode;
import com.hm.postgresql.jdbc.QueryExecutorTimeZoneProvider;
import com.hm.postgresql.jdbc.TimestampUtils;
import com.hm.postgresql.jdbc.TypeInfoCache;
import com.hm.postgresql.largeobject.LargeObjectManager;
import com.hm.postgresql.replication.PGReplicationConnection;
import com.hm.postgresql.replication.PGReplicationConnectionImpl;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.HostSpec;
import com.hm.postgresql.util.LruCache;
import com.hm.postgresql.util.PGBinaryObject;
import com.hm.postgresql.util.PGInterval;
import com.hm.postgresql.util.PGmoney;
import com.hm.postgresql.util.PGobject;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import com.hm.postgresql.xml.DefaultPGXmlFactoryFactory;
import com.hm.postgresql.xml.LegacyInsecurePGXmlFactoryFactory;
import com.hm.postgresql.xml.PGXmlFactoryFactory;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.dataflow.qual.Pure;

public class PgConnection
implements BaseConnection {
    private static final Logger LOGGER = Logger.getLogger(PgConnection.class.getName());
    private static final Set<Integer> SUPPORTED_BINARY_OIDS = PgConnection.getSupportedBinaryOids();
    private static final SQLPermission SQL_PERMISSION_ABORT = new SQLPermission("callAbort");
    private static final SQLPermission SQL_PERMISSION_NETWORK_TIMEOUT = new SQLPermission("setNetworkTimeout");
    private final Properties clientInfo;
    private final String creatingURL;
    private final ReadOnlyBehavior readOnlyBehavior;
    private @Nullable Throwable openStackTrace;
    private final QueryExecutor queryExecutor;
    private final Query commitQuery;
    private final Query rollbackQuery;
    private final CachedQuery setSessionReadOnly;
    private final CachedQuery setSessionNotReadOnly;
    private final TypeInfo typeCache;
    private boolean disableColumnSanitiser = false;
    protected int prepareThreshold;
    protected int defaultFetchSize;
    protected boolean forcebinary = false;
    private int rsHoldability = 2;
    private int savepointId = 0;
    private boolean autoCommit = true;
    private boolean readOnly = false;
    private boolean hideUnprivilegedObjects;
    private final boolean logServerErrorDetail;
    private final boolean bindStringAsVarchar;
    private @Nullable SQLWarning firstWarning;
    private volatile @Nullable Timer cancelTimer;
    private @Nullable PreparedStatement checkConnectionQuery;
    private final boolean replicationConnection;
    private final LruCache<FieldMetadata.Key, FieldMetadata> fieldMetadataCache;
    private final @Nullable String xmlFactoryFactoryClass;
    private @Nullable PGXmlFactoryFactory xmlFactoryFactory;
    private final TimestampUtils timestampUtils;
    protected Map<String, Class<?>> typemap = new HashMap();
    private @Nullable Fastpath fastpath;
    private @Nullable LargeObjectManager largeobject;
    protected @Nullable DatabaseMetaData metadata;
    private @Nullable CopyManager copyManager;

    final CachedQuery borrowQuery(String string) {
        return this.queryExecutor.borrowQuery(string);
    }

    final CachedQuery borrowCallableQuery(String string) {
        return this.queryExecutor.borrowCallableQuery(string);
    }

    private CachedQuery borrowReturningQuery(String string, String @Nullable [] stringArray) {
        return this.queryExecutor.borrowReturningQuery(string, stringArray);
    }

    @Override
    public CachedQuery createQuery(String string, boolean bl, boolean bl2, String ... stringArray) {
        return this.queryExecutor.createQuery(string, bl, bl2, stringArray);
    }

    void releaseQuery(CachedQuery cachedQuery) {
        this.queryExecutor.releaseQuery(cachedQuery);
    }

    @Override
    public void setFlushCacheOnDeallocate(boolean bl) {
        this.queryExecutor.setFlushCacheOnDeallocate(bl);
        LOGGER.log(Level.FINE, "  setFlushCacheOnDeallocate = {0}", bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PgConnection(HostSpec[] hostSpecArray, String string, String string2, Properties properties, String string3) {
        String string4;
        LOGGER.log(Level.FINE, "PostgreSQL JDBC Driver 42.3.1");
        this.creatingURL = string3;
        this.readOnlyBehavior = PgConnection.getReadOnlyBehavior(PGProperty.READ_ONLY_MODE.get(properties));
        this.setDefaultFetchSize(PGProperty.DEFAULT_ROW_FETCH_SIZE.getInt(properties));
        this.setPrepareThreshold(PGProperty.PREPARE_THRESHOLD.getInt(properties));
        if (this.prepareThreshold == -1) {
            this.setForceBinary(true);
        }
        this.queryExecutor = ConnectionFactory.openConnection(hostSpecArray, string, string2, properties);
        if (LOGGER.isLoggable(Level.WARNING) && !this.haveMinimumServerVersion(ServerVersion.v8_2)) {
            LOGGER.log(Level.WARNING, "Unsupported Server Version: {0}", this.queryExecutor.getServerVersion());
        }
        this.setSessionReadOnly = this.createQuery("SET SESSION CHARACTERISTICS AS TRANSACTION READ ONLY", false, true, new String[0]);
        this.setSessionNotReadOnly = this.createQuery("SET SESSION CHARACTERISTICS AS TRANSACTION READ WRITE", false, true, new String[0]);
        if (PGProperty.READ_ONLY.getBoolean(properties)) {
            this.setReadOnly(true);
        }
        this.hideUnprivilegedObjects = PGProperty.HIDE_UNPRIVILEGED_OBJECTS.getBoolean(properties);
        Set<Integer> set = PgConnection.getBinaryOids(properties);
        HashSet<Integer> hashSet = new HashSet<Integer>(set);
        HashSet<Integer> hashSet2 = new HashSet<Integer>(set);
        hashSet.remove(1082);
        this.queryExecutor.setBinaryReceiveOids(hashSet2);
        this.queryExecutor.setBinarySendOids(hashSet);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "    types using binary send = {0}", this.oidsToString(hashSet));
            LOGGER.log(Level.FINEST, "    types using binary receive = {0}", this.oidsToString(hashSet2));
            LOGGER.log(Level.FINEST, "    integer date/time = {0}", this.queryExecutor.getIntegerDateTimes());
        }
        if ((string4 = PGProperty.STRING_TYPE.get(properties)) != null) {
            if (string4.equalsIgnoreCase("unspecified")) {
                this.bindStringAsVarchar = false;
            } else {
                if (!string4.equalsIgnoreCase("varchar")) throw new PSQLException(GT.tr("Unsupported value for stringtype parameter: {0}", string4), PSQLState.INVALID_PARAMETER_VALUE);
                this.bindStringAsVarchar = true;
            }
        } else {
            this.bindStringAsVarchar = true;
        }
        this.timestampUtils = new TimestampUtils(!this.queryExecutor.getIntegerDateTimes(), new QueryExecutorTimeZoneProvider(this.queryExecutor));
        this.commitQuery = this.createQuery((String)"COMMIT", (boolean)false, (boolean)true, (String[])new String[0]).query;
        this.rollbackQuery = this.createQuery((String)"ROLLBACK", (boolean)false, (boolean)true, (String[])new String[0]).query;
        int n = PGProperty.UNKNOWN_LENGTH.getInt(properties);
        this.typeCache = this.createTypeInfo(this, n);
        this.initObjectTypes(properties);
        if (PGProperty.LOG_UNCLOSED_CONNECTIONS.getBoolean(properties)) {
            this.openStackTrace = new Throwable("Connection was created at this point:");
        }
        this.logServerErrorDetail = PGProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(properties);
        this.disableColumnSanitiser = PGProperty.DISABLE_COLUMN_SANITISER.getBoolean(properties);
        if (this.haveMinimumServerVersion(ServerVersion.v8_3)) {
            this.typeCache.addCoreType("uuid", 2950, 1111, "java.util.UUID", 2951);
            this.typeCache.addCoreType("xml", 142, 2009, "java.sql.SQLXML", 143);
        }
        this.clientInfo = new Properties();
        if (this.haveMinimumServerVersion(ServerVersion.v9_0)) {
            String string5 = PGProperty.APPLICATION_NAME.get(properties);
            if (string5 == null) {
                string5 = "";
            }
            this.clientInfo.put("ApplicationName", string5);
        }
        this.fieldMetadataCache = new LruCache(Math.max(0, PGProperty.DATABASE_METADATA_CACHE_FIELDS.getInt(properties)), Math.max(0L, (long)PGProperty.DATABASE_METADATA_CACHE_FIELDS_MIB.getInt(properties) * 1024L * 1024L), false);
        this.replicationConnection = PGProperty.REPLICATION.get(properties) != null;
        this.xmlFactoryFactoryClass = PGProperty.XML_FACTORY_FACTORY.get(properties);
    }

    private static ReadOnlyBehavior getReadOnlyBehavior(String string) {
        try {
            return ReadOnlyBehavior.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return ReadOnlyBehavior.valueOf(string.toLowerCase(Locale.US));
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return ReadOnlyBehavior.transaction;
            }
        }
    }

    private static Set<Integer> getSupportedBinaryOids() {
        return new HashSet<Integer>(Arrays.asList(17, 21, 23, 20, 700, 701, 1700, 1083, 1082, 1266, 1114, 1184, 1001, 1005, 1007, 1016, 1028, 1021, 1022, 1015, 1009, 600, 603, 2950));
    }

    private static Set<Integer> getBinaryOids(Properties properties) {
        String string;
        boolean bl = PGProperty.BINARY_TRANSFER.getBoolean(properties);
        HashSet<Integer> hashSet = new HashSet<Integer>(32);
        if (bl) {
            hashSet.addAll(SUPPORTED_BINARY_OIDS);
        }
        if ((string = PGProperty.BINARY_TRANSFER_ENABLE.get(properties)) != null) {
            hashSet.addAll(PgConnection.getOidSet(string));
        }
        if ((string = PGProperty.BINARY_TRANSFER_DISABLE.get(properties)) != null) {
            hashSet.removeAll(PgConnection.getOidSet(string));
        }
        return hashSet;
    }

    private static Set<Integer> getOidSet(String string) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            hashSet.add(Oid.valueOf(string2));
        }
        return hashSet;
    }

    private String oidsToString(Set<Integer> set) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer n : set) {
            stringBuilder.append(Oid.toString(n));
            stringBuilder.append(',');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        } else {
            stringBuilder.append(" <none>");
        }
        return stringBuilder.toString();
    }

    @Override
    public TimestampUtils getTimestampUtils() {
        return this.timestampUtils;
    }

    @Override
    public Statement createStatement() {
        return this.createStatement(1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String string) {
        return this.prepareStatement(string, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String string) {
        return this.prepareCall(string, 1003, 1007);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        this.checkClosed();
        return this.typemap;
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        return this.queryExecutor;
    }

    @Override
    public ReplicationProtocol getReplicationProtocol() {
        return this.queryExecutor.getReplicationProtocol();
    }

    public void addWarning(SQLWarning sQLWarning) {
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(sQLWarning);
        } else {
            this.firstWarning = sQLWarning;
        }
    }

    @Override
    public ResultSet execSQLQuery(String string) {
        return this.execSQLQuery(string, 1003, 1007);
    }

    @Override
    public ResultSet execSQLQuery(String string, int n, int n2) {
        BaseStatement baseStatement = (BaseStatement)this.createStatement(n, n2);
        boolean bl = baseStatement.executeWithFlags(string, 16);
        while (!bl && baseStatement.getUpdateCount() != -1) {
            bl = baseStatement.getMoreResults();
        }
        if (!bl) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        SQLWarning sQLWarning = baseStatement.getWarnings();
        if (sQLWarning != null) {
            this.addWarning(sQLWarning);
        }
        return Nullness.castNonNull(baseStatement.getResultSet(), "hasResultSet==true, yet getResultSet()==null");
    }

    @Override
    public void execSQLUpdate(String string) {
        BaseStatement baseStatement = (BaseStatement)this.createStatement();
        if (baseStatement.executeWithFlags(string, 22)) {
            throw new PSQLException(GT.tr("A result was returned when none was expected.", new Object[0]), PSQLState.TOO_MANY_RESULTS);
        }
        SQLWarning sQLWarning = baseStatement.getWarnings();
        if (sQLWarning != null) {
            this.addWarning(sQLWarning);
        }
        baseStatement.close();
    }

    void execSQLUpdate(CachedQuery cachedQuery) {
        BaseStatement baseStatement = (BaseStatement)this.createStatement();
        if (baseStatement.executeWithFlags(cachedQuery, 22)) {
            throw new PSQLException(GT.tr("A result was returned when none was expected.", new Object[0]), PSQLState.TOO_MANY_RESULTS);
        }
        SQLWarning sQLWarning = baseStatement.getWarnings();
        if (sQLWarning != null) {
            this.addWarning(sQLWarning);
        }
        baseStatement.close();
    }

    public void setCursorName(String string) {
        this.checkClosed();
    }

    public @Nullable String getCursorName() {
        this.checkClosed();
        return null;
    }

    public String getURL() {
        return this.creatingURL;
    }

    public String getUserName() {
        return this.queryExecutor.getUser();
    }

    @Override
    public Fastpath getFastpathAPI() {
        this.checkClosed();
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this);
        }
        return this.fastpath;
    }

    @Override
    public LargeObjectManager getLargeObjectAPI() {
        this.checkClosed();
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager(this);
        }
        return this.largeobject;
    }

    @Override
    public Object getObject(String string, @Nullable String string2, byte @Nullable [] byArray) {
        Serializable serializable;
        if (this.typemap != null && (serializable = this.typemap.get(string)) != null) {
            throw new PSQLException(GT.tr("Custom type maps are not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
        }
        serializable = null;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Constructing object from type={0} value=<{1}>", new Object[]{string, string2});
        }
        try {
            Class<? extends PGobject> clazz = this.typeCache.getPGobject(string);
            if (clazz != null) {
                serializable = clazz.newInstance();
                ((PGobject)serializable).setType(string);
                if (byArray != null && serializable instanceof PGBinaryObject) {
                    PGBinaryObject pGBinaryObject = (PGBinaryObject)((Object)serializable);
                    pGBinaryObject.setByteValue(byArray, 0);
                } else {
                    ((PGobject)serializable).setValue(string2);
                }
            } else {
                serializable = new PGobject();
                ((PGobject)serializable).setType(string);
                ((PGobject)serializable).setValue(string2);
            }
            return serializable;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw new PSQLException(GT.tr("Failed to create object for: {0}.", string), PSQLState.CONNECTION_FAILURE, (Throwable)exception);
        }
    }

    protected TypeInfo createTypeInfo(BaseConnection baseConnection, int n) {
        return new TypeInfoCache(baseConnection, n);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.typeCache;
    }

    @Override
    public void addDataType(String string, String string2) {
        try {
            this.addDataType(string, Class.forName(string2).asSubclass(PGobject.class));
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot register new type: " + exception);
        }
    }

    @Override
    public void addDataType(String string, Class<? extends PGobject> clazz) {
        this.checkClosed();
        this.typeCache.addDataType(string, clazz);
    }

    private void initObjectTypes(Properties properties) {
        this.addDataType("box", PGbox.class);
        this.addDataType("circle", PGcircle.class);
        this.addDataType("line", PGline.class);
        this.addDataType("lseg", PGlseg.class);
        this.addDataType("path", PGpath.class);
        this.addDataType("point", PGpoint.class);
        this.addDataType("polygon", PGpolygon.class);
        this.addDataType("money", PGmoney.class);
        this.addDataType("interval", PGInterval.class);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Class<?> clazz;
            String string = (String)enumeration.nextElement();
            if (string == null || !string.startsWith("datatype.")) continue;
            String string2 = string.substring(9);
            String string3 = Nullness.castNonNull(properties.getProperty(string));
            try {
                clazz = Class.forName(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new PSQLException(GT.tr("Unable to load the class {0} responsible for the datatype {1}", string3, string2), PSQLState.SYSTEM_ERROR, (Throwable)classNotFoundException);
            }
            this.addDataType(string2, clazz.asSubclass(PGobject.class));
        }
    }

    @Override
    public void close() {
        if (this.queryExecutor == null) {
            return;
        }
        this.releaseTimer();
        this.queryExecutor.close();
        this.openStackTrace = null;
    }

    @Override
    public String nativeSQL(String string) {
        this.checkClosed();
        CachedQuery cachedQuery = this.queryExecutor.createQuery(string, false, true, new String[0]);
        return cachedQuery.query.getNativeSql();
    }

    @Override
    public synchronized @Nullable SQLWarning getWarnings() {
        this.checkClosed();
        SQLWarning sQLWarning = this.queryExecutor.getWarnings();
        if (this.firstWarning == null) {
            this.firstWarning = sQLWarning;
        } else if (sQLWarning != null) {
            this.firstWarning.setNextWarning(sQLWarning);
        }
        return this.firstWarning;
    }

    @Override
    public synchronized void clearWarnings() {
        this.checkClosed();
        this.queryExecutor.getWarnings();
        this.firstWarning = null;
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.checkClosed();
        if (this.queryExecutor.getTransactionState() != TransactionState.IDLE) {
            throw new PSQLException(GT.tr("Cannot change transaction read-only property in the middle of a transaction.", new Object[0]), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        if (bl != this.readOnly && this.autoCommit && this.readOnlyBehavior == ReadOnlyBehavior.always) {
            this.execSQLUpdate(bl ? this.setSessionReadOnly : this.setSessionNotReadOnly);
        }
        this.readOnly = bl;
        LOGGER.log(Level.FINE, "  setReadOnly = {0}", bl);
    }

    @Override
    public boolean isReadOnly() {
        this.checkClosed();
        return this.readOnly;
    }

    @Override
    public boolean hintReadOnly() {
        return this.readOnly && this.readOnlyBehavior != ReadOnlyBehavior.ignore;
    }

    @Override
    public void setAutoCommit(boolean bl) {
        this.checkClosed();
        if (this.autoCommit == bl) {
            return;
        }
        if (!this.autoCommit) {
            this.commit();
        }
        if (this.readOnly && this.readOnlyBehavior == ReadOnlyBehavior.always) {
            if (bl) {
                this.autoCommit = true;
                this.execSQLUpdate(this.setSessionReadOnly);
            } else {
                this.execSQLUpdate(this.setSessionNotReadOnly);
            }
        }
        this.autoCommit = bl;
        LOGGER.log(Level.FINE, "  setAutoCommit = {0}", bl);
    }

    @Override
    public boolean getAutoCommit() {
        this.checkClosed();
        return this.autoCommit;
    }

    private void executeTransactionCommand(Query query) {
        int n = 22;
        if (this.prepareThreshold == 0) {
            n |= 1;
        }
        try {
            this.getQueryExecutor().execute(query, null, new TransactionCommandHandler(), 0, 0, n);
        }
        catch (SQLException sQLException) {
            if (query.getSubqueries() != null || !this.queryExecutor.willHealOnRetry(sQLException)) {
                throw sQLException;
            }
            query.close();
            this.getQueryExecutor().execute(query, null, new TransactionCommandHandler(), 0, 0, n);
        }
    }

    @Override
    public void commit() {
        this.checkClosed();
        if (this.autoCommit) {
            throw new PSQLException(GT.tr("Cannot commit when autoCommit is enabled.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.queryExecutor.getTransactionState() != TransactionState.IDLE) {
            this.executeTransactionCommand(this.commitQuery);
        }
    }

    protected void checkClosed() {
        if (this.isClosed()) {
            throw new PSQLException(GT.tr("This connection has been closed.", new Object[0]), PSQLState.CONNECTION_DOES_NOT_EXIST);
        }
    }

    @Override
    public void rollback() {
        this.checkClosed();
        if (this.autoCommit) {
            throw new PSQLException(GT.tr("Cannot rollback when autoCommit is enabled.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.queryExecutor.getTransactionState() != TransactionState.IDLE) {
            this.executeTransactionCommand(this.rollbackQuery);
        } else {
            LOGGER.log(Level.FINE, "Rollback requested but no transaction in progress");
        }
    }

    @Override
    public TransactionState getTransactionState() {
        return this.queryExecutor.getTransactionState();
    }

    @Override
    public int getTransactionIsolation() {
        this.checkClosed();
        String string = null;
        ResultSet resultSet = this.execSQLQuery("SHOW TRANSACTION ISOLATION LEVEL");
        if (resultSet.next()) {
            string = resultSet.getString(1);
        }
        resultSet.close();
        if (string == null) {
            return 2;
        }
        if ((string = string.toUpperCase(Locale.US)).equals("READ COMMITTED")) {
            return 2;
        }
        if (string.equals("READ UNCOMMITTED")) {
            return 1;
        }
        if (string.equals("REPEATABLE READ")) {
            return 4;
        }
        if (string.equals("SERIALIZABLE")) {
            return 8;
        }
        return 2;
    }

    @Override
    public void setTransactionIsolation(int n) {
        this.checkClosed();
        if (this.queryExecutor.getTransactionState() != TransactionState.IDLE) {
            throw new PSQLException(GT.tr("Cannot change transaction isolation level in the middle of a transaction.", new Object[0]), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        String string = this.getIsolationLevelName(n);
        if (string == null) {
            throw new PSQLException(GT.tr("Transaction isolation level {0} not supported.", n), PSQLState.NOT_IMPLEMENTED);
        }
        String string2 = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + string;
        this.execSQLUpdate(string2);
        LOGGER.log(Level.FINE, "  setTransactionIsolation = {0}", string);
    }

    protected @Nullable String getIsolationLevelName(int n) {
        switch (n) {
            case 2: {
                return "READ COMMITTED";
            }
            case 8: {
                return "SERIALIZABLE";
            }
            case 1: {
                return "READ UNCOMMITTED";
            }
            case 4: {
                return "REPEATABLE READ";
            }
        }
        return null;
    }

    @Override
    public void setCatalog(String string) {
        this.checkClosed();
    }

    @Override
    public String getCatalog() {
        this.checkClosed();
        return this.queryExecutor.getDatabase();
    }

    public boolean getHideUnprivilegedObjects() {
        return this.hideUnprivilegedObjects;
    }

    protected void finalize() {
        try {
            if (this.openStackTrace != null) {
                LOGGER.log(Level.WARNING, GT.tr("Finalizing a Connection that was never closed:", new Object[0]), this.openStackTrace);
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public String getDBVersionNumber() {
        return this.queryExecutor.getServerVersion();
    }

    public int getServerMajorVersion() {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.queryExecutor.getServerVersion(), ".");
            return PgConnection.integerPart(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0;
        }
    }

    public int getServerMinorVersion() {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.queryExecutor.getServerVersion(), ".");
            stringTokenizer.nextToken();
            return PgConnection.integerPart(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0;
        }
    }

    @Override
    public boolean haveMinimumServerVersion(int n) {
        return this.queryExecutor.getServerVersionNum() >= n;
    }

    @Override
    public boolean haveMinimumServerVersion(Version version) {
        return this.haveMinimumServerVersion(version.getVersionNum());
    }

    @Override
    @Pure
    public Encoding getEncoding() {
        return this.queryExecutor.getEncoding();
    }

    @Override
    public byte @PolyNull [] encodeString(@PolyNull String string) {
        try {
            return this.getEncoding().encode(string);
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Unable to translate data into the desired encoding.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)iOException);
        }
    }

    @Override
    public String escapeString(String string) {
        return Utils.escapeLiteral(null, string, this.queryExecutor.getStandardConformingStrings()).toString();
    }

    @Override
    public boolean getStandardConformingStrings() {
        return this.queryExecutor.getStandardConformingStrings();
    }

    @Override
    public boolean isClosed() {
        return this.queryExecutor.isClosed();
    }

    @Override
    public void cancelQuery() {
        this.checkClosed();
        this.queryExecutor.sendQueryCancel();
    }

    @Override
    public PGNotification[] getNotifications() {
        return this.getNotifications(-1);
    }

    @Override
    public PGNotification[] getNotifications(int n) {
        this.checkClosed();
        this.getQueryExecutor().processNotifies(n);
        PGNotification[] pGNotificationArray = this.queryExecutor.getNotifications();
        return pGNotificationArray;
    }

    @Override
    public int getPrepareThreshold() {
        return this.prepareThreshold;
    }

    @Override
    public void setDefaultFetchSize(int n) {
        if (n < 0) {
            throw new PSQLException(GT.tr("Fetch size must be a value greater to or equal to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.defaultFetchSize = n;
        LOGGER.log(Level.FINE, "  setDefaultFetchSize = {0}", n);
    }

    @Override
    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    @Override
    public void setPrepareThreshold(int n) {
        this.prepareThreshold = n;
        LOGGER.log(Level.FINE, "  setPrepareThreshold = {0}", n);
    }

    public boolean getForceBinary() {
        return this.forcebinary;
    }

    public void setForceBinary(boolean bl) {
        this.forcebinary = bl;
        LOGGER.log(Level.FINE, "  setForceBinary = {0}", bl);
    }

    public void setTypeMapImpl(Map<String, Class<?>> map) {
        this.typemap = map;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    public int getProtocolVersion() {
        return this.queryExecutor.getProtocolVersion();
    }

    @Override
    public boolean getStringVarcharFlag() {
        return this.bindStringAsVarchar;
    }

    @Override
    public CopyManager getCopyAPI() {
        this.checkClosed();
        if (this.copyManager == null) {
            this.copyManager = new CopyManager(this);
        }
        return this.copyManager;
    }

    @Override
    public boolean binaryTransferSend(int n) {
        return this.queryExecutor.useBinaryForSend(n);
    }

    @Override
    public int getBackendPID() {
        return this.queryExecutor.getBackendPID();
    }

    @Override
    public boolean isColumnSanitiserDisabled() {
        return this.disableColumnSanitiser;
    }

    public void setDisableColumnSanitiser(boolean bl) {
        this.disableColumnSanitiser = bl;
        LOGGER.log(Level.FINE, "  setDisableColumnSanitiser = {0}", bl);
    }

    @Override
    public PreferQueryMode getPreferQueryMode() {
        return this.queryExecutor.getPreferQueryMode();
    }

    @Override
    public AutoSave getAutosave() {
        return this.queryExecutor.getAutoSave();
    }

    @Override
    public void setAutosave(AutoSave autoSave) {
        this.queryExecutor.setAutoSave(autoSave);
        LOGGER.log(Level.FINE, "  setAutosave = {0}", autoSave.value());
    }

    protected void abort() {
        this.queryExecutor.abort();
    }

    private synchronized Timer getTimer() {
        if (this.cancelTimer == null) {
            this.cancelTimer = Driver.getSharedTimer().getTimer();
        }
        return this.cancelTimer;
    }

    private synchronized void releaseTimer() {
        if (this.cancelTimer != null) {
            this.cancelTimer = null;
            Driver.getSharedTimer().releaseTimer();
        }
    }

    @Override
    public void addTimerTask(TimerTask timerTask, long l) {
        Timer timer = this.getTimer();
        timer.schedule(timerTask, l);
    }

    @Override
    public void purgeTimerTasks() {
        Timer timer = this.cancelTimer;
        if (timer != null) {
            timer.purge();
        }
    }

    @Override
    public String escapeIdentifier(String string) {
        return Utils.escapeIdentifier(null, string).toString();
    }

    @Override
    public String escapeLiteral(String string) {
        return Utils.escapeLiteral(null, string, this.queryExecutor.getStandardConformingStrings()).toString();
    }

    @Override
    public LruCache<FieldMetadata.Key, FieldMetadata> getFieldMetadataCache() {
        return this.fieldMetadataCache;
    }

    @Override
    public PGReplicationConnection getReplicationAPI() {
        return new PGReplicationConnectionImpl(this);
    }

    private static int integerPart(String string) {
        int n;
        int n2;
        for (n2 = 0; n2 < string.length() && !Character.isDigit(string.charAt(n2)); ++n2) {
        }
        for (n = n2; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
        }
        if (n2 == n) {
            return 0;
        }
        return Integer.parseInt(string.substring(n2, n));
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) {
        this.checkClosed();
        return new PgStatement(this, n, n2, n3);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) {
        this.checkClosed();
        return new PgPreparedStatement(this, string, n, n2, n3);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) {
        this.checkClosed();
        return new PgCallableStatement(this, string, n, n2, n3);
    }

    @Override
    public DatabaseMetaData getMetaData() {
        this.checkClosed();
        if (this.metadata == null) {
            this.metadata = new PgDatabaseMetaData(this);
        }
        return this.metadata;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) {
        this.setTypeMapImpl(map);
        LOGGER.log(Level.FINE, "  setTypeMap = {0}", map);
    }

    protected Array makeArray(int n, @Nullable String string) {
        return new PgArray((BaseConnection)this, n, string);
    }

    protected Blob makeBlob(long l) {
        return new PgBlob(this, l);
    }

    protected Clob makeClob(long l) {
        return new PgClob(this, l);
    }

    protected SQLXML makeSQLXML() {
        return new PgSQLXML(this);
    }

    @Override
    public Clob createClob() {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createClob()");
    }

    @Override
    public Blob createBlob() {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createBlob()");
    }

    @Override
    public NClob createNClob() {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createNClob()");
    }

    @Override
    public SQLXML createSQLXML() {
        this.checkClosed();
        return this.makeSQLXML();
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createStruct(String, Object[])");
    }

    @Override
    public Array createArrayOf(String string, @Nullable Object object) {
        this.checkClosed();
        TypeInfo typeInfo = this.getTypeInfo();
        int n = typeInfo.getPGArrayType(string);
        char c = typeInfo.getArrayDelimiter(n);
        if (n == 0) {
            throw new PSQLException(GT.tr("Unable to find server array type for provided name {0}.", string), PSQLState.INVALID_NAME);
        }
        if (object == null) {
            return this.makeArray(n, null);
        }
        ArrayEncoding.ArrayEncoder<Object> arrayEncoder = ArrayEncoding.getArrayEncoder(object);
        if (arrayEncoder.supportBinaryRepresentation(n) && this.getPreferQueryMode() != PreferQueryMode.SIMPLE) {
            return new PgArray((BaseConnection)this, n, arrayEncoder.toBinaryRepresentation(this, object, n));
        }
        String string2 = arrayEncoder.toArrayString(c, object);
        return this.makeArray(n, string2);
    }

    @Override
    public Array createArrayOf(String string, @Nullable Object @Nullable [] objectArray) {
        return this.createArrayOf(string, (Object)objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int n) {
        if (n < 0) {
            throw new PSQLException(GT.tr("Invalid timeout ({0}<0).", n), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.isClosed()) {
            return false;
        }
        boolean bl = false;
        int n2 = this.getNetworkTimeout();
        int n3 = (int)Math.min((long)n * 1000L, Integer.MAX_VALUE);
        try {
            if (n3 != 0 && (n2 == 0 || n3 < n2)) {
                bl = true;
                this.setNetworkTimeout(null, n3);
            }
            if (this.replicationConnection) {
                Statement statement = this.createStatement();
                statement.execute("IDENTIFY_SYSTEM");
                statement.close();
            } else {
                if (this.checkConnectionQuery == null) {
                    this.checkConnectionQuery = this.prepareStatement("");
                }
                this.checkConnectionQuery.executeUpdate();
            }
            boolean bl2 = true;
            if (bl) {
                this.setNetworkTimeout(null, n2);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            try {
                if (bl) {
                    this.setNetworkTimeout(null, n2);
                }
                throw throwable;
            }
            catch (SQLException sQLException) {
                if (PSQLState.IN_FAILED_SQL_TRANSACTION.getState().equals(sQLException.getSQLState())) {
                    return true;
                }
                LOGGER.log(Level.FINE, GT.tr("Validating connection.", new Object[0]), sQLException);
                return false;
            }
        }
    }

    @Override
    public void setClientInfo(String string, @Nullable String string2) {
        try {
            this.checkClosed();
        }
        catch (SQLException sQLException) {
            HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
            hashMap.put(string, ClientInfoStatus.REASON_UNKNOWN);
            throw new SQLClientInfoException(GT.tr("This connection has been closed.", new Object[0]), hashMap, (Throwable)sQLException);
        }
        if (this.haveMinimumServerVersion(ServerVersion.v9_0) && "ApplicationName".equals(string)) {
            String string3;
            if (string2 == null) {
                string2 = "";
            }
            if (string2.equals(string3 = this.queryExecutor.getApplicationName())) {
                return;
            }
            try {
                StringBuilder stringBuilder = new StringBuilder("SET application_name = '");
                Utils.escapeLiteral(stringBuilder, string2, this.getStandardConformingStrings());
                stringBuilder.append("'");
                this.execSQLUpdate(stringBuilder.toString());
            }
            catch (SQLException sQLException) {
                HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
                hashMap.put(string, ClientInfoStatus.REASON_UNKNOWN);
                throw new SQLClientInfoException(GT.tr("Failed to set ClientInfo property: {0}", "ApplicationName"), sQLException.getSQLState(), hashMap, (Throwable)sQLException);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "  setClientInfo = {0} {1}", new Object[]{string, string2});
            }
            this.clientInfo.put(string, string2);
            return;
        }
        this.addWarning(new SQLWarning(GT.tr("ClientInfo property not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED.getState()));
    }

    @Override
    public void setClientInfo(Properties properties) {
        try {
            this.checkClosed();
        }
        catch (SQLException sQLException) {
            HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                hashMap.put((String)entry.getKey(), ClientInfoStatus.REASON_UNKNOWN);
            }
            throw new SQLClientInfoException(GT.tr("This connection has been closed.", new Object[0]), hashMap, (Throwable)sQLException);
        }
        HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
        for (String string : new String[]{"ApplicationName"}) {
            try {
                this.setClientInfo(string, properties.getProperty(string, null));
            }
            catch (SQLClientInfoException sQLClientInfoException) {
                hashMap.putAll(sQLClientInfoException.getFailedProperties());
            }
        }
        if (!hashMap.isEmpty()) {
            throw new SQLClientInfoException(GT.tr("One or more ClientInfo failed.", new Object[0]), PSQLState.NOT_IMPLEMENTED.getState(), hashMap);
        }
    }

    @Override
    public @Nullable String getClientInfo(String string) {
        this.checkClosed();
        this.clientInfo.put("ApplicationName", this.queryExecutor.getApplicationName());
        return this.clientInfo.getProperty(string);
    }

    @Override
    public Properties getClientInfo() {
        this.checkClosed();
        this.clientInfo.put("ApplicationName", this.queryExecutor.getApplicationName());
        return this.clientInfo;
    }

    public <T> T createQueryObject(Class<T> clazz) {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createQueryObject(Class<T>)");
    }

    @Override
    public boolean getLogServerErrorDetail() {
        return this.logServerErrorDetail;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        this.checkClosed();
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        this.checkClosed();
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable String getSchema() {
        this.checkClosed();
        try (Statement statement = this.createStatement();){
            ResultSet resultSet;
            block8: {
                String string;
                resultSet = statement.executeQuery("select current_schema()");
                try {
                    if (resultSet.next()) break block8;
                    string = null;
                }
                catch (Throwable throwable) {
                    resultSet.close();
                    throw throwable;
                }
                resultSet.close();
                return string;
            }
            String string = resultSet.getString(1);
            resultSet.close();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSchema(@Nullable String string) {
        this.checkClosed();
        try (Statement statement = this.createStatement();){
            if (string == null) {
                statement.executeUpdate("SET SESSION search_path TO DEFAULT");
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("SET SESSION search_path TO '");
                Utils.escapeLiteral(stringBuilder, string, this.getStandardConformingStrings());
                stringBuilder.append("'");
                statement.executeUpdate(stringBuilder.toString());
                LOGGER.log(Level.FINE, "  setSchema = {0}", string);
            }
        }
    }

    @Override
    public void abort(Executor executor) {
        if (executor == null) {
            throw new SQLException("executor is null");
        }
        if (this.isClosed()) {
            return;
        }
        SQL_PERMISSION_ABORT.checkGuard(this);
        AbortCommand abortCommand = new AbortCommand();
        executor.execute(abortCommand);
    }

    @Override
    public void setNetworkTimeout(@Nullable Executor executor, int n) {
        this.checkClosed();
        if (n < 0) {
            throw new PSQLException(GT.tr("Network timeout must be a value greater than or equal to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SQL_PERMISSION_NETWORK_TIMEOUT);
        }
        try {
            this.queryExecutor.setNetworkTimeout(n);
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Unable to set network timeout.", new Object[0]), PSQLState.COMMUNICATION_ERROR, (Throwable)iOException);
        }
    }

    @Override
    public int getNetworkTimeout() {
        this.checkClosed();
        try {
            return this.queryExecutor.getNetworkTimeout();
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Unable to get network timeout.", new Object[0]), PSQLState.COMMUNICATION_ERROR, (Throwable)iOException);
        }
    }

    @Override
    public void setHoldability(int n) {
        this.checkClosed();
        switch (n) {
            case 2: {
                this.rsHoldability = n;
                break;
            }
            case 1: {
                this.rsHoldability = n;
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Unknown ResultSet holdability setting: {0}.", n), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
        LOGGER.log(Level.FINE, "  setHoldability = {0}", n);
    }

    @Override
    public int getHoldability() {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public Savepoint setSavepoint() {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw new PSQLException(GT.tr("Cannot establish a savepoint in auto-commit mode.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        PSQLSavepoint pSQLSavepoint = new PSQLSavepoint(this.savepointId++);
        String string = pSQLSavepoint.getPGName();
        Statement statement = this.createStatement();
        statement.executeUpdate("SAVEPOINT " + string);
        statement.close();
        return pSQLSavepoint;
    }

    @Override
    public Savepoint setSavepoint(String string) {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw new PSQLException(GT.tr("Cannot establish a savepoint in auto-commit mode.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        PSQLSavepoint pSQLSavepoint = new PSQLSavepoint(string);
        Statement statement = this.createStatement();
        statement.executeUpdate("SAVEPOINT " + pSQLSavepoint.getPGName());
        statement.close();
        return pSQLSavepoint;
    }

    @Override
    public void rollback(Savepoint savepoint) {
        this.checkClosed();
        PSQLSavepoint pSQLSavepoint = (PSQLSavepoint)savepoint;
        this.execSQLUpdate("ROLLBACK TO SAVEPOINT " + pSQLSavepoint.getPGName());
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) {
        this.checkClosed();
        PSQLSavepoint pSQLSavepoint = (PSQLSavepoint)savepoint;
        this.execSQLUpdate("RELEASE SAVEPOINT " + pSQLSavepoint.getPGName());
        pSQLSavepoint.invalidate();
    }

    @Override
    public Statement createStatement(int n, int n2) {
        this.checkClosed();
        return this.createStatement(n, n2, this.getHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) {
        this.checkClosed();
        return this.prepareStatement(string, n, n2, this.getHoldability());
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) {
        this.checkClosed();
        return this.prepareCall(string, n, n2, this.getHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) {
        if (n != 1) {
            return this.prepareStatement(string);
        }
        return this.prepareStatement(string, (String[])null);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int @Nullable [] nArray) {
        if (nArray != null && nArray.length == 0) {
            return this.prepareStatement(string);
        }
        this.checkClosed();
        throw new PSQLException(GT.tr("Returning autogenerated keys is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String @Nullable [] stringArray) {
        if (stringArray != null && stringArray.length == 0) {
            return this.prepareStatement(string);
        }
        CachedQuery cachedQuery = this.borrowReturningQuery(string, stringArray);
        PgPreparedStatement pgPreparedStatement = new PgPreparedStatement(this, cachedQuery, 1003, 1007, this.getHoldability());
        Query query = cachedQuery.query;
        SqlCommand sqlCommand = query.getSqlCommand();
        if (sqlCommand != null) {
            pgPreparedStatement.wantsGeneratedKeysAlways = sqlCommand.isReturningKeywordPresent();
        }
        return pgPreparedStatement;
    }

    @Override
    public final Map<String, String> getParameterStatuses() {
        return this.queryExecutor.getParameterStatuses();
    }

    @Override
    public final @Nullable String getParameterStatus(String string) {
        return this.queryExecutor.getParameterStatus(string);
    }

    @Override
    public boolean getAdaptiveFetch() {
        return this.queryExecutor.getAdaptiveFetch();
    }

    @Override
    public void setAdaptiveFetch(boolean bl) {
        this.queryExecutor.setAdaptiveFetch(bl);
    }

    @Override
    public PGXmlFactoryFactory getXmlFactoryFactory() {
        PGXmlFactoryFactory pGXmlFactoryFactory = this.xmlFactoryFactory;
        if (pGXmlFactoryFactory != null) {
            return pGXmlFactoryFactory;
        }
        if (this.xmlFactoryFactoryClass == null || this.xmlFactoryFactoryClass.equals("")) {
            pGXmlFactoryFactory = DefaultPGXmlFactoryFactory.INSTANCE;
        } else if (this.xmlFactoryFactoryClass.equals("LEGACY_INSECURE")) {
            pGXmlFactoryFactory = LegacyInsecurePGXmlFactoryFactory.INSTANCE;
        } else {
            Class<PGXmlFactoryFactory> clazz;
            try {
                clazz = Class.forName(this.xmlFactoryFactoryClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new PSQLException(GT.tr("Could not instantiate xmlFactoryFactory: {0}", this.xmlFactoryFactoryClass), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)classNotFoundException);
            }
            if (!clazz.isAssignableFrom(PGXmlFactoryFactory.class)) {
                throw new PSQLException(GT.tr("Connection property xmlFactoryFactory must implement PGXmlFactoryFactory: {0}", this.xmlFactoryFactoryClass), PSQLState.INVALID_PARAMETER_VALUE);
            }
            try {
                pGXmlFactoryFactory = (PGXmlFactoryFactory)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new PSQLException(GT.tr("Could not instantiate xmlFactoryFactory: {0}", this.xmlFactoryFactoryClass), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)exception);
            }
        }
        this.xmlFactoryFactory = pGXmlFactoryFactory;
        return pGXmlFactoryFactory;
    }

    public class AbortCommand
    implements Runnable {
        @Override
        public void run() {
            PgConnection.this.abort();
        }
    }

    private class TransactionCommandHandler
    extends ResultHandlerBase {
        private TransactionCommandHandler() {
        }

        @Override
        public void handleCompletion() {
            SQLWarning sQLWarning = this.getWarning();
            if (sQLWarning != null) {
                PgConnection.this.addWarning(sQLWarning);
            }
            super.handleCompletion();
        }
    }

    private static enum ReadOnlyBehavior {
        ignore,
        transaction,
        always;

    }
}

