/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.Driver;
import com.hm.postgresql.core.BaseStatement;
import com.hm.postgresql.core.Field;
import com.hm.postgresql.core.ServerVersion;
import com.hm.postgresql.core.Tuple;
import com.hm.postgresql.core.TypeInfo;
import com.hm.postgresql.jdbc.PgConnection;
import com.hm.postgresql.jdbc.PgResultSet;
import com.hm.postgresql.jdbc.TypeInfoCache;
import com.hm.postgresql.util.ByteConverter;
import com.hm.postgresql.util.DriverInfo;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.JdbcBlackHole;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PgDatabaseMetaData
implements DatabaseMetaData {
    private @Nullable String keywords;
    protected final PgConnection connection;
    private int nameDataLength = 0;
    private int indexMaxKeys = 0;
    private static final Map<String, Map<String, String>> tableTypeClauses = new HashMap<String, Map<String, String>>();

    public PgDatabaseMetaData(PgConnection pgConnection) {
        this.connection = pgConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxIndexKeys() {
        if (this.indexMaxKeys == 0) {
            String string = "SELECT setting FROM pg_catalog.pg_settings WHERE name='max_index_keys'";
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = null;
            try {
                resultSet = statement.executeQuery(string);
                if (!resultSet.next()) {
                    statement.close();
                    throw new PSQLException(GT.tr("Unable to determine a value for MaxIndexKeys due to missing system catalog data.", new Object[0]), PSQLState.UNEXPECTED_ERROR);
                }
                this.indexMaxKeys = resultSet.getInt(1);
            }
            finally {
                JdbcBlackHole.close(resultSet);
                JdbcBlackHole.close(statement);
            }
        }
        return this.indexMaxKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxNameLength() {
        if (this.nameDataLength == 0) {
            String string = "SELECT t.typlen FROM pg_catalog.pg_type t, pg_catalog.pg_namespace n WHERE t.typnamespace=n.oid AND t.typname='name' AND n.nspname='pg_catalog'";
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = null;
            try {
                resultSet = statement.executeQuery(string);
                if (!resultSet.next()) {
                    throw new PSQLException(GT.tr("Unable to find name datatype in the system catalogs.", new Object[0]), PSQLState.UNEXPECTED_ERROR);
                }
                this.nameDataLength = resultSet.getInt("typlen");
            }
            finally {
                JdbcBlackHole.close(resultSet);
                JdbcBlackHole.close(statement);
            }
        }
        return this.nameDataLength - 1;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public String getURL() {
        return this.connection.getURL();
    }

    @Override
    public String getUserName() {
        return this.connection.getUserName();
    }

    @Override
    public boolean isReadOnly() {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public String getDatabaseProductName() {
        return "PostgreSQL";
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.connection.getDBVersionNumber();
    }

    @Override
    public String getDriverName() {
        return "PostgreSQL JDBC Driver";
    }

    @Override
    public String getDriverVersion() {
        return "42.3.1";
    }

    @Override
    public int getDriverMajorVersion() {
        return 42;
    }

    @Override
    public int getDriverMinorVersion() {
        return 3;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSQLKeywords() {
        String string;
        block3: {
            block5: {
                block4: {
                    this.connection.checkClosed();
                    string = this.keywords;
                    if (string != null) break block3;
                    if (!this.connection.haveMinimumServerVersion(ServerVersion.v9_0)) break block4;
                    String string2 = "select string_agg(word, ',') from pg_catalog.pg_get_keywords() where word <> ALL ('{a,abs,absolute,action,ada,add,admin,after,all,allocate,alter,always,and,any,are,array,as,asc,asensitive,assertion,assignment,asymmetric,at,atomic,attribute,attributes,authorization,avg,before,begin,bernoulli,between,bigint,binary,blob,boolean,both,breadth,by,c,call,called,cardinality,cascade,cascaded,case,cast,catalog,catalog_name,ceil,ceiling,chain,char,char_length,character,character_length,character_set_catalog,character_set_name,character_set_schema,characteristics,characters,check,checked,class_origin,clob,close,coalesce,cobol,code_units,collate,collation,collation_catalog,collation_name,collation_schema,collect,column,column_name,command_function,command_function_code,commit,committed,condition,condition_number,connect,connection_name,constraint,constraint_catalog,constraint_name,constraint_schema,constraints,constructors,contains,continue,convert,corr,corresponding,count,covar_pop,covar_samp,create,cross,cube,cume_dist,current,current_collation,current_date,current_default_transform_group,current_path,current_role,current_time,current_timestamp,current_transform_group_for_type,current_user,cursor,cursor_name,cycle,data,date,datetime_interval_code,datetime_interval_precision,day,deallocate,dec,decimal,declare,default,defaults,deferrable,deferred,defined,definer,degree,delete,dense_rank,depth,deref,derived,desc,describe,descriptor,deterministic,diagnostics,disconnect,dispatch,distinct,domain,double,drop,dynamic,dynamic_function,dynamic_function_code,each,element,else,end,end-exec,equals,escape,every,except,exception,exclude,excluding,exec,execute,exists,exp,external,extract,false,fetch,filter,final,first,float,floor,following,for,foreign,fortran,found,free,from,full,function,fusion,g,general,get,global,go,goto,grant,granted,group,grouping,having,hierarchy,hold,hour,identity,immediate,implementation,in,including,increment,indicator,initially,inner,inout,input,insensitive,insert,instance,instantiable,int,integer,intersect,intersection,interval,into,invoker,is,isolation,join,k,key,key_member,key_type,language,large,last,lateral,leading,left,length,level,like,ln,local,localtime,localtimestamp,locator,lower,m,map,match,matched,max,maxvalue,member,merge,message_length,message_octet_length,message_text,method,min,minute,minvalue,mod,modifies,module,month,more,multiset,mumps,name,names,national,natural,nchar,nclob,nesting,new,next,no,none,normalize,normalized,not,\"null\",nullable,nullif,nulls,number,numeric,object,octet_length,octets,of,old,on,only,open,option,options,or,order,ordering,ordinality,others,out,outer,output,over,overlaps,overlay,overriding,pad,parameter,parameter_mode,parameter_name,parameter_ordinal_position,parameter_specific_catalog,parameter_specific_name,parameter_specific_schema,partial,partition,pascal,path,percent_rank,percentile_cont,percentile_disc,placing,pli,position,power,preceding,precision,prepare,preserve,primary,prior,privileges,procedure,public,range,rank,read,reads,real,recursive,ref,references,referencing,regr_avgx,regr_avgy,regr_count,regr_intercept,regr_r2,regr_slope,regr_sxx,regr_sxy,regr_syy,relative,release,repeatable,restart,result,return,returned_cardinality,returned_length,returned_octet_length,returned_sqlstate,returns,revoke,right,role,rollback,rollup,routine,routine_catalog,routine_name,routine_schema,row,row_count,row_number,rows,savepoint,scale,schema,schema_name,scope_catalog,scope_name,scope_schema,scroll,search,second,section,security,select,self,sensitive,sequence,serializable,server_name,session,session_user,set,sets,similar,simple,size,smallint,some,source,space,specific,specific_name,specifictype,sql,sqlexception,sqlstate,sqlwarning,sqrt,start,state,statement,static,stddev_pop,stddev_samp,structure,style,subclass_origin,submultiset,substring,sum,symmetric,system,system_user,table,table_name,tablesample,temporary,then,ties,time,timestamp,timezone_hour,timezone_minute,to,top_level_count,trailing,transaction,transaction_active,transactions_committed,transactions_rolled_back,transform,transforms,translate,translation,treat,trigger,trigger_catalog,trigger_name,trigger_schema,trim,true,type,uescape,unbounded,uncommitted,under,union,unique,unknown,unnamed,unnest,update,upper,usage,user,user_defined_type_catalog,user_defined_type_code,user_defined_type_name,user_defined_type_schema,using,value,values,var_pop,var_samp,varchar,varying,view,when,whenever,where,width_bucket,window,with,within,without,work,write,year,zone}'::text[])";
                    Statement statement = null;
                    ResultSet resultSet = null;
                    try {
                        statement = this.connection.createStatement();
                        resultSet = statement.executeQuery(string2);
                        if (!resultSet.next()) {
                            throw new PSQLException(GT.tr("Unable to find keywords in the system catalogs.", new Object[0]), PSQLState.UNEXPECTED_ERROR);
                        }
                        string = resultSet.getString(1);
                    }
                    catch (Throwable throwable) {
                        JdbcBlackHole.close(resultSet);
                        JdbcBlackHole.close(statement);
                        throw throwable;
                    }
                    JdbcBlackHole.close(resultSet);
                    JdbcBlackHole.close(statement);
                    break block5;
                }
                string = "abort,access,aggregate,also,analyse,analyze,backward,bit,cache,checkpoint,class,cluster,comment,concurrently,connection,conversion,copy,csv,database,delimiter,delimiters,disable,do,enable,encoding,encrypted,exclusive,explain,force,forward,freeze,greatest,handler,header,if,ilike,immutable,implicit,index,indexes,inherit,inherits,instead,isnull,least,limit,listen,load,location,lock,mode,move,nothing,notify,notnull,nowait,off,offset,oids,operator,owned,owner,password,prepared,procedural,quote,reassign,recheck,reindex,rename,replace,reset,restrict,returning,rule,setof,share,show,stable,statistics,stdin,stdout,storage,strict,sysid,tablespace,temp,template,truncate,trusted,unencrypted,unlisten,until,vacuum,valid,validator,verbose,volatile";
            }
            this.keywords = Nullness.castNonNull(string);
        }
        return string;
    }

    @Override
    public String getNumericFunctions() {
        return "abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,exp,floor,log,log10,mod,pi,power,radians,round,sign,sin,sqrt,tan,truncate";
    }

    @Override
    public String getStringFunctions() {
        String string = "ascii,char,concat,lcase,left,length,ltrim,repeat,rtrim,space,substring,ucase";
        string = string + ",replace";
        return string;
    }

    @Override
    public String getSystemFunctions() {
        return "database,ifnull,user";
    }

    @Override
    public String getTimeDateFunctions() {
        String string = "curdate,curtime,dayname,dayofmonth,dayofweek,dayofyear,hour,minute,month,monthname,now,quarter,second,week,year";
        string = string + ",timestampadd";
        return string;
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int n, int n2) {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public String getSchemaTerm() {
        return "schema";
    }

    @Override
    public String getProcedureTerm() {
        return "function";
    }

    @Override
    public String getCatalogTerm() {
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return true;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return this.getMaxIndexKeys();
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 1600;
    }

    @Override
    public int getMaxConnections() {
        return 8192;
    }

    @Override
    public int getMaxCursorNameLength() {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxProcedureNameLength() {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxCatalogNameLength() {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxRowSize() {
        return 0x40000000;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return this.getMaxNameLength();
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 2;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    protected String escapeQuotes(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.connection.getStandardConformingStrings()) {
            stringBuilder.append("E");
        }
        stringBuilder.append("'");
        stringBuilder.append(this.connection.escapeString(string));
        stringBuilder.append("'");
        return stringBuilder.toString();
    }

    @Override
    public ResultSet getProcedures(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        String string4 = "SELECT NULL AS PROCEDURE_CAT, n.nspname AS PROCEDURE_SCHEM, p.proname AS PROCEDURE_NAME, NULL, NULL, NULL, d.description AS REMARKS, 2 AS PROCEDURE_TYPE,  p.proname || '_' || p.oid AS SPECIFIC_NAME  FROM pg_catalog.pg_namespace n, pg_catalog.pg_proc p  LEFT JOIN pg_catalog.pg_description d ON (p.oid=d.objoid)  LEFT JOIN pg_catalog.pg_class c ON (d.classoid=c.oid AND c.relname='pg_proc')  LEFT JOIN pg_catalog.pg_namespace pn ON (c.relnamespace=pn.oid AND pn.nspname='pg_catalog')  WHERE p.pronamespace=n.oid ";
        if (this.connection.haveMinimumServerVersion(ServerVersion.v11)) {
            string4 = string4 + " AND p.prokind='p'";
        }
        if (string2 != null && !string2.isEmpty()) {
            string4 = string4 + " AND n.nspname LIKE " + this.escapeQuotes(string2);
        }
        if (string3 != null && !string3.isEmpty()) {
            string4 = string4 + " AND p.proname LIKE " + this.escapeQuotes(string3);
        }
        if (this.connection.getHideUnprivilegedObjects()) {
            string4 = string4 + " AND has_function_privilege(p.oid,'EXECUTE')";
        }
        string4 = string4 + " ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, p.oid::text ";
        return this.createMetaDataStatement().executeQuery(string4);
    }

    @Override
    public ResultSet getProcedureColumns(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4) {
        int n = 20;
        Field[] fieldArray = new Field[n];
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        fieldArray[0] = new Field("PROCEDURE_CAT", 1043);
        fieldArray[1] = new Field("PROCEDURE_SCHEM", 1043);
        fieldArray[2] = new Field("PROCEDURE_NAME", 1043);
        fieldArray[3] = new Field("COLUMN_NAME", 1043);
        fieldArray[4] = new Field("COLUMN_TYPE", 21);
        fieldArray[5] = new Field("DATA_TYPE", 21);
        fieldArray[6] = new Field("TYPE_NAME", 1043);
        fieldArray[7] = new Field("PRECISION", 23);
        fieldArray[8] = new Field("LENGTH", 23);
        fieldArray[9] = new Field("SCALE", 21);
        fieldArray[10] = new Field("RADIX", 21);
        fieldArray[11] = new Field("NULLABLE", 21);
        fieldArray[12] = new Field("REMARKS", 1043);
        fieldArray[13] = new Field("COLUMN_DEF", 1043);
        fieldArray[14] = new Field("SQL_DATA_TYPE", 23);
        fieldArray[15] = new Field("SQL_DATETIME_SUB", 23);
        fieldArray[16] = new Field("CHAR_OCTET_LENGTH", 23);
        fieldArray[17] = new Field("ORDINAL_POSITION", 23);
        fieldArray[18] = new Field("IS_NULLABLE", 1043);
        fieldArray[19] = new Field("SPECIFIC_NAME", 1043);
        String string5 = "SELECT n.nspname,p.proname,p.prorettype,p.proargtypes, t.typtype,t.typrelid,  p.proargnames, p.proargmodes, p.proallargtypes, p.oid  FROM pg_catalog.pg_proc p, pg_catalog.pg_namespace n, pg_catalog.pg_type t  WHERE p.pronamespace=n.oid AND p.prorettype=t.oid ";
        if (string2 != null && !string2.isEmpty()) {
            string5 = string5 + " AND n.nspname LIKE " + this.escapeQuotes(string2);
        }
        if (string3 != null && !string3.isEmpty()) {
            string5 = string5 + " AND p.proname LIKE " + this.escapeQuotes(string3);
        }
        string5 = string5 + " ORDER BY n.nspname, p.proname, p.oid::text ";
        byte[] byArray = new byte[]{};
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string5);
        while (resultSet.next()) {
            int n2;
            Object object;
            byte[] byArray2 = resultSet.getBytes("nspname");
            byte[] byArray3 = resultSet.getBytes("proname");
            byte[] byArray4 = this.connection.encodeString(resultSet.getString("proname") + "_" + resultSet.getString("oid"));
            int n3 = (int)resultSet.getLong("prorettype");
            String string6 = resultSet.getString("typtype");
            int n4 = (int)resultSet.getLong("typrelid");
            String string7 = Nullness.castNonNull(resultSet.getString("proargtypes"));
            StringTokenizer stringTokenizer = new StringTokenizer(string7);
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList2.add(Long.valueOf(stringTokenizer.nextToken()));
            }
            String[] stringArray = null;
            Array array = resultSet.getArray("proargnames");
            if (array != null) {
                stringArray = (String[])array.getArray();
            }
            String[] stringArray2 = null;
            Array array2 = resultSet.getArray("proargmodes");
            if (array2 != null) {
                stringArray2 = (String[])array2.getArray();
            }
            int n5 = arrayList2.size();
            Long[] longArray = null;
            Array array3 = resultSet.getArray("proallargtypes");
            if (array3 != null) {
                longArray = (Long[])array3.getArray();
                n5 = longArray.length;
            }
            if ("b".equals(string6) || "d".equals(string6) || "e".equals(string6) || "p".equals(string6) && array2 == null) {
                byte @Nullable [][] byArrayArray = new byte[n][];
                byArrayArray[0] = null;
                byArrayArray[1] = byArray2;
                byArrayArray[2] = byArray3;
                byArrayArray[3] = this.connection.encodeString("returnValue");
                byArrayArray[4] = this.connection.encodeString(Integer.toString(5));
                byArrayArray[5] = this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getSQLType(n3)));
                byArrayArray[6] = this.connection.encodeString(this.connection.getTypeInfo().getPGType(n3));
                byArrayArray[7] = null;
                byArrayArray[8] = null;
                byArrayArray[9] = null;
                byArrayArray[10] = null;
                byArrayArray[11] = this.connection.encodeString(Integer.toString(2));
                byArrayArray[12] = null;
                byArrayArray[17] = this.connection.encodeString(Integer.toString(0));
                byArrayArray[18] = byArray;
                byArrayArray[19] = byArray4;
                arrayList.add(new Tuple(byArrayArray));
            }
            for (int i = 0; i < n5; ++i) {
                object = new byte[n][];
                object[0] = null;
                object[1] = byArray2;
                object[2] = byArray3;
                object[3] = stringArray != null ? this.connection.encodeString(stringArray[i]) : this.connection.encodeString("$" + (i + 1));
                int n6 = 1;
                if (stringArray2 != null && stringArray2[i].equals("o")) {
                    n6 = 4;
                } else if (stringArray2 != null && stringArray2[i].equals("b")) {
                    n6 = 2;
                } else if (stringArray2 != null && stringArray2[i].equals("t")) {
                    n6 = 5;
                }
                object[4] = this.connection.encodeString(Integer.toString(n6));
                n2 = longArray != null ? longArray[i].intValue() : ((Long)arrayList2.get(i)).intValue();
                object[5] = this.connection.encodeString(Integer.toString(Nullness.castNonNull(this.connection.getTypeInfo().getSQLType(n2))));
                object[6] = this.connection.encodeString(this.connection.getTypeInfo().getPGType(n2));
                object[7] = null;
                object[8] = null;
                object[9] = null;
                object[10] = null;
                object[11] = this.connection.encodeString(Integer.toString(2));
                object[12] = null;
                object[17] = this.connection.encodeString(Integer.toString(i + 1));
                object[18] = byArray;
                object[19] = byArray4;
                arrayList.add(new Tuple((byte[][])object));
            }
            if (!"c".equals(string6) && (!"p".equals(string6) || array2 == null)) continue;
            String string8 = "SELECT a.attname,a.atttypid FROM pg_catalog.pg_attribute a  WHERE a.attrelid = " + n4 + " AND NOT a.attisdropped AND a.attnum > 0 ORDER BY a.attnum ";
            object = this.connection.createStatement();
            ResultSet resultSet2 = object.executeQuery(string8);
            while (resultSet2.next()) {
                n2 = (int)resultSet2.getLong("atttypid");
                byte @Nullable [][] byArrayArray = new byte[n][];
                byArrayArray[0] = null;
                byArrayArray[1] = byArray2;
                byArrayArray[2] = byArray3;
                byArrayArray[3] = resultSet2.getBytes("attname");
                byArrayArray[4] = this.connection.encodeString(Integer.toString(3));
                byArrayArray[5] = this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getSQLType(n2)));
                byArrayArray[6] = this.connection.encodeString(this.connection.getTypeInfo().getPGType(n2));
                byArrayArray[7] = null;
                byArrayArray[8] = null;
                byArrayArray[9] = null;
                byArrayArray[10] = null;
                byArrayArray[11] = this.connection.encodeString(Integer.toString(2));
                byArrayArray[12] = null;
                byArrayArray[17] = this.connection.encodeString(Integer.toString(0));
                byArrayArray[18] = byArray;
                byArrayArray[19] = byArray4;
                arrayList.add(new Tuple(byArrayArray));
            }
            resultSet2.close();
            object.close();
        }
        resultSet.close();
        statement.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, arrayList);
    }

    @Override
    public ResultSet getTables(@Nullable String string, @Nullable String string2, @Nullable String string3, String @Nullable [] stringArray) {
        CharSequence charSequence;
        String string4 = "SCHEMAS";
        String string5 = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, c.relname AS TABLE_NAME,  CASE n.nspname ~ '^pg_' OR n.nspname = 'information_schema'  WHEN true THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN CASE c.relkind   WHEN 'r' THEN 'SYSTEM TABLE'   WHEN 'v' THEN 'SYSTEM VIEW'   WHEN 'i' THEN 'SYSTEM INDEX'   ELSE NULL   END  WHEN n.nspname = 'pg_toast' THEN CASE c.relkind   WHEN 'r' THEN 'SYSTEM TOAST TABLE'   WHEN 'i' THEN 'SYSTEM TOAST INDEX'   ELSE NULL   END  ELSE CASE c.relkind   WHEN 'r' THEN 'TEMPORARY TABLE'   WHEN 'p' THEN 'TEMPORARY TABLE'   WHEN 'i' THEN 'TEMPORARY INDEX'   WHEN 'S' THEN 'TEMPORARY SEQUENCE'   WHEN 'v' THEN 'TEMPORARY VIEW'   ELSE NULL   END  END  WHEN false THEN CASE c.relkind  WHEN 'r' THEN 'TABLE'  WHEN 'p' THEN 'PARTITIONED TABLE'  WHEN 'i' THEN 'INDEX'  WHEN 'P' then 'PARTITIONED INDEX'  WHEN 'S' THEN 'SEQUENCE'  WHEN 'v' THEN 'VIEW'  WHEN 'c' THEN 'TYPE'  WHEN 'f' THEN 'FOREIGN TABLE'  WHEN 'm' THEN 'MATERIALIZED VIEW'  ELSE NULL  END  ELSE NULL  END  AS TABLE_TYPE, d.description AS REMARKS,  '' as TYPE_CAT, '' as TYPE_SCHEM, '' as TYPE_NAME, '' AS SELF_REFERENCING_COL_NAME, '' AS REF_GENERATION  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c  LEFT JOIN pg_catalog.pg_description d ON (c.oid = d.objoid AND d.objsubid = 0  and d.classoid = 'pg_class'::regclass)  WHERE c.relnamespace = n.oid ";
        if (string2 != null && !string2.isEmpty()) {
            string5 = string5 + " AND n.nspname LIKE " + this.escapeQuotes(string2);
        }
        if (this.connection.getHideUnprivilegedObjects()) {
            string5 = string5 + " AND has_table_privilege(c.oid,  'SELECT, INSERT, UPDATE, DELETE, RULE, REFERENCES, TRIGGER')";
        }
        String string6 = " ORDER BY TABLE_TYPE,TABLE_SCHEM,TABLE_NAME ";
        if (string3 != null && !string3.isEmpty()) {
            string5 = string5 + " AND c.relname LIKE " + this.escapeQuotes(string3);
        }
        if (stringArray != null) {
            string5 = string5 + " AND (false ";
            charSequence = new StringBuilder();
            for (String string7 : stringArray) {
                Map<String, String> map = tableTypeClauses.get(string7);
                if (map == null) continue;
                String string8 = map.get(string4);
                ((StringBuilder)charSequence).append(" OR ( ").append(string8).append(" ) ");
            }
            string5 = string5 + ((StringBuilder)charSequence).toString() + ") ";
        }
        charSequence = string5 + string6;
        return ((PgResultSet)this.createMetaDataStatement().executeQuery((String)charSequence)).upperCaseFieldLabels();
    }

    @Override
    public ResultSet getSchemas() {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getSchemas(@Nullable String string, @Nullable String string2) {
        String string3 = "SELECT nspname AS TABLE_SCHEM, NULL AS TABLE_CATALOG FROM pg_catalog.pg_namespace  WHERE nspname <> 'pg_toast' AND (nspname !~ '^pg_temp_'  OR nspname = (pg_catalog.current_schemas(true))[1]) AND (nspname !~ '^pg_toast_temp_'  OR nspname = replace((pg_catalog.current_schemas(true))[1], 'pg_temp_', 'pg_toast_temp_')) ";
        if (string2 != null && !string2.isEmpty()) {
            string3 = string3 + " AND nspname LIKE " + this.escapeQuotes(string2);
        }
        if (this.connection.getHideUnprivilegedObjects()) {
            string3 = string3 + " AND has_schema_privilege(nspname, 'USAGE, CREATE')";
        }
        string3 = string3 + " ORDER BY TABLE_SCHEM";
        return this.createMetaDataStatement().executeQuery(string3);
    }

    @Override
    public ResultSet getCatalogs() {
        Field[] fieldArray = new Field[1];
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        fieldArray[0] = new Field("TABLE_CAT", 1043);
        byte @Nullable [][] byArrayArray = new byte[][]{this.connection.encodeString(this.connection.getCatalog())};
        arrayList.add(new Tuple(byArrayArray));
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, arrayList);
    }

    @Override
    public ResultSet getTableTypes() {
        Object[] objectArray = tableTypeClauses.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        Field[] fieldArray = new Field[1];
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        fieldArray[0] = new Field("TABLE_TYPE", 1043);
        for (Object object : objectArray) {
            byte @Nullable [][] byArrayArray = new byte[][]{this.connection.encodeString((String)object)};
            arrayList.add(new Tuple(byArrayArray));
        }
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, arrayList);
    }

    @Override
    public ResultSet getColumns(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4) {
        int n = 24;
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        Field[] fieldArray = new Field[n];
        fieldArray[0] = new Field("TABLE_CAT", 1043);
        fieldArray[1] = new Field("TABLE_SCHEM", 1043);
        fieldArray[2] = new Field("TABLE_NAME", 1043);
        fieldArray[3] = new Field("COLUMN_NAME", 1043);
        fieldArray[4] = new Field("DATA_TYPE", 21);
        fieldArray[5] = new Field("TYPE_NAME", 1043);
        fieldArray[6] = new Field("COLUMN_SIZE", 23);
        fieldArray[7] = new Field("BUFFER_LENGTH", 1043);
        fieldArray[8] = new Field("DECIMAL_DIGITS", 23);
        fieldArray[9] = new Field("NUM_PREC_RADIX", 23);
        fieldArray[10] = new Field("NULLABLE", 23);
        fieldArray[11] = new Field("REMARKS", 1043);
        fieldArray[12] = new Field("COLUMN_DEF", 1043);
        fieldArray[13] = new Field("SQL_DATA_TYPE", 23);
        fieldArray[14] = new Field("SQL_DATETIME_SUB", 23);
        fieldArray[15] = new Field("CHAR_OCTET_LENGTH", 1043);
        fieldArray[16] = new Field("ORDINAL_POSITION", 23);
        fieldArray[17] = new Field("IS_NULLABLE", 1043);
        fieldArray[18] = new Field("SCOPE_CATALOG", 1043);
        fieldArray[19] = new Field("SCOPE_SCHEMA", 1043);
        fieldArray[20] = new Field("SCOPE_TABLE", 1043);
        fieldArray[21] = new Field("SOURCE_DATA_TYPE", 21);
        fieldArray[22] = new Field("IS_AUTOINCREMENT", 1043);
        fieldArray[23] = new Field("IS_GENERATEDCOLUMN", 1043);
        String string5 = this.connection.haveMinimumServerVersion(ServerVersion.v8_4) ? "SELECT * FROM (" : "";
        string5 = string5 + "SELECT n.nspname,c.relname,a.attname,a.atttypid,a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) AS attnotnull,a.atttypmod,a.attlen,t.typtypmod,";
        string5 = this.connection.haveMinimumServerVersion(ServerVersion.v8_4) ? string5 + "row_number() OVER (PARTITION BY a.attrelid ORDER BY a.attnum) AS attnum, " : string5 + "a.attnum,";
        string5 = this.connection.haveMinimumServerVersion(ServerVersion.v10) ? string5 + "nullif(a.attidentity, '') as attidentity," : string5 + "null as attidentity,";
        string5 = string5 + "pg_catalog.pg_get_expr(def.adbin, def.adrelid) AS adsrc,dsc.description,t.typbasetype,t.typtype  FROM pg_catalog.pg_namespace n  JOIN pg_catalog.pg_class c ON (c.relnamespace = n.oid)  JOIN pg_catalog.pg_attribute a ON (a.attrelid=c.oid)  JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid)  LEFT JOIN pg_catalog.pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum)  LEFT JOIN pg_catalog.pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid)  LEFT JOIN pg_catalog.pg_class dc ON (dc.oid=dsc.classoid AND dc.relname='pg_class')  LEFT JOIN pg_catalog.pg_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='pg_catalog')  WHERE c.relkind in ('r','p','v','f','m') and a.attnum > 0 AND NOT a.attisdropped ";
        if (string2 != null && !string2.isEmpty()) {
            string5 = string5 + " AND n.nspname LIKE " + this.escapeQuotes(string2);
        }
        if (string3 != null && !string3.isEmpty()) {
            string5 = string5 + " AND c.relname LIKE " + this.escapeQuotes(string3);
        }
        if (this.connection.haveMinimumServerVersion(ServerVersion.v8_4)) {
            string5 = string5 + ") c WHERE true ";
        }
        if (string4 != null && !string4.isEmpty()) {
            string5 = string5 + " AND attname LIKE " + this.escapeQuotes(string4);
        }
        string5 = string5 + " ORDER BY nspname,c.relname,attnum ";
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string5);
        while (resultSet.next()) {
            int n2;
            int n3;
            byte @Nullable [][] byArrayArray = new byte[n][];
            int n4 = (int)resultSet.getLong("atttypid");
            int n5 = resultSet.getInt("atttypmod");
            byArrayArray[0] = null;
            byArrayArray[1] = resultSet.getBytes("nspname");
            byArrayArray[2] = resultSet.getBytes("relname");
            byArrayArray[3] = resultSet.getBytes("attname");
            String string6 = resultSet.getString("typtype");
            int n6 = "c".equals(string6) ? 2002 : ("d".equals(string6) ? 2001 : ("e".equals(string6) ? 12 : this.connection.getTypeInfo().getSQLType(n4)));
            byArrayArray[4] = this.connection.encodeString(Integer.toString(n6));
            String string7 = this.connection.getTypeInfo().getPGType(n4);
            byArrayArray[5] = this.connection.encodeString(string7);
            byArrayArray[7] = null;
            String string8 = resultSet.getString("adsrc");
            if (string8 != null && string8.contains("nextval(")) {
                if ("int4".equals(string7)) {
                    byArrayArray[5] = this.connection.encodeString("serial");
                } else if ("int8".equals(string7)) {
                    byArrayArray[5] = this.connection.encodeString("bigserial");
                } else if ("int2".equals(string7) && this.connection.haveMinimumServerVersion(ServerVersion.v9_2)) {
                    byArrayArray[5] = this.connection.encodeString("smallserial");
                }
            }
            String string9 = resultSet.getString("attidentity");
            int n7 = (int)resultSet.getLong("typbasetype");
            if (n6 == 2001) {
                int n8 = resultSet.getInt("typtypmod");
                n3 = this.connection.getTypeInfo().getScale(n7, n5);
                if (n8 == -1) {
                    n2 = this.connection.getTypeInfo().getPrecision(n7, n5);
                } else if (n7 == 1700) {
                    n3 = this.connection.getTypeInfo().getScale(n7, n8);
                    n2 = this.connection.getTypeInfo().getPrecision(n7, n8);
                } else {
                    n2 = n8;
                }
            } else {
                n3 = this.connection.getTypeInfo().getScale(n4, n5);
                n2 = this.connection.getTypeInfo().getPrecision(n4, n5);
                if (n6 != 2 && n2 == 0) {
                    n2 = this.connection.getTypeInfo().getDisplaySize(n4, n5);
                }
            }
            byArrayArray[6] = this.connection.encodeString(Integer.toString(n2));
            byArrayArray[8] = (byte[])((n6 == 2 || n6 == 3) && n5 == -1 ? null : this.connection.encodeString(Integer.toString(n3)));
            byArrayArray[9] = this.connection.encodeString("10");
            if ("bit".equals(string7) || "varbit".equals(string7)) {
                byArrayArray[9] = this.connection.encodeString("2");
            }
            byArrayArray[10] = this.connection.encodeString(Integer.toString(resultSet.getBoolean("attnotnull") ? 0 : 1));
            byArrayArray[11] = resultSet.getBytes("description");
            byArrayArray[12] = resultSet.getBytes("adsrc");
            byArrayArray[13] = null;
            byArrayArray[14] = null;
            byArrayArray[15] = byArrayArray[6];
            byArrayArray[16] = this.connection.encodeString(String.valueOf(resultSet.getInt("attnum")));
            byArrayArray[17] = this.connection.encodeString(resultSet.getBoolean("attnotnull") ? "NO" : "YES");
            byArrayArray[18] = null;
            byArrayArray[19] = null;
            byArrayArray[20] = null;
            byArrayArray[21] = n7 == 0 ? null : this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getSQLType(n7)));
            String string10 = "NO";
            if (string8 != null && string8.contains("nextval(") || string9 != null) {
                string10 = "YES";
            }
            byArrayArray[22] = this.connection.encodeString(string10);
            byArrayArray[23] = this.connection.encodeString("");
            arrayList.add(new Tuple(byArrayArray));
        }
        resultSet.close();
        statement.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, arrayList);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public ResultSet getColumnPrivileges(@Nullable String string, @Nullable String string2, String string3, @Nullable String string4) {
        Field[] fieldArray = new Field[8];
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        fieldArray[0] = new Field("TABLE_CAT", 1043);
        fieldArray[1] = new Field("TABLE_SCHEM", 1043);
        fieldArray[2] = new Field("TABLE_NAME", 1043);
        fieldArray[3] = new Field("COLUMN_NAME", 1043);
        fieldArray[4] = new Field("GRANTOR", 1043);
        fieldArray[5] = new Field("GRANTEE", 1043);
        fieldArray[6] = new Field("PRIVILEGE", 1043);
        fieldArray[7] = new Field("IS_GRANTABLE", 1043);
        String string5 = "SELECT n.nspname,c.relname,r.rolname,c.relacl, " + (this.connection.haveMinimumServerVersion(ServerVersion.v8_4) ? "a.attacl, " : "") + " a.attname  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c,  pg_catalog.pg_roles r, pg_catalog.pg_attribute a  WHERE c.relnamespace = n.oid  AND c.relowner = r.oid  AND c.oid = a.attrelid  AND c.relkind = 'r'  AND a.attnum > 0 AND NOT a.attisdropped ";
        if (string2 != null && !string2.isEmpty()) {
            string5 = string5 + " AND n.nspname = " + this.escapeQuotes(string2);
        }
        if (string3 != null && !string3.isEmpty()) {
            string5 = string5 + " AND c.relname = " + this.escapeQuotes(string3);
        }
        if (string4 != null && !string4.isEmpty()) {
            string5 = string5 + " AND a.attname LIKE " + this.escapeQuotes(string4);
        }
        string5 = string5 + " ORDER BY attname ";
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string5);
        while (resultSet.next()) {
            Object[] objectArray;
            byte[] byArray = resultSet.getBytes("nspname");
            byte[] byArray2 = resultSet.getBytes("relname");
            byte[] byArray3 = resultSet.getBytes("attname");
            String string6 = Nullness.castNonNull(resultSet.getString("rolname"));
            String string7 = resultSet.getString("relacl");
            Map<String, Map<String, List<@Nullable String[]>>> map = this.parseACL(string7, string6);
            if (this.connection.haveMinimumServerVersion(ServerVersion.v8_4)) {
                objectArray = resultSet.getString("attacl");
                @Nullable Object[] objectArray2 = this.parseACL((String)objectArray, string6);
                map.putAll((Map<String, Map<String, List<String[]>>>)objectArray2);
            }
            objectArray = map.keySet().toArray(new String[0]);
            Arrays.sort(objectArray);
            for (Object object : objectArray) {
                byte[] byArray4 = this.connection.encodeString((String)object);
                Map<String, List<@Nullable String[]>> map2 = map.get(object);
                for (Map.Entry<String, List<String[]>> entry : map2.entrySet()) {
                    List<@Nullable String[]> list = entry.getValue();
                    String string8 = entry.getKey();
                    for (String[] stringArray : list) {
                        String string9 = string6.equals(string8) ? "YES" : stringArray[1];
                        byte @Nullable [][] byArrayArray = new byte[][]{null, byArray, byArray2, byArray3, this.connection.encodeString(stringArray[0]), this.connection.encodeString(string8), byArray4, this.connection.encodeString(string9)};
                        arrayList.add(new Tuple(byArrayArray));
                    }
                }
            }
        }
        resultSet.close();
        statement.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, arrayList);
    }

    @Override
    public ResultSet getTablePrivileges(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        Field[] fieldArray = new Field[7];
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        fieldArray[0] = new Field("TABLE_CAT", 1043);
        fieldArray[1] = new Field("TABLE_SCHEM", 1043);
        fieldArray[2] = new Field("TABLE_NAME", 1043);
        fieldArray[3] = new Field("GRANTOR", 1043);
        fieldArray[4] = new Field("GRANTEE", 1043);
        fieldArray[5] = new Field("PRIVILEGE", 1043);
        fieldArray[6] = new Field("IS_GRANTABLE", 1043);
        String string4 = "SELECT n.nspname,c.relname,r.rolname,c.relacl  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c, pg_catalog.pg_roles r  WHERE c.relnamespace = n.oid  AND c.relowner = r.oid  AND c.relkind IN ('r','p','v','m','f') ";
        if (string2 != null && !string2.isEmpty()) {
            string4 = string4 + " AND n.nspname LIKE " + this.escapeQuotes(string2);
        }
        if (string3 != null && !string3.isEmpty()) {
            string4 = string4 + " AND c.relname LIKE " + this.escapeQuotes(string3);
        }
        string4 = string4 + " ORDER BY nspname, relname ";
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string4);
        while (resultSet.next()) {
            byte[] byArray = resultSet.getBytes("nspname");
            byte[] byArray2 = resultSet.getBytes("relname");
            String string5 = Nullness.castNonNull(resultSet.getString("rolname"));
            String string6 = resultSet.getString("relacl");
            Map<String, Map<String, List<@Nullable String[]>>> map = this.parseACL(string6, string5);
            @KeyFor(value={"permissions"}) Object[] objectArray = map.keySet().toArray(new String[0]);
            Arrays.sort(objectArray);
            for (Object object : objectArray) {
                byte[] byArray3 = this.connection.encodeString((String)object);
                Map<String, List<@Nullable String[]>> map2 = map.get(object);
                for (Map.Entry<String, List<String[]>> entry : map2.entrySet()) {
                    List<@Nullable String[]> list = entry.getValue();
                    String string7 = entry.getKey();
                    for (String[] stringArray : list) {
                        String string8 = stringArray[0] == null ? string5 : stringArray[0];
                        String string9 = string5.equals(string7) ? "YES" : stringArray[1];
                        byte @Nullable [][] byArrayArray = new byte[][]{null, byArray, byArray2, this.connection.encodeString(string8), this.connection.encodeString(string7), byArray3, this.connection.encodeString(string9)};
                        arrayList.add(new Tuple(byArrayArray));
                    }
                }
            }
        }
        resultSet.close();
        statement.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, arrayList);
    }

    private static List<String> parseACLArray(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.isEmpty()) {
            return arrayList;
        }
        boolean bl = false;
        int n2 = 1;
        int n3 = 32;
        for (n = n2; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (c == '\"' && n3 != 92) {
                bl = !bl;
            } else if (c == ',' && !bl) {
                arrayList.add(string.substring(n2, n));
                n2 = n + 1;
            }
            n3 = c;
        }
        arrayList.add(string.substring(n2, string.length() - 1));
        for (n = 0; n < arrayList.size(); ++n) {
            String string2 = (String)arrayList.get(n);
            if (!string2.startsWith("\"") || !string2.endsWith("\"")) continue;
            string2 = string2.substring(1, string2.length() - 1);
            arrayList.set(n, string2);
        }
        return arrayList;
    }

    private static void addACLPrivileges(String string, Map<String, Map<String, List<@Nullable String[]>>> map) {
        String string2;
        int n = string.lastIndexOf("=");
        int n2 = string.lastIndexOf("/");
        if (n == -1) {
            return;
        }
        String string3 = string.substring(0, n);
        String string4 = null;
        if (string3.isEmpty()) {
            string3 = "PUBLIC";
        }
        if (n2 != -1) {
            string2 = string.substring(n + 1, n2);
            string4 = string.substring(n2 + 1, string.length());
        } else {
            string2 = string.substring(n + 1, string.length());
        }
        for (int i = 0; i < string2.length(); ++i) {
            List<String[]> list;
            String string5;
            char c = string2.charAt(i);
            if (c == '*') continue;
            String string6 = i < string2.length() - 1 && string2.charAt(i + 1) == '*' ? "YES" : "NO";
            switch (c) {
                case 'a': {
                    string5 = "INSERT";
                    break;
                }
                case 'p': 
                case 'r': {
                    string5 = "SELECT";
                    break;
                }
                case 'w': {
                    string5 = "UPDATE";
                    break;
                }
                case 'd': {
                    string5 = "DELETE";
                    break;
                }
                case 'D': {
                    string5 = "TRUNCATE";
                    break;
                }
                case 'R': {
                    string5 = "RULE";
                    break;
                }
                case 'x': {
                    string5 = "REFERENCES";
                    break;
                }
                case 't': {
                    string5 = "TRIGGER";
                    break;
                }
                case 'X': {
                    string5 = "EXECUTE";
                    break;
                }
                case 'U': {
                    string5 = "USAGE";
                    break;
                }
                case 'C': {
                    string5 = "CREATE";
                    break;
                }
                case 'T': {
                    string5 = "CREATE TEMP";
                    break;
                }
                default: {
                    string5 = "UNKNOWN";
                }
            }
            Map<String, List<@Nullable String[]>> map2 = map.get(string5);
            if (map2 == null) {
                map2 = new HashMap<String, List<String[]>>();
                map.put(string5, map2);
            }
            if ((list = map2.get(string3)) == null) {
                list = new ArrayList<String[]>();
                map2.put(string3, list);
            }
            String[] stringArray = new String[]{string4, string6};
            list.add(stringArray);
        }
    }

    public Map<String, Map<String, List<@Nullable String[]>>> parseACL(@Nullable String string, String string2) {
        Object object;
        if (string == null) {
            object = this.connection.haveMinimumServerVersion(ServerVersion.v8_4) ? "arwdDxt" : "arwdxt";
            string = "{" + string2 + "=" + (String)object + "/" + string2 + "}";
        }
        object = PgDatabaseMetaData.parseACLArray(string);
        HashMap<String, Map<String, List<@Nullable String[]>>> hashMap = new HashMap<String, Map<String, List<String[]>>>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            PgDatabaseMetaData.addACLPrivileges(string3, hashMap);
        }
        return hashMap;
    }

    @Override
    public ResultSet getBestRowIdentifier(@Nullable String string, @Nullable String string2, String string3, int n, boolean bl) {
        Field[] fieldArray = new Field[8];
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        fieldArray[0] = new Field("SCOPE", 21);
        fieldArray[1] = new Field("COLUMN_NAME", 1043);
        fieldArray[2] = new Field("DATA_TYPE", 21);
        fieldArray[3] = new Field("TYPE_NAME", 1043);
        fieldArray[4] = new Field("COLUMN_SIZE", 23);
        fieldArray[5] = new Field("BUFFER_LENGTH", 23);
        fieldArray[6] = new Field("DECIMAL_DIGITS", 21);
        fieldArray[7] = new Field("PSEUDO_COLUMN", 21);
        String string4 = "SELECT a.attname, a.atttypid, atttypmod FROM pg_catalog.pg_class ct   JOIN pg_catalog.pg_attribute a ON (ct.oid = a.attrelid)   JOIN pg_catalog.pg_namespace n ON (ct.relnamespace = n.oid)   JOIN (SELECT i.indexrelid, i.indrelid, i.indisprimary,              information_schema._pg_expandarray(i.indkey) AS keys         FROM pg_catalog.pg_index i) i     ON (a.attnum = (i.keys).x AND a.attrelid = i.indrelid) WHERE true ";
        if (string2 != null && !string2.isEmpty()) {
            string4 = string4 + " AND n.nspname = " + this.escapeQuotes(string2);
        }
        string4 = string4 + " AND ct.relname = " + this.escapeQuotes(string3) + " AND i.indisprimary  ORDER BY a.attnum ";
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string4);
        while (resultSet.next()) {
            byte @Nullable [][] byArrayArray = new byte[8][];
            int n2 = (int)resultSet.getLong("atttypid");
            int n3 = this.connection.getTypeInfo().getSQLType(n2);
            int n4 = resultSet.getInt("atttypmod");
            int n5 = this.connection.getTypeInfo().getScale(n2, n4);
            int n6 = this.connection.getTypeInfo().getPrecision(n2, n4);
            if (n3 != 2 && n6 == 0) {
                n6 = this.connection.getTypeInfo().getDisplaySize(n2, n4);
            }
            byArrayArray[0] = this.connection.encodeString(Integer.toString(n));
            byArrayArray[1] = resultSet.getBytes("attname");
            byArrayArray[2] = this.connection.encodeString(Integer.toString(n3));
            byArrayArray[3] = this.connection.encodeString(this.connection.getTypeInfo().getPGType(n2));
            byArrayArray[4] = this.connection.encodeString(Integer.toString(n6));
            byArrayArray[5] = null;
            byArrayArray[6] = this.connection.encodeString(Integer.toString(n5));
            byArrayArray[7] = this.connection.encodeString(Integer.toString(1));
            arrayList.add(new Tuple(byArrayArray));
        }
        resultSet.close();
        statement.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, arrayList);
    }

    @Override
    public ResultSet getVersionColumns(@Nullable String string, @Nullable String string2, String string3) {
        Field[] fieldArray = new Field[8];
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        fieldArray[0] = new Field("SCOPE", 21);
        fieldArray[1] = new Field("COLUMN_NAME", 1043);
        fieldArray[2] = new Field("DATA_TYPE", 21);
        fieldArray[3] = new Field("TYPE_NAME", 1043);
        fieldArray[4] = new Field("COLUMN_SIZE", 23);
        fieldArray[5] = new Field("BUFFER_LENGTH", 23);
        fieldArray[6] = new Field("DECIMAL_DIGITS", 21);
        fieldArray[7] = new Field("PSEUDO_COLUMN", 21);
        byte @Nullable [][] byArrayArray = new byte[][]{null, this.connection.encodeString("ctid"), this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getSQLType("tid"))), this.connection.encodeString("tid"), null, null, null, this.connection.encodeString(Integer.toString(2))};
        arrayList.add(new Tuple(byArrayArray));
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, arrayList);
    }

    @Override
    public ResultSet getPrimaryKeys(@Nullable String string, @Nullable String string2, String string3) {
        String string4 = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM,   ct.relname AS TABLE_NAME, a.attname AS COLUMN_NAME,   (information_schema._pg_expandarray(i.indkey)).n AS KEY_SEQ, ci.relname AS PK_NAME,   information_schema._pg_expandarray(i.indkey) AS KEYS, a.attnum AS A_ATTNUM FROM pg_catalog.pg_class ct   JOIN pg_catalog.pg_attribute a ON (ct.oid = a.attrelid)   JOIN pg_catalog.pg_namespace n ON (ct.relnamespace = n.oid)   JOIN pg_catalog.pg_index i ON ( a.attrelid = i.indrelid)   JOIN pg_catalog.pg_class ci ON (ci.oid = i.indexrelid) WHERE true ";
        if (string2 != null && !string2.isEmpty()) {
            string4 = string4 + " AND n.nspname = " + this.escapeQuotes(string2);
        }
        if (string3 != null && !string3.isEmpty()) {
            string4 = string4 + " AND ct.relname = " + this.escapeQuotes(string3);
        }
        string4 = string4 + " AND i.indisprimary ";
        string4 = "SELECT        result.TABLE_CAT,        result.TABLE_SCHEM,        result.TABLE_NAME,        result.COLUMN_NAME,        result.KEY_SEQ,        result.PK_NAME FROM      (" + string4 + " ) result where  result.A_ATTNUM = (result.KEYS).x ";
        string4 = string4 + " ORDER BY result.table_name, result.pk_name, result.key_seq";
        return this.createMetaDataStatement().executeQuery(string4);
    }

    protected ResultSet getPrimaryUniqueKeys(@Nullable String string, @Nullable String string2, String string3) {
        String string4 = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM,   ct.relname AS TABLE_NAME, a.attname AS COLUMN_NAME,   (information_schema._pg_expandarray(i.indkey)).n AS KEY_SEQ, ci.relname AS PK_NAME,   information_schema._pg_expandarray(i.indkey) AS KEYS, a.attnum AS A_ATTNUM,   a.attnotnull AS IS_NOT_NULL FROM pg_catalog.pg_class ct   JOIN pg_catalog.pg_attribute a ON (ct.oid = a.attrelid)   JOIN pg_catalog.pg_namespace n ON (ct.relnamespace = n.oid)   JOIN pg_catalog.pg_index i ON ( a.attrelid = i.indrelid)   JOIN pg_catalog.pg_class ci ON (ci.oid = i.indexrelid) WHERE (i.indisprimary OR (     i.indisunique     AND i.indisvalid     AND i.indpred IS NULL     AND i.indexprs IS NULL   )) ";
        if (string2 != null && !string2.isEmpty()) {
            string4 = string4 + " AND n.nspname = " + this.escapeQuotes(string2);
        }
        if (string3 != null && !string3.isEmpty()) {
            string4 = string4 + " AND ct.relname = " + this.escapeQuotes(string3);
        }
        string4 = "SELECT        result.TABLE_CAT,        result.TABLE_SCHEM,        result.TABLE_NAME,        result.COLUMN_NAME,        result.KEY_SEQ,        result.PK_NAME,        result.IS_NOT_NULL FROM      (" + string4 + " ) result where  result.A_ATTNUM = (result.KEYS).x ";
        string4 = string4 + " ORDER BY result.table_name, result.pk_name, result.key_seq";
        return this.createMetaDataStatement().executeQuery(string4);
    }

    protected ResultSet getImportedExportedKeys(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6) {
        String string7 = "SELECT NULL::text AS PKTABLE_CAT, pkn.nspname AS PKTABLE_SCHEM, pkc.relname AS PKTABLE_NAME, pka.attname AS PKCOLUMN_NAME, NULL::text AS FKTABLE_CAT, fkn.nspname AS FKTABLE_SCHEM, fkc.relname AS FKTABLE_NAME, fka.attname AS FKCOLUMN_NAME, pos.n AS KEY_SEQ, CASE con.confupdtype  WHEN 'c' THEN 0 WHEN 'n' THEN 2 WHEN 'd' THEN 4 WHEN 'r' THEN 1 WHEN 'p' THEN 1 WHEN 'a' THEN 3 ELSE NULL END AS UPDATE_RULE, CASE con.confdeltype  WHEN 'c' THEN 0 WHEN 'n' THEN 2 WHEN 'd' THEN 4 WHEN 'r' THEN 1 WHEN 'p' THEN 1 WHEN 'a' THEN 3 ELSE NULL END AS DELETE_RULE, con.conname AS FK_NAME, pkic.relname AS PK_NAME, CASE  WHEN con.condeferrable AND con.condeferred THEN 5 WHEN con.condeferrable THEN 6 ELSE 7 END AS DEFERRABILITY  FROM  pg_catalog.pg_namespace pkn, pg_catalog.pg_class pkc, pg_catalog.pg_attribute pka,  pg_catalog.pg_namespace fkn, pg_catalog.pg_class fkc, pg_catalog.pg_attribute fka,  pg_catalog.pg_constraint con,  pg_catalog.generate_series(1, " + this.getMaxIndexKeys() + ") pos(n),  pg_catalog.pg_class pkic";
        if (!this.connection.haveMinimumServerVersion(ServerVersion.v9_0)) {
            string7 = string7 + ", pg_catalog.pg_depend dep ";
        }
        string7 = string7 + " WHERE pkn.oid = pkc.relnamespace AND pkc.oid = pka.attrelid AND pka.attnum = con.confkey[pos.n] AND con.confrelid = pkc.oid  AND fkn.oid = fkc.relnamespace AND fkc.oid = fka.attrelid AND fka.attnum = con.conkey[pos.n] AND con.conrelid = fkc.oid  AND con.contype = 'f' ";
        string7 = !this.connection.haveMinimumServerVersion(ServerVersion.v11) ? string7 + "AND pkic.relkind = 'i' " : string7 + "AND (pkic.relkind = 'i' OR pkic.relkind = 'I')";
        string7 = !this.connection.haveMinimumServerVersion(ServerVersion.v9_0) ? string7 + " AND con.oid = dep.objid AND pkic.oid = dep.refobjid AND dep.classid = 'pg_constraint'::regclass::oid AND dep.refclassid = 'pg_class'::regclass::oid " : string7 + " AND pkic.oid = con.conindid ";
        if (string2 != null && !string2.isEmpty()) {
            string7 = string7 + " AND pkn.nspname = " + this.escapeQuotes(string2);
        }
        if (string5 != null && !string5.isEmpty()) {
            string7 = string7 + " AND fkn.nspname = " + this.escapeQuotes(string5);
        }
        if (string3 != null && !string3.isEmpty()) {
            string7 = string7 + " AND pkc.relname = " + this.escapeQuotes(string3);
        }
        if (string6 != null && !string6.isEmpty()) {
            string7 = string7 + " AND fkc.relname = " + this.escapeQuotes(string6);
        }
        string7 = string3 != null ? string7 + " ORDER BY fkn.nspname,fkc.relname,con.conname,pos.n" : string7 + " ORDER BY pkn.nspname,pkc.relname, con.conname,pos.n";
        return this.createMetaDataStatement().executeQuery(string7);
    }

    @Override
    public ResultSet getImportedKeys(@Nullable String string, @Nullable String string2, String string3) {
        return this.getImportedExportedKeys(null, null, null, string, string2, string3);
    }

    @Override
    public ResultSet getExportedKeys(@Nullable String string, @Nullable String string2, String string3) {
        return this.getImportedExportedKeys(string, string2, string3, null, null, null);
    }

    @Override
    public ResultSet getCrossReference(@Nullable String string, @Nullable String string2, String string3, @Nullable String string4, @Nullable String string5, String string6) {
        return this.getImportedExportedKeys(string, string2, string3, string4, string5, string6);
    }

    @Override
    public ResultSet getTypeInfo() {
        Field[] fieldArray = new Field[18];
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        fieldArray[0] = new Field("TYPE_NAME", 1043);
        fieldArray[1] = new Field("DATA_TYPE", 21);
        fieldArray[2] = new Field("PRECISION", 23);
        fieldArray[3] = new Field("LITERAL_PREFIX", 1043);
        fieldArray[4] = new Field("LITERAL_SUFFIX", 1043);
        fieldArray[5] = new Field("CREATE_PARAMS", 1043);
        fieldArray[6] = new Field("NULLABLE", 21);
        fieldArray[7] = new Field("CASE_SENSITIVE", 16);
        fieldArray[8] = new Field("SEARCHABLE", 21);
        fieldArray[9] = new Field("UNSIGNED_ATTRIBUTE", 16);
        fieldArray[10] = new Field("FIXED_PREC_SCALE", 16);
        fieldArray[11] = new Field("AUTO_INCREMENT", 16);
        fieldArray[12] = new Field("LOCAL_TYPE_NAME", 1043);
        fieldArray[13] = new Field("MINIMUM_SCALE", 21);
        fieldArray[14] = new Field("MAXIMUM_SCALE", 21);
        fieldArray[15] = new Field("SQL_DATA_TYPE", 23);
        fieldArray[16] = new Field("SQL_DATETIME_SUB", 23);
        fieldArray[17] = new Field("NUM_PREC_RADIX", 23);
        String string = "SELECT t.typname,t.oid FROM pg_catalog.pg_type t JOIN pg_catalog.pg_namespace n ON (t.typnamespace = n.oid)  WHERE n.nspname  != 'pg_toast' AND  (t.typrelid = 0 OR (SELECT c.relkind = 'c' FROM pg_catalog.pg_class c WHERE c.oid = t.typrelid))";
        if (this.connection.getHideUnprivilegedObjects() && this.connection.haveMinimumServerVersion(ServerVersion.v9_2)) {
            string = string + " AND has_type_privilege(t.oid, 'USAGE')";
        }
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        byte[] byArray = this.connection.encodeString("0");
        byte[] byArray2 = this.connection.encodeString("10");
        byte[] byArray3 = this.connection.encodeString("f");
        byte[] byArray4 = this.connection.encodeString("t");
        byte[] byArray5 = this.connection.encodeString("'");
        byte[] byArray6 = this.connection.encodeString(Integer.toString(1));
        byte[] byArray7 = this.connection.encodeString(Integer.toString(3));
        TypeInfo typeInfo = this.connection.getTypeInfo();
        if (typeInfo instanceof TypeInfoCache) {
            ((TypeInfoCache)typeInfo).cacheSQLTypes();
        }
        while (resultSet.next()) {
            byte[][] byArray8;
            byte @Nullable [][] byArrayArray = new byte[19][];
            String string2 = Nullness.castNonNull(resultSet.getString(1));
            int n = (int)resultSet.getLong(2);
            byArrayArray[0] = this.connection.encodeString(string2);
            int n2 = this.connection.getTypeInfo().getSQLType(string2);
            byArrayArray[1] = this.connection.encodeString(Integer.toString(n2));
            byArrayArray[18] = BigInteger.valueOf(n2).toByteArray();
            byArrayArray[2] = this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getMaximumPrecision(n)));
            if (this.connection.getTypeInfo().requiresQuotingSqlType(n2)) {
                byArrayArray[3] = byArray5;
                byArrayArray[4] = byArray5;
            }
            byArrayArray[6] = byArray6;
            byArrayArray[7] = this.connection.getTypeInfo().isCaseSensitive(n) ? byArray4 : byArray3;
            byArrayArray[8] = byArray7;
            byArrayArray[9] = this.connection.getTypeInfo().isSigned(n) ? byArray3 : byArray4;
            byArrayArray[10] = byArray3;
            byArrayArray[11] = byArray3;
            byArrayArray[13] = byArray;
            byArrayArray[14] = n == 1700 ? this.connection.encodeString("1000") : byArray;
            byArrayArray[17] = byArray2;
            arrayList.add(new Tuple(byArrayArray));
            if ("int4".equals(string2)) {
                byArray8 = (byte[][])byArrayArray.clone();
                byArray8[0] = this.connection.encodeString("serial");
                byArray8[11] = byArray4;
                arrayList.add(new Tuple(byArray8));
                continue;
            }
            if ("int8".equals(string2)) {
                byArray8 = (byte[][])byArrayArray.clone();
                byArray8[0] = this.connection.encodeString("bigserial");
                byArray8[11] = byArray4;
                arrayList.add(new Tuple(byArray8));
                continue;
            }
            if (!"int2".equals(string2) || !this.connection.haveMinimumServerVersion(ServerVersion.v9_2)) continue;
            byArray8 = (byte[][])byArrayArray.clone();
            byArray8[0] = this.connection.encodeString("smallserial");
            byArray8[11] = byArray4;
            arrayList.add(new Tuple(byArray8));
        }
        resultSet.close();
        statement.close();
        Collections.sort(arrayList, new Comparator<Tuple>(){

            @Override
            public int compare(Tuple tuple, Tuple tuple2) {
                int n;
                int n2 = ByteConverter.bytesToInt(Nullness.castNonNull(tuple.get(18)));
                return n2 < (n = ByteConverter.bytesToInt(Nullness.castNonNull(tuple2.get(18)))) ? -1 : (n2 == n ? 0 : 1);
            }
        });
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, arrayList);
    }

    @Override
    public ResultSet getIndexInfo(@Nullable String string, @Nullable String string2, String string3, boolean bl, boolean bl2) {
        String string4;
        if (this.connection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            string4 = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM,   ct.relname AS TABLE_NAME, NOT i.indisunique AS NON_UNIQUE,   NULL AS INDEX_QUALIFIER, ci.relname AS INDEX_NAME,   CASE i.indisclustered     WHEN true THEN 1    ELSE CASE am.amname       WHEN 'hash' THEN 2      ELSE 3    END   END AS TYPE,   (information_schema._pg_expandarray(i.indkey)).n AS ORDINAL_POSITION,   ci.reltuples AS CARDINALITY,   ci.relpages AS PAGES,   pg_catalog.pg_get_expr(i.indpred, i.indrelid) AS FILTER_CONDITION,   ci.oid AS CI_OID,   i.indoption AS I_INDOPTION, " + (this.connection.haveMinimumServerVersion(ServerVersion.v9_6) ? "  am.amname AS AM_NAME " : "  am.amcanorder AS AM_CANORDER ") + "FROM pg_catalog.pg_class ct   JOIN pg_catalog.pg_namespace n ON (ct.relnamespace = n.oid)   JOIN pg_catalog.pg_index i ON (ct.oid = i.indrelid)   JOIN pg_catalog.pg_class ci ON (ci.oid = i.indexrelid)   JOIN pg_catalog.pg_am am ON (ci.relam = am.oid) WHERE true ";
            if (string2 != null && !string2.isEmpty()) {
                string4 = string4 + " AND n.nspname = " + this.escapeQuotes(string2);
            }
            string4 = string4 + " AND ct.relname = " + this.escapeQuotes(string3);
            if (bl) {
                string4 = string4 + " AND i.indisunique ";
            }
            string4 = "SELECT     tmp.TABLE_CAT,     tmp.TABLE_SCHEM,     tmp.TABLE_NAME,     tmp.NON_UNIQUE,     tmp.INDEX_QUALIFIER,     tmp.INDEX_NAME,     tmp.TYPE,     tmp.ORDINAL_POSITION,     trim(both '\"' from pg_catalog.pg_get_indexdef(tmp.CI_OID, tmp.ORDINAL_POSITION, false)) AS COLUMN_NAME, " + (this.connection.haveMinimumServerVersion(ServerVersion.v9_6) ? "  CASE tmp.AM_NAME     WHEN 'btree' THEN CASE tmp.I_INDOPTION[tmp.ORDINAL_POSITION - 1] & 1::smallint       WHEN 1 THEN 'D'       ELSE 'A'     END     ELSE NULL   END AS ASC_OR_DESC, " : "  CASE tmp.AM_CANORDER     WHEN true THEN CASE tmp.I_INDOPTION[tmp.ORDINAL_POSITION - 1] & 1::smallint       WHEN 1 THEN 'D'       ELSE 'A'     END     ELSE NULL   END AS ASC_OR_DESC, ") + "    tmp.CARDINALITY,     tmp.PAGES,     tmp.FILTER_CONDITION FROM (" + string4 + ") AS tmp";
        } else {
            String string5 = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, ";
            String string6 = " FROM pg_catalog.pg_namespace n, pg_catalog.pg_class ct, pg_catalog.pg_class ci,  pg_catalog.pg_attribute a, pg_catalog.pg_am am ";
            String string7 = " AND n.oid = ct.relnamespace ";
            string6 = string6 + ", pg_catalog.pg_index i ";
            if (string2 != null && !string2.isEmpty()) {
                string7 = string7 + " AND n.nspname = " + this.escapeQuotes(string2);
            }
            string4 = string5 + " ct.relname AS TABLE_NAME, NOT i.indisunique AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, ci.relname AS INDEX_NAME,  CASE i.indisclustered  WHEN true THEN " + 1 + " ELSE CASE am.amname  WHEN 'hash' THEN " + 2 + " ELSE " + 3 + " END  END AS TYPE,  a.attnum AS ORDINAL_POSITION,  CASE WHEN i.indexprs IS NULL THEN a.attname  ELSE pg_catalog.pg_get_indexdef(ci.oid,a.attnum,false) END AS COLUMN_NAME,  NULL AS ASC_OR_DESC,  ci.reltuples AS CARDINALITY,  ci.relpages AS PAGES,  pg_catalog.pg_get_expr(i.indpred, i.indrelid) AS FILTER_CONDITION " + string6 + " WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid AND a.attrelid=ci.oid AND ci.relam=am.oid " + string7;
            string4 = string4 + " AND ct.relname = " + this.escapeQuotes(string3);
            if (bl) {
                string4 = string4 + " AND i.indisunique ";
            }
        }
        string4 = string4 + " ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION ";
        return this.createMetaDataStatement().executeQuery(string4);
    }

    @Override
    public boolean supportsResultSetType(int n) {
        return n != 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) {
        if (n == 1005) {
            return false;
        }
        if (n2 == 1008) {
            return true;
        }
        return true;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) {
        return true;
    }

    @Override
    public boolean ownDeletesAreVisible(int n) {
        return true;
    }

    @Override
    public boolean ownInsertsAreVisible(int n) {
        return true;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int n) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int n) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int n) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int n) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int n) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(@Nullable String string, @Nullable String string2, @Nullable String string3, int @Nullable [] nArray) {
        Object object;
        Object object2;
        String string4 = "select null as type_cat, n.nspname as type_schem, t.typname as type_name,  null as class_name, CASE WHEN t.typtype='c' then 2002 else 2001 end as data_type, pg_catalog.obj_description(t.oid, 'pg_type')  as remarks, CASE WHEN t.typtype = 'd' then  (select CASE";
        TypeInfo typeInfo = this.connection.getTypeInfo();
        StringBuilder stringBuilder = new StringBuilder();
        Object object3 = typeInfo.getPGTypeOidsWithSQLTypes();
        while (object3.hasNext()) {
            object2 = object3.next();
            long l = typeInfo.intOidToLong((Integer)object2);
            object = typeInfo.getSQLType((Integer)object2);
            stringBuilder.append(" when t.oid = ").append(l).append(" then ").append((int)object);
        }
        string4 = string4 + stringBuilder.toString();
        string4 = string4 + " else 1111 end from pg_type where oid=t.typbasetype) else null end as base_type from pg_catalog.pg_type t, pg_catalog.pg_namespace n where t.typnamespace = n.oid and n.nspname != 'pg_catalog' and n.nspname != 'pg_toast'";
        object3 = new StringBuilder();
        if (nArray != null) {
            ((StringBuilder)object3).append(" and (false ");
            object2 = nArray;
            int n = ((Object)object2).length;
            block5: for (int i = 0; i < n; ++i) {
                object = object2[i];
                switch (object) {
                    case 2002: {
                        ((StringBuilder)object3).append(" or t.typtype = 'c'");
                        continue block5;
                    }
                    case 2001: {
                        ((StringBuilder)object3).append(" or t.typtype = 'd'");
                    }
                }
            }
            ((StringBuilder)object3).append(" ) ");
        } else {
            ((StringBuilder)object3).append(" and t.typtype IN ('c','d') ");
        }
        if (string3 != null) {
            int n = string3.indexOf(46);
            int n2 = string3.lastIndexOf(46);
            if (n != -1) {
                string2 = n != n2 ? string3.substring(n + 1, n2) : string3.substring(0, n);
                string3 = string3.substring(n2 + 1);
            }
            ((StringBuilder)object3).append(" and t.typname like ").append(this.escapeQuotes(string3));
        }
        if (string2 != null) {
            ((StringBuilder)object3).append(" and n.nspname like ").append(this.escapeQuotes(string2));
        }
        string4 = string4 + ((StringBuilder)object3).toString();
        if (this.connection.getHideUnprivilegedObjects() && this.connection.haveMinimumServerVersion(ServerVersion.v9_2)) {
            string4 = string4 + " AND has_type_privilege(t.oid, 'USAGE')";
        }
        string4 = string4 + " order by data_type, type_schem, type_name";
        return this.createMetaDataStatement().executeQuery(string4);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    protected Statement createMetaDataStatement() {
        return this.connection.createStatement(1004, 1007);
    }

    @Override
    public long getMaxLogicalLobSize() {
        return 0L;
    }

    @Override
    public boolean supportsRefCursors() {
        return true;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        throw Driver.notImplemented(this.getClass(), "getRowIdLifetime()");
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() {
        Field[] fieldArray = new Field[]{new Field("NAME", 1043), new Field("MAX_LEN", 23), new Field("DEFAULT_VALUE", 1043), new Field("DESCRIPTION", 1043)};
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        if (this.connection.haveMinimumServerVersion(ServerVersion.v9_0)) {
            byte @Nullable [][] byArrayArray = new byte[][]{this.connection.encodeString("ApplicationName"), this.connection.encodeString(Integer.toString(this.getMaxNameLength())), this.connection.encodeString(""), this.connection.encodeString("The name of the application currently utilizing the connection.")};
            arrayList.add(new Tuple(byArrayArray));
        }
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, arrayList);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }

    @Override
    public ResultSet getFunctions(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        boolean bl = this.connection.haveMinimumServerVersion(ServerVersion.v8_4);
        String string4 = "0 ";
        if (bl) {
            string4 = " CASE    WHEN (format_type(p.prorettype, null) = 'unknown') THEN 0   WHEN      (substring(pg_get_function_result(p.oid) from 0 for 6) = 'TABLE') OR      (substring(pg_get_function_result(p.oid) from 0 for 6) = 'SETOF') THEN 2   ELSE 1 END ";
        }
        String string5 = "SELECT current_database() AS FUNCTION_CAT, n.nspname AS FUNCTION_SCHEM, p.proname AS FUNCTION_NAME,  d.description AS REMARKS, " + string4 + " AS FUNCTION_TYPE,  p.proname || '_' || p.oid AS SPECIFIC_NAME FROM pg_catalog.pg_proc p INNER JOIN pg_catalog.pg_namespace n ON p.pronamespace=n.oid LEFT JOIN pg_catalog.pg_description d ON p.oid=d.objoid WHERE true  ";
        if (this.connection.haveMinimumServerVersion(ServerVersion.v11)) {
            string5 = string5 + " AND p.prokind='f'";
        }
        if (string2 != null && !string2.isEmpty()) {
            string5 = string5 + " AND n.nspname LIKE " + this.escapeQuotes(string2);
        }
        if (string3 != null && !string3.isEmpty()) {
            string5 = string5 + " AND p.proname LIKE " + this.escapeQuotes(string3);
        }
        if (this.connection.getHideUnprivilegedObjects()) {
            string5 = string5 + " AND has_function_privilege(p.oid,'EXECUTE')";
        }
        string5 = string5 + " ORDER BY FUNCTION_SCHEM, FUNCTION_NAME, p.oid::text ";
        return this.createMetaDataStatement().executeQuery(string5);
    }

    @Override
    public ResultSet getFunctionColumns(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4) {
        int n = 17;
        Field[] fieldArray = new Field[n];
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        fieldArray[0] = new Field("FUNCTION_CAT", 1043);
        fieldArray[1] = new Field("FUNCTION_SCHEM", 1043);
        fieldArray[2] = new Field("FUNCTION_NAME", 1043);
        fieldArray[3] = new Field("COLUMN_NAME", 1043);
        fieldArray[4] = new Field("COLUMN_TYPE", 21);
        fieldArray[5] = new Field("DATA_TYPE", 21);
        fieldArray[6] = new Field("TYPE_NAME", 1043);
        fieldArray[7] = new Field("PRECISION", 21);
        fieldArray[8] = new Field("LENGTH", 23);
        fieldArray[9] = new Field("SCALE", 21);
        fieldArray[10] = new Field("RADIX", 21);
        fieldArray[11] = new Field("NULLABLE", 21);
        fieldArray[12] = new Field("REMARKS", 1043);
        fieldArray[13] = new Field("CHAR_OCTET_LENGTH", 23);
        fieldArray[14] = new Field("ORDINAL_POSITION", 23);
        fieldArray[15] = new Field("IS_NULLABLE", 1043);
        fieldArray[16] = new Field("SPECIFIC_NAME", 1043);
        String string5 = "SELECT n.nspname,p.proname,p.prorettype,p.proargtypes, t.typtype,t.typrelid,  p.proargnames, p.proargmodes, p.proallargtypes, p.oid  FROM pg_catalog.pg_proc p, pg_catalog.pg_namespace n, pg_catalog.pg_type t  WHERE p.pronamespace=n.oid AND p.prorettype=t.oid ";
        if (string2 != null && !string2.isEmpty()) {
            string5 = string5 + " AND n.nspname LIKE " + this.escapeQuotes(string2);
        }
        if (string3 != null && !string3.isEmpty()) {
            string5 = string5 + " AND p.proname LIKE " + this.escapeQuotes(string3);
        }
        string5 = string5 + " ORDER BY n.nspname, p.proname, p.oid::text ";
        byte[] byArray = new byte[]{};
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string5);
        while (resultSet.next()) {
            int n2;
            Object object;
            byte[] byArray2 = resultSet.getBytes("nspname");
            byte[] byArray3 = resultSet.getBytes("proname");
            byte[] byArray4 = this.connection.encodeString(resultSet.getString("proname") + "_" + resultSet.getString("oid"));
            int n3 = (int)resultSet.getLong("prorettype");
            String string6 = resultSet.getString("typtype");
            int n4 = (int)resultSet.getLong("typrelid");
            String string7 = Nullness.castNonNull(resultSet.getString("proargtypes"));
            StringTokenizer stringTokenizer = new StringTokenizer(string7);
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList2.add(Long.valueOf(stringTokenizer.nextToken()));
            }
            String[] stringArray = null;
            Array array = resultSet.getArray("proargnames");
            if (array != null) {
                stringArray = (String[])array.getArray();
            }
            String[] stringArray2 = null;
            Array array2 = resultSet.getArray("proargmodes");
            if (array2 != null) {
                stringArray2 = (String[])array2.getArray();
            }
            int n5 = arrayList2.size();
            Long[] longArray = null;
            Array array3 = resultSet.getArray("proallargtypes");
            if (array3 != null) {
                longArray = (Long[])array3.getArray();
                n5 = longArray.length;
            }
            if ("b".equals(string6) || "d".equals(string6) || "e".equals(string6) || "p".equals(string6) && array2 == null) {
                byte @Nullable [][] byArrayArray = new byte[n][];
                byArrayArray[0] = null;
                byArrayArray[1] = byArray2;
                byArrayArray[2] = byArray3;
                byArrayArray[3] = this.connection.encodeString("returnValue");
                byArrayArray[4] = this.connection.encodeString(Integer.toString(4));
                byArrayArray[5] = this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getSQLType(n3)));
                byArrayArray[6] = this.connection.encodeString(this.connection.getTypeInfo().getPGType(n3));
                byArrayArray[7] = null;
                byArrayArray[8] = null;
                byArrayArray[9] = null;
                byArrayArray[10] = null;
                byArrayArray[11] = this.connection.encodeString(Integer.toString(2));
                byArrayArray[12] = null;
                byArrayArray[14] = this.connection.encodeString(Integer.toString(0));
                byArrayArray[15] = byArray;
                byArrayArray[16] = byArray4;
                arrayList.add(new Tuple(byArrayArray));
            }
            for (int i = 0; i < n5; ++i) {
                object = new byte[n][];
                object[0] = null;
                object[1] = byArray2;
                object[2] = byArray3;
                object[3] = stringArray != null ? this.connection.encodeString(stringArray[i]) : this.connection.encodeString("$" + (i + 1));
                int n6 = 1;
                if (stringArray2 != null && stringArray2[i] != null) {
                    if (stringArray2[i].equals("o")) {
                        n6 = 3;
                    } else if (stringArray2[i].equals("b")) {
                        n6 = 2;
                    } else if (stringArray2[i].equals("t")) {
                        n6 = 4;
                    }
                }
                object[4] = this.connection.encodeString(Integer.toString(n6));
                n2 = longArray != null ? longArray[i].intValue() : ((Long)arrayList2.get(i)).intValue();
                object[5] = this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getSQLType(n2)));
                object[6] = this.connection.encodeString(this.connection.getTypeInfo().getPGType(n2));
                object[7] = null;
                object[8] = null;
                object[9] = null;
                object[10] = null;
                object[11] = this.connection.encodeString(Integer.toString(2));
                object[12] = null;
                object[14] = this.connection.encodeString(Integer.toString(i + 1));
                object[15] = byArray;
                object[16] = byArray4;
                arrayList.add(new Tuple((byte[][])object));
            }
            if (!"c".equals(string6) && (!"p".equals(string6) || array2 == null)) continue;
            String string8 = "SELECT a.attname,a.atttypid FROM pg_catalog.pg_attribute a  WHERE a.attrelid = " + n4 + " AND NOT a.attisdropped AND a.attnum > 0 ORDER BY a.attnum ";
            object = this.connection.createStatement();
            ResultSet resultSet2 = object.executeQuery(string8);
            while (resultSet2.next()) {
                n2 = (int)resultSet2.getLong("atttypid");
                byte @Nullable [][] byArrayArray = new byte[n][];
                byArrayArray[0] = null;
                byArrayArray[1] = byArray2;
                byArrayArray[2] = byArray3;
                byArrayArray[3] = resultSet2.getBytes("attname");
                byArrayArray[4] = this.connection.encodeString(Integer.toString(5));
                byArrayArray[5] = this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getSQLType(n2)));
                byArrayArray[6] = this.connection.encodeString(this.connection.getTypeInfo().getPGType(n2));
                byArrayArray[7] = null;
                byArrayArray[8] = null;
                byArrayArray[9] = null;
                byArrayArray[10] = null;
                byArrayArray[11] = this.connection.encodeString(Integer.toString(2));
                byArrayArray[12] = null;
                byArrayArray[14] = this.connection.encodeString(Integer.toString(0));
                byArrayArray[15] = byArray;
                byArrayArray[16] = byArray4;
                arrayList.add(new Tuple(byArrayArray));
            }
            resultSet2.close();
            object.close();
        }
        resultSet.close();
        statement.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(fieldArray, arrayList);
    }

    @Override
    public ResultSet getPseudoColumns(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4) {
        throw Driver.notImplemented(this.getClass(), "getPseudoColumns(String, String, String, String)");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return true;
    }

    @Override
    public boolean supportsSavepoints() {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        throw Driver.notImplemented(this.getClass(), "getSuperTypes(String,String,String)");
    }

    @Override
    public ResultSet getSuperTables(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        throw Driver.notImplemented(this.getClass(), "getSuperTables(String,String,String,String)");
    }

    @Override
    public ResultSet getAttributes(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4) {
        throw Driver.notImplemented(this.getClass(), "getAttributes(String,String,String,String)");
    }

    @Override
    public boolean supportsResultSetHoldability(int n) {
        return true;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() {
        return this.connection.getServerMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() {
        return this.connection.getServerMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() {
        return DriverInfo.JDBC_MAJOR_VERSION;
    }

    @Override
    public int getJDBCMinorVersion() {
        return DriverInfo.JDBC_MINOR_VERSION;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        tableTypeClauses.put("TABLE", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'r' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'");
        hashMap.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname !~ '^pg_'");
        hashMap = new HashMap();
        tableTypeClauses.put("PARTITIONED TABLE", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'p' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'");
        hashMap.put("NOSCHEMAS", "c.relkind = 'p' AND c.relname !~ '^pg_'");
        hashMap = new HashMap();
        tableTypeClauses.put("VIEW", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'v' AND n.nspname <> 'pg_catalog' AND n.nspname <> 'information_schema'");
        hashMap.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname !~ '^pg_'");
        hashMap = new HashMap();
        tableTypeClauses.put("INDEX", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'i' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'");
        hashMap.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname !~ '^pg_'");
        hashMap = new HashMap();
        tableTypeClauses.put("PARTITIONED INDEX", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'I' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'");
        hashMap.put("NOSCHEMAS", "c.relkind = 'I' AND c.relname !~ '^pg_'");
        hashMap = new HashMap();
        tableTypeClauses.put("SEQUENCE", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'S'");
        hashMap.put("NOSCHEMAS", "c.relkind = 'S'");
        hashMap = new HashMap();
        tableTypeClauses.put("TYPE", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'c' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'");
        hashMap.put("NOSCHEMAS", "c.relkind = 'c' AND c.relname !~ '^pg_'");
        hashMap = new HashMap();
        tableTypeClauses.put("SYSTEM TABLE", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'r' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema')");
        hashMap.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname ~ '^pg_' AND c.relname !~ '^pg_toast_' AND c.relname !~ '^pg_temp_'");
        hashMap = new HashMap();
        tableTypeClauses.put("SYSTEM TOAST TABLE", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'pg_toast'");
        hashMap.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname ~ '^pg_toast_'");
        hashMap = new HashMap();
        tableTypeClauses.put("SYSTEM TOAST INDEX", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'pg_toast'");
        hashMap.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname ~ '^pg_toast_'");
        hashMap = new HashMap();
        tableTypeClauses.put("SYSTEM VIEW", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'v' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ");
        hashMap.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_'");
        hashMap = new HashMap();
        tableTypeClauses.put("SYSTEM INDEX", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'i' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ");
        hashMap.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_' AND c.relname !~ '^pg_toast_' AND c.relname !~ '^pg_temp_'");
        hashMap = new HashMap();
        tableTypeClauses.put("TEMPORARY TABLE", hashMap);
        hashMap.put("SCHEMAS", "c.relkind IN ('r','p') AND n.nspname ~ '^pg_temp_' ");
        hashMap.put("NOSCHEMAS", "c.relkind IN ('r','p') AND c.relname ~ '^pg_temp_' ");
        hashMap = new HashMap();
        tableTypeClauses.put("TEMPORARY INDEX", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'i' AND n.nspname ~ '^pg_temp_' ");
        hashMap.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname ~ '^pg_temp_' ");
        hashMap = new HashMap();
        tableTypeClauses.put("TEMPORARY VIEW", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'v' AND n.nspname ~ '^pg_temp_' ");
        hashMap.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_temp_' ");
        hashMap = new HashMap();
        tableTypeClauses.put("TEMPORARY SEQUENCE", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'S' AND n.nspname ~ '^pg_temp_' ");
        hashMap.put("NOSCHEMAS", "c.relkind = 'S' AND c.relname ~ '^pg_temp_' ");
        hashMap = new HashMap();
        tableTypeClauses.put("FOREIGN TABLE", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'f'");
        hashMap.put("NOSCHEMAS", "c.relkind = 'f'");
        hashMap = new HashMap();
        tableTypeClauses.put("MATERIALIZED VIEW", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'm'");
        hashMap.put("NOSCHEMAS", "c.relkind = 'm'");
    }
}

