/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.Driver;
import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.core.CachedQuery;
import com.hm.postgresql.core.ParameterList;
import com.hm.postgresql.core.Query;
import com.hm.postgresql.core.ServerVersion;
import com.hm.postgresql.core.TypeInfo;
import com.hm.postgresql.core.v3.BatchedQuery;
import com.hm.postgresql.jdbc.ArrayEncoding;
import com.hm.postgresql.jdbc.BooleanTypeUtil;
import com.hm.postgresql.jdbc.PgArray;
import com.hm.postgresql.jdbc.PgConnection;
import com.hm.postgresql.jdbc.PgParameterMetaData;
import com.hm.postgresql.jdbc.PgResultSet;
import com.hm.postgresql.jdbc.PgSQLXML;
import com.hm.postgresql.jdbc.PgStatement;
import com.hm.postgresql.jdbc.PreferQueryMode;
import com.hm.postgresql.jdbc.ResultWrapper;
import com.hm.postgresql.jdbc.TimestampUtils;
import com.hm.postgresql.largeobject.LargeObject;
import com.hm.postgresql.largeobject.LargeObjectManager;
import com.hm.postgresql.util.ByteConverter;
import com.hm.postgresql.util.ByteStreamWriter;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.HStoreConverter;
import com.hm.postgresql.util.PGBinaryObject;
import com.hm.postgresql.util.PGTime;
import com.hm.postgresql.util.PGTimestamp;
import com.hm.postgresql.util.PGobject;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.ReaderInputStream;
import com.hm.postgresql.util.internal.Nullness;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.value.qual.IntRange;

class PgPreparedStatement
extends PgStatement
implements PreparedStatement {
    protected final CachedQuery preparedQuery;
    protected final ParameterList preparedParameters;
    private @Nullable TimeZone defaultTimeZone;

    PgPreparedStatement(PgConnection pgConnection, String string, int n, int n2, int n3) {
        this(pgConnection, pgConnection.borrowQuery(string), n, n2, n3);
    }

    PgPreparedStatement(PgConnection pgConnection, CachedQuery cachedQuery, int n, int n2, int n3) {
        super(pgConnection, n, n2, n3);
        this.preparedQuery = cachedQuery;
        this.preparedParameters = this.preparedQuery.query.createParameterList();
        this.setPoolable(true);
    }

    @Override
    public ResultSet executeQuery(String string) {
        throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public ResultSet executeQuery() {
        if (!this.executeWithFlags(0)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        return this.getSingleResultSet();
    }

    @Override
    public int executeUpdate(String string) {
        throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public int executeUpdate() {
        this.executeWithFlags(4);
        this.checkNoResultUpdate();
        return this.getUpdateCount();
    }

    @Override
    public long executeLargeUpdate() {
        this.executeWithFlags(4);
        this.checkNoResultUpdate();
        return this.getLargeUpdateCount();
    }

    @Override
    public boolean execute(String string) {
        throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public boolean execute() {
        return this.executeWithFlags(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeWithFlags(int n) {
        try {
            this.checkClosed();
            if (this.connection.getPreferQueryMode() == PreferQueryMode.SIMPLE) {
                n |= 0x400;
            }
            this.execute(this.preparedQuery, this.preparedParameters, n);
            PgPreparedStatement pgPreparedStatement = this;
            synchronized (pgPreparedStatement) {
                this.checkClosed();
                boolean bl = this.result != null && this.result.getResultSet() != null;
                return bl;
            }
        }
        finally {
            this.defaultTimeZone = null;
        }
    }

    @Override
    protected boolean isOneShotQuery(@Nullable CachedQuery cachedQuery) {
        if (cachedQuery == null) {
            cachedQuery = this.preparedQuery;
        }
        return super.isOneShotQuery(cachedQuery);
    }

    @Override
    public void closeImpl() {
        if (this.preparedQuery != null) {
            ((PgConnection)this.connection).releaseQuery(this.preparedQuery);
        }
    }

    @Override
    public void setNull(int n, int n2) {
        int n3;
        this.checkClosed();
        if (n < 1 || n > this.preparedParameters.getParameterCount()) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", n, this.preparedParameters.getParameterCount()), PSQLState.INVALID_PARAMETER_VALUE);
        }
        switch (n2) {
            case 2009: {
                n3 = 142;
                break;
            }
            case 4: {
                n3 = 23;
                break;
            }
            case -6: 
            case 5: {
                n3 = 21;
                break;
            }
            case -5: {
                n3 = 20;
                break;
            }
            case 7: {
                n3 = 700;
                break;
            }
            case 6: 
            case 8: {
                n3 = 701;
                break;
            }
            case 2: 
            case 3: {
                n3 = 1700;
                break;
            }
            case 1: {
                n3 = 1042;
                break;
            }
            case -1: 
            case 12: {
                n3 = this.connection.getStringVarcharFlag() ? 1043 : 0;
                break;
            }
            case 91: {
                n3 = 1082;
                break;
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                n3 = 0;
                break;
            }
            case -7: 
            case 16: {
                n3 = 16;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                n3 = 17;
                break;
            }
            case 2004: 
            case 2005: {
                n3 = 26;
                break;
            }
            case 2012: {
                n3 = 1790;
                break;
            }
            case 0: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: {
                n3 = 0;
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Unknown Types value.", new Object[0]), PSQLState.INVALID_PARAMETER_TYPE);
            }
        }
        this.preparedParameters.setNull(n, n3);
    }

    @Override
    public void setBoolean(@Positive int n, boolean bl) {
        this.checkClosed();
        this.bindLiteral(n, bl ? "TRUE" : "FALSE", 16);
    }

    @Override
    public void setByte(@Positive int n, byte by) {
        this.setShort(n, by);
    }

    @Override
    public void setShort(@Positive int n, short s) {
        this.checkClosed();
        if (this.connection.binaryTransferSend(21)) {
            byte[] byArray = new byte[2];
            ByteConverter.int2(byArray, 0, s);
            this.bindBytes(n, byArray, 21);
            return;
        }
        this.bindLiteral(n, Integer.toString(s), 21);
    }

    @Override
    public void setInt(@Positive int n, int n2) {
        this.checkClosed();
        if (this.connection.binaryTransferSend(23)) {
            byte[] byArray = new byte[4];
            ByteConverter.int4(byArray, 0, n2);
            this.bindBytes(n, byArray, 23);
            return;
        }
        this.bindLiteral(n, Integer.toString(n2), 23);
    }

    @Override
    public void setLong(@Positive int n, long l) {
        this.checkClosed();
        if (this.connection.binaryTransferSend(20)) {
            byte[] byArray = new byte[8];
            ByteConverter.int8(byArray, 0, l);
            this.bindBytes(n, byArray, 20);
            return;
        }
        this.bindLiteral(n, Long.toString(l), 20);
    }

    @Override
    public void setFloat(@Positive int n, float f) {
        this.checkClosed();
        if (this.connection.binaryTransferSend(700)) {
            byte[] byArray = new byte[4];
            ByteConverter.float4(byArray, 0, f);
            this.bindBytes(n, byArray, 700);
            return;
        }
        this.bindLiteral(n, Float.toString(f), 701);
    }

    @Override
    public void setDouble(@Positive int n, double d) {
        this.checkClosed();
        if (this.connection.binaryTransferSend(701)) {
            byte[] byArray = new byte[8];
            ByteConverter.float8(byArray, 0, d);
            this.bindBytes(n, byArray, 701);
            return;
        }
        this.bindLiteral(n, Double.toString(d), 701);
    }

    @Override
    public void setBigDecimal(@Positive int n, @Nullable BigDecimal bigDecimal) {
        if (bigDecimal != null && this.connection.binaryTransferSend(1700)) {
            byte[] byArray = ByteConverter.numeric(bigDecimal);
            this.bindBytes(n, byArray, 1700);
            return;
        }
        this.setNumber(n, bigDecimal);
    }

    @Override
    public void setString(@Positive int n, @Nullable String string) {
        this.checkClosed();
        this.setString(n, string, this.getStringType());
    }

    private int getStringType() {
        return this.connection.getStringVarcharFlag() ? 1043 : 0;
    }

    protected void setString(@Positive int n, @Nullable String string, int n2) {
        this.checkClosed();
        if (string == null) {
            this.preparedParameters.setNull(n, n2);
        } else {
            this.bindString(n, string, n2);
        }
    }

    @Override
    public void setBytes(@Positive int n, byte @Nullable [] byArray) {
        this.checkClosed();
        if (null == byArray) {
            this.setNull(n, -3);
            return;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this.preparedParameters.setBytea(n, byArray2, 0, byArray.length);
    }

    private void setByteStreamWriter(@Positive int n, ByteStreamWriter byteStreamWriter) {
        this.preparedParameters.setBytea(n, byteStreamWriter);
    }

    @Override
    public void setDate(@Positive int n, @Nullable Date date) {
        this.setDate(n, date, null);
    }

    @Override
    public void setTime(@Positive int n, @Nullable Time time) {
        this.setTime(n, time, null);
    }

    @Override
    public void setTimestamp(@Positive int n, @Nullable Timestamp timestamp) {
        this.setTimestamp(n, timestamp, null);
    }

    private void setCharacterStreamPost71(@Positive int n, @Nullable InputStream inputStream, int n2, String string) {
        if (inputStream == null) {
            this.setNull(n, 12);
            return;
        }
        if (n2 < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", n2), PSQLState.INVALID_PARAMETER_VALUE);
        }
        try {
            int n3;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
            char[] cArray = new char[n2];
            int n4 = 0;
            while ((n3 = inputStreamReader.read(cArray, n4, n2 - n4)) != -1 && (n4 += n3) != n2) {
            }
            this.setString(n, new String(cArray, 0, n4), 1043);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PSQLException(GT.tr("The JVM claims not to support the {0} encoding.", string), PSQLState.UNEXPECTED_ERROR, (Throwable)unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Provided InputStream failed.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
    }

    @Override
    public void setAsciiStream(@Positive int n, @Nullable InputStream inputStream, @NonNegative int n2) {
        this.checkClosed();
        this.setCharacterStreamPost71(n, inputStream, n2, "ASCII");
    }

    @Override
    public void setUnicodeStream(@Positive int n, @Nullable InputStream inputStream, @NonNegative int n2) {
        this.checkClosed();
        this.setCharacterStreamPost71(n, inputStream, n2, "UTF-8");
    }

    @Override
    public void setBinaryStream(@Positive int n, @Nullable InputStream inputStream, @NonNegative int n2) {
        this.checkClosed();
        if (inputStream == null) {
            this.setNull(n, -3);
            return;
        }
        if (n2 < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", n2), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.preparedParameters.setBytea(n, inputStream, n2);
    }

    @Override
    public void clearParameters() {
        this.preparedParameters.clear();
    }

    private void setPGobject(@Positive int n, PGobject pGobject) {
        String string = pGobject.getType();
        int n2 = this.connection.getTypeInfo().getPGType(string);
        if (n2 == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", string), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (pGobject instanceof PGBinaryObject && this.connection.binaryTransferSend(n2)) {
            PGBinaryObject pGBinaryObject = (PGBinaryObject)((Object)pGobject);
            int n3 = pGBinaryObject.lengthInBytes();
            if (n3 == 0) {
                this.preparedParameters.setNull(n, n2);
                return;
            }
            byte[] byArray = new byte[n3];
            pGBinaryObject.toBytes(byArray, 0);
            this.bindBytes(n, byArray, n2);
        } else {
            this.setString(n, pGobject.getValue(), n2);
        }
    }

    private void setMap(@Positive int n, Map<?, ?> map) {
        int n2 = this.connection.getTypeInfo().getPGType("hstore");
        if (n2 == 0) {
            throw new PSQLException(GT.tr("No hstore extension installed.", new Object[0]), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (this.connection.binaryTransferSend(n2)) {
            byte[] byArray = HStoreConverter.toBytes(map, this.connection.getEncoding());
            this.bindBytes(n, byArray, n2);
        } else {
            this.setString(n, HStoreConverter.toString(map), n2);
        }
    }

    private void setNumber(@Positive int n, @Nullable Number number) {
        this.checkClosed();
        if (number == null) {
            this.setNull(n, 3);
        } else {
            this.bindLiteral(n, number.toString(), 1700);
        }
    }

    @Override
    public void setObject(@Positive int n, @Nullable Object object, int n2, int n3) {
        this.checkClosed();
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        if (n2 == 1111 && object instanceof UUID && this.connection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            this.setUuid(n, (UUID)object);
            return;
        }
        switch (n2) {
            case 2009: {
                if (object instanceof SQLXML) {
                    this.setSQLXML(n, (SQLXML)object);
                    break;
                }
                this.setSQLXML(n, new PgSQLXML(this.connection, object.toString()));
                break;
            }
            case 4: {
                this.setInt(n, PgPreparedStatement.castToInt(object));
                break;
            }
            case -6: 
            case 5: {
                this.setShort(n, PgPreparedStatement.castToShort(object));
                break;
            }
            case -5: {
                this.setLong(n, PgPreparedStatement.castToLong(object));
                break;
            }
            case 7: {
                this.setFloat(n, PgPreparedStatement.castToFloat(object));
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(n, PgPreparedStatement.castToDouble(object));
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(n, PgPreparedStatement.castToBigDecimal(object, n3));
                break;
            }
            case 1: {
                this.setString(n, PgPreparedStatement.castToString(object), 1042);
                break;
            }
            case 12: {
                this.setString(n, PgPreparedStatement.castToString(object), this.getStringType());
                break;
            }
            case -1: {
                if (object instanceof InputStream) {
                    this.preparedParameters.setText(n, (InputStream)object);
                    break;
                }
                this.setString(n, PgPreparedStatement.castToString(object), this.getStringType());
                break;
            }
            case 91: {
                Date date;
                if (object instanceof Date) {
                    this.setDate(n, (Date)object);
                    break;
                }
                if (object instanceof java.util.Date) {
                    date = new Date(((java.util.Date)object).getTime());
                } else {
                    if (object instanceof LocalDate) {
                        this.setDate(n, (LocalDate)object);
                        break;
                    }
                    date = this.connection.getTimestampUtils().toDate(this.getDefaultCalendar(), object.toString());
                }
                this.setDate(n, date);
                break;
            }
            case 92: {
                Time time;
                if (object instanceof Time) {
                    this.setTime(n, (Time)object);
                    break;
                }
                if (object instanceof java.util.Date) {
                    time = new Time(((java.util.Date)object).getTime());
                } else {
                    if (object instanceof LocalTime) {
                        this.setTime(n, (LocalTime)object);
                        break;
                    }
                    time = this.connection.getTimestampUtils().toTime(this.getDefaultCalendar(), object.toString());
                }
                this.setTime(n, time);
                break;
            }
            case 93: {
                Timestamp timestamp;
                if (object instanceof PGTimestamp) {
                    this.setObject(n, object);
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setTimestamp(n, (Timestamp)object);
                    break;
                }
                if (object instanceof java.util.Date) {
                    timestamp = new Timestamp(((java.util.Date)object).getTime());
                } else {
                    if (object instanceof LocalDateTime) {
                        this.setTimestamp(n, (LocalDateTime)object);
                        break;
                    }
                    timestamp = this.connection.getTimestampUtils().toTimestamp(this.getDefaultCalendar(), object.toString());
                }
                this.setTimestamp(n, timestamp);
                break;
            }
            case 2014: {
                if (object instanceof OffsetDateTime) {
                    this.setTimestamp(n, (OffsetDateTime)object);
                    break;
                }
                if (object instanceof PGTimestamp) {
                    this.setObject(n, object);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", object.getClass().getName(), "Types.TIMESTAMP_WITH_TIMEZONE"), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case -7: 
            case 16: {
                this.setBoolean(n, BooleanTypeUtil.castToBoolean(object));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setObject(n, object);
                break;
            }
            case 2004: {
                if (object instanceof Blob) {
                    this.setBlob(n, (Blob)object);
                    break;
                }
                if (object instanceof InputStream) {
                    long l = this.createBlob(n, (InputStream)object, -1L);
                    this.setLong(n, l);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", object.getClass().getName(), "Types.BLOB"), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2005: {
                if (object instanceof Clob) {
                    this.setClob(n, (Clob)object);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", object.getClass().getName(), "Types.CLOB"), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2003: {
                if (object instanceof Array) {
                    this.setArray(n, (Array)object);
                    break;
                }
                try {
                    this.setObjectArray(n, object);
                    break;
                }
                catch (Exception exception) {
                    throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", object.getClass().getName(), "Types.ARRAY"), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)exception);
                }
            }
            case 2001: {
                this.bindString(n, object.toString(), 0);
                break;
            }
            case 1111: {
                if (object instanceof PGobject) {
                    this.setPGobject(n, (PGobject)object);
                    break;
                }
                if (object instanceof Map) {
                    this.setMap(n, (Map)object);
                    break;
                }
                this.bindString(n, object.toString(), 0);
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Unsupported Types value: {0}", n2), PSQLState.INVALID_PARAMETER_TYPE);
            }
        }
    }

    private <A> void setObjectArray(int n, A a) {
        ArrayEncoding.ArrayEncoder<A> arrayEncoder = ArrayEncoding.getArrayEncoder(a);
        TypeInfo typeInfo = this.connection.getTypeInfo();
        int n2 = arrayEncoder.getDefaultArrayTypeOid();
        if (arrayEncoder.supportBinaryRepresentation(n2) && this.connection.getPreferQueryMode() != PreferQueryMode.SIMPLE) {
            this.bindBytes(n, arrayEncoder.toBinaryRepresentation(this.connection, a, n2), n2);
        } else {
            if (n2 == 0) {
                throw new SQLFeatureNotSupportedException();
            }
            int n3 = typeInfo.getPGArrayElement(n2);
            String string = Nullness.castNonNull(typeInfo.getPGType(n3));
            Array array = this.getPGConnection().createArrayOf(string, a);
            this.setArray(n, array);
        }
    }

    private static String asString(Clob clob) {
        return clob.getSubString(1L, (int)clob.length());
    }

    private static int castToInt(Object object) {
        try {
            if (object instanceof String) {
                return Integer.parseInt((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            if (object instanceof java.util.Date) {
                return (int)((java.util.Date)object).getTime();
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1 : 0;
            }
            if (object instanceof Clob) {
                return Integer.parseInt(PgPreparedStatement.asString((Clob)object));
            }
            if (object instanceof Character) {
                return Integer.parseInt(object.toString());
            }
        }
        catch (Exception exception) {
            throw PgPreparedStatement.cannotCastException(object.getClass().getName(), "int", exception);
        }
        throw PgPreparedStatement.cannotCastException(object.getClass().getName(), "int");
    }

    private static short castToShort(Object object) {
        try {
            if (object instanceof String) {
                return Short.parseShort((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).shortValue();
            }
            if (object instanceof java.util.Date) {
                return (short)((java.util.Date)object).getTime();
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? (short)1 : 0;
            }
            if (object instanceof Clob) {
                return Short.parseShort(PgPreparedStatement.asString((Clob)object));
            }
            if (object instanceof Character) {
                return Short.parseShort(object.toString());
            }
        }
        catch (Exception exception) {
            throw PgPreparedStatement.cannotCastException(object.getClass().getName(), "short", exception);
        }
        throw PgPreparedStatement.cannotCastException(object.getClass().getName(), "short");
    }

    private static long castToLong(Object object) {
        try {
            if (object instanceof String) {
                return Long.parseLong((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
            if (object instanceof java.util.Date) {
                return ((java.util.Date)object).getTime();
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1L : 0L;
            }
            if (object instanceof Clob) {
                return Long.parseLong(PgPreparedStatement.asString((Clob)object));
            }
            if (object instanceof Character) {
                return Long.parseLong(object.toString());
            }
        }
        catch (Exception exception) {
            throw PgPreparedStatement.cannotCastException(object.getClass().getName(), "long", exception);
        }
        throw PgPreparedStatement.cannotCastException(object.getClass().getName(), "long");
    }

    private static float castToFloat(Object object) {
        try {
            if (object instanceof String) {
                return Float.parseFloat((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).floatValue();
            }
            if (object instanceof java.util.Date) {
                return ((java.util.Date)object).getTime();
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1.0f : 0.0f;
            }
            if (object instanceof Clob) {
                return Float.parseFloat(PgPreparedStatement.asString((Clob)object));
            }
            if (object instanceof Character) {
                return Float.parseFloat(object.toString());
            }
        }
        catch (Exception exception) {
            throw PgPreparedStatement.cannotCastException(object.getClass().getName(), "float", exception);
        }
        throw PgPreparedStatement.cannotCastException(object.getClass().getName(), "float");
    }

    private static double castToDouble(Object object) {
        try {
            if (object instanceof String) {
                return Double.parseDouble((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            if (object instanceof java.util.Date) {
                return ((java.util.Date)object).getTime();
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1.0 : 0.0;
            }
            if (object instanceof Clob) {
                return Double.parseDouble(PgPreparedStatement.asString((Clob)object));
            }
            if (object instanceof Character) {
                return Double.parseDouble(object.toString());
            }
        }
        catch (Exception exception) {
            throw PgPreparedStatement.cannotCastException(object.getClass().getName(), "double", exception);
        }
        throw PgPreparedStatement.cannotCastException(object.getClass().getName(), "double");
    }

    private static BigDecimal castToBigDecimal(Object object, int n) {
        try {
            BigDecimal bigDecimal = null;
            if (object instanceof String) {
                bigDecimal = new BigDecimal((String)object);
            } else if (object instanceof BigDecimal) {
                bigDecimal = (BigDecimal)object;
            } else if (object instanceof BigInteger) {
                bigDecimal = new BigDecimal((BigInteger)object);
            } else if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
                bigDecimal = BigDecimal.valueOf(((Number)object).longValue());
            } else if (object instanceof Double || object instanceof Float) {
                bigDecimal = BigDecimal.valueOf(((Number)object).doubleValue());
            } else if (object instanceof java.util.Date) {
                bigDecimal = BigDecimal.valueOf(((java.util.Date)object).getTime());
            } else if (object instanceof Boolean) {
                bigDecimal = (Boolean)object != false ? BigDecimal.ONE : BigDecimal.ZERO;
            } else if (object instanceof Clob) {
                bigDecimal = new BigDecimal(PgPreparedStatement.asString((Clob)object));
            } else if (object instanceof Character) {
                bigDecimal = new BigDecimal(new char[]{((Character)object).charValue()});
            }
            if (bigDecimal != null) {
                if (n >= 0) {
                    bigDecimal = bigDecimal.setScale(n, RoundingMode.HALF_UP);
                }
                return bigDecimal;
            }
        }
        catch (Exception exception) {
            throw PgPreparedStatement.cannotCastException(object.getClass().getName(), "BigDecimal", exception);
        }
        throw PgPreparedStatement.cannotCastException(object.getClass().getName(), "BigDecimal");
    }

    private static String castToString(Object object) {
        try {
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof Clob) {
                return PgPreparedStatement.asString((Clob)object);
            }
            return object.toString();
        }
        catch (Exception exception) {
            throw PgPreparedStatement.cannotCastException(object.getClass().getName(), "String", exception);
        }
    }

    private static PSQLException cannotCastException(String string, String string2) {
        return PgPreparedStatement.cannotCastException(string, string2, null);
    }

    private static PSQLException cannotCastException(String string, String string2, @Nullable Exception exception) {
        return new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", string, string2), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)exception);
    }

    @Override
    public void setObject(@Positive int n, @Nullable Object object, int n2) {
        this.setObject(n, object, n2, -1);
    }

    @Override
    public void setObject(@Positive int n, @Nullable Object object) {
        this.checkClosed();
        if (object == null) {
            this.setNull(n, 1111);
        } else if (object instanceof UUID && this.connection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            this.setUuid(n, (UUID)object);
        } else if (object instanceof SQLXML) {
            this.setSQLXML(n, (SQLXML)object);
        } else if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof Short) {
            this.setShort(n, (Short)object);
        } else if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
        } else if (object instanceof Long) {
            this.setLong(n, (Long)object);
        } else if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDouble(n, (Double)object);
        } else if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
        } else if (object instanceof ByteStreamWriter) {
            this.setByteStreamWriter(n, (ByteStreamWriter)object);
        } else if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
        } else if (object instanceof Byte) {
            this.setByte(n, (Byte)object);
        } else if (object instanceof Blob) {
            this.setBlob(n, (Blob)object);
        } else if (object instanceof Clob) {
            this.setClob(n, (Clob)object);
        } else if (object instanceof Array) {
            this.setArray(n, (Array)object);
        } else if (object instanceof PGobject) {
            this.setPGobject(n, (PGobject)object);
        } else if (object instanceof Character) {
            this.setString(n, ((Character)object).toString());
        } else if (object instanceof LocalDate) {
            this.setDate(n, (LocalDate)object);
        } else if (object instanceof LocalTime) {
            this.setTime(n, (LocalTime)object);
        } else if (object instanceof LocalDateTime) {
            this.setTimestamp(n, (LocalDateTime)object);
        } else if (object instanceof OffsetDateTime) {
            this.setTimestamp(n, (OffsetDateTime)object);
        } else if (object instanceof Map) {
            this.setMap(n, (Map)object);
        } else if (object instanceof Number) {
            this.setNumber(n, (Number)object);
        } else if (object.getClass().isArray()) {
            try {
                this.setObjectArray(n, object);
            }
            catch (Exception exception) {
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", object.getClass().getName(), "Types.ARRAY"), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)exception);
            }
        } else {
            throw new PSQLException(GT.tr("Can''t infer the SQL type to use for an instance of {0}. Use setObject() with an explicit Types value to specify the type to use.", object.getClass().getName()), PSQLState.INVALID_PARAMETER_TYPE);
        }
    }

    public String toString() {
        if (this.preparedQuery == null) {
            return super.toString();
        }
        return this.preparedQuery.query.toString(this.preparedParameters);
    }

    protected void bindLiteral(@Positive int n, String string, int n2) {
        this.preparedParameters.setLiteralParameter(n, string, n2);
    }

    protected void bindBytes(@Positive int n, byte[] byArray, int n2) {
        this.preparedParameters.setBinaryParameter(n, byArray, n2);
    }

    private void bindString(@Positive int n, String string, int n2) {
        this.preparedParameters.setStringParameter(n, string, n2);
    }

    @Override
    public boolean isUseServerPrepare() {
        return this.preparedQuery != null && this.mPrepareThreshold != 0 && this.preparedQuery.getExecuteCount() + 1 >= this.mPrepareThreshold;
    }

    @Override
    public void addBatch(String string) {
        this.checkClosed();
        throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public void addBatch() {
        ArrayList<ParameterList> arrayList;
        this.checkClosed();
        ArrayList<Query> arrayList2 = this.batchStatements;
        if (arrayList2 == null) {
            this.batchStatements = arrayList2 = new ArrayList<Query>();
        }
        if ((arrayList = this.batchParameters) == null) {
            this.batchParameters = arrayList = new ArrayList<ParameterList>();
        }
        arrayList.add(this.preparedParameters.copy());
        Query query = this.preparedQuery.query;
        if (!(query instanceof BatchedQuery) || arrayList2.isEmpty()) {
            arrayList2.add(query);
        }
    }

    @Override
    public @Nullable ResultSetMetaData getMetaData() {
        this.checkClosed();
        ResultSet resultSet = this.getResultSet();
        if (resultSet == null || ((PgResultSet)resultSet).isResultSetClosed()) {
            int n = 49;
            PgStatement.StatementResultHandler statementResultHandler = new PgStatement.StatementResultHandler(this);
            this.connection.getQueryExecutor().execute(this.preparedQuery.query, this.preparedParameters, statementResultHandler, 0, 0, n);
            ResultWrapper resultWrapper = statementResultHandler.getResults();
            if (resultWrapper != null) {
                resultSet = resultWrapper.getResultSet();
            }
        }
        if (resultSet != null) {
            return resultSet.getMetaData();
        }
        return null;
    }

    @Override
    public void setArray(int n, @Nullable Array array) {
        PgArray pgArray;
        byte[] byArray;
        this.checkClosed();
        if (null == array) {
            this.setNull(n, 2003);
            return;
        }
        String string = array.getBaseTypeName();
        int n2 = this.connection.getTypeInfo().getPGArrayType(string);
        if (n2 == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", string), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (array instanceof PgArray && (byArray = (pgArray = (PgArray)array).toBytes()) != null) {
            this.bindBytes(n, byArray, n2);
            return;
        }
        this.setString(n, array.toString(), n2);
    }

    protected long createBlob(int n, InputStream inputStream, @NonNegative long l) {
        LargeObjectManager largeObjectManager = this.connection.getLargeObjectAPI();
        long l2 = largeObjectManager.createLO();
        LargeObject largeObject = largeObjectManager.open(l2);
        OutputStream outputStream = largeObject.getOutputStream();
        byte[] byArray = new byte[4096];
        try {
            long l3 = l > 0L ? l : Long.MAX_VALUE;
            int n2 = inputStream.read(byArray, 0, l > 0L && l3 < (long)byArray.length ? (int)l3 : byArray.length);
            while (n2 != -1 && l3 > 0L) {
                outputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray, 0, l > 0L && l3 < (long)byArray.length ? (int)(l3 -= (long)n2) : byArray.length);
            }
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Unexpected error writing large object to database.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(@Positive int n, @Nullable Blob blob) {
        this.checkClosed();
        if (blob == null) {
            this.setNull(n, 2004);
            return;
        }
        InputStream inputStream = blob.getBinaryStream();
        try {
            long l = this.createBlob(n, inputStream, blob.length());
            this.setLong(n, l);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private String readerToString(Reader reader, int n) {
        try {
            int n2 = Math.min(n, 1024);
            StringBuilder stringBuilder = new StringBuilder(n2);
            char[] cArray = new char[n2];
            int n3 = 0;
            while (n3 > -1 && stringBuilder.length() < n) {
                n3 = reader.read(cArray, 0, Math.min(n2, n - stringBuilder.length()));
                if (n3 <= 0) continue;
                stringBuilder.append(cArray, 0, n3);
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Provided Reader failed.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
    }

    @Override
    public void setCharacterStream(@Positive int n, @Nullable Reader reader, @NonNegative int n2) {
        this.checkClosed();
        if (reader == null) {
            this.setNull(n, 12);
            return;
        }
        if (n2 < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", n2), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.setString(n, this.readerToString(reader, n2));
    }

    @Override
    public void setClob(@Positive int n, @Nullable Clob clob) {
        this.checkClosed();
        if (clob == null) {
            this.setNull(n, 2005);
            return;
        }
        Reader reader = clob.getCharacterStream();
        int n2 = (int)clob.length();
        LargeObjectManager largeObjectManager = this.connection.getLargeObjectAPI();
        long l = largeObjectManager.createLO();
        LargeObject largeObject = largeObjectManager.open(l);
        Charset charset = Charset.forName(this.connection.getEncoding().name());
        OutputStream outputStream = largeObject.getOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, charset);
        try {
            int n3 = reader.read();
            for (int i = 0; n3 > -1 && i < n2; ++i) {
                ((Writer)outputStreamWriter).write(n3);
                n3 = reader.read();
            }
            ((Writer)outputStreamWriter).close();
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Unexpected error writing large object to database.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
        this.setLong(n, l);
    }

    @Override
    public void setNull(@Positive int n, int n2, @Nullable String string) {
        if (string == null) {
            this.setNull(n, n2);
            return;
        }
        this.checkClosed();
        TypeInfo typeInfo = this.connection.getTypeInfo();
        int n3 = typeInfo.getPGType(string);
        this.preparedParameters.setNull(n, n3);
    }

    @Override
    public void setRef(@Positive int n, @Nullable Ref ref) {
        throw Driver.notImplemented(this.getClass(), "setRef(int,Ref)");
    }

    @Override
    public void setDate(@Positive int n, @Nullable Date date, @Nullable Calendar calendar) {
        this.checkClosed();
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        if (this.connection.binaryTransferSend(1082)) {
            byte[] byArray = new byte[4];
            TimeZone timeZone = calendar != null ? calendar.getTimeZone() : null;
            this.connection.getTimestampUtils().toBinDate(timeZone, byArray, date);
            this.preparedParameters.setBinaryParameter(n, byArray, 1082);
            return;
        }
        if (calendar == null) {
            calendar = this.getDefaultCalendar();
        }
        this.bindString(n, this.connection.getTimestampUtils().toString(calendar, date), 0);
    }

    @Override
    public void setTime(@Positive int n, @Nullable Time time, @Nullable Calendar calendar) {
        this.checkClosed();
        if (time == null) {
            this.setNull(n, 92);
            return;
        }
        int n2 = 0;
        if (time instanceof PGTime) {
            PGTime pGTime = (PGTime)time;
            if (pGTime.getCalendar() == null) {
                n2 = 1083;
            } else {
                n2 = 1266;
                calendar = pGTime.getCalendar();
            }
        }
        if (calendar == null) {
            calendar = this.getDefaultCalendar();
        }
        this.bindString(n, this.connection.getTimestampUtils().toString(calendar, time), n2);
    }

    @Override
    public void setTimestamp(@Positive int n, @Nullable Timestamp timestamp, @Nullable Calendar calendar) {
        this.checkClosed();
        if (timestamp == null) {
            this.setNull(n, 93);
            return;
        }
        int n2 = 0;
        if (timestamp instanceof PGTimestamp) {
            PGTimestamp pGTimestamp = (PGTimestamp)timestamp;
            if (pGTimestamp.getCalendar() == null) {
                n2 = 1114;
            } else {
                n2 = 1184;
                calendar = pGTimestamp.getCalendar();
            }
        }
        if (calendar == null) {
            calendar = this.getDefaultCalendar();
        }
        this.bindString(n, this.connection.getTimestampUtils().toString(calendar, timestamp), n2);
    }

    private void setDate(@Positive int n, LocalDate localDate) {
        int n2 = 1082;
        this.bindString(n, this.connection.getTimestampUtils().toString(localDate), n2);
    }

    private void setTime(@Positive int n, LocalTime localTime) {
        int n2 = 1083;
        this.bindString(n, this.connection.getTimestampUtils().toString(localTime), n2);
    }

    private void setTimestamp(@Positive int n, LocalDateTime localDateTime) {
        int n2 = 1114;
        this.bindString(n, this.connection.getTimestampUtils().toString(localDateTime), n2);
    }

    private void setTimestamp(@Positive int n, OffsetDateTime offsetDateTime) {
        int n2 = 1184;
        this.bindString(n, this.connection.getTimestampUtils().toString(offsetDateTime), n2);
    }

    public ParameterMetaData createParameterMetaData(BaseConnection baseConnection, int[] nArray) {
        return new PgParameterMetaData(baseConnection, nArray);
    }

    @Override
    public void setObject(@Positive int n, @Nullable Object object, SQLType sQLType, int n2) {
        throw Driver.notImplemented(this.getClass(), "setObject");
    }

    @Override
    public void setObject(@Positive int n, @Nullable Object object, SQLType sQLType) {
        throw Driver.notImplemented(this.getClass(), "setObject");
    }

    @Override
    public void setRowId(@Positive int n, @Nullable RowId rowId) {
        throw Driver.notImplemented(this.getClass(), "setRowId(int, RowId)");
    }

    @Override
    public void setNString(@Positive int n, @Nullable String string) {
        throw Driver.notImplemented(this.getClass(), "setNString(int, String)");
    }

    @Override
    public void setNCharacterStream(@Positive int n, @Nullable Reader reader, long l) {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader, long)");
    }

    @Override
    public void setNCharacterStream(@Positive int n, @Nullable Reader reader) {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader)");
    }

    @Override
    public void setCharacterStream(@Positive int n, @Nullable Reader reader, @NonNegative long l) {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(int, Reader, long)");
    }

    @Override
    public void setCharacterStream(@Positive int n, @Nullable Reader reader) {
        if (this.connection.getPreferQueryMode() == PreferQueryMode.SIMPLE) {
            String string = reader != null ? this.readerToString(reader, Integer.MAX_VALUE) : null;
            this.setString(n, string);
            return;
        }
        ReaderInputStream readerInputStream = reader != null ? new ReaderInputStream(reader) : null;
        this.setObject(n, (Object)readerInputStream, -1);
    }

    @Override
    public void setBinaryStream(@Positive int n, @Nullable InputStream inputStream, @NonNegative @IntRange(from=0L, to=0x7FFFFFFFL) long l) {
        if (l > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("Object is too large to send over the protocol.", new Object[0]), PSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE);
        }
        if (inputStream == null) {
            this.preparedParameters.setNull(n, 17);
        } else {
            this.preparedParameters.setBytea(n, inputStream, (int)l);
        }
    }

    @Override
    public void setBinaryStream(@Positive int n, @Nullable InputStream inputStream) {
        if (inputStream == null) {
            this.preparedParameters.setNull(n, 17);
        } else {
            this.preparedParameters.setBytea(n, inputStream);
        }
    }

    @Override
    public void setAsciiStream(@Positive int n, @Nullable InputStream inputStream, @NonNegative long l) {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream, long)");
    }

    @Override
    public void setAsciiStream(@Positive int n, @Nullable InputStream inputStream) {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream)");
    }

    @Override
    public void setNClob(@Positive int n, @Nullable NClob nClob) {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, NClob)");
    }

    @Override
    public void setClob(@Positive int n, @Nullable Reader reader, @NonNegative long l) {
        throw Driver.notImplemented(this.getClass(), "setClob(int, Reader, long)");
    }

    @Override
    public void setClob(@Positive int n, @Nullable Reader reader) {
        throw Driver.notImplemented(this.getClass(), "setClob(int, Reader)");
    }

    @Override
    public void setBlob(@Positive int n, @Nullable InputStream inputStream, @NonNegative long l) {
        this.checkClosed();
        if (inputStream == null) {
            this.setNull(n, 2004);
            return;
        }
        if (l < 0L) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", l), PSQLState.INVALID_PARAMETER_VALUE);
        }
        long l2 = this.createBlob(n, inputStream, l);
        this.setLong(n, l2);
    }

    @Override
    public void setBlob(@Positive int n, @Nullable InputStream inputStream) {
        this.checkClosed();
        if (inputStream == null) {
            this.setNull(n, 2004);
            return;
        }
        long l = this.createBlob(n, inputStream, -1L);
        this.setLong(n, l);
    }

    @Override
    public void setNClob(@Positive int n, @Nullable Reader reader, @NonNegative long l) {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, Reader, long)");
    }

    @Override
    public void setNClob(@Positive int n, @Nullable Reader reader) {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, Reader)");
    }

    @Override
    public void setSQLXML(@Positive int n, @Nullable SQLXML sQLXML) {
        String string;
        this.checkClosed();
        String string2 = string = sQLXML == null ? null : sQLXML.getString();
        if (string == null) {
            this.setNull(n, 2009);
        } else {
            this.setString(n, string, 142);
        }
    }

    private void setUuid(@Positive int n, UUID uUID) {
        if (this.connection.binaryTransferSend(2950)) {
            byte[] byArray = new byte[16];
            ByteConverter.int8(byArray, 0, uUID.getMostSignificantBits());
            ByteConverter.int8(byArray, 8, uUID.getLeastSignificantBits());
            this.bindBytes(n, byArray, 2950);
        } else {
            this.bindLiteral(n, uUID.toString(), 2950);
        }
    }

    @Override
    public void setURL(@Positive int n, @Nullable URL uRL) {
        throw Driver.notImplemented(this.getClass(), "setURL(int,URL)");
    }

    @Override
    public int[] executeBatch() {
        try {
            if (this.batchParameters != null && this.batchParameters.size() > 1 && this.mPrepareThreshold > 0) {
                this.preparedQuery.increaseExecuteCount(this.mPrepareThreshold);
            }
            int[] nArray = super.executeBatch();
            return nArray;
        }
        finally {
            this.defaultTimeZone = null;
        }
    }

    private Calendar getDefaultCalendar() {
        TimestampUtils timestampUtils = this.connection.getTimestampUtils();
        if (timestampUtils.hasFastDefaultTimeZone()) {
            return timestampUtils.getSharedCalendar(null);
        }
        Calendar calendar = timestampUtils.getSharedCalendar(this.defaultTimeZone);
        if (this.defaultTimeZone == null) {
            this.defaultTimeZone = calendar.getTimeZone();
        }
        return calendar;
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        int n = 49;
        PgStatement.StatementResultHandler statementResultHandler = new PgStatement.StatementResultHandler(this);
        this.connection.getQueryExecutor().execute(this.preparedQuery.query, this.preparedParameters, statementResultHandler, 0, 0, n);
        int[] nArray = this.preparedParameters.getTypeOIDs();
        return this.createParameterMetaData(this.connection, nArray);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void transformQueriesAndParameters() {
        @Nullable ArrayList arrayList = this.batchParameters;
        if (arrayList == null || arrayList.size() <= 1 || !(this.preparedQuery.query instanceof BatchedQuery)) {
            return;
        }
        BatchedQuery batchedQuery = (BatchedQuery)this.preparedQuery.query;
        int n = batchedQuery.getBindCount();
        int n2 = 128;
        int n3 = n == 0 ? 1024 : Integer.highestOneBit(Math.min(Math.max(1, 32766 / n), 128));
        int n4 = arrayList.size();
        int n5 = n4 / n3;
        int n6 = Integer.bitCount(n4 % n3);
        int n7 = n5 + n6;
        ArrayList<BatchedQuery> arrayList2 = new ArrayList<BatchedQuery>(n7);
        ArrayList<@Nullable ParameterList> arrayList3 = new ArrayList<ParameterList>(n7);
        int n8 = 0;
        for (int i = 0; i < n7; ++i) {
            int n9 = n4 >= n3 ? n3 : Integer.highestOneBit(n4);
            BatchedQuery batchedQuery2 = batchedQuery.deriveForMultiBatch(n9);
            ParameterList parameterList = batchedQuery2.createParameterList();
            for (int j = 0; j < n9; ++j) {
                ParameterList parameterList2;
                if ((parameterList2 = (ParameterList)arrayList.get(n8++)) == null) continue;
                parameterList.appendAll(parameterList2);
            }
            arrayList2.add(batchedQuery2);
            arrayList3.add(parameterList);
            n4 -= n9;
        }
        this.batchStatements = arrayList2;
        this.batchParameters = arrayList3;
    }
}

