/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.xml.DefaultPGXmlFactoryFactory;
import com.hm.postgresql.xml.PGXmlFactoryFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLXML;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class PgSQLXML
implements SQLXML {
    private final BaseConnection conn;
    private @Nullable String data;
    private boolean initialized;
    private boolean active;
    private boolean freed;
    private @Nullable ByteArrayOutputStream byteArrayOutputStream;
    private @Nullable StringWriter stringWriter;
    private @Nullable DOMResult domResult;

    public PgSQLXML(BaseConnection baseConnection) {
        this(baseConnection, null, false);
    }

    public PgSQLXML(BaseConnection baseConnection, @Nullable String string) {
        this(baseConnection, string, true);
    }

    private PgSQLXML(BaseConnection baseConnection, @Nullable String string, boolean bl) {
        this.conn = baseConnection;
        this.data = string;
        this.initialized = bl;
        this.active = false;
        this.freed = false;
    }

    private PGXmlFactoryFactory getXmlFactoryFactory() {
        if (this.conn != null) {
            return this.conn.getXmlFactoryFactory();
        }
        return DefaultPGXmlFactoryFactory.INSTANCE;
    }

    @Override
    public synchronized void free() {
        this.freed = true;
        this.data = null;
    }

    @Override
    public synchronized @Nullable InputStream getBinaryStream() {
        this.checkFreed();
        this.ensureInitialized();
        if (this.data == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(this.conn.getEncoding().encode(this.data));
        }
        catch (IOException iOException) {
            throw new PSQLException("Failed to re-encode xml data.", PSQLState.DATA_ERROR, (Throwable)iOException);
        }
    }

    @Override
    public synchronized @Nullable Reader getCharacterStream() {
        this.checkFreed();
        this.ensureInitialized();
        if (this.data == null) {
            return null;
        }
        return new StringReader(this.data);
    }

    @Override
    public synchronized <T extends Source> @Nullable T getSource(@Nullable Class<T> clazz) {
        this.checkFreed();
        this.ensureInitialized();
        String string = this.data;
        if (string == null) {
            return null;
        }
        try {
            if (clazz == null || DOMSource.class.equals(clazz)) {
                DocumentBuilder documentBuilder = this.getXmlFactoryFactory().newDocumentBuilder();
                InputSource inputSource = new InputSource(new StringReader(string));
                DOMSource dOMSource = new DOMSource(documentBuilder.parse(inputSource));
                return (T)dOMSource;
            }
            if (SAXSource.class.equals(clazz)) {
                XMLReader xMLReader = this.getXmlFactoryFactory().createXMLReader();
                InputSource inputSource = new InputSource(new StringReader(string));
                return (T)((Source)clazz.cast(new SAXSource(xMLReader, inputSource)));
            }
            if (StreamSource.class.equals(clazz)) {
                return (T)((Source)clazz.cast(new StreamSource(new StringReader(string))));
            }
            if (StAXSource.class.equals(clazz)) {
                XMLInputFactory xMLInputFactory = this.getXmlFactoryFactory().newXMLInputFactory();
                XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(new StringReader(string));
                return (T)((Source)clazz.cast(new StAXSource(xMLStreamReader)));
            }
        }
        catch (Exception exception) {
            throw new PSQLException(GT.tr("Unable to decode xml data.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)exception);
        }
        throw new PSQLException(GT.tr("Unknown XML Source class: {0}", clazz), PSQLState.INVALID_PARAMETER_TYPE);
    }

    @Override
    public synchronized @Nullable String getString() {
        this.checkFreed();
        this.ensureInitialized();
        return this.data;
    }

    @Override
    public synchronized OutputStream setBinaryStream() {
        this.checkFreed();
        this.initialize();
        this.active = true;
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        return this.byteArrayOutputStream;
    }

    @Override
    public synchronized Writer setCharacterStream() {
        this.checkFreed();
        this.initialize();
        this.active = true;
        this.stringWriter = new StringWriter();
        return this.stringWriter;
    }

    @Override
    public synchronized <T extends Result> T setResult(Class<T> clazz) {
        this.checkFreed();
        this.initialize();
        if (clazz == null || DOMResult.class.equals(clazz)) {
            this.domResult = new DOMResult();
            this.active = true;
            return (T)this.domResult;
        }
        if (SAXResult.class.equals(clazz)) {
            try {
                SAXTransformerFactory sAXTransformerFactory = this.getXmlFactoryFactory().newSAXTransformerFactory();
                TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
                this.stringWriter = new StringWriter();
                transformerHandler.setResult(new StreamResult(this.stringWriter));
                this.active = true;
                return (T)((Result)clazz.cast(new SAXResult(transformerHandler)));
            }
            catch (TransformerException transformerException) {
                throw new PSQLException(GT.tr("Unable to create SAXResult for SQLXML.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)transformerException);
            }
        }
        if (StreamResult.class.equals(clazz)) {
            this.stringWriter = new StringWriter();
            this.active = true;
            return (T)((Result)clazz.cast(new StreamResult(this.stringWriter)));
        }
        if (StAXResult.class.equals(clazz)) {
            StringWriter stringWriter;
            this.stringWriter = stringWriter = new StringWriter();
            try {
                XMLOutputFactory xMLOutputFactory = this.getXmlFactoryFactory().newXMLOutputFactory();
                XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(stringWriter);
                this.active = true;
                return (T)((Result)clazz.cast(new StAXResult(xMLStreamWriter)));
            }
            catch (XMLStreamException xMLStreamException) {
                throw new PSQLException(GT.tr("Unable to create StAXResult for SQLXML", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)xMLStreamException);
            }
        }
        throw new PSQLException(GT.tr("Unknown XML Result class: {0}", clazz), PSQLState.INVALID_PARAMETER_TYPE);
    }

    @Override
    public synchronized void setString(String string) {
        this.checkFreed();
        this.initialize();
        this.data = string;
    }

    private void checkFreed() {
        if (this.freed) {
            throw new PSQLException(GT.tr("This SQLXML object has already been freed.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            throw new PSQLException(GT.tr("This SQLXML object has not been initialized, so you cannot retrieve data from it.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        if (!this.active) {
            return;
        }
        if (this.byteArrayOutputStream != null) {
            try {
                this.data = this.conn.getEncoding().decode(this.byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                throw new PSQLException(GT.tr("Failed to convert binary xml data to encoding: {0}.", this.conn.getEncoding().name()), PSQLState.DATA_ERROR, (Throwable)iOException);
            }
            finally {
                this.byteArrayOutputStream = null;
                this.active = false;
            }
        }
        if (this.stringWriter != null) {
            this.data = this.stringWriter.toString();
            this.stringWriter = null;
            this.active = false;
        } else if (this.domResult != null) {
            DOMResult dOMResult = this.domResult;
            try {
                TransformerFactory transformerFactory = this.getXmlFactoryFactory().newTransformerFactory();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource dOMSource = new DOMSource(dOMResult.getNode());
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                transformer.transform(dOMSource, streamResult);
                this.data = stringWriter.toString();
            }
            catch (TransformerException transformerException) {
                throw new PSQLException(GT.tr("Unable to convert DOMResult SQLXML data to a string.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)transformerException);
            }
            finally {
                dOMResult = null;
                this.active = false;
            }
        }
    }

    private void initialize() {
        if (this.initialized) {
            throw new PSQLException(GT.tr("This SQLXML object has already been initialized, so you cannot manipulate it further.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        this.initialized = true;
    }
}

