/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.Driver;
import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.core.BaseStatement;
import com.hm.postgresql.core.CachedQuery;
import com.hm.postgresql.core.Field;
import com.hm.postgresql.core.ParameterList;
import com.hm.postgresql.core.Query;
import com.hm.postgresql.core.QueryExecutor;
import com.hm.postgresql.core.ResultCursor;
import com.hm.postgresql.core.ResultHandler;
import com.hm.postgresql.core.ResultHandlerBase;
import com.hm.postgresql.core.SqlCommand;
import com.hm.postgresql.core.Tuple;
import com.hm.postgresql.jdbc.BatchResultHandler;
import com.hm.postgresql.jdbc.PSQLWarningWrapper;
import com.hm.postgresql.jdbc.PgConnection;
import com.hm.postgresql.jdbc.PgResultSet;
import com.hm.postgresql.jdbc.PreferQueryMode;
import com.hm.postgresql.jdbc.ResultWrapper;
import com.hm.postgresql.jdbc.StatementCancelState;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public class PgStatement
implements Statement,
BaseStatement {
    private static final String[] NO_RETURNING_COLUMNS = new String[0];
    private static final boolean DEFAULT_FORCE_BINARY_TRANSFERS = Boolean.getBoolean("com.hm.postgresql.forceBinary");
    private boolean forceBinaryTransfers = DEFAULT_FORCE_BINARY_TRANSFERS;
    protected @Nullable ArrayList<Query> batchStatements = null;
    protected @Nullable ArrayList<@Nullable ParameterList> batchParameters = null;
    protected final int resultsettype;
    protected final int concurrency;
    private final int rsHoldability;
    private boolean poolable;
    private boolean closeOnCompletion = false;
    protected int fetchdirection = 1000;
    private volatile @Nullable TimerTask cancelTimerTask = null;
    private static final AtomicReferenceFieldUpdater<PgStatement, @Nullable TimerTask> CANCEL_TIMER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PgStatement.class, TimerTask.class, "cancelTimerTask");
    private volatile StatementCancelState statementState = StatementCancelState.IDLE;
    private static final AtomicReferenceFieldUpdater<PgStatement, StatementCancelState> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PgStatement.class, StatementCancelState.class, "statementState");
    protected boolean wantsGeneratedKeysOnce = false;
    public boolean wantsGeneratedKeysAlways = false;
    protected final BaseConnection connection;
    protected volatile @Nullable PSQLWarningWrapper warnings = null;
    protected int maxrows = 0;
    protected int fetchSize = 0;
    protected long timeout = 0L;
    protected boolean replaceProcessingEnabled = true;
    protected @Nullable ResultWrapper result = null;
    protected @Nullable @GuardedBy(value={"<self>"}) ResultWrapper firstUnclosedResult = null;
    protected @Nullable ResultWrapper generatedKeys = null;
    protected int mPrepareThreshold;
    protected int maxFieldSize = 0;
    protected boolean adaptiveFetch = false;
    private volatile boolean isClosed = false;

    PgStatement(PgConnection pgConnection, int n, int n2, int n3) {
        this.connection = pgConnection;
        this.forceBinaryTransfers |= pgConnection.getForceBinary();
        this.resultsettype = n;
        this.concurrency = n2;
        this.setFetchSize(pgConnection.getDefaultFetchSize());
        this.setPrepareThreshold(pgConnection.getPrepareThreshold());
        this.setAdaptiveFetch(pgConnection.getAdaptiveFetch());
        this.rsHoldability = n3;
    }

    @Override
    public ResultSet createResultSet(@Nullable Query query, Field[] fieldArray, List<Tuple> list, @Nullable ResultCursor resultCursor) {
        PgResultSet pgResultSet = new PgResultSet(query, this, fieldArray, list, resultCursor, this.getMaxRows(), this.getMaxFieldSize(), this.getResultSetType(), this.getResultSetConcurrency(), this.getResultSetHoldability(), this.getAdaptiveFetch());
        pgResultSet.setFetchSize(this.getFetchSize());
        pgResultSet.setFetchDirection(this.getFetchDirection());
        return pgResultSet;
    }

    public BaseConnection getPGConnection() {
        return this.connection;
    }

    public @Nullable String getFetchingCursorName() {
        return null;
    }

    @Override
    public @NonNegative int getFetchSize() {
        return this.fetchSize;
    }

    protected boolean wantsScrollableResultSet() {
        return this.resultsettype != 1003;
    }

    protected boolean wantsHoldableResultSet() {
        return this.rsHoldability == 1;
    }

    @Override
    public ResultSet executeQuery(String string) {
        if (!this.executeWithFlags(string, 0)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        return this.getSingleResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet getSingleResultSet() {
        PgStatement pgStatement = this;
        synchronized (pgStatement) {
            this.checkClosed();
            ResultWrapper resultWrapper = Nullness.castNonNull(this.result);
            if (resultWrapper.getNext() != null) {
                throw new PSQLException(GT.tr("Multiple ResultSets were returned by the query.", new Object[0]), PSQLState.TOO_MANY_RESULTS);
            }
            return Nullness.castNonNull(resultWrapper.getResultSet(), "result.getResultSet()");
        }
    }

    @Override
    public int executeUpdate(String string) {
        this.executeWithFlags(string, 4);
        this.checkNoResultUpdate();
        return this.getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkNoResultUpdate() {
        PgStatement pgStatement = this;
        synchronized (pgStatement) {
            this.checkClosed();
            for (ResultWrapper resultWrapper = this.result; resultWrapper != null; resultWrapper = resultWrapper.getNext()) {
                if (resultWrapper.getResultSet() == null) continue;
                throw new PSQLException(GT.tr("A result was returned when none was expected.", new Object[0]), PSQLState.TOO_MANY_RESULTS);
            }
        }
    }

    @Override
    public boolean execute(String string) {
        return this.executeWithFlags(string, 0);
    }

    @Override
    public boolean executeWithFlags(String string, int n) {
        return this.executeCachedSql(string, n, NO_RETURNING_COLUMNS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeCachedSql(String string, int n, String @Nullable [] stringArray) {
        boolean bl;
        PreferQueryMode preferQueryMode = this.connection.getPreferQueryMode();
        boolean bl2 = false;
        QueryExecutor queryExecutor = this.connection.getQueryExecutor();
        Object object = queryExecutor.createQueryKey(string, this.replaceProcessingEnabled, bl2, stringArray);
        boolean bl3 = preferQueryMode == PreferQueryMode.EXTENDED_CACHE_EVERYTHING;
        CachedQuery cachedQuery = bl3 ? queryExecutor.borrowQueryByKey(object) : queryExecutor.createQueryByKey(object);
        if (this.wantsGeneratedKeysOnce) {
            SqlCommand sqlCommand = cachedQuery.query.getSqlCommand();
            this.wantsGeneratedKeysOnce = sqlCommand != null && sqlCommand.isReturningKeywordPresent();
        }
        try {
            bl = this.executeWithFlags(cachedQuery, n);
        }
        finally {
            if (bl3) {
                queryExecutor.releaseQuery(cachedQuery);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeWithFlags(CachedQuery cachedQuery, int n) {
        this.checkClosed();
        if (this.connection.getPreferQueryMode().compareTo(PreferQueryMode.EXTENDED) < 0) {
            n |= 0x400;
        }
        this.execute(cachedQuery, null, n);
        PgStatement pgStatement = this;
        synchronized (pgStatement) {
            this.checkClosed();
            return this.result != null && this.result.getResultSet() != null;
        }
    }

    @Override
    public boolean executeWithFlags(int n) {
        this.checkClosed();
        throw new PSQLException(GT.tr("Can''t use executeWithFlags(int) on a Statement.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeUnclosedProcessedResults() {
        PgStatement pgStatement = this;
        synchronized (pgStatement) {
            ResultWrapper resultWrapper;
            ResultWrapper resultWrapper2 = this.result;
            for (resultWrapper = this.firstUnclosedResult; resultWrapper != resultWrapper2 && resultWrapper != null; resultWrapper = resultWrapper.getNext()) {
                PgResultSet pgResultSet = (PgResultSet)resultWrapper.getResultSet();
                if (pgResultSet == null) continue;
                pgResultSet.closeInternally();
            }
            this.firstUnclosedResult = resultWrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeForNextExecution() {
        this.clearWarnings();
        PgStatement pgStatement = this;
        synchronized (pgStatement) {
            this.closeUnclosedProcessedResults();
            if (this.result != null && this.result.getResultSet() != null) {
                this.result.getResultSet().close();
            }
            this.result = null;
            ResultWrapper resultWrapper = this.generatedKeys;
            if (resultWrapper != null) {
                ResultSet resultSet = resultWrapper.getResultSet();
                if (resultSet != null) {
                    resultSet.close();
                }
                this.generatedKeys = null;
            }
        }
    }

    protected boolean isOneShotQuery(@Nullable CachedQuery cachedQuery) {
        if (cachedQuery == null) {
            return true;
        }
        cachedQuery.increaseExecuteCount();
        return (this.mPrepareThreshold == 0 || cachedQuery.getExecuteCount() < this.mPrepareThreshold) && !this.getForceBinaryTransfer();
    }

    protected final void execute(CachedQuery cachedQuery, @Nullable ParameterList parameterList, int n) {
        try {
            this.executeInternal(cachedQuery, parameterList, n);
        }
        catch (SQLException sQLException) {
            if (cachedQuery.query.getSubqueries() != null || !this.connection.getQueryExecutor().willHealOnRetry(sQLException)) {
                throw sQLException;
            }
            cachedQuery.query.close();
            this.executeInternal(cachedQuery, parameterList, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInternal(CachedQuery cachedQuery, @Nullable ParameterList parameterList, int n) {
        ResultWrapper resultWrapper;
        Object object;
        Query query;
        this.closeForNextExecution();
        if (!(this.fetchSize <= 0 || this.wantsScrollableResultSet() || this.connection.getAutoCommit() || this.wantsHoldableResultSet())) {
            n |= 8;
        }
        if ((this.wantsGeneratedKeysOnce || this.wantsGeneratedKeysAlways) && ((n |= 0x40) & 4) != 0) {
            n &= 0xFFFFFFFB;
        }
        if (this.isOneShotQuery(cachedQuery)) {
            n |= 1;
        }
        if (this.connection.getAutoCommit()) {
            n |= 0x10;
        }
        if (this.connection.hintReadOnly()) {
            n |= 0x800;
        }
        if (this.concurrency != 1007) {
            n |= 0x100;
        }
        if ((query = cachedQuery.query).isEmpty()) {
            n |= 0x10;
        }
        if (!query.isStatementDescribed() && this.forceBinaryTransfers && (n & 0x400) == 0) {
            int n2 = n | 0x20;
            object = new StatementResultHandler();
            this.connection.getQueryExecutor().execute(query, parameterList, (ResultHandler)object, 0, 0, n2);
            resultWrapper = ((StatementResultHandler)object).getResults();
            if (resultWrapper != null) {
                Nullness.castNonNull(resultWrapper.getResultSet(), "result2.getResultSet()").close();
            }
        }
        StatementResultHandler statementResultHandler = new StatementResultHandler();
        object = this;
        synchronized (object) {
            this.result = null;
        }
        try {
            this.startTimer();
            this.connection.getQueryExecutor().execute(query, parameterList, statementResultHandler, this.maxrows, this.fetchSize, n, this.adaptiveFetch);
        }
        finally {
            this.killTimerTask();
        }
        object = this;
        synchronized (object) {
            this.checkClosed();
            this.result = this.firstUnclosedResult = (resultWrapper = statementResultHandler.getResults());
            if (this.wantsGeneratedKeysOnce || this.wantsGeneratedKeysAlways) {
                this.generatedKeys = resultWrapper;
                this.result = Nullness.castNonNull(resultWrapper, "handler.getResults()").getNext();
                if (this.wantsGeneratedKeysOnce) {
                    this.wantsGeneratedKeysOnce = false;
                }
            }
        }
    }

    @Override
    public void setCursorName(String string) {
        this.checkClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUpdateCount() {
        PgStatement pgStatement = this;
        synchronized (pgStatement) {
            this.checkClosed();
            if (this.result == null || this.result.getResultSet() != null) {
                return -1;
            }
            long l = this.result.getUpdateCount();
            int n = l > Integer.MAX_VALUE ? -2 : (int)l;
            return n;
        }
    }

    @Override
    public boolean getMoreResults() {
        return this.getMoreResults(3);
    }

    @Override
    public int getMaxRows() {
        this.checkClosed();
        return this.maxrows;
    }

    @Override
    public void setMaxRows(int n) {
        this.checkClosed();
        if (n < 0) {
            throw new PSQLException(GT.tr("Maximum number of rows must be a value greater than or equal to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.maxrows = n;
    }

    @Override
    public void setEscapeProcessing(boolean bl) {
        this.checkClosed();
        this.replaceProcessingEnabled = bl;
    }

    @Override
    public int getQueryTimeout() {
        this.checkClosed();
        long l = this.timeout / 1000L;
        if (l >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public void setQueryTimeout(int n) {
        this.setQueryTimeoutMs((long)n * 1000L);
    }

    public long getQueryTimeoutMs() {
        this.checkClosed();
        return this.timeout;
    }

    public void setQueryTimeoutMs(long l) {
        this.checkClosed();
        if (l < 0L) {
            throw new PSQLException(GT.tr("Query timeout must be a value greater than or equals to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.timeout = l;
    }

    public void addWarning(SQLWarning sQLWarning) {
        PSQLWarningWrapper pSQLWarningWrapper = this.warnings;
        if (pSQLWarningWrapper == null) {
            this.warnings = new PSQLWarningWrapper(sQLWarning);
        } else {
            pSQLWarningWrapper.addWarning(sQLWarning);
        }
    }

    @Override
    public @Nullable SQLWarning getWarnings() {
        this.checkClosed();
        PSQLWarningWrapper pSQLWarningWrapper = this.warnings;
        return pSQLWarningWrapper != null ? pSQLWarningWrapper.getFirstWarning() : null;
    }

    @Override
    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int n) {
        this.checkClosed();
        if (n < 0) {
            throw new PSQLException(GT.tr("The maximum field size must be a value greater than or equal to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.maxFieldSize = n;
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable ResultSet getResultSet() {
        PgStatement pgStatement = this;
        synchronized (pgStatement) {
            this.checkClosed();
            if (this.result == null) {
                return null;
            }
            return this.result.getResultSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        PgStatement pgStatement = this;
        synchronized (pgStatement) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.cancel();
        this.closeForNextExecution();
        this.closeImpl();
    }

    protected void closeImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastOID() {
        PgStatement pgStatement = this;
        synchronized (pgStatement) {
            this.checkClosed();
            if (this.result == null) {
                return 0L;
            }
            return this.result.getInsertOID();
        }
    }

    @Override
    public void setPrepareThreshold(int n) {
        this.checkClosed();
        if (n < 0) {
            this.forceBinaryTransfers = true;
            n = 1;
        }
        this.mPrepareThreshold = n;
    }

    @Override
    public int getPrepareThreshold() {
        return this.mPrepareThreshold;
    }

    @Override
    public void setUseServerPrepare(boolean bl) {
        this.setPrepareThreshold(bl ? 1 : 0);
    }

    @Override
    public boolean isUseServerPrepare() {
        return false;
    }

    protected void checkClosed() {
        if (this.isClosed()) {
            throw new PSQLException(GT.tr("This statement has been closed.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    @Override
    public void addBatch(String string) {
        ArrayList<ParameterList> arrayList;
        this.checkClosed();
        ArrayList<Query> arrayList2 = this.batchStatements;
        if (arrayList2 == null) {
            arrayList2 = new ArrayList();
            this.batchStatements = arrayList2;
        }
        if ((arrayList = this.batchParameters) == null) {
            arrayList = new ArrayList();
            this.batchParameters = arrayList;
        }
        boolean bl = false;
        CachedQuery cachedQuery = this.connection.createQuery(string, this.replaceProcessingEnabled, bl, new String[0]);
        arrayList2.add(cachedQuery.query);
        arrayList.add(null);
    }

    @Override
    public void clearBatch() {
        if (this.batchStatements != null) {
            this.batchStatements.clear();
        }
        if (this.batchParameters != null) {
            this.batchParameters.clear();
        }
    }

    protected BatchResultHandler createBatchHandler(Query[] queryArray, @Nullable ParameterList[] parameterListArray) {
        return new BatchResultHandler(this, queryArray, parameterListArray, this.wantsGeneratedKeysAlways);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresNonNull(value={"batchStatements", "batchParameters"})
    private BatchResultHandler internalExecuteBatch() {
        boolean bl;
        this.transformQueriesAndParameters();
        ArrayList<Query> arrayList = Nullness.castNonNull(this.batchStatements);
        ArrayList<@Nullable ParameterList> arrayList2 = Nullness.castNonNull(this.batchParameters);
        Query[] queryArray = arrayList.toArray(new Query[0]);
        @Nullable ParameterList[] parameterListArray = arrayList2.toArray(new ParameterList[0]);
        arrayList.clear();
        arrayList2.clear();
        boolean bl2 = false;
        int n = this.wantsGeneratedKeysAlways ? 320 : 4;
        PreferQueryMode preferQueryMode = this.connection.getPreferQueryMode();
        if (preferQueryMode == PreferQueryMode.SIMPLE || preferQueryMode == PreferQueryMode.EXTENDED_FOR_PREPARED && parameterListArray[0] == null) {
            n |= 0x400;
        }
        boolean bl3 = bl = queryArray.length > 1 && queryArray[0] == queryArray[1];
        if (!bl || this.isOneShotQuery(null)) {
            n |= 1;
        } else {
            bl2 = (this.wantsGeneratedKeysAlways || bl) && !queryArray[0].isStatementDescribed();
            n |= 0x200;
        }
        if (this.connection.getAutoCommit()) {
            n |= 0x10;
        }
        if (this.connection.hintReadOnly()) {
            n |= 0x800;
        }
        BatchResultHandler batchResultHandler = this.createBatchHandler(queryArray, parameterListArray);
        if ((bl2 || this.forceBinaryTransfers) && (n & 0x400) == 0) {
            int n2 = n | 0x20;
            StatementResultHandler statementResultHandler = new StatementResultHandler();
            try {
                this.connection.getQueryExecutor().execute(queryArray[0], parameterListArray[0], statementResultHandler, 0, 0, n2);
            }
            catch (SQLException sQLException) {
                batchResultHandler.handleError(sQLException);
                batchResultHandler.handleCompletion();
            }
            ResultWrapper resultWrapper = statementResultHandler.getResults();
            if (resultWrapper != null) {
                Nullness.castNonNull(resultWrapper.getResultSet(), "result2.getResultSet()").close();
            }
        }
        PgStatement pgStatement = this;
        synchronized (pgStatement) {
            this.result = null;
        }
        try {
            this.startTimer();
            this.connection.getQueryExecutor().execute(queryArray, parameterListArray, batchResultHandler, this.maxrows, this.fetchSize, n, this.adaptiveFetch);
        }
        finally {
            this.killTimerTask();
            pgStatement = this;
            synchronized (pgStatement) {
                this.checkClosed();
                if (this.wantsGeneratedKeysAlways) {
                    this.generatedKeys = new ResultWrapper(batchResultHandler.getGeneratedKeys());
                }
            }
        }
        return batchResultHandler;
    }

    @Override
    public int[] executeBatch() {
        this.checkClosed();
        this.closeForNextExecution();
        if (this.batchStatements == null || this.batchStatements.isEmpty() || this.batchParameters == null) {
            return new int[0];
        }
        return this.internalExecuteBatch().getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        if (this.statementState == StatementCancelState.IDLE) {
            return;
        }
        if (!STATE_UPDATER.compareAndSet(this, StatementCancelState.IN_QUERY, StatementCancelState.CANCELING)) {
            return;
        }
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                this.connection.cancelQuery();
            }
            finally {
                STATE_UPDATER.set(this, StatementCancelState.CANCELLED);
                this.connection.notifyAll();
            }
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchdirection;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.concurrency;
    }

    @Override
    public int getResultSetType() {
        return this.resultsettype;
    }

    @Override
    public void setFetchDirection(int n) {
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchdirection = n;
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Invalid fetch direction constant: {0}.", n), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
    }

    @Override
    public void setFetchSize(@NonNegative int n) {
        this.checkClosed();
        if (n < 0) {
            throw new PSQLException(GT.tr("Fetch size must be a value greater to or equal to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.fetchSize = n;
    }

    private void startTimer() {
        this.cleanupTimer();
        STATE_UPDATER.set(this, StatementCancelState.IN_QUERY);
        if (this.timeout == 0L) {
            return;
        }
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    if (!CANCEL_TIMER_UPDATER.compareAndSet(PgStatement.this, this, null)) {
                        return;
                    }
                    PgStatement.this.cancel();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        };
        CANCEL_TIMER_UPDATER.set(this, timerTask);
        this.connection.addTimerTask(timerTask, this.timeout);
    }

    private boolean cleanupTimer() {
        TimerTask timerTask = CANCEL_TIMER_UPDATER.get(this);
        if (timerTask == null) {
            return this.timeout == 0L;
        }
        if (!CANCEL_TIMER_UPDATER.compareAndSet(this, timerTask, null)) {
            return false;
        }
        timerTask.cancel();
        this.connection.purgeTimerTasks();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killTimerTask() {
        boolean bl = this.cleanupTimer();
        if (bl && STATE_UPDATER.compareAndSet(this, StatementCancelState.IN_QUERY, StatementCancelState.IDLE)) {
            return;
        }
        boolean bl2 = false;
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            while (!STATE_UPDATER.compareAndSet(this, StatementCancelState.CANCELLED, StatementCancelState.IDLE)) {
                try {
                    this.connection.wait(10L);
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            Thread.currentThread().interrupt();
        }
    }

    protected boolean getForceBinaryTransfer() {
        return this.forceBinaryTransfers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLargeUpdateCount() {
        PgStatement pgStatement = this;
        synchronized (pgStatement) {
            this.checkClosed();
            if (this.result == null || this.result.getResultSet() != null) {
                return -1L;
            }
            return this.result.getUpdateCount();
        }
    }

    @Override
    public void setLargeMaxRows(long l) {
        throw Driver.notImplemented(this.getClass(), "setLargeMaxRows");
    }

    @Override
    public long getLargeMaxRows() {
        throw Driver.notImplemented(this.getClass(), "getLargeMaxRows");
    }

    @Override
    public long[] executeLargeBatch() {
        this.checkClosed();
        this.closeForNextExecution();
        if (this.batchStatements == null || this.batchStatements.isEmpty() || this.batchParameters == null) {
            return new long[0];
        }
        return this.internalExecuteBatch().getLargeUpdateCount();
    }

    @Override
    public long executeLargeUpdate(String string) {
        this.executeWithFlags(string, 4);
        this.checkNoResultUpdate();
        return this.getLargeUpdateCount();
    }

    @Override
    public long executeLargeUpdate(String string, int n) {
        if (n == 2) {
            return this.executeLargeUpdate(string);
        }
        return this.executeLargeUpdate(string, (String[])null);
    }

    @Override
    public long executeLargeUpdate(String string, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return this.executeLargeUpdate(string);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys by column index is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public long executeLargeUpdate(String string, String @Nullable [] stringArray) {
        if (stringArray != null && stringArray.length == 0) {
            return this.executeLargeUpdate(string);
        }
        this.wantsGeneratedKeysOnce = true;
        if (!this.executeCachedSql(string, 0, stringArray)) {
            // empty if block
        }
        return this.getLargeUpdateCount();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean bl) {
        this.checkClosed();
        this.poolable = bl;
    }

    @Override
    public boolean isPoolable() {
        this.checkClosed();
        return this.poolable;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }

    @Override
    public void closeOnCompletion() {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() {
        return this.closeOnCompletion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCompletion() {
        if (!this.closeOnCompletion) {
            return;
        }
        PgStatement pgStatement = this;
        synchronized (pgStatement) {
            for (ResultWrapper resultWrapper = this.firstUnclosedResult; resultWrapper != null; resultWrapper = resultWrapper.getNext()) {
                ResultSet resultSet = resultWrapper.getResultSet();
                if (resultSet == null || resultSet.isClosed()) continue;
                return;
            }
        }
        this.closeOnCompletion = false;
        try {
            this.close();
        }
        finally {
            this.closeOnCompletion = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int n) {
        PgStatement pgStatement = this;
        synchronized (pgStatement) {
            this.checkClosed();
            if (n == 1 && this.result != null && this.result.getResultSet() != null) {
                this.result.getResultSet().close();
            }
            if (this.result != null) {
                this.result = this.result.getNext();
            }
            if (n == 3) {
                this.closeUnclosedProcessedResults();
            }
            return this.result != null && this.result.getResultSet() != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getGeneratedKeys() {
        PgStatement pgStatement = this;
        synchronized (pgStatement) {
            this.checkClosed();
            if (this.generatedKeys == null || this.generatedKeys.getResultSet() == null) {
                return this.createDriverResultSet(new Field[0], new ArrayList<Tuple>());
            }
            return this.generatedKeys.getResultSet();
        }
    }

    @Override
    public int executeUpdate(String string, int n) {
        if (n == 2) {
            return this.executeUpdate(string);
        }
        return this.executeUpdate(string, (String[])null);
    }

    @Override
    public int executeUpdate(String string, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return this.executeUpdate(string);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys by column index is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public int executeUpdate(String string, String @Nullable [] stringArray) {
        if (stringArray != null && stringArray.length == 0) {
            return this.executeUpdate(string);
        }
        this.wantsGeneratedKeysOnce = true;
        if (!this.executeCachedSql(string, 0, stringArray)) {
            // empty if block
        }
        return this.getUpdateCount();
    }

    @Override
    public boolean execute(String string, int n) {
        if (n == 2) {
            return this.execute(string);
        }
        return this.execute(string, (String[])null);
    }

    @Override
    public boolean execute(String string, int @Nullable [] nArray) {
        if (nArray != null && nArray.length == 0) {
            return this.execute(string);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys by column index is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public boolean execute(String string, String @Nullable [] stringArray) {
        if (stringArray != null && stringArray.length == 0) {
            return this.execute(string);
        }
        this.wantsGeneratedKeysOnce = true;
        return this.executeCachedSql(string, 0, stringArray);
    }

    @Override
    public int getResultSetHoldability() {
        return this.rsHoldability;
    }

    @Override
    public ResultSet createDriverResultSet(Field[] fieldArray, List<Tuple> list) {
        return this.createResultSet(null, fieldArray, list, null);
    }

    protected void transformQueriesAndParameters() {
    }

    @Override
    public void setAdaptiveFetch(boolean bl) {
        this.adaptiveFetch = bl;
    }

    @Override
    public boolean getAdaptiveFetch() {
        return this.adaptiveFetch;
    }

    public class StatementResultHandler
    extends ResultHandlerBase {
        private @Nullable ResultWrapper results;
        private @Nullable ResultWrapper lastResult;

        @Nullable ResultWrapper getResults() {
            return this.results;
        }

        private void append(ResultWrapper resultWrapper) {
            if (this.results == null) {
                this.lastResult = this.results = resultWrapper;
            } else {
                Nullness.castNonNull(this.lastResult).append(resultWrapper);
            }
        }

        @Override
        public void handleResultRows(Query query, Field[] fieldArray, List<Tuple> list, @Nullable ResultCursor resultCursor) {
            try {
                ResultSet resultSet = PgStatement.this.createResultSet(query, fieldArray, list, resultCursor);
                this.append(new ResultWrapper(resultSet));
            }
            catch (SQLException sQLException) {
                this.handleError(sQLException);
            }
        }

        @Override
        public void handleCommandStatus(String string, long l, long l2) {
            this.append(new ResultWrapper(l, l2));
        }

        @Override
        public void handleWarning(SQLWarning sQLWarning) {
            PgStatement.this.addWarning(sQLWarning);
        }
    }
}

