/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.core.JavaVersion;
import com.hm.postgresql.core.Provider;
import com.hm.postgresql.util.ByteConverter;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.IsoEra;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;

public class TimestampUtils {
    private static final int ONEDAY = 86400000;
    private static final char[] ZEROS;
    private static final char[][] NUMBERS;
    private static final HashMap<String, TimeZone> GMT_ZONES;
    private static final int MAX_NANOS_BEFORE_WRAP_ON_ROUND = 999999500;
    private static final Duration ONE_MICROSECOND;
    private static final LocalTime MAX_TIME;
    private static final OffsetDateTime MAX_OFFSET_DATETIME;
    private static final LocalDateTime MAX_LOCAL_DATETIME;
    private static final LocalDate MIN_LOCAL_DATE;
    private static final LocalDateTime MIN_LOCAL_DATETIME;
    private static final OffsetDateTime MIN_OFFSET_DATETIME;
    private static final @Nullable Field DEFAULT_TIME_ZONE_FIELD;
    private @Nullable TimeZone prevDefaultZoneFieldValue;
    private @Nullable TimeZone defaultTimeZoneCache;
    private final StringBuilder sbuf = new StringBuilder();
    private final Calendar calendarWithUserTz = new GregorianCalendar();
    private final TimeZone utcTz = TimeZone.getTimeZone("UTC");
    private @Nullable Calendar calCache;
    private int calCacheZone;
    private final boolean usesDouble;
    private final Provider<TimeZone> timeZoneProvider;

    public TimestampUtils(boolean bl, Provider<TimeZone> provider) {
        this.usesDouble = bl;
        this.timeZoneProvider = provider;
    }

    private Calendar getCalendar(int n, int n2, int n3, int n4) {
        int n5 = n * (((n2 * 60 + n3) * 60 + n4) * 1000);
        if (this.calCache != null && this.calCacheZone == n5) {
            return this.calCache;
        }
        StringBuilder stringBuilder = new StringBuilder("GMT");
        stringBuilder.append(n < 0 ? (char)'-' : '+');
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        if (n4 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n4);
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n5, stringBuilder.toString());
        this.calCache = new GregorianCalendar(simpleTimeZone);
        this.calCacheZone = n5;
        return this.calCache;
    }

    private ParsedTimestamp parseBackendTimestamp(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        ParsedTimestamp parsedTimestamp = new ParsedTimestamp();
        try {
            int n2;
            char c;
            int n3 = TimestampUtils.skipWhitespace(cArray, 0);
            int n4 = TimestampUtils.firstNonDigit(cArray, n3);
            if (TimestampUtils.charAt(cArray, n4) == '-') {
                parsedTimestamp.hasDate = true;
                parsedTimestamp.year = TimestampUtils.number(cArray, n3, n4);
                n3 = n4 + 1;
                n4 = TimestampUtils.firstNonDigit(cArray, n3);
                parsedTimestamp.month = TimestampUtils.number(cArray, n3, n4);
                c = TimestampUtils.charAt(cArray, n4);
                if (c != '-') {
                    throw new NumberFormatException("Expected date to be dash-separated, got '" + c + "'");
                }
                n3 = n4 + 1;
                n4 = TimestampUtils.firstNonDigit(cArray, n3);
                parsedTimestamp.day = TimestampUtils.number(cArray, n3, n4);
                n3 = TimestampUtils.skipWhitespace(cArray, n4);
            }
            if (Character.isDigit(TimestampUtils.charAt(cArray, n3))) {
                parsedTimestamp.hasTime = true;
                n4 = TimestampUtils.firstNonDigit(cArray, n3);
                parsedTimestamp.hour = TimestampUtils.number(cArray, n3, n4);
                c = TimestampUtils.charAt(cArray, n4);
                if (c != ':') {
                    throw new NumberFormatException("Expected time to be colon-separated, got '" + c + "'");
                }
                n3 = n4 + 1;
                n4 = TimestampUtils.firstNonDigit(cArray, n3);
                parsedTimestamp.minute = TimestampUtils.number(cArray, n3, n4);
                c = TimestampUtils.charAt(cArray, n4);
                if (c != ':') {
                    throw new NumberFormatException("Expected time to be colon-separated, got '" + c + "'");
                }
                n3 = n4 + 1;
                n4 = TimestampUtils.firstNonDigit(cArray, n3);
                parsedTimestamp.second = TimestampUtils.number(cArray, n3, n4);
                n3 = n4;
                if (TimestampUtils.charAt(cArray, n3) == '.') {
                    n4 = TimestampUtils.firstNonDigit(cArray, n3 + 1);
                    int n5 = TimestampUtils.number(cArray, n3 + 1, n4);
                    for (n2 = n4 - (n3 + 1); n2 < 9; ++n2) {
                        n5 *= 10;
                    }
                    parsedTimestamp.nanos = n5;
                    n3 = n4;
                }
                n3 = TimestampUtils.skipWhitespace(cArray, n3);
            }
            if ((c = TimestampUtils.charAt(cArray, n3)) == '-' || c == '+') {
                int n6;
                n2 = c == '-' ? -1 : 1;
                n4 = TimestampUtils.firstNonDigit(cArray, n3 + 1);
                int n7 = TimestampUtils.number(cArray, n3 + 1, n4);
                n3 = n4;
                c = TimestampUtils.charAt(cArray, n3);
                if (c == ':') {
                    n4 = TimestampUtils.firstNonDigit(cArray, n3 + 1);
                    n6 = TimestampUtils.number(cArray, n3 + 1, n4);
                    n3 = n4;
                } else {
                    n6 = 0;
                }
                int n8 = 0;
                c = TimestampUtils.charAt(cArray, n3);
                if (c == ':') {
                    n4 = TimestampUtils.firstNonDigit(cArray, n3 + 1);
                    n8 = TimestampUtils.number(cArray, n3 + 1, n4);
                    n3 = n4;
                }
                parsedTimestamp.tz = this.getCalendar(n2, n7, n6, n8);
                n3 = TimestampUtils.skipWhitespace(cArray, n3);
            }
            if (parsedTimestamp.hasDate && n3 < n) {
                String string2 = new String(cArray, n3, n - n3);
                if (string2.startsWith("AD")) {
                    parsedTimestamp.era = 1;
                    n3 += 2;
                } else if (string2.startsWith("BC")) {
                    parsedTimestamp.era = 0;
                    n3 += 2;
                }
            }
            if (n3 < n) {
                throw new NumberFormatException("Trailing junk on timestamp: '" + new String(cArray, n3, n - n3) + "'");
            }
            if (!parsedTimestamp.hasTime && !parsedTimestamp.hasDate) {
                throw new NumberFormatException("Timestamp has neither date nor time");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException(GT.tr("Bad value for type timestamp/date/time: {1}", string), PSQLState.BAD_DATETIME_FORMAT, (Throwable)numberFormatException);
        }
        return parsedTimestamp;
    }

    public synchronized @PolyNull Timestamp toTimestamp(@Nullable Calendar calendar, @PolyNull String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 8 && string.equals("infinity")) {
            return new Timestamp(9223372036825200000L);
        }
        if (n == 9 && string.equals("-infinity")) {
            return new Timestamp(-9223372036832400000L);
        }
        ParsedTimestamp parsedTimestamp = this.parseBackendTimestamp(string);
        Calendar calendar2 = parsedTimestamp.tz != null ? parsedTimestamp.tz : this.setupCalendar(calendar);
        calendar2.set(0, parsedTimestamp.era);
        calendar2.set(1, parsedTimestamp.year);
        calendar2.set(2, parsedTimestamp.month - 1);
        calendar2.set(5, parsedTimestamp.day);
        calendar2.set(11, parsedTimestamp.hour);
        calendar2.set(12, parsedTimestamp.minute);
        calendar2.set(13, parsedTimestamp.second);
        calendar2.set(14, 0);
        Timestamp timestamp = new Timestamp(calendar2.getTimeInMillis());
        timestamp.setNanos(parsedTimestamp.nanos);
        return timestamp;
    }

    public @PolyNull LocalTime toLocalTime(@PolyNull String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("24:00:00")) {
            return LocalTime.MAX;
        }
        try {
            return LocalTime.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new PSQLException(GT.tr("Bad value for type timestamp/date/time: {1}", string), PSQLState.BAD_DATETIME_FORMAT, (Throwable)dateTimeParseException);
        }
    }

    public @PolyNull LocalDateTime toLocalDateTime(@PolyNull String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 8 && string.equals("infinity")) {
            return LocalDateTime.MAX;
        }
        if (n == 9 && string.equals("-infinity")) {
            return LocalDateTime.MIN;
        }
        ParsedTimestamp parsedTimestamp = this.parseBackendTimestamp(string);
        LocalDateTime localDateTime = LocalDateTime.of(parsedTimestamp.year, parsedTimestamp.month, parsedTimestamp.day, parsedTimestamp.hour, parsedTimestamp.minute, parsedTimestamp.second, parsedTimestamp.nanos);
        if (parsedTimestamp.era == 0) {
            return localDateTime.with(ChronoField.ERA, IsoEra.BCE.getValue());
        }
        return localDateTime;
    }

    public @PolyNull OffsetDateTime toOffsetDateTime(@PolyNull String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 8 && string.equals("infinity")) {
            return OffsetDateTime.MAX;
        }
        if (n == 9 && string.equals("-infinity")) {
            return OffsetDateTime.MIN;
        }
        ParsedTimestamp parsedTimestamp = this.parseBackendTimestamp(string);
        Calendar calendar = parsedTimestamp.tz;
        int n2 = calendar == null ? 0 : calendar.get(15) / 1000;
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n2);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(parsedTimestamp.year, parsedTimestamp.month, parsedTimestamp.day, parsedTimestamp.hour, parsedTimestamp.minute, parsedTimestamp.second, parsedTimestamp.nanos, zoneOffset).withOffsetSameInstant(ZoneOffset.UTC);
        if (parsedTimestamp.era == 0) {
            return offsetDateTime.with(ChronoField.ERA, IsoEra.BCE.getValue());
        }
        return offsetDateTime;
    }

    public OffsetDateTime toOffsetDateTime(Time time) {
        return time.toLocalTime().atDate(LocalDate.of(1970, 1, 1)).atOffset(ZoneOffset.UTC);
    }

    public OffsetDateTime toOffsetDateTimeBin(byte[] byArray) {
        ParsedBinaryTimestamp parsedBinaryTimestamp = this.toProlepticParsedTimestampBin(byArray);
        if (parsedBinaryTimestamp.infinity == Infinity.POSITIVE) {
            return OffsetDateTime.MAX;
        }
        if (parsedBinaryTimestamp.infinity == Infinity.NEGATIVE) {
            return OffsetDateTime.MIN;
        }
        Instant instant = Instant.ofEpochSecond(parsedBinaryTimestamp.millis / 1000L, parsedBinaryTimestamp.nanos);
        return OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    public synchronized @PolyNull Time toTime(@Nullable Calendar calendar, @PolyNull String string) {
        Calendar calendar2;
        if (string == null) {
            return null;
        }
        ParsedTimestamp parsedTimestamp = this.parseBackendTimestamp(string);
        Calendar calendar3 = calendar2 = parsedTimestamp.tz != null ? parsedTimestamp.tz : this.setupCalendar(calendar);
        if (parsedTimestamp.tz == null) {
            calendar2.set(0, parsedTimestamp.era);
            calendar2.set(1, parsedTimestamp.year);
            calendar2.set(2, parsedTimestamp.month - 1);
            calendar2.set(5, parsedTimestamp.day);
        } else {
            calendar2.set(0, 1);
            calendar2.set(1, 1970);
            calendar2.set(2, 0);
            calendar2.set(5, 1);
        }
        calendar2.set(11, parsedTimestamp.hour);
        calendar2.set(12, parsedTimestamp.minute);
        calendar2.set(13, parsedTimestamp.second);
        calendar2.set(14, 0);
        long l = calendar2.getTimeInMillis() + (long)(parsedTimestamp.nanos / 1000000);
        if (parsedTimestamp.tz != null || parsedTimestamp.year == 1970 && parsedTimestamp.era == 1) {
            return new Time(l);
        }
        return this.convertToTime(l, calendar2.getTimeZone());
    }

    public synchronized @PolyNull Date toDate(@Nullable Calendar calendar, @PolyNull String string) {
        Timestamp timestamp = this.toTimestamp(calendar, string);
        if (timestamp == null) {
            return null;
        }
        return this.convertToDate(timestamp.getTime(), calendar == null ? null : calendar.getTimeZone());
    }

    private Calendar setupCalendar(@Nullable Calendar calendar) {
        TimeZone timeZone = calendar == null ? null : calendar.getTimeZone();
        return this.getSharedCalendar(timeZone);
    }

    public Calendar getSharedCalendar(@Nullable TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = this.getDefaultTz();
        }
        Calendar calendar = this.calendarWithUserTz;
        calendar.setTimeZone(timeZone);
        return calendar;
    }

    private static boolean nanosExceed499(int n) {
        return n % 1000 > 499;
    }

    public synchronized String toString(@Nullable Calendar calendar, Timestamp timestamp) {
        return this.toString(calendar, timestamp, true);
    }

    public synchronized String toString(@Nullable Calendar calendar, Timestamp timestamp, boolean bl) {
        if (timestamp.getTime() == 9223372036825200000L) {
            return "infinity";
        }
        if (timestamp.getTime() == -9223372036832400000L) {
            return "-infinity";
        }
        calendar = this.setupCalendar(calendar);
        long l = timestamp.getTime();
        int n = timestamp.getNanos();
        if (n >= 999999500) {
            n = 0;
            ++l;
        } else if (TimestampUtils.nanosExceed499(n)) {
            n += 1000 - n % 1000;
        }
        calendar.setTimeInMillis(l);
        this.sbuf.setLength(0);
        TimestampUtils.appendDate(this.sbuf, calendar);
        this.sbuf.append(' ');
        TimestampUtils.appendTime(this.sbuf, calendar, n);
        if (bl) {
            this.appendTimeZone(this.sbuf, calendar);
        }
        TimestampUtils.appendEra(this.sbuf, calendar);
        return this.sbuf.toString();
    }

    public synchronized String toString(@Nullable Calendar calendar, Date date) {
        return this.toString(calendar, date, true);
    }

    public synchronized String toString(@Nullable Calendar calendar, Date date, boolean bl) {
        if (date.getTime() == 9223372036825200000L) {
            return "infinity";
        }
        if (date.getTime() == -9223372036832400000L) {
            return "-infinity";
        }
        calendar = this.setupCalendar(calendar);
        calendar.setTime(date);
        this.sbuf.setLength(0);
        TimestampUtils.appendDate(this.sbuf, calendar);
        TimestampUtils.appendEra(this.sbuf, calendar);
        if (bl) {
            this.sbuf.append(' ');
            this.appendTimeZone(this.sbuf, calendar);
        }
        return this.sbuf.toString();
    }

    public synchronized String toString(@Nullable Calendar calendar, Time time) {
        return this.toString(calendar, time, true);
    }

    public synchronized String toString(@Nullable Calendar calendar, Time time, boolean bl) {
        calendar = this.setupCalendar(calendar);
        calendar.setTime(time);
        this.sbuf.setLength(0);
        TimestampUtils.appendTime(this.sbuf, calendar, calendar.get(14) * 1000000);
        if (bl) {
            this.appendTimeZone(this.sbuf, calendar);
        }
        return this.sbuf.toString();
    }

    private static void appendDate(StringBuilder stringBuilder, Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        TimestampUtils.appendDate(stringBuilder, n, n2, n3);
    }

    private static void appendDate(StringBuilder stringBuilder, int n, int n2, int n3) {
        int n4 = stringBuilder.length();
        stringBuilder.append(n);
        int n5 = 4 - (stringBuilder.length() - n4);
        if (n5 > 0) {
            stringBuilder.insert(n4, ZEROS, 0, n5);
        }
        stringBuilder.append('-');
        stringBuilder.append(NUMBERS[n2]);
        stringBuilder.append('-');
        stringBuilder.append(NUMBERS[n3]);
    }

    private static void appendTime(StringBuilder stringBuilder, Calendar calendar, int n) {
        int n2 = calendar.get(11);
        int n3 = calendar.get(12);
        int n4 = calendar.get(13);
        TimestampUtils.appendTime(stringBuilder, n2, n3, n4, n);
    }

    private static void appendTime(StringBuilder stringBuilder, int n, int n2, int n3, int n4) {
        stringBuilder.append(NUMBERS[n]);
        stringBuilder.append(':');
        stringBuilder.append(NUMBERS[n2]);
        stringBuilder.append(':');
        stringBuilder.append(NUMBERS[n3]);
        if (n4 < 1000) {
            return;
        }
        stringBuilder.append('.');
        int n5 = stringBuilder.length();
        stringBuilder.append(n4 / 1000);
        int n6 = 6 - (stringBuilder.length() - n5);
        if (n6 > 0) {
            stringBuilder.insert(n5, ZEROS, 0, n6);
        }
        int n7 = stringBuilder.length() - 1;
        while (stringBuilder.charAt(n7) == '0') {
            stringBuilder.deleteCharAt(n7);
            --n7;
        }
    }

    private void appendTimeZone(StringBuilder stringBuilder, Calendar calendar) {
        int n = (calendar.get(15) + calendar.get(16)) / 1000;
        this.appendTimeZone(stringBuilder, n);
    }

    private void appendTimeZone(StringBuilder stringBuilder, int n) {
        int n2 = Math.abs(n);
        int n3 = n2 / 60 / 60;
        int n4 = (n2 - n3 * 60 * 60) / 60;
        int n5 = n2 - n3 * 60 * 60 - n4 * 60;
        stringBuilder.append(n >= 0 ? "+" : "-");
        stringBuilder.append(NUMBERS[n3]);
        if (n4 == 0 && n5 == 0) {
            return;
        }
        stringBuilder.append(':');
        stringBuilder.append(NUMBERS[n4]);
        if (n5 != 0) {
            stringBuilder.append(':');
            stringBuilder.append(NUMBERS[n5]);
        }
    }

    private static void appendEra(StringBuilder stringBuilder, Calendar calendar) {
        if (calendar.get(0) == 0) {
            stringBuilder.append(" BC");
        }
    }

    public synchronized String toString(LocalDate localDate) {
        if (LocalDate.MAX.equals(localDate)) {
            return "infinity";
        }
        if (localDate.isBefore(MIN_LOCAL_DATE)) {
            return "-infinity";
        }
        this.sbuf.setLength(0);
        TimestampUtils.appendDate(this.sbuf, localDate);
        TimestampUtils.appendEra(this.sbuf, localDate);
        return this.sbuf.toString();
    }

    public synchronized String toString(LocalTime localTime) {
        this.sbuf.setLength(0);
        if (localTime.isAfter(MAX_TIME)) {
            return "24:00:00";
        }
        int n = localTime.getNano();
        if (TimestampUtils.nanosExceed499(n)) {
            localTime = localTime.plus(ONE_MICROSECOND);
        }
        TimestampUtils.appendTime(this.sbuf, localTime);
        return this.sbuf.toString();
    }

    public synchronized String toString(OffsetDateTime offsetDateTime) {
        if (offsetDateTime.isAfter(MAX_OFFSET_DATETIME)) {
            return "infinity";
        }
        if (offsetDateTime.isBefore(MIN_OFFSET_DATETIME)) {
            return "-infinity";
        }
        this.sbuf.setLength(0);
        int n = offsetDateTime.getNano();
        if (TimestampUtils.nanosExceed499(n)) {
            offsetDateTime = offsetDateTime.plus(ONE_MICROSECOND);
        }
        LocalDateTime localDateTime = offsetDateTime.toLocalDateTime();
        LocalDate localDate = localDateTime.toLocalDate();
        TimestampUtils.appendDate(this.sbuf, localDate);
        this.sbuf.append(' ');
        TimestampUtils.appendTime(this.sbuf, localDateTime.toLocalTime());
        this.appendTimeZone(this.sbuf, offsetDateTime.getOffset());
        TimestampUtils.appendEra(this.sbuf, localDate);
        return this.sbuf.toString();
    }

    public synchronized String toString(LocalDateTime localDateTime) {
        if (localDateTime.isAfter(MAX_LOCAL_DATETIME)) {
            return "infinity";
        }
        if (localDateTime.isBefore(MIN_LOCAL_DATETIME)) {
            return "-infinity";
        }
        ZonedDateTime zonedDateTime = localDateTime.atZone(this.getDefaultTz().toZoneId());
        return this.toString(zonedDateTime.toOffsetDateTime());
    }

    private static void appendDate(StringBuilder stringBuilder, LocalDate localDate) {
        int n = localDate.get(ChronoField.YEAR_OF_ERA);
        int n2 = localDate.getMonthValue();
        int n3 = localDate.getDayOfMonth();
        TimestampUtils.appendDate(stringBuilder, n, n2, n3);
    }

    private static void appendTime(StringBuilder stringBuilder, LocalTime localTime) {
        int n = localTime.getHour();
        int n2 = localTime.getMinute();
        int n3 = localTime.getSecond();
        int n4 = localTime.getNano();
        TimestampUtils.appendTime(stringBuilder, n, n2, n3, n4);
    }

    private void appendTimeZone(StringBuilder stringBuilder, ZoneOffset zoneOffset) {
        int n = zoneOffset.getTotalSeconds();
        this.appendTimeZone(stringBuilder, n);
    }

    private static void appendEra(StringBuilder stringBuilder, LocalDate localDate) {
        if (localDate.get(ChronoField.ERA) == IsoEra.BCE.getValue()) {
            stringBuilder.append(" BC");
        }
    }

    private static int skipWhitespace(char[] cArray, int n) {
        int n2 = cArray.length;
        for (int i = n; i < n2; ++i) {
            if (Character.isSpace(cArray[i])) continue;
            return i;
        }
        return n2;
    }

    private static int firstNonDigit(char[] cArray, int n) {
        int n2 = cArray.length;
        for (int i = n; i < n2; ++i) {
            if (Character.isDigit(cArray[i])) continue;
            return i;
        }
        return n2;
    }

    private static int number(char[] cArray, int n, int n2) {
        if (n >= n2) {
            throw new NumberFormatException();
        }
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 = 10 * n3 + (cArray[i] - 48);
        }
        return n3;
    }

    private static char charAt(char[] cArray, int n) {
        if (n >= 0 && n < cArray.length) {
            return cArray[n];
        }
        return '\u0000';
    }

    public Date toDateBin(@Nullable TimeZone timeZone, byte[] byArray) {
        long l;
        long l2;
        if (byArray.length != 4) {
            throw new PSQLException(GT.tr("Unsupported binary encoding of {0}.", "date"), PSQLState.BAD_DATETIME_FORMAT);
        }
        int n = ByteConverter.int4(byArray, 0);
        if (timeZone == null) {
            timeZone = this.getDefaultTz();
        }
        l2 = (l2 = (l = TimestampUtils.toJavaSecs((long)n * 86400L)) * 1000L) <= -185543533774800000L ? -9223372036832400000L : (l2 >= 185543533774800000L ? 9223372036825200000L : this.guessTimestamp(l2, timeZone));
        return new Date(l2);
    }

    private TimeZone getDefaultTz() {
        TimeZone timeZone;
        if (DEFAULT_TIME_ZONE_FIELD != null) {
            try {
                timeZone = (TimeZone)DEFAULT_TIME_ZONE_FIELD.get(null);
                if (timeZone == this.prevDefaultZoneFieldValue) {
                    return Nullness.castNonNull(this.defaultTimeZoneCache);
                }
                this.prevDefaultZoneFieldValue = timeZone;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.defaultTimeZoneCache = timeZone = TimeZone.getDefault();
        return timeZone;
    }

    public boolean hasFastDefaultTimeZone() {
        return DEFAULT_TIME_ZONE_FIELD != null;
    }

    public Time toTimeBin(@Nullable TimeZone timeZone, byte[] byArray) {
        long l;
        if (byArray.length != 8 && byArray.length != 12) {
            throw new PSQLException(GT.tr("Unsupported binary encoding of {0}.", "time"), PSQLState.BAD_DATETIME_FORMAT);
        }
        if (this.usesDouble) {
            double d = ByteConverter.float8(byArray, 0);
            l = (long)(d * 1000.0);
        } else {
            long l2 = ByteConverter.int8(byArray, 0);
            l = l2 / 1000L;
        }
        if (byArray.length == 12) {
            int n = ByteConverter.int4(byArray, 8);
            return new Time(l -= (long)(n *= -1000));
        }
        if (timeZone == null) {
            timeZone = this.getDefaultTz();
        }
        l = this.guessTimestamp(l, timeZone);
        return this.convertToTime(l, timeZone);
    }

    public LocalTime toLocalTimeBin(byte[] byArray) {
        long l;
        if (byArray.length != 8) {
            throw new PSQLException(GT.tr("Unsupported binary encoding of {0}.", "time"), PSQLState.BAD_DATETIME_FORMAT);
        }
        if (this.usesDouble) {
            double d = ByteConverter.float8(byArray, 0);
            l = (long)(d * 1000000.0);
        } else {
            l = ByteConverter.int8(byArray, 0);
        }
        return LocalTime.ofNanoOfDay(l * 1000L);
    }

    public Timestamp toTimestampBin(@Nullable TimeZone timeZone, byte[] byArray, boolean bl) {
        ParsedBinaryTimestamp parsedBinaryTimestamp = this.toParsedTimestampBin(timeZone, byArray, bl);
        if (parsedBinaryTimestamp.infinity == Infinity.POSITIVE) {
            return new Timestamp(9223372036825200000L);
        }
        if (parsedBinaryTimestamp.infinity == Infinity.NEGATIVE) {
            return new Timestamp(-9223372036832400000L);
        }
        Timestamp timestamp = new Timestamp(parsedBinaryTimestamp.millis);
        timestamp.setNanos(parsedBinaryTimestamp.nanos);
        return timestamp;
    }

    private ParsedBinaryTimestamp toParsedTimestampBinPlain(byte[] byArray) {
        int n;
        long l;
        if (byArray.length != 8) {
            throw new PSQLException(GT.tr("Unsupported binary encoding of {0}.", "timestamp"), PSQLState.BAD_DATETIME_FORMAT);
        }
        if (this.usesDouble) {
            double d = ByteConverter.float8(byArray, 0);
            if (d == Double.POSITIVE_INFINITY) {
                ParsedBinaryTimestamp parsedBinaryTimestamp = new ParsedBinaryTimestamp();
                parsedBinaryTimestamp.infinity = Infinity.POSITIVE;
                return parsedBinaryTimestamp;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                ParsedBinaryTimestamp parsedBinaryTimestamp = new ParsedBinaryTimestamp();
                parsedBinaryTimestamp.infinity = Infinity.NEGATIVE;
                return parsedBinaryTimestamp;
            }
            l = (long)d;
            n = (int)((d - (double)l) * 1000000.0);
        } else {
            long l2 = ByteConverter.int8(byArray, 0);
            if (l2 == Long.MAX_VALUE) {
                ParsedBinaryTimestamp parsedBinaryTimestamp = new ParsedBinaryTimestamp();
                parsedBinaryTimestamp.infinity = Infinity.POSITIVE;
                return parsedBinaryTimestamp;
            }
            if (l2 == Long.MIN_VALUE) {
                ParsedBinaryTimestamp parsedBinaryTimestamp = new ParsedBinaryTimestamp();
                parsedBinaryTimestamp.infinity = Infinity.NEGATIVE;
                return parsedBinaryTimestamp;
            }
            l = l2 / 1000000L;
            n = (int)(l2 - l * 1000000L);
        }
        if (n < 0) {
            --l;
            n += 1000000;
        }
        long l3 = l * 1000L;
        ParsedBinaryTimestamp parsedBinaryTimestamp = new ParsedBinaryTimestamp();
        parsedBinaryTimestamp.millis = l3;
        parsedBinaryTimestamp.nanos = n *= 1000;
        return parsedBinaryTimestamp;
    }

    private ParsedBinaryTimestamp toParsedTimestampBin(@Nullable TimeZone timeZone, byte[] byArray, boolean bl) {
        ParsedBinaryTimestamp parsedBinaryTimestamp = this.toParsedTimestampBinPlain(byArray);
        if (parsedBinaryTimestamp.infinity != null) {
            return parsedBinaryTimestamp;
        }
        long l = parsedBinaryTimestamp.millis / 1000L;
        l = TimestampUtils.toJavaSecs(l);
        long l2 = l * 1000L;
        if (!bl) {
            l2 = this.guessTimestamp(l2, timeZone);
        }
        parsedBinaryTimestamp.millis = l2;
        return parsedBinaryTimestamp;
    }

    private ParsedBinaryTimestamp toProlepticParsedTimestampBin(byte[] byArray) {
        long l;
        ParsedBinaryTimestamp parsedBinaryTimestamp = this.toParsedTimestampBinPlain(byArray);
        if (parsedBinaryTimestamp.infinity != null) {
            return parsedBinaryTimestamp;
        }
        long l2 = parsedBinaryTimestamp.millis / 1000L;
        parsedBinaryTimestamp.millis = l = (l2 += 946684800L) * 1000L;
        return parsedBinaryTimestamp;
    }

    public LocalDateTime toLocalDateTimeBin(byte[] byArray) {
        ParsedBinaryTimestamp parsedBinaryTimestamp = this.toProlepticParsedTimestampBin(byArray);
        if (parsedBinaryTimestamp.infinity == Infinity.POSITIVE) {
            return LocalDateTime.MAX;
        }
        if (parsedBinaryTimestamp.infinity == Infinity.NEGATIVE) {
            return LocalDateTime.MIN;
        }
        return LocalDateTime.ofEpochSecond(parsedBinaryTimestamp.millis / 1000L, parsedBinaryTimestamp.nanos, ZoneOffset.UTC);
    }

    private long guessTimestamp(long l, @Nullable TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = this.getDefaultTz();
        }
        if (TimestampUtils.isSimpleTimeZone(timeZone.getID())) {
            return l - (long)timeZone.getRawOffset();
        }
        Calendar calendar = this.calendarWithUserTz;
        calendar.setTimeZone(this.utcTz);
        calendar.setTimeInMillis(l);
        int n = calendar.get(0);
        int n2 = calendar.get(1);
        int n3 = calendar.get(2);
        int n4 = calendar.get(5);
        int n5 = calendar.get(11);
        int n6 = calendar.get(12);
        int n7 = calendar.get(13);
        int n8 = calendar.get(14);
        calendar.setTimeZone(timeZone);
        calendar.set(0, n);
        calendar.set(1, n2);
        calendar.set(2, n3);
        calendar.set(5, n4);
        calendar.set(11, n5);
        calendar.set(12, n6);
        calendar.set(13, n7);
        calendar.set(14, n8);
        return calendar.getTimeInMillis();
    }

    private static boolean isSimpleTimeZone(String string) {
        return string.startsWith("GMT") || string.startsWith("UTC");
    }

    public Date convertToDate(long l, @Nullable TimeZone timeZone) {
        if (l <= -9223372036832400000L || l >= 9223372036825200000L) {
            return new Date(l);
        }
        if (timeZone == null) {
            timeZone = this.getDefaultTz();
        }
        if (TimestampUtils.isSimpleTimeZone(timeZone.getID())) {
            int n = timeZone.getRawOffset();
            l += (long)n;
            l = TimestampUtils.floorDiv(l, 86400000L) * 86400000L;
            return new Date(l -= (long)n);
        }
        Calendar calendar = this.calendarWithUserTz;
        calendar.setTimeZone(timeZone);
        calendar.setTimeInMillis(l);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public Time convertToTime(long l, TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = this.getDefaultTz();
        }
        if (TimestampUtils.isSimpleTimeZone(timeZone.getID())) {
            int n = timeZone.getRawOffset();
            l += (long)n;
            l = TimestampUtils.floorMod(l, 86400000L);
            return new Time(l -= (long)n);
        }
        Calendar calendar = this.calendarWithUserTz;
        calendar.setTimeZone(timeZone);
        calendar.setTimeInMillis(l);
        calendar.set(0, 1);
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        return new Time(calendar.getTimeInMillis());
    }

    public String timeToString(java.util.Date date, boolean bl) {
        Calendar calendar = null;
        if (bl) {
            calendar = this.calendarWithUserTz;
            calendar.setTimeZone(this.timeZoneProvider.get());
        }
        if (date instanceof Timestamp) {
            return this.toString(calendar, (Timestamp)date, bl);
        }
        if (date instanceof Time) {
            return this.toString(calendar, (Time)date, bl);
        }
        return this.toString(calendar, (Date)date, bl);
    }

    private static long toJavaSecs(long l) {
        if ((l += 946684800L) < -12219292800L && (l += 864000L) < -14825808000L) {
            int n = (int)((l + 14825808000L) / 3155760000L);
            --n;
            n -= n / 4;
            l += (long)n * 86400L;
        }
        return l;
    }

    private static long toPgSecs(long l) {
        if ((l -= 946684800L) < -13165977600L && (l -= 864000L) < -15773356800L) {
            int n = (int)((l + 15773356800L) / -3155823050L);
            ++n;
            n -= n / 4;
            l += (long)n * 86400L;
        }
        return l;
    }

    public void toBinDate(@Nullable TimeZone timeZone, byte[] byArray, Date date) {
        long l = date.getTime();
        if (timeZone == null) {
            timeZone = this.getDefaultTz();
        }
        l += (long)timeZone.getOffset(l);
        long l2 = TimestampUtils.toPgSecs(l / 1000L);
        ByteConverter.int4(byArray, 0, (int)(l2 / 86400L));
    }

    public static TimeZone parseBackendTimeZone(String string) {
        TimeZone timeZone;
        if (string.startsWith("GMT") && (timeZone = GMT_ZONES.get(string)) != null) {
            return timeZone;
        }
        return TimeZone.getTimeZone(string);
    }

    private static long floorDiv(long l, long l2) {
        long l3 = l / l2;
        if ((l ^ l2) < 0L && l3 * l2 != l) {
            --l3;
        }
        return l3;
    }

    private static long floorMod(long l, long l2) {
        return l - TimestampUtils.floorDiv(l, l2) * l2;
    }

    static {
        Field field;
        Object object;
        TimeZone timeZone;
        int n;
        ZEROS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
        GMT_ZONES = new HashMap();
        ONE_MICROSECOND = Duration.ofNanos(1000L);
        MAX_TIME = LocalTime.MAX.minus(Duration.ofNanos(500L));
        MAX_OFFSET_DATETIME = OffsetDateTime.MAX.minus(Duration.ofMillis(500L));
        MAX_LOCAL_DATETIME = LocalDateTime.MAX.minus(Duration.ofMillis(500L));
        MIN_LOCAL_DATE = LocalDate.of(4713, 1, 1).with(ChronoField.ERA, IsoEra.BCE.getValue());
        MIN_LOCAL_DATETIME = MIN_LOCAL_DATE.atStartOfDay();
        MIN_OFFSET_DATETIME = MIN_LOCAL_DATETIME.atOffset(ZoneOffset.UTC);
        NUMBERS = new char[64][];
        for (n = 0; n < NUMBERS.length; ++n) {
            TimestampUtils.NUMBERS[n] = ((n < 10 ? "0" : "") + Integer.toString(n)).toCharArray();
        }
        for (n = -12; n <= 14; ++n) {
            if (n == 0) {
                timeZone = TimeZone.getTimeZone("GMT");
                object = "GMT";
            } else {
                timeZone = TimeZone.getTimeZone("GMT" + (n <= 0 ? "+" : "-") + Math.abs(n));
                object = "GMT" + (n >= 0 ? "+" : "-");
            }
            if (n == 0) {
                GMT_ZONES.put((String)object, timeZone);
                continue;
            }
            GMT_ZONES.put((String)object + Math.abs(n), timeZone);
            GMT_ZONES.put((String)object + new String(NUMBERS[Math.abs(n)]), timeZone);
        }
        try {
            field = null;
            if (JavaVersion.getRuntimeVersion().compareTo(JavaVersion.v1_8) <= 0) {
                field = TimeZone.class.getDeclaredField("defaultTimeZone");
                field.setAccessible(true);
                timeZone = TimeZone.getDefault();
                object = field.get(null);
                if (timeZone == null || !timeZone.equals(object)) {
                    field = null;
                }
            }
        }
        catch (Exception exception) {
            field = null;
        }
        DEFAULT_TIME_ZONE_FIELD = field;
    }

    static enum Infinity {
        POSITIVE,
        NEGATIVE;

    }

    private static class ParsedBinaryTimestamp {
        @Nullable Infinity infinity = null;
        long millis = 0L;
        int nanos = 0;

        private ParsedBinaryTimestamp() {
        }
    }

    private static class ParsedTimestamp {
        boolean hasDate = false;
        int era = 1;
        int year = 1970;
        int month = 1;
        boolean hasTime = false;
        int day = 1;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int nanos = 0;
        @Nullable Calendar tz = null;

        private ParsedTimestamp() {
        }
    }
}

