/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.largeobject;

import com.hm.postgresql.largeobject.LargeObject;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BlobOutputStream
extends OutputStream {
    private @Nullable LargeObject lo;
    private byte[] buf;
    private int bsize;
    private int bpos;

    public BlobOutputStream(LargeObject largeObject) {
        this(largeObject, 1024);
    }

    public BlobOutputStream(LargeObject largeObject, int n) {
        this.lo = largeObject;
        this.bsize = n;
        this.buf = new byte[n];
        this.bpos = 0;
    }

    @Override
    public void write(int n) {
        LargeObject largeObject = this.checkClosed();
        try {
            if (this.bpos >= this.bsize) {
                largeObject.write(this.buf);
                this.bpos = 0;
            }
            this.buf[this.bpos++] = (byte)n;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.toString());
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        LargeObject largeObject = this.checkClosed();
        try {
            if (this.bpos > 0) {
                this.flush();
            }
            if (n == 0 && n2 == byArray.length) {
                largeObject.write(byArray);
            } else {
                largeObject.write(byArray, n, n2);
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.toString());
        }
    }

    @Override
    public void flush() {
        LargeObject largeObject = this.checkClosed();
        try {
            if (this.bpos > 0) {
                largeObject.write(this.buf, 0, this.bpos);
            }
            this.bpos = 0;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.toString());
        }
    }

    @Override
    public void close() {
        LargeObject largeObject = this.lo;
        if (largeObject != null) {
            try {
                this.flush();
                largeObject.close();
                this.lo = null;
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.toString());
            }
        }
    }

    private LargeObject checkClosed() {
        if (this.lo == null) {
            throw new IOException("BlobOutputStream is closed");
        }
        return this.lo;
    }
}

