/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.largeobject;

import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.fastpath.Fastpath;
import com.hm.postgresql.fastpath.FastpathArg;
import com.hm.postgresql.largeobject.BlobInputStream;
import com.hm.postgresql.largeobject.BlobOutputStream;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LargeObject
implements AutoCloseable {
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    private final Fastpath fp;
    private final long oid;
    private final int mode;
    private final int fd;
    private @Nullable BlobOutputStream os;
    private boolean closed = false;
    private @Nullable BaseConnection conn;
    private final boolean commitOnClose;

    protected LargeObject(Fastpath fastpath, long l, int n, @Nullable BaseConnection baseConnection, boolean bl) {
        this.fp = fastpath;
        this.oid = l;
        this.mode = n;
        if (bl) {
            this.commitOnClose = true;
            this.conn = baseConnection;
        } else {
            this.commitOnClose = false;
        }
        FastpathArg[] fastpathArgArray = new FastpathArg[]{Fastpath.createOIDArg(l), new FastpathArg(n)};
        this.fd = fastpath.getInteger("lo_open", fastpathArgArray);
    }

    protected LargeObject(Fastpath fastpath, long l, int n) {
        this(fastpath, l, n, null, false);
    }

    public LargeObject copy() {
        return new LargeObject(this.fp, this.oid, this.mode);
    }

    @Deprecated
    public int getOID() {
        return (int)this.oid;
    }

    public long getLongOID() {
        return this.oid;
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.os != null) {
                try {
                    this.os.flush();
                }
                catch (IOException iOException) {
                    throw new PSQLException("Exception flushing output stream", PSQLState.DATA_ERROR, (Throwable)iOException);
                }
                finally {
                    this.os = null;
                }
            }
            FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd)};
            this.fp.fastpath("lo_close", fastpathArgArray);
            this.closed = true;
            BaseConnection baseConnection = this.conn;
            if (this.commitOnClose && baseConnection != null) {
                baseConnection.commit();
            }
        }
    }

    public byte[] read(int n) {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(n)};
        return Nullness.castNonNull(this.fp.getData("loread", fastpathArgArray));
    }

    public int read(byte[] byArray, int n, int n2) {
        byte[] byArray2 = this.read(n2);
        if (byArray2 == null) {
            return 0;
        }
        if (byArray2.length < n2) {
            n2 = byArray2.length;
        }
        System.arraycopy(byArray2, 0, byArray, n, n2);
        return n2;
    }

    public void write(byte[] byArray) {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(byArray)};
        this.fp.fastpath("lowrite", fastpathArgArray);
    }

    public void write(byte[] byArray, int n, int n2) {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(byArray, n, n2)};
        this.fp.fastpath("lowrite", fastpathArgArray);
    }

    public void seek(int n, int n2) {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(n), new FastpathArg(n2)};
        this.fp.fastpath("lo_lseek", fastpathArgArray);
    }

    public void seek64(long l, int n) {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(l), new FastpathArg(n)};
        this.fp.fastpath("lo_lseek64", fastpathArgArray);
    }

    public void seek(int n) {
        this.seek(n, 0);
    }

    public int tell() {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd)};
        return this.fp.getInteger("lo_tell", fastpathArgArray);
    }

    public long tell64() {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd)};
        return this.fp.getLong("lo_tell64", fastpathArgArray);
    }

    public int size() {
        int n = this.tell();
        this.seek(0, 2);
        int n2 = this.tell();
        this.seek(n, 0);
        return n2;
    }

    public long size64() {
        long l = this.tell64();
        this.seek64(0L, 2);
        long l2 = this.tell64();
        this.seek64(l, 0);
        return l2;
    }

    public void truncate(int n) {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(n)};
        this.fp.getInteger("lo_truncate", fastpathArgArray);
    }

    public void truncate64(long l) {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(l)};
        this.fp.getInteger("lo_truncate64", fastpathArgArray);
    }

    public InputStream getInputStream() {
        return new BlobInputStream(this, 4096);
    }

    public InputStream getInputStream(long l) {
        return new BlobInputStream(this, 4096, l);
    }

    public OutputStream getOutputStream() {
        if (this.os == null) {
            this.os = new BlobOutputStream(this, 4096);
        }
        return this.os;
    }
}

