/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.replication.fluent;

import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.core.ServerVersion;
import com.hm.postgresql.replication.fluent.ChainedCommonCreateSlotBuilder;
import com.hm.postgresql.util.GT;
import java.sql.SQLFeatureNotSupportedException;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractCreateSlotBuilder<T extends ChainedCommonCreateSlotBuilder<T>>
implements ChainedCommonCreateSlotBuilder<T> {
    protected @Nullable String slotName;
    protected boolean temporaryOption = false;
    protected BaseConnection connection;

    protected AbstractCreateSlotBuilder(BaseConnection baseConnection) {
        this.connection = baseConnection;
    }

    protected abstract T self();

    @Override
    public T withSlotName(String string) {
        this.slotName = string;
        return this.self();
    }

    @Override
    public T withTemporaryOption() {
        if (!this.connection.haveMinimumServerVersion(ServerVersion.v10)) {
            throw new SQLFeatureNotSupportedException(GT.tr("Server does not support temporary replication slots", new Object[0]));
        }
        this.temporaryOption = true;
        return this.self();
    }
}

