/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.replication.fluent;

import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.core.ReplicationProtocol;
import com.hm.postgresql.replication.PGReplicationStream;
import com.hm.postgresql.replication.fluent.ChainedStreamBuilder;
import com.hm.postgresql.replication.fluent.logical.ChainedLogicalStreamBuilder;
import com.hm.postgresql.replication.fluent.logical.LogicalReplicationOptions;
import com.hm.postgresql.replication.fluent.logical.LogicalStreamBuilder;
import com.hm.postgresql.replication.fluent.logical.StartLogicalReplicationCallback;
import com.hm.postgresql.replication.fluent.physical.ChainedPhysicalStreamBuilder;
import com.hm.postgresql.replication.fluent.physical.PhysicalReplicationOptions;
import com.hm.postgresql.replication.fluent.physical.PhysicalStreamBuilder;
import com.hm.postgresql.replication.fluent.physical.StartPhysicalReplicationCallback;

public class ReplicationStreamBuilder
implements ChainedStreamBuilder {
    private final BaseConnection baseConnection;

    public ReplicationStreamBuilder(BaseConnection baseConnection) {
        this.baseConnection = baseConnection;
    }

    @Override
    public ChainedLogicalStreamBuilder logical() {
        return new LogicalStreamBuilder(new StartLogicalReplicationCallback(){

            @Override
            public PGReplicationStream start(LogicalReplicationOptions logicalReplicationOptions) {
                ReplicationProtocol replicationProtocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return replicationProtocol.startLogical(logicalReplicationOptions);
            }
        });
    }

    @Override
    public ChainedPhysicalStreamBuilder physical() {
        return new PhysicalStreamBuilder(new StartPhysicalReplicationCallback(){

            @Override
            public PGReplicationStream start(PhysicalReplicationOptions physicalReplicationOptions) {
                ReplicationProtocol replicationProtocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return replicationProtocol.startPhysical(physicalReplicationOptions);
            }
        });
    }
}

