/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.replication.fluent.logical;

import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.replication.LogSequenceNumber;
import com.hm.postgresql.replication.ReplicationSlotInfo;
import com.hm.postgresql.replication.ReplicationType;
import com.hm.postgresql.replication.fluent.AbstractCreateSlotBuilder;
import com.hm.postgresql.replication.fluent.logical.ChainedLogicalCreateSlotBuilder;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.sql.ResultSet;
import java.sql.Statement;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LogicalCreateSlotBuilder
extends AbstractCreateSlotBuilder<ChainedLogicalCreateSlotBuilder>
implements ChainedLogicalCreateSlotBuilder {
    private @Nullable String outputPlugin;

    public LogicalCreateSlotBuilder(BaseConnection baseConnection) {
        super(baseConnection);
    }

    @Override
    protected ChainedLogicalCreateSlotBuilder self() {
        return this;
    }

    @Override
    public ChainedLogicalCreateSlotBuilder withOutputPlugin(String string) {
        this.outputPlugin = string;
        return this.self();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationSlotInfo make() {
        ReplicationSlotInfo replicationSlotInfo;
        block7: {
            String string = this.outputPlugin;
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("OutputPlugin required parameter for logical replication slot");
            }
            if (this.slotName == null || this.slotName.isEmpty()) {
                throw new IllegalArgumentException("Replication slotName can't be null");
            }
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = null;
            replicationSlotInfo = null;
            try {
                String string2 = String.format("CREATE_REPLICATION_SLOT %s %s LOGICAL %s", this.slotName, this.temporaryOption ? "TEMPORARY" : "", string);
                statement.execute(string2);
                resultSet = statement.getResultSet();
                if (resultSet != null && resultSet.next()) {
                    replicationSlotInfo = new ReplicationSlotInfo(Nullness.castNonNull(resultSet.getString("slot_name")), ReplicationType.LOGICAL, LogSequenceNumber.valueOf(Nullness.castNonNull(resultSet.getString("consistent_point"))), resultSet.getString("snapshot_name"), resultSet.getString("output_plugin"));
                    break block7;
                }
                throw new PSQLException(GT.tr("{0} returned no results", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                statement.close();
            }
        }
        return replicationSlotInfo;
    }
}

