/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.replication.fluent.physical;

import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.replication.LogSequenceNumber;
import com.hm.postgresql.replication.ReplicationSlotInfo;
import com.hm.postgresql.replication.ReplicationType;
import com.hm.postgresql.replication.fluent.AbstractCreateSlotBuilder;
import com.hm.postgresql.replication.fluent.physical.ChainedPhysicalCreateSlotBuilder;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.sql.ResultSet;
import java.sql.Statement;

public class PhysicalCreateSlotBuilder
extends AbstractCreateSlotBuilder<ChainedPhysicalCreateSlotBuilder>
implements ChainedPhysicalCreateSlotBuilder {
    public PhysicalCreateSlotBuilder(BaseConnection baseConnection) {
        super(baseConnection);
    }

    @Override
    protected ChainedPhysicalCreateSlotBuilder self() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationSlotInfo make() {
        ReplicationSlotInfo replicationSlotInfo;
        block6: {
            if (this.slotName == null || this.slotName.isEmpty()) {
                throw new IllegalArgumentException("Replication slotName can't be null");
            }
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = null;
            replicationSlotInfo = null;
            try {
                String string = String.format("CREATE_REPLICATION_SLOT %s %s PHYSICAL", this.slotName, this.temporaryOption ? "TEMPORARY" : "");
                statement.execute(string);
                resultSet = statement.getResultSet();
                if (resultSet != null && resultSet.next()) {
                    replicationSlotInfo = new ReplicationSlotInfo(Nullness.castNonNull(resultSet.getString("slot_name")), ReplicationType.PHYSICAL, LogSequenceNumber.valueOf(Nullness.castNonNull(resultSet.getString("consistent_point"))), resultSet.getString("snapshot_name"), resultSet.getString("output_plugin"));
                    break block6;
                }
                throw new PSQLException(GT.tr("{0} returned no results", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                statement.close();
            }
        }
        return replicationSlotInfo;
    }
}

