/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.shaded.com.ongres.scram.client;

import com.hm.postgresql.shaded.com.ongres.scram.common.ScramFunctions;
import com.hm.postgresql.shaded.com.ongres.scram.common.ScramMechanism;
import com.hm.postgresql.shaded.com.ongres.scram.common.bouncycastle.base64.Base64;
import com.hm.postgresql.shaded.com.ongres.scram.common.exception.ScramInvalidServerSignatureException;
import com.hm.postgresql.shaded.com.ongres.scram.common.exception.ScramServerErrorException;
import com.hm.postgresql.shaded.com.ongres.scram.common.gssapi.Gs2CbindFlag;
import com.hm.postgresql.shaded.com.ongres.scram.common.message.ClientFinalMessage;
import com.hm.postgresql.shaded.com.ongres.scram.common.message.ClientFirstMessage;
import com.hm.postgresql.shaded.com.ongres.scram.common.message.ServerFinalMessage;
import com.hm.postgresql.shaded.com.ongres.scram.common.message.ServerFirstMessage;
import com.hm.postgresql.shaded.com.ongres.scram.common.stringprep.StringPreparation;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.Preconditions;

public class ScramSession {
    private final ScramMechanism scramMechanism;
    private final StringPreparation stringPreparation;
    private final String user;
    private final String nonce;
    private ClientFirstMessage clientFirstMessage;
    private String serverFirstMessageString;

    public ScramSession(ScramMechanism scramMechanism, StringPreparation stringPreparation, String string, String string2) {
        this.scramMechanism = Preconditions.checkNotNull(scramMechanism, "scramMechanism");
        this.stringPreparation = Preconditions.checkNotNull(stringPreparation, "stringPreparation");
        this.user = Preconditions.checkNotEmpty(string, "user");
        this.nonce = Preconditions.checkNotEmpty(string2, "nonce");
    }

    private String setAndReturnClientFirstMessage(ClientFirstMessage clientFirstMessage) {
        this.clientFirstMessage = clientFirstMessage;
        return clientFirstMessage.toString();
    }

    public String clientFirstMessage(Gs2CbindFlag gs2CbindFlag, String string, String string2) {
        return this.setAndReturnClientFirstMessage(new ClientFirstMessage(gs2CbindFlag, string2, string, this.user, this.nonce));
    }

    public String clientFirstMessage() {
        return this.setAndReturnClientFirstMessage(new ClientFirstMessage(this.user, this.nonce));
    }

    public ServerFirstProcessor receiveServerFirstMessage(String string) {
        return new ServerFirstProcessor(Preconditions.checkNotEmpty(string, "serverFirstMessage"));
    }

    public class ClientFinalProcessor {
        private final String nonce;
        private final byte[] clientKey;
        private final byte[] storedKey;
        private final byte[] serverKey;
        private String authMessage;

        private ClientFinalProcessor(String string, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            assert (null != byArray) : "clientKey";
            assert (null != byArray2) : "storedKey";
            assert (null != byArray3) : "serverKey";
            this.nonce = string;
            this.clientKey = byArray;
            this.storedKey = byArray2;
            this.serverKey = byArray3;
        }

        private ClientFinalProcessor(String string, byte[] byArray, byte[] byArray2) {
            this(string, byArray, ScramFunctions.storedKey(scramSession.scramMechanism, byArray), byArray2);
        }

        private ClientFinalProcessor(String string, byte[] byArray) {
            this(string, ScramFunctions.clientKey(scramSession.scramMechanism, byArray), ScramFunctions.serverKey(scramSession.scramMechanism, byArray));
        }

        private ClientFinalProcessor(String string, String string2, String string3, int n) {
            this(string, ScramFunctions.saltedPassword(scramSession.scramMechanism, scramSession.stringPreparation, string2, Base64.decode(string3), n));
        }

        private synchronized void generateAndCacheAuthMessage(byte[] byArray) {
            if (null != this.authMessage) {
                return;
            }
            this.authMessage = ScramSession.this.clientFirstMessage.writeToWithoutGs2Header(new StringBuffer()).append(",").append(ScramSession.this.serverFirstMessageString).append(",").append(ClientFinalMessage.writeToWithoutProof(ScramSession.this.clientFirstMessage.getGs2Header(), byArray, this.nonce)).toString();
        }

        private String clientFinalMessage(byte[] byArray) {
            if (null == this.authMessage) {
                this.generateAndCacheAuthMessage(byArray);
            }
            ClientFinalMessage clientFinalMessage = new ClientFinalMessage(ScramSession.this.clientFirstMessage.getGs2Header(), byArray, this.nonce, ScramFunctions.clientProof(this.clientKey, ScramFunctions.clientSignature(ScramSession.this.scramMechanism, this.storedKey, this.authMessage)));
            return clientFinalMessage.toString();
        }

        public String clientFinalMessage() {
            return this.clientFinalMessage(null);
        }

        public void receiveServerFinalMessage(String string) {
            Preconditions.checkNotEmpty(string, "serverFinalMessage");
            ServerFinalMessage serverFinalMessage = ServerFinalMessage.parseFrom(string);
            if (serverFinalMessage.isError()) {
                throw new ScramServerErrorException(serverFinalMessage.getError());
            }
            if (!ScramFunctions.verifyServerSignature(ScramSession.this.scramMechanism, this.serverKey, this.authMessage, serverFinalMessage.getVerifier())) {
                throw new ScramInvalidServerSignatureException("Invalid server SCRAM signature");
            }
        }
    }

    public class ServerFirstProcessor {
        private final ServerFirstMessage serverFirstMessage;

        private ServerFirstProcessor(String string) {
            ScramSession.this.serverFirstMessageString = string;
            this.serverFirstMessage = ServerFirstMessage.parseFrom(string, ScramSession.this.nonce);
        }

        public String getSalt() {
            return this.serverFirstMessage.getSalt();
        }

        public int getIteration() {
            return this.serverFirstMessage.getIteration();
        }

        public ClientFinalProcessor clientFinalProcessor(String string) {
            return new ClientFinalProcessor(this.serverFirstMessage.getNonce(), Preconditions.checkNotEmpty(string, "password"), this.getSalt(), this.getIteration());
        }

        public ClientFinalProcessor clientFinalProcessor(byte[] byArray, byte[] byArray2) {
            return new ClientFinalProcessor(this.serverFirstMessage.getNonce(), Preconditions.checkNotNull(byArray, "clientKey"), Preconditions.checkNotNull(byArray2, "storedKey"));
        }
    }
}

