/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.shaded.com.ongres.scram.common;

import com.hm.postgresql.shaded.com.ongres.scram.common.ScramMechanism;
import com.hm.postgresql.shaded.com.ongres.scram.common.stringprep.StringPreparation;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.CryptoUtil;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class ScramFunctions {
    private static final byte[] CLIENT_KEY_HMAC_KEY = "Client Key".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SERVER_KEY_HMAC_KEY = "Server Key".getBytes(StandardCharsets.UTF_8);

    public static byte[] saltedPassword(ScramMechanism scramMechanism, StringPreparation stringPreparation, String string, byte[] byArray, int n) {
        return scramMechanism.saltedPassword(stringPreparation, string, byArray, n);
    }

    public static byte[] hmac(ScramMechanism scramMechanism, byte[] byArray, byte[] byArray2) {
        return scramMechanism.hmac(byArray2, byArray);
    }

    public static byte[] clientKey(ScramMechanism scramMechanism, byte[] byArray) {
        return ScramFunctions.hmac(scramMechanism, CLIENT_KEY_HMAC_KEY, byArray);
    }

    public static byte[] clientKey(ScramMechanism scramMechanism, StringPreparation stringPreparation, String string, byte[] byArray, int n) {
        return ScramFunctions.clientKey(scramMechanism, ScramFunctions.saltedPassword(scramMechanism, stringPreparation, string, byArray, n));
    }

    public static byte[] serverKey(ScramMechanism scramMechanism, byte[] byArray) {
        return ScramFunctions.hmac(scramMechanism, SERVER_KEY_HMAC_KEY, byArray);
    }

    public static byte[] serverKey(ScramMechanism scramMechanism, StringPreparation stringPreparation, String string, byte[] byArray, int n) {
        return ScramFunctions.serverKey(scramMechanism, ScramFunctions.saltedPassword(scramMechanism, stringPreparation, string, byArray, n));
    }

    public static byte[] hash(ScramMechanism scramMechanism, byte[] byArray) {
        return scramMechanism.digest(byArray);
    }

    public static byte[] storedKey(ScramMechanism scramMechanism, byte[] byArray) {
        return ScramFunctions.hash(scramMechanism, byArray);
    }

    public static byte[] clientSignature(ScramMechanism scramMechanism, byte[] byArray, String string) {
        return ScramFunctions.hmac(scramMechanism, string.getBytes(StandardCharsets.UTF_8), byArray);
    }

    public static byte[] clientProof(byte[] byArray, byte[] byArray2) {
        return CryptoUtil.xor(byArray, byArray2);
    }

    public static byte[] serverSignature(ScramMechanism scramMechanism, byte[] byArray, String string) {
        return ScramFunctions.clientSignature(scramMechanism, byArray, string);
    }

    public static boolean verifyClientProof(ScramMechanism scramMechanism, byte[] byArray, byte[] byArray2, String string) {
        byte[] byArray3 = ScramFunctions.clientSignature(scramMechanism, byArray2, string);
        byte[] byArray4 = CryptoUtil.xor(byArray3, byArray);
        byte[] byArray5 = ScramFunctions.hash(scramMechanism, byArray4);
        return Arrays.equals(byArray2, byArray5);
    }

    public static boolean verifyServerSignature(ScramMechanism scramMechanism, byte[] byArray, String string, byte[] byArray2) {
        return Arrays.equals(ScramFunctions.serverSignature(scramMechanism, byArray, string), byArray2);
    }
}

