/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.shaded.com.ongres.scram.common;

import com.hm.postgresql.shaded.com.ongres.scram.common.ScramMechanism;
import com.hm.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.DigestFactory;
import com.hm.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.KeyParameter;
import com.hm.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.PBEParametersGenerator;
import com.hm.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.PKCS5S2ParametersGenerator;
import com.hm.postgresql.shaded.com.ongres.scram.common.stringprep.StringPreparation;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.CryptoUtil;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;

public enum ScramMechanisms implements ScramMechanism
{
    SCRAM_SHA_1("SHA-1", "SHA-1", 160, "HmacSHA1", false, 1),
    SCRAM_SHA_1_PLUS("SHA-1", "SHA-1", 160, "HmacSHA1", true, 1),
    SCRAM_SHA_256("SHA-256", "SHA-256", 256, "HmacSHA256", false, 10),
    SCRAM_SHA_256_PLUS("SHA-256", "SHA-256", 256, "HmacSHA256", true, 10);

    private static final String SCRAM_MECHANISM_NAME_PREFIX = "SCRAM-";
    private static final String CHANNEL_BINDING_SUFFIX = "-PLUS";
    private static final String PBKDF2_PREFIX_ALGORITHM_NAME = "PBKDF2With";
    private static final Map<String, ScramMechanisms> BY_NAME_MAPPING;
    private final String mechanismName;
    private final String hashAlgorithmName;
    private final int keyLength;
    private final String hmacAlgorithmName;
    private final boolean channelBinding;
    private final int priority;

    private ScramMechanisms(String string2, String string3, int n2, String string4, boolean bl, int n3) {
        this.mechanismName = SCRAM_MECHANISM_NAME_PREFIX + Preconditions.checkNotNull(string2, "name") + (bl ? CHANNEL_BINDING_SUFFIX : "");
        this.hashAlgorithmName = Preconditions.checkNotNull(string3, "hashAlgorithmName");
        this.keyLength = Preconditions.gt0(n2, "keyLength");
        this.hmacAlgorithmName = Preconditions.checkNotNull(string4, "hmacAlgorithmName");
        this.channelBinding = bl;
        this.priority = Preconditions.gt0(n3, "priority");
    }

    protected String getHashAlgorithmName() {
        return this.hashAlgorithmName;
    }

    protected String getHmacAlgorithmName() {
        return this.hmacAlgorithmName;
    }

    @Override
    public String getName() {
        return this.mechanismName;
    }

    @Override
    public boolean supportsChannelBinding() {
        return this.channelBinding;
    }

    @Override
    public int algorithmKeyLength() {
        return this.keyLength;
    }

    @Override
    public byte[] digest(byte[] byArray) {
        try {
            return MessageDigest.getInstance(this.hashAlgorithmName).digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Algorithm " + this.hashAlgorithmName + " not present in current JVM");
        }
    }

    @Override
    public byte[] hmac(byte[] byArray, byte[] byArray2) {
        try {
            return CryptoUtil.hmac(new SecretKeySpec(byArray, this.hmacAlgorithmName), Mac.getInstance(this.hmacAlgorithmName), byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("MAC Algorithm " + this.hmacAlgorithmName + " not present in current JVM");
        }
    }

    @Override
    public byte[] saltedPassword(StringPreparation stringPreparation, String string, byte[] byArray, int n) {
        char[] cArray = stringPreparation.normalize(string).toCharArray();
        try {
            return CryptoUtil.hi(SecretKeyFactory.getInstance(PBKDF2_PREFIX_ALGORITHM_NAME + this.hmacAlgorithmName), this.algorithmKeyLength(), cArray, byArray, n);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (!SCRAM_SHA_256.getHmacAlgorithmName().equals(this.getHmacAlgorithmName())) {
                throw new RuntimeException("Unsupported PBKDF2 for " + this.mechanismName);
            }
            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA256());
            pKCS5S2ParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(cArray), byArray, n);
            KeyParameter keyParameter = (KeyParameter)((PBEParametersGenerator)pKCS5S2ParametersGenerator).generateDerivedParameters(this.algorithmKeyLength());
            return keyParameter.getKey();
        }
    }

    public static ScramMechanisms byName(String string) {
        Preconditions.checkNotNull(string, "name");
        return BY_NAME_MAPPING.get(string);
    }

    public static ScramMechanism selectMatchingMechanism(boolean bl, String ... stringArray) {
        ScramMechanisms scramMechanisms = null;
        for (String string : stringArray) {
            ScramMechanisms scramMechanisms2 = BY_NAME_MAPPING.get(string);
            if (scramMechanisms2 == null) continue;
            for (ScramMechanisms scramMechanisms3 : ScramMechanisms.values()) {
                if (bl != scramMechanisms3.channelBinding || !scramMechanisms3.mechanismName.equals(scramMechanisms2.mechanismName) || scramMechanisms != null && scramMechanisms.priority >= scramMechanisms3.priority) continue;
                scramMechanisms = scramMechanisms3;
            }
        }
        return scramMechanisms;
    }

    private static Map<String, ScramMechanisms> valuesAsMap() {
        HashMap<String, ScramMechanisms> hashMap = new HashMap<String, ScramMechanisms>(ScramMechanisms.values().length);
        for (ScramMechanisms scramMechanisms : ScramMechanisms.values()) {
            hashMap.put(scramMechanisms.getName(), scramMechanisms);
        }
        return hashMap;
    }

    static {
        BY_NAME_MAPPING = ScramMechanisms.valuesAsMap();
    }
}

