/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.shaded.com.ongres.scram.common.message;

import com.hm.postgresql.shaded.com.ongres.scram.common.ScramAttributeValue;
import com.hm.postgresql.shaded.com.ongres.scram.common.ScramAttributes;
import com.hm.postgresql.shaded.com.ongres.scram.common.ScramStringFormatting;
import com.hm.postgresql.shaded.com.ongres.scram.common.gssapi.Gs2Header;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.StringWritable;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.StringWritableCsv;

public class ClientFinalMessage
implements StringWritable {
    private final String cbind;
    private final String nonce;
    private final byte[] proof;

    private static String generateCBind(Gs2Header gs2Header, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        gs2Header.writeTo(stringBuffer).append(',');
        if (null != byArray) {
            new ScramAttributeValue(ScramAttributes.CHANNEL_BINDING, ScramStringFormatting.base64Encode(byArray)).writeTo(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public ClientFinalMessage(Gs2Header gs2Header, byte[] byArray, String string, byte[] byArray2) {
        this.cbind = ClientFinalMessage.generateCBind(Preconditions.checkNotNull(gs2Header, "gs2Header"), byArray);
        this.nonce = Preconditions.checkNotEmpty(string, "nonce");
        this.proof = Preconditions.checkNotNull(byArray2, "proof");
    }

    private static StringBuffer writeToWithoutProof(StringBuffer stringBuffer, String string, String string2) {
        return StringWritableCsv.writeTo(stringBuffer, new ScramAttributeValue(ScramAttributes.CHANNEL_BINDING, ScramStringFormatting.base64Encode(string)), new ScramAttributeValue(ScramAttributes.NONCE, string2));
    }

    private static StringBuffer writeToWithoutProof(StringBuffer stringBuffer, Gs2Header gs2Header, byte[] byArray, String string) {
        return ClientFinalMessage.writeToWithoutProof(stringBuffer, ClientFinalMessage.generateCBind(Preconditions.checkNotNull(gs2Header, "gs2Header"), byArray), string);
    }

    public static StringBuffer writeToWithoutProof(Gs2Header gs2Header, byte[] byArray, String string) {
        return ClientFinalMessage.writeToWithoutProof(new StringBuffer(), gs2Header, byArray, string);
    }

    @Override
    public StringBuffer writeTo(StringBuffer stringBuffer) {
        ClientFinalMessage.writeToWithoutProof(stringBuffer, this.cbind, this.nonce);
        return StringWritableCsv.writeTo(stringBuffer, null, new ScramAttributeValue(ScramAttributes.CLIENT_PROOF, ScramStringFormatting.base64Encode(this.proof)));
    }

    public String toString() {
        return this.writeTo(new StringBuffer()).toString();
    }
}

