/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.shaded.com.ongres.scram.common.message;

import com.hm.postgresql.shaded.com.ongres.scram.common.ScramAttributeValue;
import com.hm.postgresql.shaded.com.ongres.scram.common.ScramAttributes;
import com.hm.postgresql.shaded.com.ongres.scram.common.ScramStringFormatting;
import com.hm.postgresql.shaded.com.ongres.scram.common.exception.ScramParseException;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.StringWritable;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.StringWritableCsv;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;

public class ServerFinalMessage
implements StringWritable {
    private final byte[] verifier;
    private final Error error;

    public ServerFinalMessage(byte[] byArray) {
        this.verifier = Preconditions.checkNotNull(byArray, "verifier");
        this.error = null;
    }

    public ServerFinalMessage(Error error) {
        this.error = Preconditions.checkNotNull(error, "error");
        this.verifier = null;
    }

    public boolean isError() {
        return null != this.error;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getVerifier() {
        return this.verifier;
    }

    public Error getError() {
        return this.error;
    }

    @Override
    public StringBuffer writeTo(StringBuffer stringBuffer) {
        return StringWritableCsv.writeTo(stringBuffer, this.isError() ? new ScramAttributeValue(ScramAttributes.ERROR, this.error.errorMessage) : new ScramAttributeValue(ScramAttributes.SERVER_SIGNATURE, ScramStringFormatting.base64Encode(this.verifier)));
    }

    public static ServerFinalMessage parseFrom(String string) {
        Preconditions.checkNotEmpty(string, "serverFinalMessage");
        String[] stringArray = StringWritableCsv.parseFrom(string, 1, 0);
        if (stringArray == null || stringArray.length != 1) {
            throw new ScramParseException("Invalid server-final-message");
        }
        ScramAttributeValue scramAttributeValue = ScramAttributeValue.parse(stringArray[0]);
        if (ScramAttributes.SERVER_SIGNATURE.getChar() == scramAttributeValue.getChar()) {
            byte[] byArray = ScramStringFormatting.base64Decode(scramAttributeValue.getValue());
            return new ServerFinalMessage(byArray);
        }
        if (ScramAttributes.ERROR.getChar() == scramAttributeValue.getChar()) {
            return new ServerFinalMessage(Error.getByErrorMessage(scramAttributeValue.getValue()));
        }
        throw new ScramParseException("Invalid server-final-message: it must contain either a verifier or an error attribute");
    }

    public String toString() {
        return this.writeTo(new StringBuffer()).toString();
    }

    public static enum Error {
        INVALID_ENCODING("invalid-encoding"),
        EXTENSIONS_NOT_SUPPORTED("extensions-not-supported"),
        INVALID_PROOF("invalid-proof"),
        CHANNEL_BINDINGS_DONT_MATCH("channel-bindings-dont-match"),
        SERVER_DOES_SUPPORT_CHANNEL_BINDING("server-does-support-channel-binding"),
        CHANNEL_BINDING_NOT_SUPPORTED("channel-binding-not-supported"),
        UNSUPPORTED_CHANNEL_BINDING_TYPE("unsupported-channel-binding-type"),
        UNKNOWN_USER("unknown-user"),
        INVALID_USERNAME_ENCODING("invalid-username-encoding"),
        NO_RESOURCES("no-resources"),
        OTHER_ERROR("other-error");

        private static final Map<String, Error> BY_NAME_MAPPING;
        private final String errorMessage;

        private Error(String string2) {
            this.errorMessage = string2;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public static Error getByErrorMessage(String string) {
            Preconditions.checkNotEmpty(string, "errorMessage");
            if (!BY_NAME_MAPPING.containsKey(string)) {
                throw new IllegalArgumentException("Invalid error message '" + string + "'");
            }
            return BY_NAME_MAPPING.get(string);
        }

        private static Map<String, Error> valuesAsMap() {
            HashMap<String, Error> hashMap = new HashMap<String, Error>(Error.values().length);
            for (Error error : Error.values()) {
                hashMap.put(error.errorMessage, error);
            }
            return hashMap;
        }

        static {
            BY_NAME_MAPPING = Error.valuesAsMap();
        }
    }
}

