/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.shaded.com.ongres.scram.common.message;

import com.hm.postgresql.shaded.com.ongres.scram.common.ScramAttributeValue;
import com.hm.postgresql.shaded.com.ongres.scram.common.ScramAttributes;
import com.hm.postgresql.shaded.com.ongres.scram.common.exception.ScramParseException;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.StringWritable;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.StringWritableCsv;

public class ServerFirstMessage
implements StringWritable {
    public static final int ITERATION_MIN_VALUE = 4096;
    private final String clientNonce;
    private final String serverNonce;
    private final String salt;
    private final int iteration;

    public ServerFirstMessage(String string, String string2, String string3, int n) {
        this.clientNonce = Preconditions.checkNotEmpty(string, "clientNonce");
        this.serverNonce = Preconditions.checkNotEmpty(string2, "serverNonce");
        this.salt = Preconditions.checkNotEmpty(string3, "salt");
        Preconditions.checkArgument(n >= 4096, "iteration must be >= 4096");
        this.iteration = n;
    }

    public String getClientNonce() {
        return this.clientNonce;
    }

    public String getServerNonce() {
        return this.serverNonce;
    }

    public String getNonce() {
        return this.clientNonce + this.serverNonce;
    }

    public String getSalt() {
        return this.salt;
    }

    public int getIteration() {
        return this.iteration;
    }

    @Override
    public StringBuffer writeTo(StringBuffer stringBuffer) {
        return StringWritableCsv.writeTo(stringBuffer, new ScramAttributeValue(ScramAttributes.NONCE, this.getNonce()), new ScramAttributeValue(ScramAttributes.SALT, this.salt), new ScramAttributeValue(ScramAttributes.ITERATION, this.iteration + ""));
    }

    public static ServerFirstMessage parseFrom(String string, String string2) {
        int n;
        Preconditions.checkNotEmpty(string, "serverFirstMessage");
        Preconditions.checkNotEmpty(string2, "clientNonce");
        String[] stringArray = StringWritableCsv.parseFrom(string, 3, 0);
        if (stringArray.length != 3) {
            throw new ScramParseException("Invalid server-first-message");
        }
        ScramAttributeValue scramAttributeValue = ScramAttributeValue.parse(stringArray[0]);
        if (ScramAttributes.NONCE.getChar() != scramAttributeValue.getChar()) {
            throw new ScramParseException("serverNonce must be the 1st element of the server-first-message");
        }
        if (!scramAttributeValue.getValue().startsWith(string2)) {
            throw new ScramParseException("parsed serverNonce does not start with client serverNonce");
        }
        ScramAttributeValue scramAttributeValue2 = ScramAttributeValue.parse(stringArray[1]);
        if (ScramAttributes.SALT.getChar() != scramAttributeValue2.getChar()) {
            throw new ScramParseException("salt must be the 2nd element of the server-first-message");
        }
        ScramAttributeValue scramAttributeValue3 = ScramAttributeValue.parse(stringArray[2]);
        if (ScramAttributes.ITERATION.getChar() != scramAttributeValue3.getChar()) {
            throw new ScramParseException("iteration must be the 3rd element of the server-first-message");
        }
        try {
            n = Integer.parseInt(scramAttributeValue3.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ScramParseException("invalid iteration");
        }
        return new ServerFirstMessage(string2, scramAttributeValue.getValue().substring(string2.length()), scramAttributeValue2.getValue(), n);
    }

    public String toString() {
        return this.writeTo(new StringBuffer()).toString();
    }
}

