/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.shaded.com.ongres.scram.common.util;

import com.hm.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import com.hm.postgresql.shaded.com.ongres.scram.common.util.StringWritable;
import java.util.Arrays;

public class StringWritableCsv {
    private static void writeStringWritableToStringBuffer(StringWritable stringWritable, StringBuffer stringBuffer) {
        if (null != stringWritable) {
            stringWritable.writeTo(stringBuffer);
        }
    }

    public static StringBuffer writeTo(StringBuffer stringBuffer, StringWritable ... stringWritableArray) {
        Preconditions.checkNotNull(stringBuffer, "sb");
        if (null == stringWritableArray || stringWritableArray.length == 0) {
            return stringBuffer;
        }
        StringWritableCsv.writeStringWritableToStringBuffer(stringWritableArray[0], stringBuffer);
        for (int i = 1; i < stringWritableArray.length; ++i) {
            stringBuffer.append(',');
            StringWritableCsv.writeStringWritableToStringBuffer(stringWritableArray[i], stringBuffer);
        }
        return stringBuffer;
    }

    public static String[] parseFrom(String string, int n, int n2) {
        Preconditions.checkNotNull(string, "value");
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Limit and offset have to be >= 0");
        }
        if (string.isEmpty()) {
            return new String[0];
        }
        String[] stringArray = string.split(",");
        if (stringArray.length < n2) {
            throw new IllegalArgumentException("Not enough items for the given offset");
        }
        return Arrays.copyOfRange(stringArray, n2, (n == 0 ? stringArray.length : n) + n2);
    }

    public static String[] parseFrom(String string, int n) {
        return StringWritableCsv.parseFrom(string, n, 0);
    }

    public static String[] parseFrom(String string) {
        return StringWritableCsv.parseFrom(string, 0, 0);
    }
}

