/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.ssl;

import com.hm.postgresql.ssl.LibPQFactory;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LazyKeyManager
implements X509KeyManager {
    private X509Certificate @Nullable [] cert = null;
    private @Nullable PrivateKey key = null;
    private final @Nullable String certfile;
    private final @Nullable String keyfile;
    private final CallbackHandler cbh;
    private final boolean defaultfile;
    private @Nullable PSQLException error = null;

    public LazyKeyManager(@Nullable String string, @Nullable String string2, CallbackHandler callbackHandler, boolean bl) {
        this.certfile = string;
        this.keyfile = string2;
        this.cbh = callbackHandler;
        this.defaultfile = bl;
    }

    public void throwKeyManagerException() {
        if (this.error != null) {
            throw this.error;
        }
    }

    @Override
    public @Nullable String chooseClientAlias(String[] stringArray, Principal @Nullable [] principalArray, @Nullable Socket socket) {
        if (this.certfile == null) {
            return null;
        }
        if (principalArray == null || principalArray.length == 0) {
            return "user";
        }
        X509Certificate[] x509CertificateArray = this.getCertificateChain("user");
        if (x509CertificateArray == null) {
            return null;
        }
        X500Principal x500Principal = x509CertificateArray[x509CertificateArray.length - 1].getIssuerX500Principal();
        boolean bl = false;
        for (Principal principal : principalArray) {
            if (!x500Principal.equals(principal)) continue;
            bl = true;
        }
        return bl ? "user" : null;
    }

    @Override
    public @Nullable String chooseServerAlias(String string, Principal @Nullable [] principalArray, @Nullable Socket socket) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public X509Certificate @Nullable [] getCertificateChain(String string) {
        Collection<? extends Certificate> collection;
        block18: {
            CertificateFactory certificateFactory;
            if (this.cert != null) return this.cert;
            if (this.certfile == null) return this.cert;
            try {
                certificateFactory = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException certificateException) {
                this.error = new PSQLException(GT.tr("Could not find a java cryptographic algorithm: X.509 CertificateFactory not available.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)certificateException);
                return null;
            }
            FileInputStream fileInputStream = null;
            fileInputStream = new FileInputStream(this.certfile);
            collection = certificateFactory.generateCertificates(fileInputStream);
            if (fileInputStream == null) break block18;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                if (!this.defaultfile) {
                    this.error = new PSQLException(GT.tr("Could not close SSL certificate file {0}.", this.certfile), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
                }
                break block18;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!this.defaultfile) {
                    this.error = new PSQLException(GT.tr("Could not open SSL certificate file {0}.", this.certfile), PSQLState.CONNECTION_FAILURE, (Throwable)fileNotFoundException);
                }
                X509Certificate[] x509CertificateArray = null;
                if (fileInputStream == null) return x509CertificateArray;
                {
                    catch (Throwable throwable) {
                        if (fileInputStream == null) throw throwable;
                        try {
                            fileInputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            if (this.defaultfile) throw throwable;
                            this.error = new PSQLException(GT.tr("Could not close SSL certificate file {0}.", this.certfile), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
                        }
                        throw throwable;
                    }
                }
                try {
                    fileInputStream.close();
                    return x509CertificateArray;
                }
                catch (IOException iOException) {
                    if (this.defaultfile) return x509CertificateArray;
                    this.error = new PSQLException(GT.tr("Could not close SSL certificate file {0}.", this.certfile), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
                }
                return x509CertificateArray;
                catch (CertificateException certificateException) {
                    this.error = new PSQLException(GT.tr("Loading the SSL certificate {0} into a KeyManager failed.", this.certfile), PSQLState.CONNECTION_FAILURE, (Throwable)certificateException);
                    X509Certificate[] x509CertificateArray2 = null;
                    if (fileInputStream == null) return x509CertificateArray2;
                    try {
                        fileInputStream.close();
                        return x509CertificateArray2;
                    }
                    catch (IOException iOException) {
                        if (this.defaultfile) return x509CertificateArray2;
                        this.error = new PSQLException(GT.tr("Could not close SSL certificate file {0}.", this.certfile), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
                    }
                    return x509CertificateArray2;
                }
            }
        }
        this.cert = collection.toArray(new X509Certificate[0]);
        return this.cert;
    }

    @Override
    public String @Nullable [] getClientAliases(String string, Principal @Nullable [] principalArray) {
        String[] stringArray;
        String string2 = this.chooseClientAlias(new String[]{string}, principalArray, null);
        if (string2 == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string2;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFileFully(String string) {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");){
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @Override
    public @Nullable PrivateKey getPrivateKey(String string) {
        block15: {
            try {
                byte[] byArray;
                if (this.key != null || this.keyfile == null) break block15;
                X509Certificate[] x509CertificateArray = this.getCertificateChain("user");
                if (x509CertificateArray == null || x509CertificateArray.length == 0) {
                    return null;
                }
                try {
                    byArray = LazyKeyManager.readFileFully(this.keyfile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!this.defaultfile) {
                        throw fileNotFoundException;
                    }
                    return null;
                }
                KeyFactory keyFactory = KeyFactory.getInstance(x509CertificateArray[0].getPublicKey().getAlgorithm());
                try {
                    PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
                    this.key = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    Cipher cipher;
                    EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
                    try {
                        cipher = Cipher.getInstance(encryptedPrivateKeyInfo.getAlgName());
                    }
                    catch (NoSuchPaddingException noSuchPaddingException) {
                        throw new NoSuchAlgorithmException(noSuchPaddingException.getMessage(), noSuchPaddingException);
                    }
                    PasswordCallback passwordCallback = new PasswordCallback(GT.tr("Enter SSL password: ", new Object[0]), false);
                    try {
                        this.cbh.handle(new Callback[]{passwordCallback});
                    }
                    catch (UnsupportedCallbackException unsupportedCallbackException) {
                        this.error = this.cbh instanceof LibPQFactory.ConsoleCallbackHandler && "Console is not available".equals(unsupportedCallbackException.getMessage()) ? new PSQLException(GT.tr("Could not read password for SSL key file, console is not available.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)unsupportedCallbackException) : new PSQLException(GT.tr("Could not read password for SSL key file by callbackhandler {0}.", this.cbh.getClass().getName()), PSQLState.CONNECTION_FAILURE, (Throwable)unsupportedCallbackException);
                        return null;
                    }
                    try {
                        PBEKeySpec pBEKeySpec = new PBEKeySpec(passwordCallback.getPassword());
                        passwordCallback.clearPassword();
                        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
                        SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
                        AlgorithmParameters algorithmParameters = encryptedPrivateKeyInfo.getAlgParameters();
                        cipher.init(2, (Key)secretKey, algorithmParameters);
                        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = encryptedPrivateKeyInfo.getKeySpec(cipher);
                        this.key = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        this.error = new PSQLException(GT.tr("Could not decrypt SSL key file {0}.", this.keyfile), PSQLState.CONNECTION_FAILURE, (Throwable)generalSecurityException);
                        return null;
                    }
                }
            }
            catch (IOException iOException) {
                this.error = new PSQLException(GT.tr("Could not read SSL key file {0}.", this.keyfile), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.error = new PSQLException(GT.tr("Could not find a java cryptographic algorithm: {0}.", noSuchAlgorithmException.getMessage()), PSQLState.CONNECTION_FAILURE, (Throwable)noSuchAlgorithmException);
                return null;
            }
        }
        return this.key;
    }

    @Override
    public String @Nullable [] getServerAliases(String string, Principal @Nullable [] principalArray) {
        return new String[0];
    }
}

