/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.ssl;

import com.hm.postgresql.PGProperty;
import com.hm.postgresql.jdbc.SslMode;
import com.hm.postgresql.ssl.LazyKeyManager;
import com.hm.postgresql.ssl.NonValidatingFactory;
import com.hm.postgresql.ssl.PKCS12KeyManager;
import com.hm.postgresql.ssl.WrappedFactory;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.ObjectFactory;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.io.Console;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LibPQFactory
extends WrappedFactory {
    @Nullable KeyManager km;
    boolean defaultfile;

    private CallbackHandler getCallbackHandler(@UnderInitialization(value=WrappedFactory.class) LibPQFactory this, Properties properties) {
        CallbackHandler callbackHandler;
        String string = PGProperty.SSL_PASSWORD_CALLBACK.get(properties);
        if (string != null) {
            try {
                callbackHandler = (CallbackHandler)ObjectFactory.instantiate(string, properties, false, null);
            }
            catch (Exception exception) {
                throw new PSQLException(GT.tr("The password callback class provided {0} could not be instantiated.", string), PSQLState.CONNECTION_FAILURE, (Throwable)exception);
            }
        } else {
            callbackHandler = new ConsoleCallbackHandler(PGProperty.SSL_PASSWORD.get(properties));
        }
        return callbackHandler;
    }

    private void initPk8(@UnderInitialization(value=WrappedFactory.class) LibPQFactory this, String string, String string2, Properties properties) {
        String string3 = PGProperty.SSL_CERT.get(properties);
        if (string3 == null) {
            this.defaultfile = true;
            string3 = string2 + "postgresql.crt";
        }
        this.km = new LazyKeyManager("".equals(string3) ? null : string3, "".equals(string) ? null : string, this.getCallbackHandler(properties), this.defaultfile);
    }

    private void initP12(@UnderInitialization(value=WrappedFactory.class) LibPQFactory this, String string, Properties properties) {
        this.km = new PKCS12KeyManager(string, this.getCallbackHandler(properties));
    }

    public LibPQFactory(Properties properties) {
        try {
            Object object;
            TrustManager[] trustManagerArray;
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            String string = System.getProperty("file.separator");
            String string2 = System.getProperty("os.name").toLowerCase().contains("windows") ? System.getenv("APPDATA") + string + "postgresql" + string : System.getProperty("user.home") + string + ".postgresql" + string;
            String string3 = PGProperty.SSL_KEY.get(properties);
            if (string3 == null) {
                this.defaultfile = true;
                string3 = string2 + "postgresql.pk8";
            }
            if (string3.endsWith(".p12") || string3.endsWith(".pfx")) {
                this.initP12(string3, properties);
            } else {
                this.initPk8(string3, string2, properties);
            }
            SslMode sslMode = SslMode.of(properties);
            if (!sslMode.verifyCertificate()) {
                trustManagerArray = new TrustManager[]{new NonValidatingFactory.NonValidatingTM()};
            } else {
                FileInputStream fileInputStream;
                KeyStore keyStore;
                object = TrustManagerFactory.getInstance("PKIX");
                try {
                    keyStore = KeyStore.getInstance("jks");
                }
                catch (KeyStoreException keyStoreException) {
                    throw new NoSuchAlgorithmException("jks KeyStore not available");
                }
                String string4 = PGProperty.SSL_ROOT_CERT.get(properties);
                if (string4 == null) {
                    string4 = string2 + "root.crt";
                }
                try {
                    fileInputStream = new FileInputStream(string4);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new PSQLException(GT.tr("Could not open SSL root certificate file {0}.", string4), PSQLState.CONNECTION_FAILURE, (Throwable)fileNotFoundException);
                }
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    Certificate[] certificateArray = certificateFactory.generateCertificates(fileInputStream).toArray(new Certificate[0]);
                    keyStore.load(null, null);
                    for (int i = 0; i < certificateArray.length; ++i) {
                        keyStore.setCertificateEntry("cert" + i, certificateArray[i]);
                    }
                    ((TrustManagerFactory)object).init(keyStore);
                }
                catch (IOException iOException) {
                    throw new PSQLException(GT.tr("Could not read SSL root certificate file {0}.", string4), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new PSQLException(GT.tr("Loading the SSL root certificate {0} into a TrustManager failed.", string4), PSQLState.CONNECTION_FAILURE, (Throwable)generalSecurityException);
                }
                finally {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                trustManagerArray = ((TrustManagerFactory)object).getTrustManagers();
            }
            try {
                KeyManager[] keyManagerArray;
                object = this.km;
                if (object == null) {
                    keyManagerArray = null;
                } else {
                    KeyManager[] keyManagerArray2 = new KeyManager[1];
                    keyManagerArray = keyManagerArray2;
                    keyManagerArray2[0] = object;
                }
                sSLContext.init(keyManagerArray, trustManagerArray, null);
            }
            catch (KeyManagementException keyManagementException) {
                throw new PSQLException(GT.tr("Could not initialize SSL context.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)keyManagementException);
            }
            this.factory = sSLContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PSQLException(GT.tr("Could not find a java cryptographic algorithm: {0}.", noSuchAlgorithmException.getMessage()), PSQLState.CONNECTION_FAILURE, (Throwable)noSuchAlgorithmException);
        }
    }

    public void throwKeyManagerException() {
        if (this.km != null) {
            if (this.km instanceof LazyKeyManager) {
                ((LazyKeyManager)this.km).throwKeyManagerException();
            }
            if (this.km instanceof PKCS12KeyManager) {
                ((PKCS12KeyManager)this.km).throwKeyManagerException();
            }
        }
    }

    public static class ConsoleCallbackHandler
    implements CallbackHandler {
        private char @Nullable [] password = null;

        ConsoleCallbackHandler(@Nullable String string) {
            if (string != null) {
                this.password = string.toCharArray();
            }
        }

        @Override
        public void handle(Callback[] callbackArray) {
            Console console = System.console();
            char[] cArray = this.password;
            if (console == null && cArray == null) {
                throw new UnsupportedCallbackException(callbackArray[0], "Console is not available");
            }
            for (Callback callback : callbackArray) {
                if (!(callback instanceof PasswordCallback)) {
                    throw new UnsupportedCallbackException(callback);
                }
                PasswordCallback passwordCallback = (PasswordCallback)callback;
                if (cArray != null) {
                    passwordCallback.setPassword(cArray);
                    continue;
                }
                passwordCallback.setPassword(Nullness.castNonNull(console, "System.console()").readPassword("%s", passwordCallback.getPrompt()));
            }
        }
    }
}

