/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.ssl;

import com.hm.postgresql.ssl.LibPQFactory;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.io.File;
import java.io.FileInputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PKCS12KeyManager
implements X509KeyManager {
    private final CallbackHandler cbh;
    private @Nullable PSQLException error = null;
    private final String keyfile;
    private final KeyStore keyStore;
    boolean keystoreLoaded = false;

    public PKCS12KeyManager(String string, CallbackHandler callbackHandler) {
        try {
            this.keyStore = KeyStore.getInstance("pkcs12");
            this.keyfile = string;
            this.cbh = callbackHandler;
        }
        catch (KeyStoreException keyStoreException) {
            throw new PSQLException(GT.tr("Unable to find pkcs12 keystore.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)keyStoreException);
        }
    }

    public void throwKeyManagerException() {
        if (this.error != null) {
            throw this.error;
        }
    }

    @Override
    public String @Nullable [] getClientAliases(String string, Principal @Nullable [] principalArray) {
        String[] stringArray;
        String string2 = this.chooseClientAlias(new String[]{string}, principalArray, null);
        if (string2 == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string2;
        }
        return stringArray;
    }

    @Override
    public @Nullable String chooseClientAlias(String[] stringArray, Principal @Nullable [] principalArray, @Nullable Socket socket) {
        if (principalArray == null || principalArray.length == 0) {
            return "user";
        }
        X509Certificate[] x509CertificateArray = this.getCertificateChain("user");
        if (x509CertificateArray == null) {
            return null;
        }
        X500Principal x500Principal = x509CertificateArray[x509CertificateArray.length - 1].getIssuerX500Principal();
        boolean bl = false;
        for (Principal principal : principalArray) {
            if (!x500Principal.equals(principal)) continue;
            bl = true;
        }
        return bl ? "user" : null;
    }

    @Override
    public String @Nullable [] getServerAliases(String string, Principal @Nullable [] principalArray) {
        return new String[0];
    }

    @Override
    public @Nullable String chooseServerAlias(String string, Principal @Nullable [] principalArray, @Nullable Socket socket) {
        return null;
    }

    @Override
    public X509Certificate @Nullable [] getCertificateChain(String string) {
        try {
            this.loadKeyStore();
            Certificate[] certificateArray = this.keyStore.getCertificateChain(string);
            if (certificateArray == null) {
                return null;
            }
            X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
            int n = 0;
            for (Certificate certificate : certificateArray) {
                x509CertificateArray[n++] = (X509Certificate)certificate;
            }
            return x509CertificateArray;
        }
        catch (Exception exception) {
            this.error = new PSQLException(GT.tr("Could not find a java cryptographic algorithm: X.509 CertificateFactory not available.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)exception);
            return null;
        }
    }

    @Override
    public @Nullable PrivateKey getPrivateKey(String string) {
        try {
            this.loadKeyStore();
            PasswordCallback passwordCallback = new PasswordCallback(GT.tr("Enter SSL password: ", new Object[0]), false);
            this.cbh.handle(new Callback[]{passwordCallback});
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(passwordCallback.getPassword());
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry("user", passwordProtection);
            if (privateKeyEntry == null) {
                return null;
            }
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            return privateKey;
        }
        catch (Exception exception) {
            this.error = new PSQLException(GT.tr("Could not read SSL key file {0}.", this.keyfile), PSQLState.CONNECTION_FAILURE, (Throwable)exception);
            return null;
        }
    }

    private synchronized void loadKeyStore() {
        if (this.keystoreLoaded) {
            return;
        }
        PasswordCallback passwordCallback = new PasswordCallback(GT.tr("Enter SSL password: ", new Object[0]), false);
        try {
            this.cbh.handle(new Callback[]{passwordCallback});
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            this.error = this.cbh instanceof LibPQFactory.ConsoleCallbackHandler && "Console is not available".equals(unsupportedCallbackException.getMessage()) ? new PSQLException(GT.tr("Could not read password for SSL key file, console is not available.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)unsupportedCallbackException) : new PSQLException(GT.tr("Could not read password for SSL key file by callbackhandler {0}.", this.cbh.getClass().getName()), PSQLState.CONNECTION_FAILURE, (Throwable)unsupportedCallbackException);
        }
        this.keyStore.load(new FileInputStream(new File(this.keyfile)), passwordCallback.getPassword());
        this.keystoreLoaded = true;
    }
}

