/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class ByteConverter {
    private static final int NUMERIC_DSCALE_MASK = 16383;
    private static final short NUMERIC_POS = 0;
    private static final short NUMERIC_NEG = 16384;
    private static final short NUMERIC_NAN = -16384;
    private static final int SHORT_BYTES = 2;
    private static final int LONG_BYTES = 4;
    private static final int[] INT_TEN_POWERS;
    private static final long[] LONG_TEN_POWERS;
    private static final BigInteger[] BI_TEN_POWERS;
    private static final BigInteger BI_TEN_THOUSAND;
    private static final BigInteger BI_MAX_LONG;

    private ByteConverter() {
    }

    public static int bytesToInt(byte[] byArray) {
        if (byArray.length == 1) {
            return byArray[0];
        }
        if (byArray.length == 2) {
            return ByteConverter.int2(byArray, 0);
        }
        if (byArray.length == 4) {
            return ByteConverter.int4(byArray, 0);
        }
        throw new IllegalArgumentException("Argument bytes is empty");
    }

    public static Number numeric(byte[] byArray) {
        return ByteConverter.numeric(byArray, 0, byArray.length);
    }

    public static Number numeric(byte[] byArray, int n, int n2) {
        if (n2 < 8) {
            throw new IllegalArgumentException("number of bytes should be at-least 8");
        }
        int n3 = ByteConverter.int2(byArray, n);
        int n4 = ByteConverter.int2(byArray, n + 2);
        short s = ByteConverter.int2(byArray, n + 4);
        int n5 = ByteConverter.int2(byArray, n + 6);
        if (n2 != n3 * 2 + 8) {
            throw new IllegalArgumentException("invalid length of bytes \"numeric\" value");
        }
        if (s != 0 && s != 16384 && s != -16384) {
            throw new IllegalArgumentException("invalid sign in \"numeric\" value");
        }
        if (s == -16384) {
            return Double.NaN;
        }
        if ((n5 & 0x3FFF) != n5) {
            throw new IllegalArgumentException("invalid scale in \"numeric\" value");
        }
        if (n3 == 0) {
            return new BigDecimal(BigInteger.ZERO, n5);
        }
        int n6 = n + 8;
        short s2 = ByteConverter.int2(byArray, n6);
        if (n4 < 0) {
            int n7;
            assert (n5 > 0);
            int n8 = n5;
            if ((n4 = (short)(n4 + 1)) < 0) {
                n8 += 4 * n4;
            }
            for (n7 = 1; n7 < n3 && s2 == 0; ++n7) {
                n8 -= 4;
                s2 = ByteConverter.int2(byArray, n6 += 2);
            }
            BigInteger bigInteger = null;
            assert (n8 > 0);
            if (n8 >= 4) {
                n8 -= 4;
            } else {
                s2 = (short)(s2 / INT_TEN_POWERS[4 - n8]);
                n8 = 0;
            }
            long l = s2;
            while (n7 < n3) {
                if (n7 == 4 && n8 > 2) {
                    bigInteger = BigInteger.valueOf(l);
                }
                s2 = ByteConverter.int2(byArray, n6 += 2);
                if (n8 >= 4) {
                    if (bigInteger == null) {
                        l *= 10000L;
                    } else {
                        bigInteger = bigInteger.multiply(BI_TEN_THOUSAND);
                    }
                    n8 -= 4;
                } else {
                    if (bigInteger == null) {
                        l *= (long)INT_TEN_POWERS[n8];
                    } else {
                        bigInteger = bigInteger.multiply(ByteConverter.tenPower(n8));
                    }
                    s2 = (short)(s2 / INT_TEN_POWERS[4 - n8]);
                    n8 = 0;
                }
                if (bigInteger == null) {
                    l += (long)s2;
                } else if (s2 != 0) {
                    bigInteger = bigInteger.add(BigInteger.valueOf(s2));
                }
                ++n7;
            }
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l);
            }
            if (n8 > 0) {
                bigInteger = bigInteger.multiply(ByteConverter.tenPower(n8));
            }
            if (s == 16384) {
                bigInteger = bigInteger.negate();
            }
            return new BigDecimal(bigInteger, n5);
        }
        if (n5 == 0) {
            int n9;
            BigInteger bigInteger = null;
            long l = s2;
            for (n9 = 1; n9 < n3; ++n9) {
                if (n9 == 4) {
                    bigInteger = BigInteger.valueOf(l);
                }
                s2 = ByteConverter.int2(byArray, n6 += 2);
                if (bigInteger == null) {
                    l *= 10000L;
                    l += (long)s2;
                    continue;
                }
                bigInteger = bigInteger.multiply(BI_TEN_THOUSAND);
                if (s2 == 0) continue;
                bigInteger = bigInteger.add(BigInteger.valueOf(s2));
            }
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l);
            }
            if (s == 16384) {
                bigInteger = bigInteger.negate();
            }
            return (n9 = (n3 - (n4 + 1)) * 4) == 0 ? new BigDecimal(bigInteger) : new BigDecimal(bigInteger, n9).setScale(0);
        }
        BigInteger bigInteger = null;
        long l = s2;
        int n10 = n4;
        int n11 = n5;
        for (int i = 1; i < n3; ++i) {
            if (i == 4) {
                bigInteger = BigInteger.valueOf(l);
            }
            s2 = ByteConverter.int2(byArray, n6 += 2);
            if (n10 > 0) {
                --n10;
                if (bigInteger == null) {
                    l *= 10000L;
                } else {
                    bigInteger = bigInteger.multiply(BI_TEN_THOUSAND);
                }
            } else if (n11 >= 4) {
                n11 -= 4;
                if (bigInteger == null) {
                    l *= 10000L;
                } else {
                    bigInteger = bigInteger.multiply(BI_TEN_THOUSAND);
                }
            } else {
                if (bigInteger == null) {
                    l *= (long)INT_TEN_POWERS[n11];
                } else {
                    bigInteger = bigInteger.multiply(ByteConverter.tenPower(n11));
                }
                s2 = (short)(s2 / INT_TEN_POWERS[4 - n11]);
                n11 = 0;
            }
            if (bigInteger == null) {
                l += (long)s2;
                continue;
            }
            if (s2 == 0) continue;
            bigInteger = bigInteger.add(BigInteger.valueOf(s2));
        }
        if (bigInteger == null) {
            bigInteger = BigInteger.valueOf(l);
        }
        if (n10 > 0) {
            bigInteger = bigInteger.multiply(ByteConverter.tenPower(n10 * 4));
        }
        if (n11 > 0) {
            bigInteger = bigInteger.multiply(ByteConverter.tenPower(n11));
        }
        if (s == 16384) {
            bigInteger = bigInteger.negate();
        }
        return new BigDecimal(bigInteger, n5);
    }

    public static byte[] numeric(BigDecimal bigDecimal) {
        short s;
        PositiveShorts positiveShorts = new PositiveShorts();
        BigInteger bigInteger = bigDecimal.unscaledValue().abs();
        int n = bigDecimal.scale();
        if (bigInteger.equals(BigInteger.ZERO)) {
            byte[] byArray = new byte[]{0, 0, -1, -1, 0, 0, 0, 0};
            ByteConverter.int2(byArray, 6, Math.max(0, n));
            return byArray;
        }
        int n2 = -1;
        if (n <= 0) {
            if (n < 0) {
                n = Math.abs(n);
                n2 += n / 4;
                int n3 = n % 4;
                bigInteger = bigInteger.multiply(ByteConverter.tenPower(n3));
                n = 0;
            }
            while (bigInteger.compareTo(BI_MAX_LONG) > 0) {
                BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(BI_TEN_THOUSAND);
                bigInteger = bigIntegerArray[0];
                short s2 = bigIntegerArray[1].shortValue();
                if (s2 != 0 || !positiveShorts.isEmpty()) {
                    positiveShorts.push(s2);
                }
                ++n2;
            }
            long l = bigInteger.longValueExact();
            do {
                if ((s = (short)(l % 10000L)) != 0 || !positiveShorts.isEmpty()) {
                    positiveShorts.push(s);
                }
                ++n2;
            } while ((l /= 10000L) != 0L);
        } else {
            int n4;
            BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(ByteConverter.tenPower(n));
            BigInteger bigInteger2 = bigIntegerArray[1];
            BigInteger bigInteger3 = bigIntegerArray[0];
            n2 = -1;
            if (!BigInteger.ZERO.equals(bigInteger2)) {
                int n5 = n % 4;
                n4 = n / 4;
                if (n5 != 0) {
                    bigInteger2 = bigInteger2.multiply(ByteConverter.tenPower(4 - n5));
                    ++n4;
                }
                do {
                    BigInteger[] bigIntegerArray2 = bigInteger2.divideAndRemainder(BI_TEN_THOUSAND);
                    bigInteger2 = bigIntegerArray2[0];
                    short s3 = bigIntegerArray2[1].shortValue();
                    if (s3 != 0 || !positiveShorts.isEmpty()) {
                        positiveShorts.push(s3);
                    }
                    --n4;
                } while (!BigInteger.ZERO.equals(bigInteger2));
                if (BigInteger.ZERO.equals(bigInteger3)) {
                    n2 -= n4;
                } else {
                    for (int i = 0; i < n4; ++i) {
                        positiveShorts.push((short)0);
                    }
                }
            }
            while (!BigInteger.ZERO.equals(bigInteger3)) {
                ++n2;
                BigInteger[] bigIntegerArray3 = bigInteger3.divideAndRemainder(BI_TEN_THOUSAND);
                bigInteger3 = bigIntegerArray3[0];
                n4 = bigIntegerArray3[1].shortValue();
                if (n4 == 0 && positiveShorts.isEmpty()) continue;
                positiveShorts.push((short)n4);
            }
        }
        byte[] byArray = new byte[8 + 2 * positiveShorts.size()];
        int n6 = 0;
        ByteConverter.int2(byArray, n6, positiveShorts.size());
        ByteConverter.int2(byArray, n6 += 2, n2);
        ByteConverter.int2(byArray, n6 += 2, bigDecimal.signum() == -1 ? 16384 : 0);
        ByteConverter.int2(byArray, n6 += 2, Math.max(0, n));
        n6 += 2;
        while ((s = positiveShorts.pop()) != -1) {
            ByteConverter.int2(byArray, n6, s);
            n6 += 2;
        }
        return byArray;
    }

    private static BigInteger tenPower(int n) {
        return BI_TEN_POWERS.length > n ? BI_TEN_POWERS[n] : BigInteger.TEN.pow(n);
    }

    public static long int8(byte[] byArray, int n) {
        return ((long)(byArray[n + 0] & 0xFF) << 56) + ((long)(byArray[n + 1] & 0xFF) << 48) + ((long)(byArray[n + 2] & 0xFF) << 40) + ((long)(byArray[n + 3] & 0xFF) << 32) + ((long)(byArray[n + 4] & 0xFF) << 24) + ((long)(byArray[n + 5] & 0xFF) << 16) + ((long)(byArray[n + 6] & 0xFF) << 8) + (long)(byArray[n + 7] & 0xFF);
    }

    public static int int4(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
    }

    public static short int2(byte[] byArray, int n) {
        return (short)(((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF));
    }

    public static boolean bool(byte[] byArray, int n) {
        return byArray[n] == 1;
    }

    public static float float4(byte[] byArray, int n) {
        return Float.intBitsToFloat(ByteConverter.int4(byArray, n));
    }

    public static double float8(byte[] byArray, int n) {
        return Double.longBitsToDouble(ByteConverter.int8(byArray, n));
    }

    public static void int8(byte[] byArray, int n, long l) {
        byArray[n + 0] = (byte)(l >>> 56);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 7] = (byte)l;
    }

    public static void int4(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 >>> 24);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 3] = (byte)n2;
    }

    public static void int2(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 >>> 8);
        byArray[n + 1] = (byte)n2;
    }

    public static void bool(byte[] byArray, int n, boolean bl) {
        byArray[n] = bl ? (byte)1 : 0;
    }

    public static void float4(byte[] byArray, int n, float f) {
        ByteConverter.int4(byArray, n, Float.floatToRawIntBits(f));
    }

    public static void float8(byte[] byArray, int n, double d) {
        ByteConverter.int8(byArray, n, Double.doubleToRawLongBits(d));
    }

    static {
        int n;
        INT_TEN_POWERS = new int[6];
        LONG_TEN_POWERS = new long[19];
        BI_TEN_POWERS = new BigInteger[32];
        BI_TEN_THOUSAND = BigInteger.valueOf(10000L);
        BI_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
        for (n = 0; n < INT_TEN_POWERS.length; ++n) {
            ByteConverter.INT_TEN_POWERS[n] = (int)Math.pow(10.0, n);
        }
        for (n = 0; n < LONG_TEN_POWERS.length; ++n) {
            ByteConverter.LONG_TEN_POWERS[n] = (long)Math.pow(10.0, n);
        }
        for (n = 0; n < BI_TEN_POWERS.length; ++n) {
            ByteConverter.BI_TEN_POWERS[n] = BigInteger.TEN.pow(n);
        }
    }

    private static final class PositiveShorts {
        private short[] shorts = new short[8];
        private int idx = 0;

        PositiveShorts() {
        }

        public void push(short s) {
            if (s < 0) {
                throw new IllegalArgumentException("only non-negative values accepted: " + s);
            }
            if (this.idx == this.shorts.length) {
                this.grow();
            }
            this.shorts[this.idx++] = s;
        }

        public int size() {
            return this.idx;
        }

        public boolean isEmpty() {
            return this.idx == 0;
        }

        public short pop() {
            return this.idx > 0 ? this.shorts[--this.idx] : (short)-1;
        }

        private void grow() {
            int n = this.shorts.length <= 1024 ? this.shorts.length << 1 : (int)((double)this.shorts.length * 1.5);
            this.shorts = Arrays.copyOf(this.shorts, n);
        }
    }
}

