/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.util;

import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PGobject;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGInterval
extends PGobject
implements Serializable,
Cloneable {
    private static final int MICROS_IN_SECOND = 1000000;
    private int years;
    private int months;
    private int days;
    private int hours;
    private int minutes;
    private int wholeSeconds;
    private int microSeconds;
    private boolean isNull;

    public PGInterval() {
        this.type = "interval";
    }

    public PGInterval(String string) {
        this();
        this.setValue(string);
    }

    private int lookAhead(String string, int n, String string2) {
        char[] cArray = string2.toCharArray();
        int n2 = -1;
        for (int i = 0; i < cArray.length; ++i) {
            n2 = string.indexOf(cArray[i], n);
            if (n2 <= 0) continue;
            return n2;
        }
        return n2;
    }

    private void parseISO8601Format(String string) {
        int n;
        int n2;
        String string2;
        int n3 = 0;
        String string3 = null;
        int n4 = string.indexOf(84);
        if (n4 > 0) {
            string2 = string.substring(1, n4);
            string3 = string.substring(n4 + 1);
        } else {
            string2 = string.substring(1);
        }
        for (n2 = 0; n2 < string2.length(); ++n2) {
            n = this.lookAhead(string2, n2, "YMD");
            if (n <= 0) continue;
            n3 = Integer.parseInt(string2.substring(n2, n));
            if (string2.charAt(n) == 'Y') {
                this.setYears(n3);
            } else if (string2.charAt(n) == 'M') {
                this.setMonths(n3);
            } else if (string2.charAt(n) == 'D') {
                this.setDays(n3);
            }
            n2 = n;
        }
        if (string3 != null) {
            for (n2 = 0; n2 < string3.length(); ++n2) {
                n = this.lookAhead(string3, n2, "HMS");
                if (n <= 0) continue;
                n3 = Integer.parseInt(string3.substring(n2, n));
                if (string3.charAt(n) == 'H') {
                    this.setHours(n3);
                } else if (string3.charAt(n) == 'M') {
                    this.setMinutes(n3);
                } else if (string3.charAt(n) == 'S') {
                    this.setSeconds(n3);
                }
                n2 = n;
            }
        }
    }

    public PGInterval(int n, int n2, int n3, int n4, int n5, double d) {
        this();
        this.setValue(n, n2, n3, n4, n5, d);
    }

    @Override
    public void setValue(@Nullable String string) {
        boolean bl;
        boolean bl2 = this.isNull = string == null;
        if (string == null) {
            this.setValue(0, 0, 0, 0, 0, 0.0);
            this.isNull = true;
            return;
        }
        boolean bl3 = bl = !string.startsWith("@");
        if (string.startsWith("P")) {
            this.parseISO8601Format(string);
            return;
        }
        if (!bl && string.length() == 3 && string.charAt(2) == '0') {
            this.setValue(0, 0, 0, 0, 0, 0.0);
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        try {
            String string2 = null;
            string = string.replace('+', ' ').replace('@', ' ');
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n6 = 1;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (n6 & true) {
                    int n7 = string3.indexOf(58);
                    if (n7 == -1) {
                        string2 = string3;
                    } else {
                        int n8 = string3.charAt(0) == '-' ? 1 : 0;
                        n4 = PGInterval.nullSafeIntGet(string3.substring(n8 + 0, n7));
                        n5 = PGInterval.nullSafeIntGet(string3.substring(n7 + 1, n7 + 3));
                        int n9 = string3.indexOf(58, n7 + 1);
                        if (n9 != -1) {
                            d = PGInterval.nullSafeDoubleGet(string3.substring(n9 + 1));
                        }
                        if (n8 == 1) {
                            n4 = -n4;
                            n5 = -n5;
                            d = -d;
                        }
                        string2 = null;
                    }
                } else if (string3.startsWith("year")) {
                    n = PGInterval.nullSafeIntGet(string2);
                } else if (string3.startsWith("mon")) {
                    n2 = PGInterval.nullSafeIntGet(string2);
                } else if (string3.startsWith("day")) {
                    n3 = PGInterval.nullSafeIntGet(string2);
                } else if (string3.startsWith("hour")) {
                    n4 = PGInterval.nullSafeIntGet(string2);
                } else if (string3.startsWith("min")) {
                    n5 = PGInterval.nullSafeIntGet(string2);
                } else if (string3.startsWith("sec")) {
                    d = PGInterval.nullSafeDoubleGet(string2);
                }
                ++n6;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException(GT.tr("Conversion of interval failed", new Object[0]), PSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE, (Throwable)numberFormatException);
        }
        if (!bl && string.endsWith("ago")) {
            this.setValue(-n, -n2, -n3, -n4, -n5, -d);
        } else {
            this.setValue(n, n2, n3, n4, n5, d);
        }
    }

    public void setValue(int n, int n2, int n3, int n4, int n5, double d) {
        this.setYears(n);
        this.setMonths(n2);
        this.setDays(n3);
        this.setHours(n4);
        this.setMinutes(n5);
        this.setSeconds(d);
    }

    @Override
    public @Nullable String getValue() {
        if (this.isNull) {
            return null;
        }
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        decimalFormat.applyPattern("0.0#####");
        return String.format(Locale.ROOT, "%d years %d mons %d days %d hours %d mins %s secs", this.years, this.months, this.days, this.hours, this.minutes, decimalFormat.format(this.getSeconds()));
    }

    public int getYears() {
        return this.years;
    }

    public void setYears(int n) {
        this.isNull = false;
        this.years = n;
    }

    public int getMonths() {
        return this.months;
    }

    public void setMonths(int n) {
        this.isNull = false;
        this.months = n;
    }

    public int getDays() {
        return this.days;
    }

    public void setDays(int n) {
        this.isNull = false;
        this.days = n;
    }

    public int getHours() {
        return this.hours;
    }

    public void setHours(int n) {
        this.isNull = false;
        this.hours = n;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setMinutes(int n) {
        this.isNull = false;
        this.minutes = n;
    }

    public double getSeconds() {
        return (double)this.wholeSeconds + (double)this.microSeconds / 1000000.0;
    }

    public int getWholeSeconds() {
        return this.wholeSeconds;
    }

    public int getMicroSeconds() {
        return this.microSeconds;
    }

    public void setSeconds(double d) {
        this.isNull = false;
        this.wholeSeconds = (int)d;
        this.microSeconds = (int)Math.round((d - (double)this.wholeSeconds) * 1000000.0);
    }

    public void add(Calendar calendar) {
        if (this.isNull) {
            return;
        }
        int n = (this.microSeconds + (this.microSeconds < 0 ? -500 : 500)) / 1000 + this.wholeSeconds * 1000;
        calendar.add(14, n);
        calendar.add(12, this.getMinutes());
        calendar.add(10, this.getHours());
        calendar.add(5, this.getDays());
        calendar.add(2, this.getMonths());
        calendar.add(1, this.getYears());
    }

    public void add(Date date) {
        if (this.isNull) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.add(calendar);
        date.setTime(calendar.getTime().getTime());
    }

    public void add(PGInterval pGInterval) {
        if (this.isNull || pGInterval.isNull) {
            return;
        }
        pGInterval.setYears(pGInterval.getYears() + this.getYears());
        pGInterval.setMonths(pGInterval.getMonths() + this.getMonths());
        pGInterval.setDays(pGInterval.getDays() + this.getDays());
        pGInterval.setHours(pGInterval.getHours() + this.getHours());
        pGInterval.setMinutes(pGInterval.getMinutes() + this.getMinutes());
        pGInterval.setSeconds(pGInterval.getSeconds() + this.getSeconds());
    }

    public void scale(int n) {
        if (this.isNull) {
            return;
        }
        this.setYears(n * this.getYears());
        this.setMonths(n * this.getMonths());
        this.setDays(n * this.getDays());
        this.setHours(n * this.getHours());
        this.setMinutes(n * this.getMinutes());
        this.setSeconds((double)n * this.getSeconds());
    }

    private static int nullSafeIntGet(@Nullable String string) {
        return string == null ? 0 : Integer.parseInt(string);
    }

    private static double nullSafeDoubleGet(@Nullable String string) {
        return string == null ? 0.0 : Double.parseDouble(string);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof PGInterval)) {
            return false;
        }
        PGInterval pGInterval = (PGInterval)object;
        if (this.isNull) {
            return pGInterval.isNull;
        }
        if (pGInterval.isNull) {
            return false;
        }
        return pGInterval.years == this.years && pGInterval.months == this.months && pGInterval.days == this.days && pGInterval.hours == this.hours && pGInterval.minutes == this.minutes && pGInterval.wholeSeconds == this.wholeSeconds && pGInterval.microSeconds == this.microSeconds;
    }

    @Override
    public int hashCode() {
        if (this.isNull) {
            return 0;
        }
        return (((((((248 + this.microSeconds) * 31 + this.wholeSeconds) * 31 + this.minutes) * 31 + this.hours) * 31 + this.days) * 31 + this.months) * 31 + this.years) * 31;
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

