/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.util;

import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PGobject;
import com.hm.postgresql.util.PGtokenizer;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGmoney
extends PGobject
implements Serializable,
Cloneable {
    public double val;
    public boolean isNull;

    public PGmoney(double d) {
        this();
        this.val = d;
    }

    public PGmoney(String string) {
        this();
        this.setValue(string);
    }

    public PGmoney() {
        this.type = "money";
    }

    @Override
    public void setValue(@Nullable String string) {
        boolean bl = this.isNull = string == null;
        if (string == null) {
            return;
        }
        try {
            boolean bl2 = string.charAt(0) == '(';
            String string2 = PGtokenizer.removePara(string).substring(1);
            int n = string2.indexOf(44);
            while (n != -1) {
                string2 = string2.substring(0, n) + string2.substring(n + 1);
                n = string2.indexOf(44);
            }
            this.val = Double.parseDouble(string2);
            this.val = bl2 ? -this.val : this.val;
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException(GT.tr("Conversion of money failed.", new Object[0]), PSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE, (Throwable)numberFormatException);
        }
    }

    @Override
    public int hashCode() {
        if (this.isNull) {
            return 0;
        }
        int n = 31;
        int n2 = super.hashCode();
        long l = Double.doubleToLongBits(this.val);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        return n2;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof PGmoney) {
            PGmoney pGmoney = (PGmoney)object;
            if (this.isNull) {
                return pGmoney.isNull;
            }
            if (pGmoney.isNull) {
                return false;
            }
            return this.val == pGmoney.val;
        }
        return false;
    }

    @Override
    public @Nullable String getValue() {
        if (this.isNull) {
            return null;
        }
        if (this.val < 0.0) {
            return "-$" + -this.val;
        }
        return "$" + this.val;
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

