/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.util;

import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public class ReaderInputStream
extends InputStream {
    private static final int DEFAULT_CHAR_BUFFER_SIZE = 8192;
    private final Reader reader;
    private final CharsetEncoder encoder;
    private final ByteBuffer bbuf;
    private final CharBuffer cbuf;
    private boolean endOfInput;
    private final byte[] oneByte = new byte[1];

    public ReaderInputStream(Reader reader) {
        this(reader, 8192);
    }

    ReaderInputStream(Reader reader, int n) {
        if (reader == null) {
            throw new IllegalArgumentException("reader cannot be null");
        }
        if (n < 2) {
            throw new IllegalArgumentException("charBufferSize must be at least 2 chars");
        }
        this.reader = reader;
        this.encoder = StandardCharsets.UTF_8.newEncoder();
        this.bbuf = ByteBuffer.allocate(3 * n);
        this.bbuf.flip();
        this.cbuf = CharBuffer.allocate(n);
        this.cbuf.flip();
    }

    private void advance() {
        assert (!this.endOfInput);
        assert (!this.bbuf.hasRemaining()) : "advance() should be called when output byte buffer is empty. bbuf: " + this.bbuf + ", as string: " + this.bbuf.asCharBuffer().toString();
        assert (this.cbuf.remaining() < 2);
        if (this.cbuf.remaining() == 0) {
            this.cbuf.clear();
        } else {
            this.cbuf.compact();
        }
        int n = this.reader.read(this.cbuf);
        this.cbuf.flip();
        this.endOfInput = n == -1;
        this.bbuf.clear();
        CoderResult coderResult = this.encoder.encode(this.cbuf, this.bbuf, this.endOfInput);
        this.checkEncodeResult(coderResult);
        if (this.endOfInput) {
            coderResult = this.encoder.flush(this.bbuf);
            this.checkEncodeResult(coderResult);
        }
        this.bbuf.flip();
    }

    private void checkEncodeResult(CoderResult coderResult) {
        if (coderResult.isError()) {
            coderResult.throwException();
        }
    }

    @Override
    public int read() {
        int n = 0;
        while (n != -1) {
            n = this.read(this.oneByte);
            if (n <= 0) continue;
            return this.oneByte[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.endOfInput && !this.bbuf.hasRemaining()) {
            return -1;
        }
        int n3 = 0;
        while (n2 > 0 && !this.endOfInput) {
            if (this.bbuf.hasRemaining()) {
                int n4 = Math.min(n2, this.bbuf.remaining());
                this.bbuf.get(byArray, n, n4);
                n3 += n4;
                n += n4;
                if ((n2 -= n4) == 0) {
                    return n3;
                }
            }
            this.advance();
        }
        if (this.endOfInput && !this.bbuf.hasRemaining() && n3 == 0) {
            return -1;
        }
        return n3;
    }

    @Override
    public void close() {
        this.endOfInput = true;
        this.reader.close();
    }
}

