/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.chest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.jetbrains.annotations.Nullable;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.ChestType;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.containers.Container;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.ChestPage;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.title.ChestTitle;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.SellType;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.SortStatus;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sorter.SortType;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.ChunkLocation;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.InteractiveInventory;

public interface AdvancedChest<I, T extends ChestPage<I>> {
    public UUID getUniqueId();

    public Map<Integer, T> getPages();

    public String getConfigType();

    public ChestType getChestType();

    public Container getContainer();

    public Integer getSize();

    public ChestTitle getChestTitle();

    public UUID getWhoPlaced();

    public void setWhoPlaced(UUID var1);

    public boolean isAutomaticSellsStatus();

    public void setAutomaticSellsStatus(boolean var1);

    public UUID getAutomaticSellsSessionOwner();

    public void setAutomaticSellsSessionOwner(UUID var1);

    public double getMoney();

    public void setMoney(double var1);

    public Set<InteractiveInventory> getSubInventories();

    public ChunkLocation getChunkLocation();

    public boolean isEntityLoaded();

    public void loadEntity();

    public void unLoadEntity();

    public void openPage(HumanEntity var1, int var2);

    public void expandSlots(int var1);

    public void upgrade(String var1, @Nullable Player var2);

    /*
     * WARNING - void declaration
     */
    @Deprecated
    default public void upgrade(String upgrade) {
        void var1_1;
        this.upgrade((String)var1_1, null);
    }

    public void updatePages();

    public void remove(@Nullable BlockBreakEvent var1, @Nullable Player var2, boolean var3);

    public void handleExplosion(List<Block> var1, @Nullable Entity var2);

    public SortStatus sort(SortType var1);

    public void sell(@Nullable Player var1, SellType var2);

    public boolean smelt();

    public void compress(@Nullable Player var1);

    default public void closeForViewers() {
        for (ChestPage interactiveInventory : this.getPages().values()) {
            interactiveInventory.closeForViewers();
        }
        for (InteractiveInventory interactiveInventory : this.getSubInventories()) {
            interactiveInventory.closeForViewers();
        }
    }

    public void save();

    default public T getPlayerPage(Player player) {
        for (ChestPage page : this.getPages().values()) {
            for (HumanEntity humanEntity : page.getBukkitInventory().getViewers()) {
                Player viewer = (Player)humanEntity;
                if (!player.equals(viewer)) continue;
                return (T)page;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    default public T getPageById(int id) {
        void var1_1;
        return (T)((ChestPage)this.getPages().get((int)var1_1));
    }

    public T[] getOrderedPages();

    /*
     * WARNING - void declaration
     */
    default public List<I> getAllContent() {
        void var1_1;
        ArrayList content = new ArrayList();
        for (ChestPage page : this.getPages().values()) {
            void var3_3;
            content.addAll(Arrays.asList(var3_3.getItems()));
        }
        return var1_1;
    }

    public Location getLocation();

    public BlockFace getDirection();

    public int getSlotsUsed();

    default public int getSlotsLeft() {
        return this.getSize() - this.getSlotsUsed();
    }

    public boolean isPlayerChangingPage(Player var1);

    public InteractiveInventory getSubInventoryByName(String var1);

    public boolean isBeingSold();

    public boolean isBeingCompressed();

    public boolean canBeLoaded();
}

