/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.chest;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.event.inventory.InventoryType;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.containers.BarrelContainer;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.containers.ChestContainer;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.containers.Container;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.containers.ShulkerBoxContainer;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.xseries.XMaterial;

public enum ContainerType {
    CHEST(XMaterial.CHEST, 8, Arrays.asList(BlockFace.UP, BlockFace.DOWN)),
    SHULKER_BOX(XMaterial.SHULKER_BOX, 11, null),
    BLACK_SHULKER_BOX(XMaterial.BLACK_SHULKER_BOX, 11, null),
    BLUE_SHULKER_BOX(XMaterial.BLUE_SHULKER_BOX, 11, null),
    CYAN_SHULKER_BOX(XMaterial.CYAN_SHULKER_BOX, 11, null),
    BROWN_SHULKER_BOX(XMaterial.BROWN_SHULKER_BOX, 11, null),
    GRAY_SHULKER_BOX(XMaterial.GRAY_SHULKER_BOX, 11, null),
    GREEN_SHULKER_BOX(XMaterial.GREEN_SHULKER_BOX, 11, null),
    LIGHT_BLUE_SHULKER_BOX(XMaterial.LIGHT_BLUE_SHULKER_BOX, 11, null),
    LIGHT_GRAY_SHULKER_BOX(XMaterial.LIGHT_GRAY_SHULKER_BOX, 11, null),
    LIME_SHULKER_BOX(XMaterial.LIME_SHULKER_BOX, 11, null),
    MAGENTA_SHULKER_BOX(XMaterial.MAGENTA_SHULKER_BOX, 11, null),
    ORANGE_SHULKER_BOX(XMaterial.ORANGE_SHULKER_BOX, 11, null),
    RED_SHULKER_BOX(XMaterial.RED_SHULKER_BOX, 11, null),
    PINK_SHULKER_BOX(XMaterial.PINK_SHULKER_BOX, 11, null),
    PURPLE_SHULKER_BOX(XMaterial.PURPLE_SHULKER_BOX, 11, null),
    WHITE_SHULKER_BOX(XMaterial.WHITE_SHULKER_BOX, 11, null),
    YELLOW_SHULKER_BOX(XMaterial.YELLOW_SHULKER_BOX, 11, null),
    BARREL(XMaterial.BARREL, 14, null);

    private static HashMap<ContainerType, Container> a;
    private XMaterial b;
    private int c;
    private List<BlockFace> d;

    private ContainerType(XMaterial xMaterial, int n2, List<BlockFace> list) {
        this.b = xMaterial;
        this.c = n2;
        this.d = list;
    }

    public final Container getContainer() {
        Container container = a.get((Object)this);
        if (container == null) {
            switch (this) {
                case CHEST: {
                    container = new ChestContainer();
                    break;
                }
                case BLACK_SHULKER_BOX: 
                case BLUE_SHULKER_BOX: 
                case CYAN_SHULKER_BOX: 
                case BROWN_SHULKER_BOX: 
                case GRAY_SHULKER_BOX: 
                case GREEN_SHULKER_BOX: 
                case LIGHT_BLUE_SHULKER_BOX: 
                case LIGHT_GRAY_SHULKER_BOX: 
                case LIME_SHULKER_BOX: 
                case MAGENTA_SHULKER_BOX: 
                case ORANGE_SHULKER_BOX: 
                case RED_SHULKER_BOX: 
                case PINK_SHULKER_BOX: 
                case PURPLE_SHULKER_BOX: 
                case WHITE_SHULKER_BOX: 
                case YELLOW_SHULKER_BOX: 
                case SHULKER_BOX: {
                    ContainerType containerType = this;
                    container = new ShulkerBoxContainer(containerType, containerType.b.parseMaterial());
                    break;
                }
                case BARREL: {
                    container = new BarrelContainer();
                }
            }
            a.put(this, container);
        }
        return container;
    }

    public final boolean isAvailable() {
        if (this.b != null) {
            return XMaterial.supports(this.c);
        }
        return false;
    }

    public final boolean isBlockFaceAllowed(BlockFace blockFace) {
        return this.d == null || !this.d.contains(blockFace);
    }

    public static boolean isAValidInventoryType(InventoryType inventoryType) {
        return inventoryType == InventoryType.CHEST || BARREL.isAvailable() && inventoryType == InventoryType.BARREL || SHULKER_BOX.isAvailable() && inventoryType == InventoryType.SHULKER_BOX;
    }

    public static boolean isAContainerItemMaterial(Material object) {
        object = XMaterial.matchXMaterial(object);
        for (ContainerType containerType : ContainerType.values()) {
            XMaterial enum_ = containerType.getMaterial();
            if (enum_ == null || enum_ != object) continue;
            return true;
        }
        return false;
    }

    public final XMaterial getMaterial() {
        return this.b;
    }

    public final int getSupportedVersion() {
        return this.c;
    }

    static {
        a = new HashMap();
    }
}

