/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.chest.containers;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.AdvancedChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.ContainerType;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.containers.BaseContainer;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.xseries.XBlock;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.xseries.XSound;

public class BarrelContainer
extends BaseContainer {
    public BarrelContainer() {
        super(ContainerType.BARREL);
    }

    @Override
    public void place(Location location) {
        location.getBlock().setType(Material.BARREL);
    }

    @Override
    public void place(Location location, @Nullable BlockFace blockFace) {
        location = location.getBlock();
        location.setType(Material.BARREL);
        if (blockFace != null) {
            XBlock.setDirection((Block)location, blockFace);
        }
    }

    @Override
    public boolean checkBlock(Location location, @Nullable BlockFace blockFace) {
        if ((location = location.getBlock()).getType() != Material.BARREL) {
            location.setType(Material.BARREL);
            if (blockFace != null) {
                XBlock.setDirection((Block)location, blockFace);
            }
            return true;
        }
        return false;
    }

    @Override
    public void playOpenAnimation(AdvancedChest<?, ?> advancedChest, Player player) {
        XBlock.setOpened(advancedChest.getLocation().getBlock(), true);
    }

    @Override
    public void playCloseAnimation(AdvancedChest<?, ?> advancedChest, Player player) {
        XBlock.setOpened(advancedChest.getLocation().getBlock(), false);
    }

    @Override
    public void playOpenAnimation(BlockState blockState, Player player) {
        XBlock.setOpened(blockState.getBlock(), true);
    }

    @Override
    public void playCloseAnimation(BlockState blockState, Player player) {
        XBlock.setOpened(blockState.getBlock(), false);
    }

    @Override
    public void playOpenSound(Player player, float f, float f2) {
        XSound.BLOCK_BARREL_OPEN.play((Entity)player, f, f2);
    }

    @Override
    public void playCloseSound(Player player, float f, float f2) {
        XSound.BLOCK_BARREL_CLOSE.play((Entity)player, f, f2);
    }
}

