/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.chest.containers;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.AdvancedChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.ContainerType;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.containers.BaseContainer;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.packets.ChestUtils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.xseries.XBlock;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.xseries.XSound;

public class ChestContainer
extends BaseContainer {
    public ChestContainer() {
        super(ContainerType.CHEST);
    }

    @Override
    public void place(Location location) {
        location.getBlock().setType(Material.CHEST);
    }

    @Override
    public void place(Location location, @Nullable BlockFace blockFace) {
        location = location.getBlock();
        location.setType(Material.CHEST);
        if (blockFace != null) {
            XBlock.setDirection((Block)location, blockFace);
        }
    }

    @Override
    public boolean checkBlock(Location location, @Nullable BlockFace blockFace) {
        if ((location = location.getBlock()).getType() != Material.CHEST) {
            location.setType(Material.CHEST);
            if (blockFace != null) {
                XBlock.setDirection((Block)location, blockFace);
            }
            return true;
        }
        return false;
    }

    @Override
    public void playOpenAnimation(AdvancedChest<?, ?> advancedChest, Player player) {
        this.playOpenAnimation(advancedChest.getLocation().getBlock().getState(), player);
    }

    @Override
    public void playCloseAnimation(AdvancedChest<?, ?> advancedChest, Player player) {
        this.playCloseAnimation(advancedChest.getLocation().getBlock().getState(), player);
    }

    @Override
    public void playOpenAnimation(BlockState blockState, Player player) {
        if (blockState instanceof Chest) {
            ChestUtils.changeChest(player, blockState, true);
        }
    }

    @Override
    public void playCloseAnimation(BlockState blockState, Player player) {
        if (blockState instanceof Chest) {
            ChestUtils.changeChest(player, blockState, false);
        }
    }

    @Override
    public void playOpenSound(Player player, float f, float f2) {
        XSound.BLOCK_CHEST_OPEN.play((Entity)player, f, f2);
    }

    @Override
    public void playCloseSound(Player player, float f, float f2) {
        XSound.BLOCK_CHEST_CLOSE.play((Entity)player, f, f2);
    }

    @Override
    public boolean canBePlacedAt(Block block) {
        Block block2 = block.getRelative(BlockFace.NORTH);
        Block block3 = block.getRelative(BlockFace.SOUTH);
        Block block4 = block.getRelative(BlockFace.EAST);
        block = block.getRelative(BlockFace.WEST);
        return !(block2.getType() == Material.CHEST || block3.getType() == Material.CHEST || block4.getType() == Material.CHEST || block.getType() == Material.CHEST);
    }

    private static boolean a(Block block) {
        Block block2 = block.getRelative(BlockFace.NORTH);
        Block block3 = block.getRelative(BlockFace.SOUTH);
        Block block4 = block.getRelative(BlockFace.EAST);
        block = block.getRelative(BlockFace.WEST);
        return block2.getType() == Material.CHEST || block3.getType() == Material.CHEST || block4.getType() == Material.CHEST || block.getType() == Material.CHEST;
    }
}

