/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.chest.containers;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.AdvancedChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.ContainerType;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.containers.BaseContainer;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.ItemUtils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.packets.ChestUtils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.xseries.XSound;

public class ShulkerBoxContainer
extends BaseContainer {
    private Material a;

    public ShulkerBoxContainer(ContainerType containerType, Material material) {
        super(containerType);
        this.a = material;
    }

    @Override
    public void place(Location location) {
        location.getBlock().setType(this.a);
    }

    @Override
    public void place(Location location, BlockFace blockFace) {
        location = location.getBlock();
        location.setType(this.a);
    }

    @Override
    public boolean checkBlock(Location location, BlockFace blockFace) {
        if ((location = location.getBlock()).getType() != this.a) {
            location.setType(this.a);
            return true;
        }
        return false;
    }

    @Override
    public void playOpenAnimation(AdvancedChest<?, ?> advancedChest, Player player) {
        this.playOpenAnimation(advancedChest.getLocation().getBlock().getState(), player);
    }

    @Override
    public void playCloseAnimation(AdvancedChest<?, ?> advancedChest, Player player) {
        this.playCloseAnimation(advancedChest.getLocation().getBlock().getState(), player);
    }

    @Override
    public void playOpenAnimation(BlockState blockState, Player player) {
        ChestUtils.changeChest(player, blockState, true);
    }

    @Override
    public void playCloseAnimation(BlockState blockState, Player player) {
        ChestUtils.changeChest(player, blockState, false);
    }

    @Override
    public void playOpenSound(Player player, float f, float f2) {
        XSound.BLOCK_SHULKER_BOX_OPEN.play((Entity)player, f, f2);
    }

    @Override
    public void playCloseSound(Player player, float f, float f2) {
        XSound.BLOCK_SHULKER_BOX_CLOSE.play((Entity)player, f, f2);
    }

    @Override
    public boolean canBeTransferred(ItemStack itemStack) {
        return !ItemUtils.isAShulkerBox(itemStack);
    }

    public Material getMaterial() {
        return this.a;
    }
}

