/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.autosells.buttons;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import us.lynuxcraft.deadsilenceiv.advancedchests.AdvancedChestsPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.UniqueChestButton;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.autosells.AutoSellsMenu;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.FormatUtils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.ItemPlaceHolder;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.actions.SlotAction;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.items.BaseUniqueButtonItem;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.items.UniqueButtonItem;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.xseries.XSound;

public class ClaimMoney
extends UniqueChestButton {
    public ClaimMoney(AutoSellsMenu autoSellsMenu) {
        super(autoSellsMenu, "claim-money");
        this.build();
        this.loadActions();
    }

    @Override
    public void build() {
        Object object = this.languages.getGuiAutoSellsMoneyIconMaterial();
        String string = this.languages.getGuiAutoSellsMoneyIconName();
        ArrayList<String> arrayList = new ArrayList<String>(this.languages.getGuiAutoSellsMoneyIconLore());
        object = this.getItemStack((Material)object, string, this.languages.getGuiAutoSellsMoneyIconHead(), (List<String>)arrayList, this.languages.getGuiAutoSellsMoneyIconCustomModelData());
        object = new BaseUniqueButtonItem(this, "main", (ItemStack)object);
        this.addItem(object);
        this.loadPlaceholders();
        this.inventory.addButton(this);
        this.show("main");
    }

    @Override
    public void loadActions() {
        this.inventory.addAction(new SlotAction(ClickType.LEFT, this.getSlot()){

            @Override
            public boolean execute(Player player) {
                double d;
                player.closeInventory();
                double d2 = ClaimMoney.this.chest.getMoney();
                if (d > 0.0) {
                    ClaimMoney.this.chest.setMoney(0.0);
                    ClaimMoney.this.economy.depositPlayer((OfflinePlayer)player, d2);
                    ((UniqueButtonItem)ClaimMoney.this.getItemByName("main")).refresh();
                    AdvancedChestsPlugin.sendMessage((CommandSender)player, ClaimMoney.this.languages.getAutoSellsClaimMoneySuccess(), false);
                    XSound.ENTITY_PLAYER_LEVELUP.play((Entity)player, ClaimMoney.this.config.getSoundsVolume(), ClaimMoney.this.config.getSoundsPitch());
                } else {
                    AdvancedChestsPlugin.sendMessage((CommandSender)player, ClaimMoney.this.languages.getAutoSellsClaimMoneyFail(), false);
                    XSound.BLOCK_ANVIL_BREAK.play((Entity)player, ClaimMoney.this.config.getSoundsVolume(), ClaimMoney.this.config.getSoundsPitch());
                }
                return true;
            }
        });
    }

    @Override
    protected void loadPlaceholders() {
        for (UniqueButtonItem uniqueButtonItem : this.getItems()) {
            uniqueButtonItem.addPlaceholder(new ItemPlaceHolder("%money%"){

                @Override
                public String getReplacement() {
                    return FormatUtils.format(ClaimMoney.this.chest.getMoney());
                }
            });
        }
    }

    @Override
    public Integer getSlot() {
        return 11;
    }
}

