/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.confirmations.buttons;

import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import us.lynuxcraft.deadsilenceiv.advancedchests.AdvancedChestsPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.AdvancedChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.containers.BaseContainer;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ChestInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ShareableChestButton;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.economy.EconomyProvider;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.economy.EconomyService;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.InteractiveInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.actions.SlotAction;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.items.BaseShareableButtonItem;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.xseries.XSound;

public class UpgradeChest
extends ShareableChestButton {
    private EconomyService a = EconomyProvider.UPGRADES.get();

    public UpgradeChest(String string) {
        super(string, "confirm");
        this.build();
    }

    @Override
    protected void build() {
        Object object = this.languages.getUpgradeConfirmationIconMaterial();
        String string = this.languages.getUpgradeConfirmationIconName();
        ArrayList<String> arrayList = new ArrayList<String>(this.languages.getUpgradeConfirmationIconLore());
        object = this.getItemStack((Material)object, string, this.languages.getUpgradeConfirmationIconHead(), arrayList, this.languages.getUpgradeConfirmationIconCustomModelData());
        object = new BaseShareableButtonItem(this, "main", (ItemStack)object);
        this.addItem(object);
        ((BaseShareableButtonItem)object).refresh(null);
    }

    @Override
    public void loadActions(ChestInventory chestInventory) {
        final AdvancedChest<?, ?> advancedChest = chestInventory.getChest();
        chestInventory.addAction(new SlotAction(ClickType.LEFT, this.getSlot(chestInventory)){

            @Override
            public boolean execute(Player player) {
                String string = UpgradeChest.this.dataManager.getChestUpgrade(advancedChest.getConfigType());
                if (!((BaseContainer)advancedChest.getContainer()).canBeUpgraded(advancedChest)) {
                    AdvancedChestsPlugin.sendMessage((CommandSender)player, UpgradeChest.this.languages.getUpgradesNewChestContainerForbiddenLocation());
                    XSound.BLOCK_ANVIL_BREAK.play((Entity)player, UpgradeChest.this.config.getSoundsVolume(), UpgradeChest.this.config.getSoundsPitch());
                    return true;
                }
                double d = UpgradeChest.this.dataManager.getChestUpgradePrice(advancedChest.getConfigType());
                if (UpgradeChest.this.a.getBalance(player) >= d) {
                    UpgradeChest.this.a.withdraw(player, d);
                    player.closeInventory();
                    advancedChest.upgrade(string, player);
                    AdvancedChestsPlugin.sendMessage((CommandSender)player, UpgradeChest.this.languages.getUpgradesOnSuccess());
                    XSound.ENTITY_PLAYER_LEVELUP.play((Entity)player, UpgradeChest.this.config.getSoundsVolume(), UpgradeChest.this.config.getSoundsPitch());
                } else {
                    AdvancedChestsPlugin.sendMessage((CommandSender)player, UpgradeChest.this.languages.getUpgradesOnFail());
                    XSound.BLOCK_ANVIL_BREAK.play((Entity)player, UpgradeChest.this.config.getSoundsVolume(), UpgradeChest.this.config.getSoundsPitch());
                }
                return true;
            }
        });
    }

    @Override
    public Integer getSlot(@NotNull InteractiveInventory interactiveInventory) {
        return 13;
    }
}

