/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.buttons;

import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.BaseChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ChestInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ShareableChestButton;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.autosells.AutoSellsMenu;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.FormatUtils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.ItemPlaceHolder;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.InteractiveInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.actions.SlotAction;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.items.BaseShareableButtonItem;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.items.ShareableButtonItem;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.xseries.XSound;

public class AutomaticSells
extends ShareableChestButton {
    public AutomaticSells(String string) {
        super(string, "automatic-sells");
        this.build();
    }

    @Override
    protected void build() {
        Object object = this.languages.getGuiAutoSellsIconMaterial();
        String string = this.languages.getGuiAutoSellsIconName();
        ArrayList<String> arrayList = new ArrayList<String>(this.languages.getGuiAutoSellsIconLore());
        object = this.getItemStack((Material)object, string, this.languages.getGuiAutoSellsIconHead(), arrayList, this.languages.getGuiAutoSellsIconCustomModelData());
        object = new BaseShareableButtonItem(this, "main", (ItemStack)object);
        this.addItem(object);
        this.loadPlaceholders();
        ((BaseShareableButtonItem)object).refresh(null);
    }

    @Override
    public void loadActions(ChestInventory chestInventory) {
        final BaseChest baseChest = (BaseChest)chestInventory.getChest();
        chestInventory.addAction(new SlotAction(ClickType.LEFT, this.getSlot(chestInventory)){

            @Override
            public boolean execute(Player player) {
                InteractiveInventory interactiveInventory = baseChest.getSubInventoryByName("automatic-sells");
                if (interactiveInventory == null) {
                    interactiveInventory = new AutoSellsMenu(baseChest);
                    baseChest.getSubInventories().add(interactiveInventory);
                    AutomaticSells.this.inventoryManager.register(interactiveInventory);
                }
                ((AutoSellsMenu)interactiveInventory).open(player);
                XSound.UI_BUTTON_CLICK.play((Entity)player, AutomaticSells.this.config.getSoundsVolume(), AutomaticSells.this.config.getSoundsPitch());
                return true;
            }
        });
    }

    @Override
    protected void loadPlaceholders() {
        for (ShareableButtonItem shareableButtonItem : this.getItems()) {
            shareableButtonItem.addPlaceholder(new ItemPlaceHolder("%multiplier%"){

                @Override
                public String getReplacement() {
                    return FormatUtils.format(AutomaticSells.this.dataManager.getAutoSellsMultiplier(AutomaticSells.this.chestType));
                }
            });
            shareableButtonItem.addPlaceholder(new ItemPlaceHolder("%frequency%"){

                @Override
                public String getReplacement() {
                    return FormatUtils.format((double)AutomaticSells.this.dataManager.getAutoSellsFrequency(AutomaticSells.this.chestType) / 20.0);
                }
            });
            shareableButtonItem.addPlaceholder(new ItemPlaceHolder("%tax%"){

                @Override
                public String getReplacement() {
                    return FormatUtils.format(AutomaticSells.this.dataManager.getAutoSellsTax(AutomaticSells.this.chestType));
                }
            });
        }
    }

    @Override
    public Integer getSlot(@NotNull InteractiveInventory interactiveInventory) {
        return interactiveInventory.getBukkitInventory().getSize() - (10 - this.dataManager.getAutoSellsSlot(this.chestType));
    }
}

