/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.buttons;

import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.BaseChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ChestInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ShareableChestButton;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.actions.Upgrading;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.FormatUtils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.ItemPlaceHolder;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.InteractiveInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.items.BaseShareableButtonItem;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.items.ShareableButtonItem;

public class Upgrade
extends ShareableChestButton {
    public Upgrade(String string) {
        super(string, "upgrade");
        this.build();
    }

    @Override
    protected void build() {
        Object object = this.languages.getGuiUpgradeIconMaterial();
        String string = this.languages.getGuiUpgradeIconName();
        ArrayList<String> arrayList = new ArrayList<String>(this.languages.getGuiUpgradeIconLore());
        object = this.getItemStack((Material)object, string, this.languages.getGuiUpgradeIconHead(), arrayList, this.languages.getGuiUpgradeIconCustomModelData());
        object = new BaseShareableButtonItem(this, "main", (ItemStack)object);
        this.addItem(object);
        this.loadPlaceholders();
        ((BaseShareableButtonItem)object).refresh(null);
    }

    @Override
    public void loadActions(ChestInventory chestInventory) {
        BaseChest baseChest = (BaseChest)chestInventory.getChest();
        chestInventory.addAction(new Upgrading(baseChest, ClickType.LEFT, this.getSlot(chestInventory)));
    }

    @Override
    protected void loadPlaceholders() {
        for (ShareableButtonItem shareableButtonItem : this.getItems()) {
            shareableButtonItem.addPlaceholder(new ItemPlaceHolder("%price%"){

                @Override
                public String getReplacement() {
                    return FormatUtils.format(Upgrade.this.dataManager.getChestUpgradePrice(Upgrade.this.chestType));
                }
            });
            shareableButtonItem.addPlaceholder(new ItemPlaceHolder("%size%"){

                @Override
                public String getReplacement() {
                    return "" + Upgrade.this.dataManager.getChestSize(Upgrade.this.dataManager.getChestUpgrade(Upgrade.this.chestType));
                }
            });
        }
    }

    @Override
    public Integer getSlot(@NotNull InteractiveInventory interactiveInventory) {
        return interactiveInventory.getBukkitInventory().getSize() - (10 - this.dataManager.getUpgradeSlot(this.chestType));
    }
}

