/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.chest.title;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.AdvancedChest;

public abstract class ChestTitle {
    public List<String> content;
    public boolean usingRefreshablePlaceholders;
    protected AdvancedChest<?, ?> chest;
    private int a;

    public ChestTitle(AdvancedChest<?, ?> advancedChest, List<String> list) {
        this.chest = advancedChest;
        this.a = 0;
        this.usingRefreshablePlaceholders = false;
        this.content = list;
    }

    public abstract void spawn();

    public abstract void delete();

    public abstract void update();

    public void tickByHopper() {
        ++this.a;
        if (this.a == 32) {
            this.a = 0;
            this.update();
        }
    }

    protected List<String> getReplacedPlaceholders() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.content != null && !this.content.isEmpty()) {
            for (int i = 0; i <= this.content.size() - 1; ++i) {
                UUID uUID;
                String string = ChatColor.translateAlternateColorCodes((char)'&', (String)this.content.get(i));
                if (string.contains("%size%")) {
                    string = string.replaceAll("%size%", "" + this.chest.getSize());
                }
                if (string.contains("%slots_used%")) {
                    this.usingRefreshablePlaceholders = true;
                    string = string.replaceAll("%slots_used%", "" + this.chest.getSlotsUsed());
                }
                if (string.contains("%slots_left%")) {
                    this.usingRefreshablePlaceholders = true;
                    string = string.replaceAll("%slots_left%", "" + this.chest.getSlotsLeft());
                }
                if (string.contains("%placed-by%") && (uUID = this.chest.getWhoPlaced()) != null) {
                    this.usingRefreshablePlaceholders = true;
                    string = string.replaceAll("%placed-by%", Bukkit.getOfflinePlayer((UUID)uUID).getName());
                }
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public List<String> getContent() {
        return this.content;
    }

    public void setContent(List<String> list) {
        this.content = list;
    }

    public boolean isUsingRefreshablePlaceholders() {
        return this.usingRefreshablePlaceholders;
    }
}

