/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.listeners;

import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.AdvancedChestsPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.ChestInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.title.ChestTitle;
import us.lynuxcraft.deadsilenceiv.advancedchests.listeners.priorities.inventoryclick.InventoryClickHigh;
import us.lynuxcraft.deadsilenceiv.advancedchests.listeners.priorities.inventoryclick.InventoryClickHighest;
import us.lynuxcraft.deadsilenceiv.advancedchests.listeners.priorities.inventoryclick.InventoryClickLow;
import us.lynuxcraft.deadsilenceiv.advancedchests.listeners.priorities.inventoryclick.InventoryClickLowest;
import us.lynuxcraft.deadsilenceiv.advancedchests.listeners.priorities.inventoryclick.InventoryClickNormal;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.InventoryManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.yml.config.Configuration;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.ChestsProvider;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.InteractiveInventory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.xseries.XMaterial;

public class InventoryInteraction
implements Listener {
    private AdvancedChestsPlugin a = AdvancedChestsPlugin.getInstance();
    private Configuration b = this.a.getConfiguration();
    private InventoryManager c = this.a.getInventoryManager();

    public InventoryInteraction() {
        InventoryInteraction inventoryInteraction = this;
        PluginManager pluginManager = inventoryInteraction.a.getServer().getPluginManager();
        EventPriority eventPriority = inventoryInteraction.b.fetchPriorityFromOption("inventory_click");
        if (eventPriority == EventPriority.LOWEST) {
            pluginManager.registerEvents((Listener)new InventoryClickLowest(inventoryInteraction), (Plugin)inventoryInteraction.a);
        }
        if (eventPriority == EventPriority.LOW) {
            pluginManager.registerEvents((Listener)new InventoryClickLow(inventoryInteraction), (Plugin)inventoryInteraction.a);
        }
        if (eventPriority == EventPriority.NORMAL) {
            pluginManager.registerEvents((Listener)new InventoryClickNormal(inventoryInteraction), (Plugin)inventoryInteraction.a);
        }
        if (eventPriority == EventPriority.HIGH) {
            pluginManager.registerEvents((Listener)new InventoryClickHigh(inventoryInteraction), (Plugin)inventoryInteraction.a);
        }
        if (eventPriority == EventPriority.HIGHEST) {
            pluginManager.registerEvents((Listener)new InventoryClickHighest(inventoryInteraction), (Plugin)inventoryInteraction.a);
        }
    }

    private void a() {
        PluginManager pluginManager = this.a.getServer().getPluginManager();
        EventPriority eventPriority = this.b.fetchPriorityFromOption("inventory_click");
        if (eventPriority == EventPriority.LOWEST) {
            pluginManager.registerEvents((Listener)new InventoryClickLowest(this), (Plugin)this.a);
        }
        if (eventPriority == EventPriority.LOW) {
            pluginManager.registerEvents((Listener)new InventoryClickLow(this), (Plugin)this.a);
        }
        if (eventPriority == EventPriority.NORMAL) {
            pluginManager.registerEvents((Listener)new InventoryClickNormal(this), (Plugin)this.a);
        }
        if (eventPriority == EventPriority.HIGH) {
            pluginManager.registerEvents((Listener)new InventoryClickHigh(this), (Plugin)this.a);
        }
        if (eventPriority == EventPriority.HIGHEST) {
            pluginManager.registerEvents((Listener)new InventoryClickHighest(this), (Plugin)this.a);
        }
    }

    public void handleOnInventoryClickEvent(InventoryClickEvent inventoryClickEvent) {
        Object object = (Player)inventoryClickEvent.getWhoClicked();
        if ((object = this.c.getInteractiveByBukkit(object.getOpenInventory().getTopInventory())) != null) {
            object.handleInventoryInteraction(inventoryClickEvent);
            return;
        }
        object = inventoryClickEvent.getInventory();
        if (object.getType() == InventoryType.ANVIL && inventoryClickEvent.getSlotType() == InventoryType.SlotType.RESULT) {
            ItemStack itemStack = object.getItem(0);
            object = object.getItem(1);
            if (ChestsProvider.getAdvancedChestTypeByItem(itemStack) != null || ChestsProvider.getAdvancedChestTypeByItem((ItemStack)object) != null) {
                inventoryClickEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void handleOnInventoryDragging(InventoryDragEvent inventoryDragEvent) {
        Object object = (Player)inventoryDragEvent.getWhoClicked();
        if ((object = this.c.getInteractiveByBukkit(object.getOpenInventory().getTopInventory())) != null) {
            object.handleInventoryDragging(inventoryDragEvent);
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent object) {
        Player player = (Player)object.getPlayer();
        if ((object = this.c.getInteractiveByBukkit(object.getInventory())) instanceof ChestInventory) {
            object = ((ChestInventory)object).getChest();
            Location location = object.getLocation();
            if (!object.isPlayerChangingPage(player)) {
                ChestTitle chestTitle = object.getChestTitle();
                if (chestTitle != null && chestTitle.isUsingRefreshablePlaceholders()) {
                    chestTitle.update();
                }
                object = object.getContainer();
                location = location.getBlock().getState();
                object.playCloseAnimation((BlockState)location, player);
                object.playCloseSound(player, this.b.getSoundsVolume(), this.b.getSoundsPitch());
            }
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent object) {
        object = object.getPlayer();
        if ((object = this.c.getChestsShopByPlayer((Player)object)) != null && !object.isChangingIndex()) {
            this.c.unRegister((InteractiveInventory)object);
        }
    }

    @EventHandler
    public void onDropItemFromInventory(PlayerDropItemEvent playerDropItemEvent) {
        Player player = playerDropItemEvent.getPlayer();
        Object object = player.getOpenInventory().getTopInventory();
        if (!XMaterial.supports(17)) {
            return;
        }
        if ((object = this.c.getAdvancedChest((Inventory)object)) != null && object.isPlayerChangingPage(player)) {
            playerDropItemEvent.getItemDrop().remove();
        }
    }
}

