/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.services.chest;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sells.SellService;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sells.compatibility.BossShopProWorth;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sells.compatibility.CMIWorth;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sells.compatibility.CustomWorth;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sells.compatibility.DeluxeBazaarWorth;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sells.compatibility.DynamicShopWorth;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sells.compatibility.EconomyShopGUIWorth;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sells.compatibility.EssentialsXWorth;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sells.compatibility.ExcellentShopWorth;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sells.compatibility.IslandShopWorth;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sells.compatibility.OneStopShopWorth;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sells.compatibility.RoyaleEconomyWorth;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sells.compatibility.ShopGuiPlusWorth;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sells.compatibility.ZShopWorth;

public enum WorthProvider {
    ESSENTIALS("Essentials"),
    SHOPGUIPLUS("ShopGUIPlus"),
    ZSHOP("zShop"),
    ROYALE_ECONOMY("RoyaleEconomy"),
    CMI("CMI"),
    BOSS_SHOP_PRO("BossShopPro"),
    ISLAND_SHOP("IslandShop"),
    ONE_STOP_SHOP("OneStopShop"),
    ECONOMY_SHOP_GUI("EconomyShopGUI"),
    ECONOMY_SHOP_GUI_PREMIUM("EconomyShopGUI-Premium"),
    DELUXE_BAZAAR("DeluxeBazaar"),
    DYNAMIC_SHOP("DynamicShop"),
    EXCELLENT_SHOP("ExcellentShop"),
    CUSTOM(null);

    private static Set<WorthProvider> a;
    private String b;

    private WorthProvider(String string2) {
        this.b = string2;
    }

    public final SellService getService() {
        switch (this) {
            case ESSENTIALS: {
                return new EssentialsXWorth();
            }
            case SHOPGUIPLUS: {
                return new ShopGuiPlusWorth();
            }
            case ZSHOP: {
                return new ZShopWorth();
            }
            case ROYALE_ECONOMY: {
                return new RoyaleEconomyWorth();
            }
            case CMI: {
                return new CMIWorth();
            }
            case BOSS_SHOP_PRO: {
                return new BossShopProWorth();
            }
            case ISLAND_SHOP: {
                return new IslandShopWorth();
            }
            case ONE_STOP_SHOP: {
                return new OneStopShopWorth();
            }
            case ECONOMY_SHOP_GUI: 
            case ECONOMY_SHOP_GUI_PREMIUM: {
                return new EconomyShopGUIWorth();
            }
            case DELUXE_BAZAAR: {
                return new DeluxeBazaarWorth();
            }
            case DYNAMIC_SHOP: {
                return new DynamicShopWorth();
            }
            case EXCELLENT_SHOP: {
                return new ExcellentShopWorth();
            }
            case CUSTOM: {
                return new CustomWorth();
            }
        }
        return null;
    }

    public final boolean isAvailable() {
        return this == CUSTOM || Bukkit.getPluginManager().getPlugin(this.b) != null;
    }

    public static Set<WorthProvider> getAvailableProviders() {
        if (a == null) {
            a = new HashSet<WorthProvider>();
            for (WorthProvider worthProvider : WorthProvider.values()) {
                if (!worthProvider.isAvailable()) continue;
                a.add(worthProvider);
            }
        }
        return a;
    }

    public final String getPluginName() {
        return this.b;
    }
}

