/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.tasks.sells;

import java.util.HashSet;
import java.util.Set;
import net.milkbowl.vault.economy.Economy;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.AdvancedChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.ChestPage;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.DataManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.LanguagesManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.TaskManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.managers.yml.config.IConfiguration;
import us.lynuxcraft.deadsilenceiv.advancedchests.services.chest.sells.PageBatchSeller;
import us.lynuxcraft.deadsilenceiv.advancedchests.tasks.ChestTask;
import us.lynuxcraft.deadsilenceiv.advancedchests.tasks.SplitOperation;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.SoldItem;

public abstract class SellProcess
extends SplitOperation<ChestPage<?>>
implements ChestTask {
    protected AdvancedChest<?, ?> chest;
    protected IConfiguration config;
    protected LanguagesManager languagesManager;
    protected DataManager dataManager;
    protected TaskManager taskManager;
    protected Economy economy;
    protected int maxDelay;
    protected double totalValue;
    protected PageBatchSeller batchSeller;
    protected Set<SoldItem> soldContents;

    SellProcess(AdvancedChest<?, ?> advancedChest) {
        this.chest = advancedChest;
        this.config = this.plugin.getConfiguration();
        this.languagesManager = this.plugin.getLanguagesManager();
        this.dataManager = this.plugin.getDataManager();
        this.taskManager = this.plugin.getTaskManager();
        this.economy = this.plugin.getEcon();
        this.totalValue = 0.0;
        this.maxDelay = this.config.getSellTimeMaxDelay();
        if (this.maxDelay > 1) {
            advancedChest.closeForViewers();
        }
        this.batchSeller = advancedChest.getChestType().getPageBatchSeller();
        this.soldContents = new HashSet<SoldItem>();
        this.start(0L, 20L, this.maxDelay, advancedChest.getOrderedPages());
        this.taskManager.register(this);
    }

    @Override
    public AdvancedChest<?, ?> getChest() {
        return this.chest;
    }
}

