/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.HikariConfig;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.SQLExceptionOverride;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.metrics.IMetricsTracker;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool.HikariPool;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool.PoolEntry;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool.ProxyConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util.ClockSource;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util.DriverDataSource;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util.PropertyElf;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util.UtilityElf;

abstract class PoolBase {
    private final Logger a = LoggerFactory.getLogger(PoolBase.class);
    public final HikariConfig config;
    IMetricsTrackerDelegate metricsTracker;
    protected final String poolName;
    volatile String catalog;
    final AtomicReference<Exception> lastConnectionFailure;
    long connectionTimeout;
    long validationTimeout;
    SQLExceptionOverride exceptionOverride;
    private static final String[] b = new String[]{"readOnly", "autoCommit", "isolation", "catalog", "netTimeout", "schema"};
    private static final int c = -1;
    private static final int d = 1;
    private static final int e = 0;
    private int f;
    private int g;
    private int h;
    private int i;
    private int j;
    private Executor k;
    private DataSource l;
    private final String m;
    private final boolean n;
    private final boolean o;
    private final boolean p;
    private final boolean q;
    private volatile boolean r;

    PoolBase(HikariConfig object) {
        this.config = object;
        this.f = -1;
        this.catalog = ((HikariConfig)object).getCatalog();
        this.m = ((HikariConfig)object).getSchema();
        this.n = ((HikariConfig)object).isReadOnly();
        this.o = ((HikariConfig)object).isAutoCommit();
        this.exceptionOverride = UtilityElf.createInstance(((HikariConfig)object).getExceptionOverrideClassName(), SQLExceptionOverride.class, new Object[0]);
        this.j = UtilityElf.getTransactionIsolation(((HikariConfig)object).getTransactionIsolation());
        this.h = -1;
        this.g = -1;
        this.p = ((HikariConfig)object).getConnectionTestQuery() == null;
        this.q = ((HikariConfig)object).isIsolateInternalQueries();
        this.poolName = ((HikariConfig)object).getPoolName();
        this.connectionTimeout = ((HikariConfig)object).getConnectionTimeout();
        this.validationTimeout = ((HikariConfig)object).getValidationTimeout();
        this.lastConnectionFailure = new AtomicReference();
        object = this;
        Object object2 = ((PoolBase)object).config.getJdbcUrl();
        Object object3 = ((PoolBase)object).config.getUsername();
        String string = ((PoolBase)object).config.getPassword();
        String string2 = ((PoolBase)object).config.getDataSourceClassName();
        String string3 = ((PoolBase)object).config.getDriverClassName();
        String string4 = ((PoolBase)object).config.getDataSourceJNDI();
        Properties properties = ((PoolBase)object).config.getDataSourceProperties();
        DataSource dataSource = ((PoolBase)object).config.getDataSource();
        if (string2 != null && dataSource == null) {
            dataSource = UtilityElf.createInstance(string2, DataSource.class, new Object[0]);
            PropertyElf.setTargetFromProperties(dataSource, properties);
        } else if (object2 != null && dataSource == null) {
            dataSource = new DriverDataSource((String)object2, string3, properties, (String)object3, string);
        } else if (string4 != null && dataSource == null) {
            try {
                object3 = new InitialContext();
                dataSource = (DataSource)((InitialContext)object3).lookup(string4);
            }
            catch (NamingException namingException) {
                throw new HikariPool.PoolInitializationException(namingException);
            }
        }
        if (dataSource != null) {
            super.a(dataSource);
            String string5 = string2;
            string2 = object2;
            string = string5;
            object3 = dataSource;
            object2 = object;
            if (string != null && string.contains("Mysql") || string2 != null && string2.contains("mysql") || object3 != null && object3.getClass().getName().contains("Mysql")) {
                ((PoolBase)object2).k = new SynchronousExecutor(0);
            } else {
                object3 = ((PoolBase)object2).config.getThreadFactory();
                object3 = object3 != null ? object3 : new UtilityElf.DefaultThreadFactory(((PoolBase)object2).poolName + " network timeout executor", true);
                object3 = (ThreadPoolExecutor)Executors.newCachedThreadPool((ThreadFactory)object3);
                ((ThreadPoolExecutor)object3).setKeepAliveTime(15L, TimeUnit.SECONDS);
                ((ThreadPoolExecutor)object3).allowCoreThreadTimeOut(true);
                ((PoolBase)object2).k = object3;
            }
        }
        ((PoolBase)object).l = dataSource;
    }

    public String toString() {
        return this.poolName;
    }

    abstract void recycle(PoolEntry var1);

    void quietlyCloseConnection(Connection connection, String string) {
        if (connection != null) {
            try {
                this.a.debug("{} - Closing connection {}: {}", this.poolName, connection, string);
                try {
                    this.b(connection, TimeUnit.SECONDS.toMillis(15L));
                }
                catch (SQLException sQLException) {
                }
                finally {
                    connection.close();
                }
            }
            catch (Exception exception) {
                this.a.debug("{} - Closing connection {} failed", this.poolName, connection, exception);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isConnectionAlive(Connection connection) {
        try {
            try {
                this.b(connection, this.validationTimeout);
                int n = (int)Math.max(1000L, this.validationTimeout) / 1000;
                if (this.p) {
                    boolean bl = connection.isValid(n);
                    return bl;
                }
                try (Statement statement = connection.createStatement();){
                    block18: {
                        if (this.g != 1) {
                            int n2 = n;
                            Statement statement2 = statement;
                            PoolBase poolBase = this;
                            if (poolBase.h != 0) {
                                try {
                                    statement2.setQueryTimeout(n2);
                                    poolBase.h = 1;
                                }
                                catch (Exception exception) {
                                    if (poolBase.h != -1) break block18;
                                    poolBase.h = 0;
                                    poolBase.a.info("{} - Failed to set query timeout for statement. ({})", (Object)poolBase.poolName, (Object)exception.getMessage());
                                }
                            }
                        }
                    }
                    statement.execute(this.config.getConnectionTestQuery());
                    return true;
                }
            }
            finally {
                this.b(connection, this.f);
                if (this.q && !this.o) {
                    connection.rollback();
                }
            }
        }
        catch (Exception exception) {
            this.lastConnectionFailure.set(exception);
            this.a.warn("{} - Failed to validate connection {} ({}). Possibly consider using a shorter maxLifetime value.", this.poolName, connection, exception.getMessage());
            return false;
        }
    }

    Exception getLastConnectionFailure() {
        return this.lastConnectionFailure.get();
    }

    public DataSource getUnwrappedDataSource() {
        return this.l;
    }

    PoolEntry newPoolEntry() {
        PoolBase poolBase = this;
        return new PoolEntry(this.b(), poolBase, poolBase.n, this.o);
    }

    void resetConnectionState(Connection connection, ProxyConnection proxyConnection, int n) {
        int n2 = 0;
        if ((n & 1) != 0 && proxyConnection.e() != this.n) {
            connection.setReadOnly(this.n);
            n2 = 1;
        }
        if ((n & 2) != 0 && proxyConnection.a() != this.o) {
            connection.setAutoCommit(this.o);
            n2 |= 2;
        }
        if ((n & 4) != 0 && proxyConnection.d() != this.j) {
            connection.setTransactionIsolation(this.j);
            n2 |= 4;
        }
        if ((n & 8) != 0 && this.catalog != null && !this.catalog.equals(proxyConnection.b())) {
            connection.setCatalog(this.catalog);
            n2 |= 8;
        }
        if ((n & 0x10) != 0 && proxyConnection.f() != this.f) {
            this.b(connection, this.f);
            n2 |= 0x10;
        }
        if ((n & 0x20) != 0 && this.m != null && !this.m.equals(proxyConnection.c())) {
            connection.setSchema(this.m);
            n2 |= 0x20;
        }
        if (n2 != 0 && this.a.isDebugEnabled()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = this.poolName;
            int n3 = n2;
            StringBuilder stringBuilder = new StringBuilder();
            for (n2 = 0; n2 < b.length; ++n2) {
                if ((n3 & 1 << n2) == 0) continue;
                stringBuilder.append(b[n2]).append(", ");
            }
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.setLength(stringBuilder2.length() - 2);
            objectArray[1] = stringBuilder.toString();
            objectArray[2] = connection;
            this.a.debug("{} - Reset ({}) on connection {}", objectArray);
        }
    }

    void shutdownNetworkTimeoutExecutor() {
        if (this.k instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.k).shutdownNow();
        }
    }

    long getLoginTimeout() {
        try {
            if (this.l != null) {
                return this.l.getLoginTimeout();
            }
            return TimeUnit.SECONDS.toSeconds(5L);
        }
        catch (SQLException sQLException) {
            return TimeUnit.SECONDS.toSeconds(5L);
        }
    }

    void handleMBeans(HikariPool hikariPool, boolean bl) {
        block9: {
            if (!this.config.isRegisterMbeans()) {
                return;
            }
            try {
                ObjectName objectName;
                ObjectName objectName2;
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                if ("true".equals(System.getProperty("hikaricp.jmx.register2.0"))) {
                    objectName2 = new ObjectName("us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari:type=PoolConfig,name=" + this.poolName);
                    objectName = new ObjectName("us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari:type=Pool,name=" + this.poolName);
                } else {
                    objectName2 = new ObjectName("us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari:type=PoolConfig (" + this.poolName + ")");
                    objectName = new ObjectName("us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari:type=Pool (" + this.poolName + ")");
                }
                if (bl) {
                    if (!mBeanServer.isRegistered(objectName2)) {
                        mBeanServer.registerMBean(this.config, objectName2);
                        mBeanServer.registerMBean(hikariPool, objectName);
                    } else {
                        this.a.error("{} - JMX name ({}) is already registered.", (Object)this.poolName, (Object)this.poolName);
                    }
                    break block9;
                }
                if (mBeanServer.isRegistered(objectName2)) {
                    mBeanServer.unregisterMBean(objectName2);
                    mBeanServer.unregisterMBean(objectName);
                }
                return;
            }
            catch (Exception exception) {
                this.a.warn("{} - Failed to {} management beans.", this.poolName, bl ? "register" : "unregister", exception);
            }
        }
    }

    private void a() {
        String string = this.config.getJdbcUrl();
        Object object = this.config.getUsername();
        String string2 = this.config.getPassword();
        String string3 = this.config.getDataSourceClassName();
        String string4 = this.config.getDriverClassName();
        String string5 = this.config.getDataSourceJNDI();
        Properties properties = this.config.getDataSourceProperties();
        DataSource dataSource = this.config.getDataSource();
        if (string3 != null && dataSource == null) {
            dataSource = UtilityElf.createInstance(string3, DataSource.class, new Object[0]);
            PropertyElf.setTargetFromProperties(dataSource, properties);
        } else if (string != null && dataSource == null) {
            dataSource = new DriverDataSource(string, string4, properties, (String)object, string2);
        } else if (string5 != null && dataSource == null) {
            try {
                object = new InitialContext();
                dataSource = (DataSource)((InitialContext)object).lookup(string5);
            }
            catch (NamingException namingException) {
                throw new HikariPool.PoolInitializationException(namingException);
            }
        }
        if (dataSource != null) {
            this.a(dataSource);
            this.a(dataSource, string3, string);
        }
        this.l = dataSource;
    }

    private Connection b() {
        long l = ClockSource.currentTime();
        Connection connection = null;
        try {
            Object object = this.config.getUsername();
            Object object2 = this.config.getPassword();
            connection = object == null ? this.l.getConnection() : this.l.getConnection((String)object, (String)object2);
            if (connection == null) {
                throw new SQLTransientConnectionException("DataSource returned null unexpectedly");
            }
            object2 = connection;
            object = this;
            try {
                if (((PoolBase)object).f == -1) {
                    ((PoolBase)object).f = super.a((Connection)object2, ((PoolBase)object).validationTimeout);
                } else {
                    super.b((Connection)object2, ((PoolBase)object).validationTimeout);
                }
                if (object2.isReadOnly() != ((PoolBase)object).n) {
                    object2.setReadOnly(((PoolBase)object).n);
                }
                if (object2.getAutoCommit() != ((PoolBase)object).o) {
                    object2.setAutoCommit(((PoolBase)object).o);
                }
                Object object3 = object2;
                Object object4 = object;
                if (!((PoolBase)object4).r) {
                    super.c((Connection)object3);
                    super.d((Connection)object3);
                    ((PoolBase)object4).r = true;
                }
                if (((PoolBase)object).j != ((PoolBase)object).i) {
                    object2.setTransactionIsolation(((PoolBase)object).j);
                }
                if (((PoolBase)object).catalog != null) {
                    object2.setCatalog(((PoolBase)object).catalog);
                }
                if (((PoolBase)object).m != null) {
                    object2.setSchema(((PoolBase)object).m);
                }
                super.a((Connection)object2, ((PoolBase)object).config.getConnectionInitSql(), true);
                super.b((Connection)object2, ((PoolBase)object).f);
            }
            catch (SQLException sQLException) {
                throw new ConnectionSetupException(sQLException);
            }
            this.lastConnectionFailure.set(null);
            object = connection;
            return object;
        }
        catch (Exception exception) {
            if (connection != null) {
                this.quietlyCloseConnection(connection, "(Failed to create/setup connection)");
            } else if (this.getLastConnectionFailure() == null) {
                this.a.debug("{} - Failed to create/setup connection: {}", (Object)this.poolName, (Object)exception.getMessage());
            }
            this.lastConnectionFailure.set(exception);
            throw exception;
        }
        finally {
            if (this.metricsTracker != null) {
                this.metricsTracker.recordConnectionCreated(ClockSource.elapsedMillis(l));
            }
        }
    }

    private void a(Connection connection) {
        try {
            if (this.f == -1) {
                this.f = this.a(connection, this.validationTimeout);
            } else {
                this.b(connection, this.validationTimeout);
            }
            if (connection.isReadOnly() != this.n) {
                connection.setReadOnly(this.n);
            }
            if (connection.getAutoCommit() != this.o) {
                connection.setAutoCommit(this.o);
            }
            this.b(connection);
            if (this.j != this.i) {
                connection.setTransactionIsolation(this.j);
            }
            if (this.catalog != null) {
                connection.setCatalog(this.catalog);
            }
            if (this.m != null) {
                connection.setSchema(this.m);
            }
            this.a(connection, this.config.getConnectionInitSql(), true);
            this.b(connection, this.f);
            return;
        }
        catch (SQLException sQLException) {
            throw new ConnectionSetupException(sQLException);
        }
    }

    private void b(Connection connection) {
        if (!this.r) {
            this.c(connection);
            this.d(connection);
            this.r = true;
        }
    }

    private void c(Connection connection) {
        try {
            if (!this.p) {
                this.a(connection, this.config.getConnectionTestQuery(), false);
                return;
            }
            connection.isValid(1);
        }
        catch (AbstractMethodError | Exception throwable) {
            this.a.error("{} - Failed to execute{} connection test query ({}).", this.poolName, this.p ? " isValid() for connection, configure" : "", throwable.getMessage());
            throw throwable;
        }
    }

    private void d(Connection connection) {
        try {
            this.i = connection.getTransactionIsolation();
            if (this.j == -1) {
                this.j = this.i;
            }
            return;
        }
        catch (SQLException sQLException) {
            this.a.warn("{} - Default transaction isolation level detection failed ({}).", (Object)this.poolName, (Object)sQLException.getMessage());
            if (sQLException.getSQLState() != null && !sQLException.getSQLState().startsWith("08")) {
                throw sQLException;
            }
            return;
        }
    }

    private void a(Statement statement, int n) {
        block3: {
            if (this.h != 0) {
                try {
                    statement.setQueryTimeout(n);
                    this.h = 1;
                    return;
                }
                catch (Exception exception) {
                    if (this.h != -1) break block3;
                    this.h = 0;
                    this.a.info("{} - Failed to set query timeout for statement. ({})", (Object)this.poolName, (Object)exception.getMessage());
                }
            }
        }
    }

    private int a(Connection connection, long l) {
        block4: {
            if (this.g != 0) {
                try {
                    int n = connection.getNetworkTimeout();
                    connection.setNetworkTimeout(this.k, (int)l);
                    this.g = 1;
                    return n;
                }
                catch (AbstractMethodError | Exception throwable) {
                    if (this.g != -1) break block4;
                    this.g = 0;
                    this.a.info("{} - Driver does not support get/set network timeout for connections. ({})", (Object)this.poolName, (Object)throwable.getMessage());
                    if (this.validationTimeout < TimeUnit.SECONDS.toMillis(1L)) {
                        this.a.warn("{} - A validationTimeout of less than 1 second cannot be honored on drivers without setNetworkTimeout() support.", (Object)this.poolName);
                    }
                    if (this.validationTimeout % TimeUnit.SECONDS.toMillis(1L) == 0L) break block4;
                    this.a.warn("{} - A validationTimeout with fractional second granularity cannot be honored on drivers without setNetworkTimeout() support.", (Object)this.poolName);
                }
            }
        }
        return 0;
    }

    private void b(Connection connection, long l) {
        if (this.g == 1) {
            connection.setNetworkTimeout(this.k, (int)l);
        }
    }

    private void a(Connection connection, String string, boolean bl) {
        if (string != null) {
            try (Statement statement = connection.createStatement();){
                statement.execute(string);
            }
            if (this.q && !this.o) {
                if (bl) {
                    connection.commit();
                    return;
                }
                connection.rollback();
            }
        }
    }

    private void a(DataSource object, String string, String string2) {
        if (string != null && string.contains("Mysql") || string2 != null && string2.contains("mysql") || object != null && object.getClass().getName().contains("Mysql")) {
            this.k = new SynchronousExecutor(0);
            return;
        }
        object = this.config.getThreadFactory();
        object = object != null ? object : new UtilityElf.DefaultThreadFactory(this.poolName + " network timeout executor", true);
        object = (ThreadPoolExecutor)Executors.newCachedThreadPool((ThreadFactory)object);
        ((ThreadPoolExecutor)object).setKeepAliveTime(15L, TimeUnit.SECONDS);
        ((ThreadPoolExecutor)object).allowCoreThreadTimeOut(true);
        this.k = object;
    }

    private void a(DataSource dataSource) {
        if (this.connectionTimeout != Integer.MAX_VALUE) {
            try {
                dataSource.setLoginTimeout(Math.max(1, (int)TimeUnit.MILLISECONDS.toSeconds(500L + this.connectionTimeout)));
                return;
            }
            catch (Exception exception) {
                this.a.info("{} - Failed to set login timeout for data source. ({})", (Object)this.poolName, (Object)exception.getMessage());
            }
        }
    }

    private static String a(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            if ((n & 1 << i) == 0) continue;
            stringBuilder.append(b[i]).append(", ");
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.setLength(stringBuilder2.length() - 2);
        return stringBuilder.toString();
    }

    static final class NopMetricsTrackerDelegate
    implements IMetricsTrackerDelegate {
        NopMetricsTrackerDelegate() {
        }
    }

    static class MetricsTrackerDelegate
    implements IMetricsTrackerDelegate {
        final IMetricsTracker tracker;

        MetricsTrackerDelegate(IMetricsTracker iMetricsTracker) {
            this.tracker = iMetricsTracker;
        }

        @Override
        public void recordConnectionUsage(PoolEntry poolEntry) {
            this.tracker.recordConnectionUsageMillis(poolEntry.getMillisSinceBorrowed());
        }

        @Override
        public void recordConnectionCreated(long l) {
            this.tracker.recordConnectionCreatedMillis(l);
        }

        @Override
        public void recordBorrowTimeoutStats(long l) {
            this.tracker.recordConnectionAcquiredNanos(ClockSource.elapsedNanos(l));
        }

        @Override
        public void recordBorrowStats(PoolEntry poolEntry, long l) {
            long l2;
            poolEntry.lastBorrowed = l2 = ClockSource.currentTime();
            this.tracker.recordConnectionAcquiredNanos(ClockSource.elapsedNanos(l, l2));
        }

        @Override
        public void recordConnectionTimeout() {
            this.tracker.recordConnectionTimeout();
        }

        @Override
        public void close() {
            this.tracker.close();
        }
    }

    static interface IMetricsTrackerDelegate
    extends AutoCloseable {
        default public void recordConnectionUsage(PoolEntry poolEntry) {
        }

        default public void recordConnectionCreated(long connectionCreatedMillis) {
        }

        default public void recordBorrowTimeoutStats(long startTime) {
        }

        default public void recordBorrowStats(PoolEntry poolEntry, long startTime) {
        }

        default public void recordConnectionTimeout() {
        }

        @Override
        default public void close() {
        }
    }

    private static class SynchronousExecutor
    implements Executor {
        private SynchronousExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            try {
                runnable.run();
                return;
            }
            catch (Exception exception) {
                LoggerFactory.getLogger(PoolBase.class).debug("Failed to execute: {}", (Object)runnable, (Object)exception);
                return;
            }
        }

        /* synthetic */ SynchronousExecutor(byte by) {
            this();
        }
    }

    static class ConnectionSetupException
    extends Exception {
        private static final long a = 929872118275916521L;

        ConnectionSetupException(Throwable throwable) {
            super(throwable);
        }
    }
}

