/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.SQLExceptionOverride;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool.PoolEntry;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool.ProxyFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.pool.ProxyLeakTask;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util.ClockSource;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util.FastList;

public abstract class ProxyConnection
implements Connection {
    static final int DIRTY_BIT_READONLY = 1;
    static final int DIRTY_BIT_AUTOCOMMIT = 2;
    static final int DIRTY_BIT_ISOLATION = 4;
    static final int DIRTY_BIT_CATALOG = 8;
    static final int DIRTY_BIT_NETTIMEOUT = 16;
    static final int DIRTY_BIT_SCHEMA = 32;
    private static final Logger a = LoggerFactory.getLogger(ProxyConnection.class);
    private static final Set<String> b = new HashSet<String>();
    private static final Set<Integer> c;
    protected Connection delegate;
    private final PoolEntry d;
    private final ProxyLeakTask e;
    private final FastList<Statement> f;
    private int g;
    private long h;
    private boolean i;
    private boolean j;
    private boolean k;
    private int l;
    private int m;
    private String n;
    private String o;

    protected ProxyConnection(PoolEntry poolEntry, Connection connection, FastList<Statement> fastList, ProxyLeakTask proxyLeakTask, long l, boolean bl, boolean bl2) {
        this.d = poolEntry;
        this.delegate = connection;
        this.f = fastList;
        this.e = proxyLeakTask;
        this.h = l;
        this.j = bl;
        this.k = bl2;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + '@' + System.identityHashCode(this) + " wrapping " + this.delegate;
    }

    final boolean a() {
        return this.k;
    }

    final String b() {
        return this.n;
    }

    final String c() {
        return this.o;
    }

    final int d() {
        return this.m;
    }

    final boolean e() {
        return this.j;
    }

    final int f() {
        return this.l;
    }

    final PoolEntry g() {
        return this.d;
    }

    final SQLException a(SQLException sQLException) {
        boolean bl = false;
        SQLException sQLException2 = sQLException;
        SQLExceptionOverride sQLExceptionOverride = this.d.getPoolBase().exceptionOverride;
        for (int n = 0; this.delegate != ClosedConnection.CLOSED_CONNECTION && sQLException2 != null && n < 10; sQLException2 = sQLException2.getNextException(), ++n) {
            String string = sQLException2.getSQLState();
            if ((string == null || !string.startsWith("08")) && !(sQLException2 instanceof SQLTimeoutException) && !b.contains(string) && !c.contains(sQLException2.getErrorCode())) continue;
            if (sQLExceptionOverride != null && sQLExceptionOverride.adjudicate(sQLException2) == SQLExceptionOverride.Override.DO_NOT_EVICT) break;
            bl = true;
            break;
        }
        if (bl) {
            SQLException sQLException3 = sQLException2 != null ? sQLException2 : sQLException;
            a.warn("{} - Connection {} marked as broken because of SQLSTATE({}), ErrorCode({})", this.d.getPoolName(), this.delegate, sQLException3.getSQLState(), sQLException3.getErrorCode(), sQLException3);
            this.e.cancel();
            this.d.evict("(connection is broken)");
            this.delegate = ClosedConnection.CLOSED_CONNECTION;
        }
        return sQLException;
    }

    final synchronized void a(Statement statement) {
        this.f.remove(statement);
    }

    final void h() {
        if (this.k) {
            this.h = ClockSource.currentTime();
            return;
        }
        this.i = true;
    }

    void cancelLeakTask() {
        this.e.cancel();
    }

    private synchronized <T extends Statement> T b(T t) {
        this.f.add(t);
        return t;
    }

    private synchronized void i() {
        int n = this.f.size();
        if (n > 0) {
            for (int i = 0; i < n && this.delegate != ClosedConnection.CLOSED_CONNECTION; ++i) {
                try {
                    Statement statement = this.f.get(i);
                    if (statement == null) continue;
                    statement.close();
                    continue;
                }
                catch (SQLException sQLException) {
                    a.warn("{} - Connection {} marked as broken because of an exception closing open statements during Connection.close()", (Object)this.d.getPoolName(), (Object)this.delegate);
                    this.e.cancel();
                    this.d.evict("(exception closing Statements during Connection.close())");
                    this.delegate = ClosedConnection.CLOSED_CONNECTION;
                }
            }
            this.f.clear();
        }
    }

    @Override
    public final void close() {
        this.i();
        if (this.delegate != ClosedConnection.CLOSED_CONNECTION) {
            this.e.cancel();
            try {
                if (this.i && !this.k) {
                    this.delegate.rollback();
                    this.h = ClockSource.currentTime();
                    a.debug("{} - Executed rollback on connection {} due to dirty commit state on close().", (Object)this.d.getPoolName(), (Object)this.delegate);
                }
                if (this.g != 0) {
                    ProxyConnection proxyConnection = this;
                    this.d.resetConnectionState(proxyConnection, proxyConnection.g);
                    this.h = ClockSource.currentTime();
                }
                this.delegate.clearWarnings();
                return;
            }
            catch (SQLException sQLException) {
                if (!this.d.isMarkedEvicted()) {
                    throw this.a(sQLException);
                }
                return;
            }
            finally {
                this.delegate = ClosedConnection.CLOSED_CONNECTION;
                this.d.recycle(this.h);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.delegate == ClosedConnection.CLOSED_CONNECTION;
    }

    @Override
    public Statement createStatement() {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyStatement(proxyConnection, proxyConnection.b(this.delegate.createStatement()));
    }

    @Override
    public Statement createStatement(int n, int n2) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyStatement(proxyConnection, proxyConnection.b(this.delegate.createStatement(n, n2)));
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyStatement(proxyConnection, proxyConnection.b(this.delegate.createStatement(n, n2, n3)));
    }

    @Override
    public CallableStatement prepareCall(String string) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyCallableStatement(proxyConnection, proxyConnection.b(this.delegate.prepareCall(string)));
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyCallableStatement(proxyConnection, proxyConnection.b(this.delegate.prepareCall(string, n, n2)));
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyCallableStatement(proxyConnection, proxyConnection.b(this.delegate.prepareCall(string, n, n2, n3)));
    }

    @Override
    public PreparedStatement prepareStatement(String string) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyPreparedStatement(proxyConnection, proxyConnection.b(this.delegate.prepareStatement(string)));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyPreparedStatement(proxyConnection, proxyConnection.b(this.delegate.prepareStatement(string, n)));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyPreparedStatement(proxyConnection, proxyConnection.b(this.delegate.prepareStatement(string, n, n2)));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyPreparedStatement(proxyConnection, proxyConnection.b(this.delegate.prepareStatement(string, n, n2, n3)));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyPreparedStatement(proxyConnection, proxyConnection.b(this.delegate.prepareStatement(string, nArray)));
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyPreparedStatement(proxyConnection, proxyConnection.b(this.delegate.prepareStatement(string, stringArray)));
    }

    @Override
    public DatabaseMetaData getMetaData() {
        this.h();
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyDatabaseMetaData(proxyConnection, proxyConnection.delegate.getMetaData());
    }

    @Override
    public void commit() {
        this.delegate.commit();
        this.i = false;
        this.h = ClockSource.currentTime();
    }

    @Override
    public void rollback() {
        this.delegate.rollback();
        this.i = false;
        this.h = ClockSource.currentTime();
    }

    @Override
    public void rollback(Savepoint savepoint) {
        this.delegate.rollback(savepoint);
        this.i = false;
        this.h = ClockSource.currentTime();
    }

    @Override
    public void setAutoCommit(boolean bl) {
        this.delegate.setAutoCommit(bl);
        this.k = bl;
        this.g |= 2;
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.delegate.setReadOnly(bl);
        this.j = bl;
        this.i = false;
        this.g |= 1;
    }

    @Override
    public void setTransactionIsolation(int n) {
        this.delegate.setTransactionIsolation(n);
        this.m = n;
        this.g |= 4;
    }

    @Override
    public void setCatalog(String string) {
        this.delegate.setCatalog(string);
        this.n = string;
        this.g |= 8;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) {
        this.delegate.setNetworkTimeout(executor, n);
        this.l = n;
        this.g |= 0x10;
    }

    @Override
    public void setSchema(String string) {
        this.delegate.setSchema(string);
        this.o = string;
        this.g |= 0x20;
    }

    @Override
    public final boolean isWrapperFor(Class<?> clazz) {
        return clazz.isInstance(this.delegate) || this.delegate != null && this.delegate.isWrapperFor(clazz);
    }

    @Override
    public final <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this.delegate)) {
            return (T)this.delegate;
        }
        if (this.delegate != null) {
            return this.delegate.unwrap(clazz);
        }
        throw new SQLException("Wrapped connection is not an instance of " + clazz);
    }

    static {
        b.add("0A000");
        b.add("57P01");
        b.add("57P02");
        b.add("57P03");
        b.add("01002");
        b.add("JZ0C0");
        b.add("JZ0C1");
        c = new HashSet<Integer>();
        c.add(500150);
        c.add(2399);
    }

    private static final class ClosedConnection {
        static final Connection CLOSED_CONNECTION;

        private ClosedConnection() {
        }

        private static Connection a() {
            InvocationHandler invocationHandler = (object, method, objectArray) -> {
                object = method.getName();
                if ("isClosed".equals(object)) {
                    return Boolean.TRUE;
                }
                if ("isValid".equals(object)) {
                    return Boolean.FALSE;
                }
                if ("abort".equals(object)) {
                    return Void.TYPE;
                }
                if ("close".equals(object)) {
                    return Void.TYPE;
                }
                if ("toString".equals(object)) {
                    return ClosedConnection.class.getCanonicalName();
                }
                throw new SQLException("Connection is closed");
            };
            return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, invocationHandler);
        }

        static {
            InvocationHandler invocationHandler = (object, method, objectArray) -> {
                object = method.getName();
                if ("isClosed".equals(object)) {
                    return Boolean.TRUE;
                }
                if ("isValid".equals(object)) {
                    return Boolean.FALSE;
                }
                if ("abort".equals(object)) {
                    return Void.TYPE;
                }
                if ("close".equals(object)) {
                    return Void.TYPE;
                }
                if ("toString".equals(object)) {
                    return ClosedConnection.class.getCanonicalName();
                }
                throw new SQLException("Connection is closed");
            };
            CLOSED_CONNECTION = (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, invocationHandler);
        }
    }
}

